'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var HistoryQuery = function HistoryQuery(_ref) {
  var query = _ref.query,
      variables = _ref.variables,
      operationName = _ref.operationName,
      onSelect = _ref.onSelect;

  var onClick = function onClick() {
    onSelect(query, variables, operationName);
  };

  var displayName = void 0;
  if (operationName) {
    displayName = operationName;
  } else {
    displayName = query.split('\n').filter(function (line) {
      return line.indexOf('#') !== 0;
    }).join('');
  }

  return _react2.default.createElement(
    'p',
    { onClick: onClick },
    displayName
  );
};

HistoryQuery.propTypes = {
  query: _propTypes2.default.string,
  variables: _propTypes2.default.string,
  operationName: _propTypes2.default.string,
  onSelect: _propTypes2.default.func
};

exports.default = HistoryQuery;