'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryHistory = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _graphql = require('graphql');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _HistoryStore = require('../utility/HistoryStore');

var _HistoryStore2 = _interopRequireDefault(_HistoryStore);

var _HistoryQuery = require('./HistoryQuery');

var _HistoryQuery2 = _interopRequireDefault(_HistoryQuery);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var shouldSaveQuery = function shouldSaveQuery(nextProps, current, lastQuerySaved) {
  if (nextProps.queryID === current.queryID) {
    return false;
  }
  try {
    (0, _graphql.parse)(nextProps.query);
  } catch (e) {
    return false;
  }
  if (!lastQuerySaved) {
    return true;
  }
  if (JSON.stringify(nextProps.query) === JSON.stringify(lastQuerySaved.query)) {
    if (JSON.stringify(nextProps.variables) === JSON.stringify(lastQuerySaved.variables)) {
      return false;
    }
    if (!nextProps.variables && !lastQuerySaved.variables) {
      return false;
    }
  }
  return true;
};

var MAX_HISTORY_LENGTH = 20;

var QueryHistory = exports.QueryHistory = function (_React$Component) {
  _inherits(QueryHistory, _React$Component);

  function QueryHistory(props) {
    _classCallCheck(this, QueryHistory);

    var _this = _possibleConstructorReturn(this, (QueryHistory.__proto__ || Object.getPrototypeOf(QueryHistory)).call(this, props));

    _this.store = new _HistoryStore2.default('queries', props.storage);
    _this.state = {
      queries: _this.store.fetchAll()
    };
    return _this;
  }

  _createClass(QueryHistory, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      if (shouldSaveQuery(nextProps, this.props, this.store.fetchRecent())) {
        this.store.push({
          query: nextProps.query,
          variables: nextProps.variables || '',
          operationName: nextProps.operationName || ''
        });
        if (this.store.length > MAX_HISTORY_LENGTH) {
          this.store.shift();
        }
        this.setState({
          queries: this.store.items
        });
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var queries = this.state.queries.slice().reverse();
      var queryNodes = queries.map(function (query, i) {
        return _react2.default.createElement(_HistoryQuery2.default, _extends({ key: i }, query, { onSelect: _this2.props.onSelectQuery }));
      });
      return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
          'div',
          { className: 'history-title-bar' },
          _react2.default.createElement(
            'div',
            { className: 'history-title' },
            'History'
          ),
          _react2.default.createElement(
            'div',
            { className: 'doc-explorer-rhs' },
            this.props.children
          )
        ),
        _react2.default.createElement(
          'div',
          { className: 'history-contents' },
          queryNodes
        )
      );
    }
  }]);

  return QueryHistory;
}(_react2.default.Component);

QueryHistory.propTypes = {
  query: _propTypes2.default.string,
  variables: _propTypes2.default.string,
  operationName: _propTypes2.default.string,
  queryID: _propTypes2.default.number,
  onSelectQuery: _propTypes2.default.func,
  storage: _propTypes2.default.object
};