'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var StorageAPI = function () {
  function StorageAPI(storage) {
    _classCallCheck(this, StorageAPI);

    this.storage = storage || window.localStorage;
  }

  _createClass(StorageAPI, [{
    key: 'get',
    value: function get(name) {
      if (this.storage) {
        var value = this.storage.getItem('graphiql:' + name);
        // Clean up any inadvertently saved null/undefined values.
        if (value === 'null' || value === 'undefined') {
          this.storage.removeItem('graphiql:' + name);
        } else {
          return value;
        }
      }
    }
  }, {
    key: 'set',
    value: function set(name, value) {
      if (this.storage) {
        if (value) {
          this.storage.setItem('graphiql:' + name, value);
        } else {
          this.storage.removeItem('graphiql:' + name);
        }
      }
    }
  }]);

  return StorageAPI;
}();

exports.default = StorageAPI;