"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _debounce = _interopRequireDefault(require("../../utility/debounce"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var SearchBox =
/*#__PURE__*/
function (_React$Component) {
  _inherits(SearchBox, _React$Component);

  function SearchBox(props) {
    var _this;

    _classCallCheck(this, SearchBox);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(SearchBox).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "handleChange", function (event) {
      var value = event.target.value;

      _this.setState({
        value: value
      });

      _this.debouncedOnSearch(value);
    });

    _defineProperty(_assertThisInitialized(_this), "handleClear", function () {
      _this.setState({
        value: ''
      });

      _this.props.onSearch('');
    });

    _this.state = {
      value: props.value || ''
    };
    _this.debouncedOnSearch = (0, _debounce.default)(200, _this.props.onSearch);
    return _this;
  }

  _createClass(SearchBox, [{
    key: "render",
    value: function render() {
      return _react.default.createElement("label", {
        className: "search-box"
      }, _react.default.createElement("div", {
        className: "search-box-icon",
        "aria-hidden": "true"
      }, "\u26B2"), _react.default.createElement("input", {
        value: this.state.value,
        onChange: this.handleChange,
        type: "text",
        placeholder: this.props.placeholder,
        "aria-label": this.props.placeholder
      }), this.state.value && _react.default.createElement("button", {
        className: "search-box-clear",
        onClick: this.handleClear,
        "aria-label": "Clear search input"
      }, "\u2715"));
    }
  }]);

  return SearchBox;
}(_react.default.Component);

exports.default = SearchBox;

_defineProperty(SearchBox, "propTypes", {
  value: _propTypes.default.string,
  placeholder: _propTypes.default.string,
  onSearch: _propTypes.default.func
});