"use strict";

var _QueryStore = _interopRequireDefault(require("../QueryStore"));

var _StorageAPI = _interopRequireDefault(require("../StorageAPI"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var StorageMock =
/*#__PURE__*/
function () {
  function StorageMock(shouldThrow) {
    _classCallCheck(this, StorageMock);

    this.shouldThrow = shouldThrow;
    this.map = {};
  }

  _createClass(StorageMock, [{
    key: "set",
    value: function set(key, value) {
      this.count++;

      if (this.shouldThrow()) {
        return {
          error: {},
          isQuotaError: true,
          storageAvailable: true
        };
      }

      this.map[key] = value;
      return {
        error: null,
        isQuotaError: false,
        storageAvailable: true
      };
    }
  }, {
    key: "get",
    value: function get(key) {
      return this.map[key] || null;
    }
  }]);

  return StorageMock;
}();

describe('QueryStore', function () {
  describe('with no max items', function () {
    it('can push multiple items', function () {
      var store = new _QueryStore.default('normal', new _StorageAPI.default());

      for (var i = 0; i < 100; i++) {
        store.push("item".concat(i));
      }

      expect(store.items.length).toBe(100);
    });
    it('will fail silently on quota error', function () {
      var i = 0;
      var store = new _QueryStore.default('normal', new StorageMock(function () {
        return i > 4;
      }));

      for (; i < 10; i++) {
        store.push("item".concat(i));
      }

      expect(store.items.length).toBe(5);
      expect(store.items[0]).toBe('item0');
      expect(store.items[4]).toBe('item4');
    });
  });
  describe('with max items', function () {
    it('can push a limited number of items', function () {
      var store = new _QueryStore.default('limited', new _StorageAPI.default(), 20);

      for (var i = 0; i < 100; i++) {
        store.push("item".concat(i));
      }

      expect(store.items.length).toBe(20); // keeps the more recent items

      expect(store.items[0]).toBe('item80');
      expect(store.items[19]).toBe('item99');
    });
    it('tries to remove on quota error until it succeeds', function () {
      var shouldThrow;
      var retryCounter = 0;
      var store = new _QueryStore.default('normal', new StorageMock(function () {
        retryCounter++;
        return shouldThrow();
      }), 10);

      for (var i = 0; i < 20; i++) {
        shouldThrow = function shouldThrow() {
          return false;
        };

        store.push("item".concat(i));
      }

      expect(store.items.length).toBe(10); // keeps the more recent items

      expect(store.items[0]).toBe('item10');
      expect(store.items[9]).toBe('item19'); // tries to add an item, succeeds on 3rd try

      retryCounter = 0;

      shouldThrow = function shouldThrow() {
        return retryCounter < 3;
      };

      store.push("finalItem");
      expect(store.items.length).toBe(8);
      expect(store.items[0]).toBe('item13');
      expect(store.items[7]).toBe('finalItem');
    });
    it('tries to remove a maximum of 5 times', function () {
      var shouldTrow;
      var retryCounter = 0;
      var store = new _QueryStore.default('normal', new StorageMock(function () {
        retryCounter++;
        return shouldTrow();
      }), 10);

      for (var i = 0; i < 20; i++) {
        shouldTrow = function shouldTrow() {
          return false;
        };

        store.push("item".concat(i));
      }

      expect(store.items.length).toBe(10); // keeps the more recent items

      expect(store.items[0]).toBe('item10');
      expect(store.items[9]).toBe('item19'); // tries to add an item, keeps failing

      retryCounter = 0;

      shouldTrow = function shouldTrow() {
        return true;
      };

      store.push("finalItem");
      expect(store.items.length).toBe(10); // kept the items

      expect(store.items[0]).toBe('item10');
      expect(store.items[9]).toBe('item19'); // retried 5 times

      expect(retryCounter).toBe(5);
    });
  });
});