"use strict";

var _StorageAPI = _interopRequireDefault(require("../StorageAPI"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 *  Copyright (c) 2019 GraphQL Contributors.
 *
 *  This source code is licensed under the MIT license found in the
 *  LICENSE file in the root directory of this source tree.
 */
describe('StorageAPI', function () {
  var storage = new _StorageAPI.default();
  it('returns nothing if no value set', function () {
    var result = storage.get('key1');
    expect(result).toBeNull();
  });
  it('sets and gets a value correctly', function () {
    var result = storage.set('key2', 'value');
    expect(result).toEqual({
      error: null,
      isQuotaError: false
    });
    result = storage.get('key2');
    expect(result).toEqual('value');
  });
  it('sets and removes a value correctly', function () {
    var result = storage.set('key3', 'value');
    expect(result).toEqual({
      error: null,
      isQuotaError: false
    });
    result = storage.set('key3');
    expect(result).toEqual({
      error: null,
      isQuotaError: false
    });
    result = storage.get('key3');
    expect(result).toBeNull();
  });
  it('sets and overrides a value correctly', function () {
    var result = storage.set('key4', 'value');
    expect(result).toEqual({
      error: null,
      isQuotaError: false
    });
    result = storage.set('key4', 'value2');
    expect(result).toEqual({
      error: null,
      isQuotaError: false
    });
    result = storage.get('key4');
    expect(result).toEqual('value2');
  });
  it('cleans up `null` value', function () {
    storage.set('key5', 'null');
    var result = storage.get('key5');
    expect(result).toBeNull();
  });
  it('cleans up `undefined` value', function () {
    storage.set('key6', 'undefined');
    var result = storage.get('key6');
    expect(result).toBeNull();
  });
  it('returns any error while setting a value', function () {
    var throwingStorage = new _StorageAPI.default({
      setItem: function setItem() {
        throw new DOMException('Terrible Error');
      },
      length: 1
    });
    var result = throwingStorage.set('key', 'value');
    expect(result.error.message).toEqual('Terrible Error');
    expect(result.isQuotaError).toBe(false);
  });
  it('returns isQuotaError to true if isQuotaError is thrown', function () {
    var throwingStorage = new _StorageAPI.default({
      setItem: function setItem() {
        throw new DOMException('Terrible Error', 'QuotaExceededError');
      },
      length: 1
    });
    var result = throwingStorage.set('key', 'value');
    expect(result.error.message).toEqual('Terrible Error');
    expect(result.isQuotaError).toBe(true);
  });
});