"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _Argument = _interopRequireDefault(require("./Argument"));

var _MarkdownContent = _interopRequireDefault(require("./MarkdownContent"));

var _TypeLink = _interopRequireDefault(require("./TypeLink"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class FieldDoc extends _react.default.Component {
  shouldComponentUpdate(nextProps) {
    return this.props.field !== nextProps.field;
  }

  render() {
    const field = this.props.field;
    let argsDef;

    if (field.args && field.args.length > 0) {
      argsDef = _react.default.createElement("div", {
        className: "doc-category"
      }, _react.default.createElement("div", {
        className: "doc-category-title"
      }, 'arguments'), field.args.map(arg => _react.default.createElement("div", {
        key: arg.name,
        className: "doc-category-item"
      }, _react.default.createElement("div", null, _react.default.createElement(_Argument.default, {
        arg: arg,
        onClickType: this.props.onClickType
      })), _react.default.createElement(_MarkdownContent.default, {
        className: "doc-value-description",
        markdown: arg.description
      }))));
    }

    return _react.default.createElement("div", null, _react.default.createElement(_MarkdownContent.default, {
      className: "doc-type-description",
      markdown: field.description || 'No Description'
    }), field.deprecationReason && _react.default.createElement(_MarkdownContent.default, {
      className: "doc-deprecation",
      markdown: field.deprecationReason
    }), _react.default.createElement("div", {
      className: "doc-category"
    }, _react.default.createElement("div", {
      className: "doc-category-title"
    }, 'type'), _react.default.createElement(_TypeLink.default, {
      type: field.type,
      onClick: this.props.onClickType
    })), argsDef);
  }

}

exports.default = FieldDoc;

_defineProperty(FieldDoc, "propTypes", {
  field: _propTypes.default.object,
  onClickType: _propTypes.default.func
});