"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _markdownIt = _interopRequireDefault(require("markdown-it"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const md = new _markdownIt.default();

class MarkdownContent extends _react.default.Component {
  shouldComponentUpdate(nextProps) {
    return this.props.markdown !== nextProps.markdown;
  }

  render() {
    const markdown = this.props.markdown;

    if (!markdown) {
      return _react.default.createElement("div", null);
    }

    return _react.default.createElement("div", {
      className: this.props.className,
      dangerouslySetInnerHTML: {
        __html: md.render(markdown)
      }
    });
  }

}

exports.default = MarkdownContent;

_defineProperty(MarkdownContent, "propTypes", {
  markdown: _propTypes.default.string,
  className: _propTypes.default.string
});