"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _TypeLink = _interopRequireDefault(require("./TypeLink"));

var _MarkdownContent = _interopRequireDefault(require("./MarkdownContent"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Render the top level Schema
class SchemaDoc extends _react.default.Component {
  shouldComponentUpdate(nextProps) {
    return this.props.schema !== nextProps.schema;
  }

  render() {
    const schema = this.props.schema;
    const queryType = schema.getQueryType();
    const mutationType = schema.getMutationType && schema.getMutationType();
    const subscriptionType = schema.getSubscriptionType && schema.getSubscriptionType();
    return _react.default.createElement("div", null, _react.default.createElement(_MarkdownContent.default, {
      className: "doc-type-description",
      markdown: 'A GraphQL schema provides a root type for each kind of operation.'
    }), _react.default.createElement("div", {
      className: "doc-category"
    }, _react.default.createElement("div", {
      className: "doc-category-title"
    }, 'root types'), _react.default.createElement("div", {
      className: "doc-category-item"
    }, _react.default.createElement("span", {
      className: "keyword"
    }, 'query'), ': ', _react.default.createElement(_TypeLink.default, {
      type: queryType,
      onClick: this.props.onClickType
    })), mutationType && _react.default.createElement("div", {
      className: "doc-category-item"
    }, _react.default.createElement("span", {
      className: "keyword"
    }, 'mutation'), ': ', _react.default.createElement(_TypeLink.default, {
      type: mutationType,
      onClick: this.props.onClickType
    })), subscriptionType && _react.default.createElement("div", {
      className: "doc-category-item"
    }, _react.default.createElement("span", {
      className: "keyword"
    }, 'subscription'), ': ', _react.default.createElement(_TypeLink.default, {
      type: subscriptionType,
      onClick: this.props.onClickType
    }))));
  }

}

exports.default = SchemaDoc;

_defineProperty(SchemaDoc, "propTypes", {
  schema: _propTypes.default.object,
  onClickType: _propTypes.default.func
});