"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _debounce = _interopRequireDefault(require("../../utility/debounce"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class SearchBox extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "handleChange", event => {
      const value = event.target.value;
      this.setState({
        value
      });
      this.debouncedOnSearch(value);
    });

    _defineProperty(this, "handleClear", () => {
      this.setState({
        value: ''
      });
      this.props.onSearch('');
    });

    this.state = {
      value: props.value || ''
    };
    this.debouncedOnSearch = (0, _debounce.default)(200, this.props.onSearch);
  }

  render() {
    return _react.default.createElement("label", {
      className: "search-box"
    }, _react.default.createElement("div", {
      className: "search-box-icon",
      "aria-hidden": "true"
    }, '\u26b2'), _react.default.createElement("input", {
      value: this.state.value,
      onChange: this.handleChange,
      type: "text",
      placeholder: this.props.placeholder,
      "aria-label": this.props.placeholder
    }), this.state.value && _react.default.createElement("button", {
      className: "search-box-clear",
      onClick: this.handleClear,
      "aria-label": "Clear search input"
    }, '\u2715'));
  }

}

exports.default = SearchBox;

_defineProperty(SearchBox, "propTypes", {
  value: _propTypes.default.string,
  placeholder: _propTypes.default.string,
  onSearch: _propTypes.default.func
});