"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _Argument = _interopRequireDefault(require("./Argument"));

var _TypeLink = _interopRequireDefault(require("./TypeLink"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class SearchResults extends _react.default.Component {
  shouldComponentUpdate(nextProps) {
    return this.props.schema !== nextProps.schema || this.props.searchValue !== nextProps.searchValue;
  }

  render() {
    const searchValue = this.props.searchValue;
    const withinType = this.props.withinType;
    const schema = this.props.schema;
    const onClickType = this.props.onClickType;
    const onClickField = this.props.onClickField;
    const matchedWithin = [];
    const matchedTypes = [];
    const matchedFields = [];
    const typeMap = schema.getTypeMap();
    let typeNames = Object.keys(typeMap); // Move the within type name to be the first searched.

    if (withinType) {
      typeNames = typeNames.filter(n => n !== withinType.name);
      typeNames.unshift(withinType.name);
    }

    for (const typeName of typeNames) {
      if (matchedWithin.length + matchedTypes.length + matchedFields.length >= 100) {
        break;
      }

      const type = typeMap[typeName];

      if (withinType !== type && isMatch(typeName, searchValue)) {
        matchedTypes.push(_react.default.createElement("div", {
          className: "doc-category-item",
          key: typeName
        }, _react.default.createElement(_TypeLink.default, {
          type: type,
          onClick: onClickType
        })));
      }

      if (type.getFields) {
        const fields = type.getFields();
        Object.keys(fields).forEach(fieldName => {
          const field = fields[fieldName];
          let matchingArgs;

          if (!isMatch(fieldName, searchValue)) {
            if (field.args && field.args.length) {
              matchingArgs = field.args.filter(arg => isMatch(arg.name, searchValue));

              if (matchingArgs.length === 0) {
                return;
              }
            } else {
              return;
            }
          }

          const match = _react.default.createElement("div", {
            className: "doc-category-item",
            key: typeName + '.' + fieldName
          }, withinType !== type && [_react.default.createElement(_TypeLink.default, {
            key: "type",
            type: type,
            onClick: onClickType
          }), '.'], _react.default.createElement("a", {
            className: "field-name",
            onClick: event => onClickField(field, type, event)
          }, field.name), matchingArgs && ['(', _react.default.createElement("span", {
            key: "args"
          }, matchingArgs.map(arg => _react.default.createElement(_Argument.default, {
            key: arg.name,
            arg: arg,
            onClickType: onClickType,
            showDefaultValue: false
          }))), ')']);

          if (withinType === type) {
            matchedWithin.push(match);
          } else {
            matchedFields.push(match);
          }
        });
      }
    }

    if (matchedWithin.length + matchedTypes.length + matchedFields.length === 0) {
      return _react.default.createElement("span", {
        className: "doc-alert-text"
      }, 'No results found.');
    }

    if (withinType && matchedTypes.length + matchedFields.length > 0) {
      return _react.default.createElement("div", null, matchedWithin, _react.default.createElement("div", {
        className: "doc-category"
      }, _react.default.createElement("div", {
        className: "doc-category-title"
      }, 'other results'), matchedTypes, matchedFields));
    }

    return _react.default.createElement("div", null, matchedWithin, matchedTypes, matchedFields);
  }

}

exports.default = SearchResults;

_defineProperty(SearchResults, "propTypes", {
  schema: _propTypes.default.object,
  withinType: _propTypes.default.object,
  searchValue: _propTypes.default.string,
  onClickType: _propTypes.default.func,
  onClickField: _propTypes.default.func
});

function isMatch(sourceText, searchValue) {
  try {
    const escaped = searchValue.replace(/[^_0-9A-Za-z]/g, ch => '\\' + ch);
    return sourceText.search(new RegExp(escaped, 'i')) !== -1;
  } catch (e) {
    return sourceText.toLowerCase().indexOf(searchValue.toLowerCase()) !== -1;
  }
}