"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _graphql = require("graphql");

var _Argument = _interopRequireDefault(require("./Argument"));

var _MarkdownContent = _interopRequireDefault(require("./MarkdownContent"));

var _TypeLink = _interopRequireDefault(require("./TypeLink"));

var _DefaultValue = _interopRequireDefault(require("./DefaultValue"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class TypeDoc extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "handleShowDeprecated", () => this.setState({
      showDeprecated: true
    }));

    this.state = {
      showDeprecated: false
    };
  }

  shouldComponentUpdate(nextProps, nextState) {
    return this.props.type !== nextProps.type || this.props.schema !== nextProps.schema || this.state.showDeprecated !== nextState.showDeprecated;
  }

  render() {
    const schema = this.props.schema;
    const type = this.props.type;
    const onClickType = this.props.onClickType;
    const onClickField = this.props.onClickField;
    let typesTitle;
    let types;

    if (type instanceof _graphql.GraphQLUnionType) {
      typesTitle = 'possible types';
      types = schema.getPossibleTypes(type);
    } else if (type instanceof _graphql.GraphQLInterfaceType) {
      typesTitle = 'implementations';
      types = schema.getPossibleTypes(type);
    } else if (type instanceof _graphql.GraphQLObjectType) {
      typesTitle = 'implements';
      types = type.getInterfaces();
    }

    let typesDef;

    if (types && types.length > 0) {
      typesDef = _react.default.createElement("div", {
        className: "doc-category"
      }, _react.default.createElement("div", {
        className: "doc-category-title"
      }, typesTitle), types.map(subtype => _react.default.createElement("div", {
        key: subtype.name,
        className: "doc-category-item"
      }, _react.default.createElement(_TypeLink.default, {
        type: subtype,
        onClick: onClickType
      }))));
    } // InputObject and Object


    let fieldsDef;
    let deprecatedFieldsDef;

    if (type.getFields) {
      const fieldMap = type.getFields();
      const fields = Object.keys(fieldMap).map(name => fieldMap[name]);
      fieldsDef = _react.default.createElement("div", {
        className: "doc-category"
      }, _react.default.createElement("div", {
        className: "doc-category-title"
      }, 'fields'), fields.filter(field => !field.isDeprecated).map(field => _react.default.createElement(Field, {
        key: field.name,
        type: type,
        field: field,
        onClickType: onClickType,
        onClickField: onClickField
      })));
      const deprecatedFields = fields.filter(field => field.isDeprecated);

      if (deprecatedFields.length > 0) {
        deprecatedFieldsDef = _react.default.createElement("div", {
          className: "doc-category"
        }, _react.default.createElement("div", {
          className: "doc-category-title"
        }, 'deprecated fields'), !this.state.showDeprecated ? _react.default.createElement("button", {
          className: "show-btn",
          onClick: this.handleShowDeprecated
        }, 'Show deprecated fields...') : deprecatedFields.map(field => _react.default.createElement(Field, {
          key: field.name,
          type: type,
          field: field,
          onClickType: onClickType,
          onClickField: onClickField
        })));
      }
    }

    let valuesDef;
    let deprecatedValuesDef;

    if (type instanceof _graphql.GraphQLEnumType) {
      const values = type.getValues();
      valuesDef = _react.default.createElement("div", {
        className: "doc-category"
      }, _react.default.createElement("div", {
        className: "doc-category-title"
      }, 'values'), values.filter(value => !value.isDeprecated).map(value => _react.default.createElement(EnumValue, {
        key: value.name,
        value: value
      })));
      const deprecatedValues = values.filter(value => value.isDeprecated);

      if (deprecatedValues.length > 0) {
        deprecatedValuesDef = _react.default.createElement("div", {
          className: "doc-category"
        }, _react.default.createElement("div", {
          className: "doc-category-title"
        }, 'deprecated values'), !this.state.showDeprecated ? _react.default.createElement("button", {
          className: "show-btn",
          onClick: this.handleShowDeprecated
        }, 'Show deprecated values...') : deprecatedValues.map(value => _react.default.createElement(EnumValue, {
          key: value.name,
          value: value
        })));
      }
    }

    return _react.default.createElement("div", null, _react.default.createElement(_MarkdownContent.default, {
      className: "doc-type-description",
      markdown: type.description || 'No Description'
    }), type instanceof _graphql.GraphQLObjectType && typesDef, fieldsDef, deprecatedFieldsDef, valuesDef, deprecatedValuesDef, !(type instanceof _graphql.GraphQLObjectType) && typesDef);
  }

}

exports.default = TypeDoc;

_defineProperty(TypeDoc, "propTypes", {
  schema: _propTypes.default.instanceOf(_graphql.GraphQLSchema),
  type: _propTypes.default.object,
  onClickType: _propTypes.default.func,
  onClickField: _propTypes.default.func
});

function Field({
  type,
  field,
  onClickType,
  onClickField
}) {
  return _react.default.createElement("div", {
    className: "doc-category-item"
  }, _react.default.createElement("a", {
    className: "field-name",
    onClick: event => onClickField(field, type, event)
  }, field.name), field.args && field.args.length > 0 && ['(', _react.default.createElement("span", {
    key: "args"
  }, field.args.map(arg => _react.default.createElement(_Argument.default, {
    key: arg.name,
    arg: arg,
    onClickType: onClickType
  }))), ')'], ': ', _react.default.createElement(_TypeLink.default, {
    type: field.type,
    onClick: onClickType
  }), _react.default.createElement(_DefaultValue.default, {
    field: field
  }), field.description && _react.default.createElement(_MarkdownContent.default, {
    className: "field-short-description",
    markdown: field.description
  }), field.deprecationReason && _react.default.createElement(_MarkdownContent.default, {
    className: "doc-deprecation",
    markdown: field.deprecationReason
  }));
}

Field.propTypes = {
  type: _propTypes.default.object,
  field: _propTypes.default.object,
  onClickType: _propTypes.default.func,
  onClickField: _propTypes.default.func
};

function EnumValue({
  value
}) {
  return _react.default.createElement("div", {
    className: "doc-category-item"
  }, _react.default.createElement("div", {
    className: "enum-value"
  }, value.name), _react.default.createElement(_MarkdownContent.default, {
    className: "doc-value-description",
    markdown: value.description
  }), value.deprecationReason && _react.default.createElement(_MarkdownContent.default, {
    className: "doc-deprecation",
    markdown: value.deprecationReason
  }));
}

EnumValue.propTypes = {
  value: _propTypes.default.object
};