"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _graphql = require("graphql");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class TypeLink extends _react.default.Component {
  shouldComponentUpdate(nextProps) {
    return this.props.type !== nextProps.type;
  }

  render() {
    return renderType(this.props.type, this.props.onClick);
  }

}

exports.default = TypeLink;

_defineProperty(TypeLink, "propTypes", {
  type: _propTypes.default.object,
  onClick: _propTypes.default.func
});

function renderType(type, onClick) {
  if (type instanceof _graphql.GraphQLNonNull) {
    return _react.default.createElement("span", null, renderType(type.ofType, onClick), '!');
  }

  if (type instanceof _graphql.GraphQLList) {
    return _react.default.createElement("span", null, '[', renderType(type.ofType, onClick), ']');
  }

  return _react.default.createElement("a", {
    className: "type-name",
    onClick: event => {
      event.preventDefault();
      onClick(type, event);
    },
    href: "#"
  }, type.name);
}