"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class HistoryQuery extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "editField", null);

    this.state = {
      editable: false
    };
  }

  render() {
    const displayName = this.props.label || this.props.operationName || this.props.query.split('\n').filter(line => line.indexOf('#') !== 0).join('');
    const starIcon = this.props.favorite ? '\u2605' : '\u2606';
    return _react.default.createElement("li", {
      className: this.state.editable ? 'editable' : undefined
    }, this.state.editable ? _react.default.createElement("input", {
      type: "text",
      defaultValue: this.props.label,
      ref: c => this.editField = c,
      onBlur: this.handleFieldBlur.bind(this),
      onKeyDown: this.handleFieldKeyDown.bind(this),
      placeholder: "Type a label"
    }) : _react.default.createElement("button", {
      className: "history-label",
      onClick: this.handleClick.bind(this)
    }, displayName), _react.default.createElement("button", {
      onClick: this.handleEditClick.bind(this),
      "aria-label": "Edit label"
    }, '\u270e'), _react.default.createElement("button", {
      className: this.props.favorite ? 'favorited' : undefined,
      onClick: this.handleStarClick.bind(this),
      "aria-label": this.props.favorite ? 'Remove favorite' : 'Add favorite'
    }, starIcon));
  }

  handleClick() {
    this.props.onSelect(this.props.query, this.props.variables, this.props.operationName, this.props.label);
  }

  handleStarClick(e) {
    e.stopPropagation();
    this.props.handleToggleFavorite(this.props.query, this.props.variables, this.props.operationName, this.props.label, this.props.favorite);
  }

  handleFieldBlur(e) {
    e.stopPropagation();
    this.setState({
      editable: false
    });
    this.props.handleEditLabel(this.props.query, this.props.variables, this.props.operationName, e.target.value, this.props.favorite);
  }

  handleFieldKeyDown(e) {
    if (e.keyCode === 13) {
      e.stopPropagation();
      this.setState({
        editable: false
      });
      this.props.handleEditLabel(this.props.query, this.props.variables, this.props.operationName, e.target.value, this.props.favorite);
    }
  }

  handleEditClick(e) {
    e.stopPropagation();
    this.setState({
      editable: true
    }, () => {
      if (this.editField) {
        this.editField.focus();
      }
    });
  }

}

exports.default = HistoryQuery;

_defineProperty(HistoryQuery, "propTypes", {
  favorite: _propTypes.default.bool,
  favoriteSize: _propTypes.default.number,
  handleEditLabel: _propTypes.default.func,
  handleToggleFavorite: _propTypes.default.func,
  operationName: _propTypes.default.string,
  onSelect: _propTypes.default.func,
  query: _propTypes.default.string,
  variables: _propTypes.default.string,
  label: _propTypes.default.string
});