"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImagePreview = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function tokenToURL(token) {
  if (token.type !== 'string') {
    return null;
  }

  const value = token.string.slice(1).slice(0, -1).trim();

  try {
    const location = window.location;
    return new URL(value, location.protocol + '//' + location.host);
  } catch (err) {
    return null;
  }
}

function isImageURL(url) {
  return /(bmp|gif|jpeg|jpg|png|svg)$/.test(url.pathname);
}

class ImagePreview extends _react.default.Component {
  static shouldRender(token) {
    const url = tokenToURL(token);
    return url ? isImageURL(url) : false;
  }

  constructor(props) {
    super(props);

    _defineProperty(this, "state", {
      width: null,
      height: null,
      src: null,
      mime: null
    });
  }

  componentDidMount() {
    this._updateMetadata();
  }

  componentDidUpdate() {
    this._updateMetadata();
  }

  render() {
    let dims = null;

    if (this.state.width !== null && this.state.height !== null) {
      let dimensions = this.state.width + 'x' + this.state.height;

      if (this.state.mime !== null) {
        dimensions += ' ' + this.state.mime;
      }

      dims = _react.default.createElement("div", null, dimensions);
    }

    return _react.default.createElement("div", null, _react.default.createElement("img", {
      onLoad: () => this._updateMetadata(),
      ref: node => {
        this._node = node;
      },
      src: tokenToURL(this.props.token)
    }), dims);
  }

  _updateMetadata() {
    if (!this._node) {
      return;
    }

    const width = this._node.naturalWidth;
    const height = this._node.naturalHeight;
    const src = this._node.src;

    if (src !== this.state.src) {
      this.setState({
        src
      });
      fetch(src, {
        method: 'HEAD'
      }).then(response => {
        this.setState({
          mime: response.headers.get('Content-Type')
        });
      });
    }

    if (width !== this.state.width || height !== this.state.height) {
      this.setState({
        height,
        width
      });
    }
  }

}

exports.ImagePreview = ImagePreview;

_defineProperty(ImagePreview, "propTypes", {
  token: _propTypes.default.any
});