"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryHistory = void 0;

var _graphql = require("graphql");

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _QueryStore = _interopRequireDefault(require("../utility/QueryStore"));

var _HistoryQuery = _interopRequireDefault(require("./HistoryQuery"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const MAX_QUERY_SIZE = 100000;
const MAX_HISTORY_LENGTH = 20;

const shouldSaveQuery = (nextProps, current, lastQuerySaved) => {
  if (nextProps.queryID === current.queryID) {
    return false;
  }

  try {
    (0, _graphql.parse)(nextProps.query);
  } catch (e) {
    return false;
  } // Don't try to save giant queries


  if (nextProps.query.length > MAX_QUERY_SIZE) {
    return false;
  }

  if (!lastQuerySaved) {
    return true;
  }

  if (JSON.stringify(nextProps.query) === JSON.stringify(lastQuerySaved.query)) {
    if (JSON.stringify(nextProps.variables) === JSON.stringify(lastQuerySaved.variables)) {
      return false;
    }

    if (!nextProps.variables && !lastQuerySaved.variables) {
      return false;
    }
  }

  return true;
};

class QueryHistory extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "toggleFavorite", (query, variables, operationName, label, favorite) => {
      const item = {
        query,
        variables,
        operationName,
        label
      };

      if (!this.favoriteStore.contains(item)) {
        item.favorite = true;
        this.favoriteStore.push(item);
      } else if (favorite) {
        item.favorite = false;
        this.favoriteStore.delete(item);
      }

      this.setState({
        queries: [...this.historyStore.items, ...this.favoriteStore.items]
      });
    });

    _defineProperty(this, "editLabel", (query, variables, operationName, label, favorite) => {
      const item = {
        query,
        variables,
        operationName,
        label
      };

      if (favorite) {
        this.favoriteStore.edit({ ...item,
          favorite
        });
      } else {
        this.historyStore.edit(item);
      }

      this.setState({
        queries: [...this.historyStore.items, ...this.favoriteStore.items]
      });
    });

    this.historyStore = new _QueryStore.default('queries', props.storage, MAX_HISTORY_LENGTH); // favorites are not automatically deleted, so there's no need for a max length

    this.favoriteStore = new _QueryStore.default('favorites', props.storage, null);
    const historyQueries = this.historyStore.fetchAll();
    const favoriteQueries = this.favoriteStore.fetchAll();
    const queries = historyQueries.concat(favoriteQueries);
    this.state = {
      queries
    };
  }

  componentWillReceiveProps(nextProps) {
    if (shouldSaveQuery(nextProps, this.props, this.historyStore.fetchRecent())) {
      const item = {
        query: nextProps.query,
        variables: nextProps.variables,
        operationName: nextProps.operationName
      };
      this.historyStore.push(item);
      const historyQueries = this.historyStore.items;
      const favoriteQueries = this.favoriteStore.items;
      const queries = historyQueries.concat(favoriteQueries);
      this.setState({
        queries
      });
    }
  }

  render() {
    const queries = this.state.queries.slice().reverse();
    const queryNodes = queries.map((query, i) => {
      return _react.default.createElement(_HistoryQuery.default, _extends({
        handleEditLabel: this.editLabel,
        handleToggleFavorite: this.toggleFavorite,
        key: `${i}:${query.label || query.query}`,
        onSelect: this.props.onSelectQuery
      }, query));
    });
    return _react.default.createElement("section", {
      "aria-label": "History"
    }, _react.default.createElement("div", {
      className: "history-title-bar"
    }, _react.default.createElement("div", {
      className: "history-title"
    }, 'History'), _react.default.createElement("div", {
      className: "doc-explorer-rhs"
    }, this.props.children)), _react.default.createElement("ul", {
      className: "history-contents"
    }, queryNodes));
  }

}

exports.QueryHistory = QueryHistory;

_defineProperty(QueryHistory, "propTypes", {
  query: _propTypes.default.string,
  variables: _propTypes.default.string,
  operationName: _propTypes.default.string,
  queryID: _propTypes.default.number,
  onSelectQuery: _propTypes.default.func,
  storage: _propTypes.default.object
});