"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultViewer = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _commonKeys = _interopRequireDefault(require("../utility/commonKeys"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * ResultViewer
 *
 * Maintains an instance of CodeMirror for viewing a GraphQL response.
 *
 * Props:
 *
 *   - value: The text of the editor.
 *
 */
class ResultViewer extends _react.default.Component {
  constructor() {
    super();
  }

  componentDidMount() {
    // Lazily require to ensure requiring GraphiQL outside of a Browser context
    // does not produce an error.
    const CodeMirror = require('codemirror');

    require('codemirror/addon/fold/foldgutter');

    require('codemirror/addon/fold/brace-fold');

    require('codemirror/addon/dialog/dialog');

    require('codemirror/addon/search/search');

    require('codemirror/addon/search/searchcursor');

    require('codemirror/addon/search/jump-to-line');

    require('codemirror/keymap/sublime');

    require('codemirror-graphql/results/mode');

    const Tooltip = this.props.ResultsTooltip;
    const ImagePreview = this.props.ImagePreview;

    if (Tooltip || ImagePreview) {
      require('codemirror-graphql/utils/info-addon');

      const tooltipDiv = document.createElement('div');
      CodeMirror.registerHelper('info', 'graphql-results', (token, options, cm, pos) => {
        const infoElements = [];

        if (Tooltip) {
          infoElements.push(_react.default.createElement(Tooltip, {
            pos: pos
          }));
        }

        if (ImagePreview && typeof ImagePreview.shouldRender === 'function' && ImagePreview.shouldRender(token)) {
          infoElements.push(_react.default.createElement(ImagePreview, {
            token: token
          }));
        }

        if (!infoElements.length) {
          _reactDom.default.unmountComponentAtNode(tooltipDiv);

          return null;
        }

        _reactDom.default.render(_react.default.createElement("div", null, infoElements), tooltipDiv);

        return tooltipDiv;
      });
    }

    this.viewer = CodeMirror(this._node, {
      lineWrapping: true,
      value: this.props.value || '',
      readOnly: true,
      theme: this.props.editorTheme || 'graphiql',
      mode: 'graphql-results',
      keyMap: 'sublime',
      foldGutter: {
        minFoldSize: 4
      },
      gutters: ['CodeMirror-foldgutter'],
      info: Boolean(this.props.ResultsTooltip || this.props.ImagePreview),
      extraKeys: _commonKeys.default
    });
  }

  shouldComponentUpdate(nextProps) {
    return this.props.value !== nextProps.value;
  }

  componentDidUpdate() {
    this.viewer.setValue(this.props.value || '');
  }

  componentWillUnmount() {
    this.viewer = null;
  }

  render() {
    return _react.default.createElement("section", {
      className: "result-window",
      "aria-label": "Result Window",
      "aria-live": "polite",
      "aria-atomic": "true",
      ref: node => {
        this._node = node;
      }
    });
  }
  /**
   * Public API for retrieving the CodeMirror instance from this
   * React component.
   */


  getCodeMirror() {
    return this.viewer;
  }
  /**
   * Public API for retrieving the DOM client height for this component.
   */


  getClientHeight() {
    return this._node && this._node.clientHeight;
  }

}

exports.ResultViewer = ResultViewer;

_defineProperty(ResultViewer, "propTypes", {
  value: _propTypes.default.string,
  editorTheme: _propTypes.default.string,
  ResultsTooltip: _propTypes.default.any,
  ImagePreview: _propTypes.default.any
});