"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolbarButton = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * ToolbarButton
 *
 * A button to use within the Toolbar.
 */
class ToolbarButton extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "handleClick", () => {
      try {
        this.props.onClick();
        this.setState({
          error: null
        });
      } catch (error) {
        this.setState({
          error
        });
      }
    });

    this.state = {
      error: null
    };
  }

  render() {
    const {
      error
    } = this.state;
    return _react.default.createElement("button", {
      className: 'toolbar-button' + (error ? ' error' : ''),
      onClick: this.handleClick,
      title: error ? error.message : this.props.title,
      "aria-invalid": error ? 'true' : 'false'
    }, this.props.label);
  }

}

exports.ToolbarButton = ToolbarButton;

_defineProperty(ToolbarButton, "propTypes", {
  onClick: _propTypes.default.func,
  title: _propTypes.default.string,
  label: _propTypes.default.string
});