"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolbarMenuItem = ToolbarMenuItem;
exports.ToolbarMenu = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * ToolbarMenu
 *
 * A menu style button to use within the Toolbar.
 */
class ToolbarMenu extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "handleOpen", e => {
      preventDefault(e);
      this.setState({
        visible: true
      });

      this._subscribe();
    });

    this.state = {
      visible: false
    };
  }

  componentWillUnmount() {
    this._release();
  }

  render() {
    const visible = this.state.visible;
    return _react.default.createElement("a", {
      className: "toolbar-menu toolbar-button",
      onClick: this.handleOpen.bind(this),
      onMouseDown: preventDefault,
      ref: node => {
        this._node = node;
      },
      title: this.props.title
    }, this.props.label, _react.default.createElement("svg", {
      width: "14",
      height: "8"
    }, _react.default.createElement("path", {
      fill: "#666",
      d: "M 5 1.5 L 14 1.5 L 9.5 7 z"
    })), _react.default.createElement("ul", {
      className: 'toolbar-menu-items' + (visible ? ' open' : '')
    }, this.props.children));
  }

  _subscribe() {
    if (!this._listener) {
      this._listener = this.handleClick.bind(this);
      document.addEventListener('click', this._listener);
    }
  }

  _release() {
    if (this._listener) {
      document.removeEventListener('click', this._listener);
      this._listener = null;
    }
  }

  handleClick(e) {
    if (this._node !== e.target) {
      preventDefault(e);
      this.setState({
        visible: false
      });

      this._release();
    }
  }

}

exports.ToolbarMenu = ToolbarMenu;

_defineProperty(ToolbarMenu, "propTypes", {
  title: _propTypes.default.string,
  label: _propTypes.default.string
});

function ToolbarMenuItem({
  onSelect,
  title,
  label
}) {
  return _react.default.createElement("li", {
    onMouseOver: e => {
      e.target.className = 'hover';
    },
    onMouseOut: e => {
      e.target.className = null;
    },
    onMouseDown: preventDefault,
    onMouseUp: onSelect,
    title: title
  }, label);
}

ToolbarMenuItem.propTypes = {
  onSelect: _propTypes.default.func,
  title: _propTypes.default.string,
  label: _propTypes.default.string
};

function preventDefault(e) {
  e.preventDefault();
}