"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolbarSelectOption = ToolbarSelectOption;
exports.ToolbarSelect = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * ToolbarSelect
 *
 * A select-option style button to use within the Toolbar.
 *
 */
class ToolbarSelect extends _react.default.Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "handleOpen", e => {
      preventDefault(e);
      this.setState({
        visible: true
      });

      this._subscribe();
    });

    this.state = {
      visible: false
    };
  }

  componentWillUnmount() {
    this._release();
  }

  render() {
    let selectedChild;
    const visible = this.state.visible;

    const optionChildren = _react.default.Children.map(this.props.children, (child, i) => {
      if (!selectedChild || child.props.selected) {
        selectedChild = child;
      }

      const onChildSelect = child.props.onSelect || this.props.onSelect && this.props.onSelect.bind(null, child.props.value, i);
      return _react.default.createElement(ToolbarSelectOption, _extends({}, child.props, {
        onSelect: onChildSelect
      }));
    });

    return _react.default.createElement("a", {
      className: "toolbar-select toolbar-button",
      onClick: this.handleOpen.bind(this),
      onMouseDown: preventDefault,
      ref: node => {
        this._node = node;
      },
      title: this.props.title
    }, selectedChild.props.label, _react.default.createElement("svg", {
      width: "13",
      height: "10"
    }, _react.default.createElement("path", {
      fill: "#666",
      d: "M 5 5 L 13 5 L 9 1 z"
    }), _react.default.createElement("path", {
      fill: "#666",
      d: "M 5 6 L 13 6 L 9 10 z"
    })), _react.default.createElement("ul", {
      className: 'toolbar-select-options' + (visible ? ' open' : '')
    }, optionChildren));
  }

  _subscribe() {
    if (!this._listener) {
      this._listener = this.handleClick.bind(this);
      document.addEventListener('click', this._listener);
    }
  }

  _release() {
    if (this._listener) {
      document.removeEventListener('click', this._listener);
      this._listener = null;
    }
  }

  handleClick(e) {
    if (this._node !== e.target) {
      preventDefault(e);
      this.setState({
        visible: false
      });

      this._release();
    }
  }

}

exports.ToolbarSelect = ToolbarSelect;

_defineProperty(ToolbarSelect, "propTypes", {
  title: _propTypes.default.string,
  label: _propTypes.default.string,
  onSelect: _propTypes.default.func
});

function ToolbarSelectOption({
  onSelect,
  label,
  selected
}) {
  return _react.default.createElement("li", {
    onMouseOver: e => {
      e.target.className = 'hover';
    },
    onMouseOut: e => {
      e.target.className = null;
    },
    onMouseDown: preventDefault,
    onMouseUp: onSelect
  }, label, selected && _react.default.createElement("svg", {
    width: "13",
    height: "13"
  }, _react.default.createElement("polygon", {
    points: "4.851,10.462 0,5.611 2.314,3.297 4.851,5.835 10.686,0 13,2.314 4.851,10.462"
  })));
}

ToolbarSelectOption.propTypes = {
  onSelect: _propTypes.default.func,
  selected: _propTypes.default.bool,
  label: _propTypes.default.string,
  value: _propTypes.default.any
};

function preventDefault(e) {
  e.preventDefault();
}