"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeAst = mergeAst;

var _kinds = require("graphql/language/kinds");

/**
 *  Copyright (c) 2019 GraphQL Contributors.
 *
 *  This source code is licensed under the MIT license found in the
 *  LICENSE file in the root directory of this source tree.
 */
function resolveDefinition(fragments, obj) {
  let definition = obj;

  if (definition.kind === _kinds.Kind.FRAGMENT_SPREAD) {
    definition = fragments[definition.name.value];
  }

  if (definition.selectionSet) {
    definition.selectionSet.selections = definition.selectionSet.selections.filter((selection, idx, self) => selection.kind !== _kinds.Kind.FRAGMENT_SPREAD || idx === self.findIndex(_selection => _selection.kind === _kinds.Kind.FRAGMENT_SPREAD && selection.name.value === _selection.name.value)).map(selection => resolveDefinition(fragments, selection));
  }

  return definition;
}

function mergeAst(queryAst) {
  const fragments = {};
  queryAst.definitions.filter(elem => {
    return elem.kind === _kinds.Kind.FRAGMENT_DEFINITION;
  }).forEach(frag => {
    const copyFragment = { ...frag
    };
    copyFragment.kind = _kinds.Kind.INLINE_FRAGMENT;
    fragments[frag.name.value] = copyFragment;
  });
  const copyAst = { ...queryAst
  };
  copyAst.definitions = queryAst.definitions.filter(elem => {
    return elem.kind !== _kinds.Kind.FRAGMENT_DEFINITION;
  }).map(op => resolveDefinition(fragments, op));
  return copyAst;
}