/**
 *  Copyright (c) 2019 GraphQL Contributors.
 *
 *  This source code is licensed under the MIT license found in the
 *  LICENSE file in the root directory of this source tree.
 */

/**
 * When a containing DOM node's height has been altered, trigger a resize of
 * the related CodeMirror instance so that it is always correctly sized.
 */
export default class CodeMirrorSizer {
  constructor() {
    this.sizes = [];
  }

  updateSizes(components) {
    components.forEach((component, i) => {
      const size = component.getClientHeight();

      if (i <= this.sizes.length && size !== this.sizes[i]) {
        component.getCodeMirror().setSize();
      }

      this.sizes[i] = size;
    });
  }

}