var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import React from 'react';
import Nav from './Nav';
import List, { ListRow } from './List';
import { useThemeLayout } from './themes/provider';
var explorer = {
    input: (React.createElement(List, null,
        React.createElement(ListRow, null, 'Input'))),
    response: (React.createElement(List, null,
        React.createElement(ListRow, null, 'Response'))),
    console: (React.createElement(List, null,
        React.createElement(ListRow, null, 'Console/Inspector'))),
};
var nav = React.createElement(Nav, null);
var slots = { nav: nav, explorer: explorer };
export default { title: 'Layout' };
export var WithSlots = function () {
    var Layout = useThemeLayout();
    return React.createElement(Layout, __assign({}, slots));
};
export var WithManySidebars = function () {
    var Layout = useThemeLayout();
    return (React.createElement(Layout, __assign({}, slots, { navPanels: [
            {
                key: 1,
                size: 'sidebar',
                component: (React.createElement(List, null,
                    React.createElement(ListRow, null, 'Sidebar'))),
            },
            {
                key: 2,
                size: 'aside',
                component: (React.createElement(List, null,
                    React.createElement(ListRow, null, 'aside'))),
            },
            {
                key: 3,
                size: 'aside',
                component: (React.createElement(List, null,
                    React.createElement(ListRow, null, 'Another aside'))),
            },
        ] })));
};
export var WithFullScreenPanel = function () {
    var Layout = useThemeLayout();
    return (React.createElement(Layout, __assign({}, slots, { navPanels: [
            {
                key: 1,
                size: 'full-screen',
                component: (React.createElement(List, null,
                    React.createElement(ListRow, null, 'Woooo'))),
            },
        ] })));
};
export var WithStringsOnly = function () {
    var Layout = useThemeLayout();
    return (React.createElement(Layout, __assign({}, {
        explorer: {
            input: 'input',
            response: 'response',
            console: 'console',
        },
        nav: 'nav',
        navPanels: [
            {
                component: 'sidebar',
                key: 'sidebar',
                size: 'sidebar',
            },
        ],
    })));
};
//# sourceMappingURL=Layout.stories.js.map