"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DocExplorer = void 0;
var react_1 = __importDefault(require("react"));
var graphql_1 = require("graphql");
var react_2 = require("@graphiql/react");
var FieldDoc_1 = __importDefault(require("./DocExplorer/FieldDoc"));
var SchemaDoc_1 = __importDefault(require("./DocExplorer/SchemaDoc"));
var SearchBox_1 = __importDefault(require("./DocExplorer/SearchBox"));
var SearchResults_1 = __importDefault(require("./DocExplorer/SearchResults"));
var TypeDoc_1 = __importDefault(require("./DocExplorer/TypeDoc"));
function DocExplorer(props) {
    var _a = (0, react_2.useSchemaContext)({ nonNull: true }), fetchError = _a.fetchError, isFetching = _a.isFetching, schemaFromContext = _a.schema, validationErrors = _a.validationErrors;
    var _b = (0, react_2.useExplorerContext)({
        nonNull: true,
    }), explorerNavStack = _b.explorerNavStack, hide = _b.hide, pop = _b.pop, showSearch = _b.showSearch;
    var navItem = explorerNavStack[explorerNavStack.length - 1];
    var schema = props.schema === undefined ? schemaFromContext : props.schema;
    var content = null;
    if (fetchError) {
        content = react_1.default.createElement("div", { className: "error-container" }, "Error fetching schema");
    }
    else if (validationErrors.length > 0) {
        content = (react_1.default.createElement("div", { className: "error-container" },
            "Schema is invalid: ",
            validationErrors[0].message));
    }
    else if (isFetching) {
        content = (react_1.default.createElement("div", { className: "spinner-container" },
            react_1.default.createElement("div", { className: "spinner" })));
    }
    else if (!schema) {
        content = react_1.default.createElement("div", { className: "error-container" }, "No Schema Available");
    }
    else if (navItem.search) {
        content = react_1.default.createElement(SearchResults_1.default, null);
    }
    else if (explorerNavStack.length === 1) {
        content = react_1.default.createElement(SchemaDoc_1.default, null);
    }
    else if ((0, graphql_1.isType)(navItem.def)) {
        content = react_1.default.createElement(TypeDoc_1.default, null);
    }
    else if (navItem.def) {
        content = react_1.default.createElement(FieldDoc_1.default, null);
    }
    var shouldSearchBoxAppear = explorerNavStack.length === 1 ||
        ((0, graphql_1.isType)(navItem.def) && 'getFields' in navItem.def);
    var prevName;
    if (explorerNavStack.length > 1) {
        prevName = explorerNavStack[explorerNavStack.length - 2].name;
    }
    return (react_1.default.createElement("section", { className: "doc-explorer", key: navItem.name, "aria-label": "Documentation Explorer" },
        react_1.default.createElement("div", { className: "doc-explorer-title-bar" },
            prevName && (react_1.default.createElement("button", { type: "button", className: "doc-explorer-back", onClick: pop, "aria-label": "Go back to ".concat(prevName) }, prevName)),
            react_1.default.createElement("div", { className: "doc-explorer-title" }, navItem.title || navItem.name),
            react_1.default.createElement("div", { className: "doc-explorer-rhs" },
                react_1.default.createElement("button", { type: "button", className: "docExplorerHide", onClick: function () {
                        var _a;
                        hide();
                        (_a = props.onClose) === null || _a === void 0 ? void 0 : _a.call(props);
                    }, "aria-label": "Close Documentation Explorer" }, '\u2715'))),
        react_1.default.createElement("div", { className: "doc-explorer-contents" },
            shouldSearchBoxAppear && (react_1.default.createElement(SearchBox_1.default, { value: navItem.search, placeholder: "Search ".concat(navItem.name, "..."), onSearch: showSearch })),
            content)));
}
exports.DocExplorer = DocExplorer;
//# sourceMappingURL=DocExplorer.js.map