"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var graphql_1 = require("graphql");
var react_2 = require("@graphiql/react");
var Argument_1 = __importDefault(require("./Argument"));
var Directive_1 = __importDefault(require("./Directive"));
var MarkdownContent_1 = __importDefault(require("./MarkdownContent"));
var TypeLink_1 = __importDefault(require("./TypeLink"));
function FieldDoc() {
    var _a;
    var explorerNavStack = (0, react_2.useExplorerContext)({ nonNull: true }).explorerNavStack;
    var _b = __read(react_1.default.useState(false), 2), showDeprecated = _b[0], handleShowDeprecated = _b[1];
    var navItem = explorerNavStack[explorerNavStack.length - 1];
    var field = navItem.def;
    if (!field || (0, graphql_1.isType)(field)) {
        return null;
    }
    var argsDef;
    var deprecatedArgsDef;
    if (field && 'args' in field && field.args.length > 0) {
        argsDef = (react_1.default.createElement("div", { id: "doc-args", className: "doc-category" },
            react_1.default.createElement("div", { className: "doc-category-title" }, "arguments"),
            field.args
                .filter(function (arg) { return !arg.deprecationReason; })
                .map(function (arg) { return (react_1.default.createElement("div", { key: arg.name, className: "doc-category-item" },
                react_1.default.createElement("div", null,
                    react_1.default.createElement(Argument_1.default, { arg: arg })),
                react_1.default.createElement(MarkdownContent_1.default, { className: "doc-value-description", markdown: arg.description }),
                arg && 'deprecationReason' in arg && (react_1.default.createElement(MarkdownContent_1.default, { className: "doc-deprecation", markdown: arg === null || arg === void 0 ? void 0 : arg.deprecationReason })))); })));
        var deprecatedArgs = field.args.filter(function (arg) {
            return Boolean(arg.deprecationReason);
        });
        if (deprecatedArgs.length > 0) {
            deprecatedArgsDef = (react_1.default.createElement("div", { id: "doc-deprecated-args", className: "doc-category" },
                react_1.default.createElement("div", { className: "doc-category-title" }, "deprecated arguments"),
                !showDeprecated ? (react_1.default.createElement("button", { type: "button", className: "show-btn", onClick: function () { return handleShowDeprecated(!showDeprecated); } }, "Show deprecated arguments...")) : (deprecatedArgs.map(function (arg, i) { return (react_1.default.createElement("div", { key: i },
                    react_1.default.createElement("div", null,
                        react_1.default.createElement(Argument_1.default, { arg: arg })),
                    react_1.default.createElement(MarkdownContent_1.default, { className: "doc-value-description", markdown: arg.description }),
                    arg && 'deprecationReason' in arg && (react_1.default.createElement(MarkdownContent_1.default, { className: "doc-deprecation", markdown: arg === null || arg === void 0 ? void 0 : arg.deprecationReason })))); }))));
        }
    }
    var directivesDef;
    if (((_a = field === null || field === void 0 ? void 0 : field.astNode) === null || _a === void 0 ? void 0 : _a.directives) && field.astNode.directives.length > 0) {
        directivesDef = (react_1.default.createElement("div", { id: "doc-directives", className: "doc-category" },
            react_1.default.createElement("div", { className: "doc-category-title" }, "directives"),
            field.astNode.directives.map(function (directive) { return (react_1.default.createElement("div", { key: directive.name.value, className: "doc-category-item" },
                react_1.default.createElement("div", null,
                    react_1.default.createElement(Directive_1.default, { directive: directive })))); })));
    }
    return (react_1.default.createElement("div", null,
        react_1.default.createElement(MarkdownContent_1.default, { className: "doc-type-description", markdown: field.description || 'No Description' }),
        field && 'deprecationReason' in field && (react_1.default.createElement(MarkdownContent_1.default, { className: "doc-deprecation", markdown: field.deprecationReason })),
        react_1.default.createElement("div", { className: "doc-category" },
            react_1.default.createElement("div", { className: "doc-category-title" }, "type"),
            react_1.default.createElement(TypeLink_1.default, { type: field.type })),
        argsDef,
        directivesDef,
        deprecatedArgsDef));
}
exports.default = FieldDoc;
//# sourceMappingURL=FieldDoc.js.map