"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("@graphiql/react");
var graphql_1 = require("graphql");
var react_2 = __importStar(require("react"));
var Argument_1 = __importDefault(require("./Argument"));
var DefaultValue_1 = __importDefault(require("./DefaultValue"));
var FieldLink_1 = __importDefault(require("./FieldLink"));
var MarkdownContent_1 = __importDefault(require("./MarkdownContent"));
var TypeLink_1 = __importDefault(require("./TypeLink"));
function TypeDoc() {
    var schema = (0, react_1.useSchemaContext)({ nonNull: true }).schema;
    var explorerNavStack = (0, react_1.useExplorerContext)({ nonNull: true }).explorerNavStack;
    var _a = __read((0, react_2.useState)(false), 2), showDeprecated = _a[0], setShowDeprecated = _a[1];
    var navItem = explorerNavStack[explorerNavStack.length - 1];
    var type = navItem.def;
    if (!schema || !(0, graphql_1.isNamedType)(type)) {
        return null;
    }
    var typesTitle = null;
    var types = [];
    if ((0, graphql_1.isUnionType)(type)) {
        typesTitle = 'possible types';
        types = schema.getPossibleTypes(type);
    }
    else if ((0, graphql_1.isInterfaceType)(type)) {
        typesTitle = 'implementations';
        types = schema.getPossibleTypes(type);
    }
    else if ((0, graphql_1.isObjectType)(type)) {
        typesTitle = 'implements';
        types = type.getInterfaces();
    }
    var typesDef;
    if (types && types.length > 0) {
        typesDef = (react_2.default.createElement("div", { id: "doc-types", className: "doc-category" },
            react_2.default.createElement("div", { className: "doc-category-title" }, typesTitle),
            types.map(function (subtype) { return (react_2.default.createElement("div", { key: subtype.name, className: "doc-category-item" },
                react_2.default.createElement(TypeLink_1.default, { type: subtype }))); })));
    }
    var fieldsDef;
    var deprecatedFieldsDef;
    if (type && 'getFields' in type) {
        var fieldMap_1 = type.getFields();
        var fields = Object.keys(fieldMap_1).map(function (name) { return fieldMap_1[name]; });
        fieldsDef = (react_2.default.createElement("div", { id: "doc-fields", className: "doc-category" },
            react_2.default.createElement("div", { className: "doc-category-title" }, "fields"),
            fields
                .filter(function (field) { return !field.deprecationReason; })
                .map(function (field) { return (react_2.default.createElement(Field, { key: field.name, type: type, field: field })); })));
        var deprecatedFields = fields.filter(function (field) {
            return Boolean(field.deprecationReason);
        });
        if (deprecatedFields.length > 0) {
            deprecatedFieldsDef = (react_2.default.createElement("div", { id: "doc-deprecated-fields", className: "doc-category" },
                react_2.default.createElement("div", { className: "doc-category-title" }, "deprecated fields"),
                !showDeprecated ? (react_2.default.createElement("button", { type: "button", className: "show-btn", onClick: function () {
                        setShowDeprecated(true);
                    } }, "Show deprecated fields...")) : (deprecatedFields.map(function (field) { return (react_2.default.createElement(Field, { key: field.name, type: type, field: field })); }))));
        }
    }
    var valuesDef;
    var deprecatedValuesDef;
    if ((0, graphql_1.isEnumType)(type)) {
        var values = type.getValues();
        valuesDef = (react_2.default.createElement("div", { className: "doc-category" },
            react_2.default.createElement("div", { className: "doc-category-title" }, "values"),
            values
                .filter(function (value) { return Boolean(!value.deprecationReason); })
                .map(function (value) { return (react_2.default.createElement(EnumValue, { key: value.name, value: value })); })));
        var deprecatedValues = values.filter(function (value) {
            return Boolean(value.deprecationReason);
        });
        if (deprecatedValues.length > 0) {
            deprecatedValuesDef = (react_2.default.createElement("div", { className: "doc-category" },
                react_2.default.createElement("div", { className: "doc-category-title" }, "deprecated values"),
                !showDeprecated ? (react_2.default.createElement("button", { type: "button", className: "show-btn", onClick: function () {
                        setShowDeprecated(true);
                    } }, "Show deprecated values...")) : (deprecatedValues.map(function (value) { return (react_2.default.createElement(EnumValue, { key: value.name, value: value })); }))));
        }
    }
    return (react_2.default.createElement("div", null,
        react_2.default.createElement(MarkdownContent_1.default, { className: "doc-type-description", markdown: ('description' in type && type.description) || 'No Description' }),
        (0, graphql_1.isObjectType)(type) && typesDef,
        fieldsDef,
        deprecatedFieldsDef,
        valuesDef,
        deprecatedValuesDef,
        !(0, graphql_1.isObjectType)(type) && typesDef));
}
exports.default = TypeDoc;
function Field(_a) {
    var field = _a.field;
    return (react_2.default.createElement("div", { className: "doc-category-item" },
        react_2.default.createElement(FieldLink_1.default, { field: field }),
        'args' in field &&
            field.args &&
            field.args.length > 0 && [
            '(',
            react_2.default.createElement("span", { key: "args" }, field.args
                .filter(function (arg) { return !arg.deprecationReason; })
                .map(function (arg) { return (react_2.default.createElement(Argument_1.default, { key: arg.name, arg: arg })); })),
            ')',
        ],
        ': ',
        react_2.default.createElement(TypeLink_1.default, { type: field.type }),
        react_2.default.createElement(DefaultValue_1.default, { field: field }),
        field.description && (react_2.default.createElement(MarkdownContent_1.default, { className: "field-short-description", markdown: field.description })),
        'deprecationReason' in field && field.deprecationReason && (react_2.default.createElement(MarkdownContent_1.default, { className: "doc-deprecation", markdown: field.deprecationReason }))));
}
function EnumValue(_a) {
    var value = _a.value;
    return (react_2.default.createElement("div", { className: "doc-category-item" },
        react_2.default.createElement("div", { className: "enum-value" }, value.name),
        react_2.default.createElement(MarkdownContent_1.default, { className: "doc-value-description", markdown: value.description }),
        value.deprecationReason && (react_2.default.createElement(MarkdownContent_1.default, { className: "doc-deprecation", markdown: value.deprecationReason }))));
}
//# sourceMappingURL=TypeDoc.js.map