"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueryHistoryItem = exports.QueryHistory = void 0;
var react_1 = require("@graphiql/react");
var react_2 = __importStar(require("react"));
function QueryHistory() {
    var _a = (0, react_1.useHistoryContext)({
        nonNull: true,
    }), hide = _a.hide, items = _a.items;
    return (react_2.default.createElement("section", { "aria-label": "History" },
        react_2.default.createElement("div", { className: "history-title-bar" },
            react_2.default.createElement("div", { className: "history-title" }, "History"),
            react_2.default.createElement("div", { className: "doc-explorer-rhs" },
                react_2.default.createElement("button", { type: "button", className: "docExplorerHide", onClick: function () { return hide(); }, "aria-label": "Close History" }, '\u2715'))),
        react_2.default.createElement("ul", { className: "history-contents" }, items
            .slice()
            .reverse()
            .map(function (item, i) {
            return (react_2.default.createElement(QueryHistoryItem, { key: "".concat(i, ":").concat(item.label || item.query), item: item }));
        }))));
}
exports.QueryHistory = QueryHistory;
function QueryHistoryItem(props) {
    var _a;
    var _b = (0, react_1.useHistoryContext)({ nonNull: true }), editLabel = _b.editLabel, toggleFavorite = _b.toggleFavorite;
    var selectHistoryItem = (0, react_1.useSelectHistoryItem)();
    var editField = (0, react_2.useRef)(null);
    var _c = __read((0, react_2.useState)(false), 2), isEditable = _c[0], setIsEditable = _c[1];
    (0, react_2.useEffect)(function () {
        if (isEditable && editField.current) {
            editField.current.focus();
        }
    }, [isEditable]);
    var displayName = props.item.label ||
        props.item.operationName ||
        ((_a = props.item.query) === null || _a === void 0 ? void 0 : _a.split('\n').filter(function (line) { return line.indexOf('#') !== 0; }).join(''));
    var starIcon = props.item.favorite ? '\u2605' : '\u2606';
    return (react_2.default.createElement("li", { className: isEditable ? 'editable' : undefined },
        isEditable ? (react_2.default.createElement("input", { type: "text", defaultValue: props.item.label, ref: editField, onBlur: function (e) {
                e.stopPropagation();
                setIsEditable(false);
                editLabel(__assign(__assign({}, props.item), { label: e.target.value }));
            }, onKeyDown: function (e) {
                if (e.keyCode === 13) {
                    e.stopPropagation();
                    setIsEditable(false);
                    editLabel(__assign(__assign({}, props.item), { label: e.currentTarget.value }));
                }
            }, placeholder: "Type a label" })) : (react_2.default.createElement("button", { type: "button", className: "history-label", onClick: function () {
                selectHistoryItem(props.item);
            } }, displayName)),
        react_2.default.createElement("button", { type: "button", onClick: function (e) {
                e.stopPropagation();
                setIsEditable(true);
            }, "aria-label": "Edit label" }, '\u270e'),
        react_2.default.createElement("button", { type: "button", onClick: function (e) {
                e.stopPropagation();
                toggleFavorite(props.item);
            }, "aria-label": props.item.favorite ? 'Remove favorite' : 'Add favorite' }, starIcon)));
}
exports.QueryHistoryItem = QueryHistoryItem;
//# sourceMappingURL=QueryHistory.js.map