import React from 'react';
import TypeLink from './TypeLink';
import MarkdownContent from './MarkdownContent';
import { useSchemaContext } from '@graphiql/react';
export default function SchemaDoc() {
    var _a, _b;
    var schema = useSchemaContext({ nonNull: true }).schema;
    if (!schema) {
        return null;
    }
    var queryType = schema.getQueryType();
    var mutationType = (_a = schema.getMutationType) === null || _a === void 0 ? void 0 : _a.call(schema);
    var subscriptionType = (_b = schema.getSubscriptionType) === null || _b === void 0 ? void 0 : _b.call(schema);
    return (React.createElement("div", null,
        React.createElement(MarkdownContent, { className: "doc-type-description", markdown: schema.description ||
                'A GraphQL schema provides a root type for each kind of operation.' }),
        React.createElement("div", { className: "doc-category" },
            React.createElement("div", { className: "doc-category-title" }, "root types"),
            queryType ? (React.createElement("div", { className: "doc-category-item" },
                React.createElement("span", { className: "keyword" }, "query"),
                ': ',
                React.createElement(TypeLink, { type: queryType }))) : null,
            mutationType && (React.createElement("div", { className: "doc-category-item" },
                React.createElement("span", { className: "keyword" }, "mutation"),
                ': ',
                React.createElement(TypeLink, { type: mutationType }))),
            subscriptionType && (React.createElement("div", { className: "doc-category-item" },
                React.createElement("span", { className: "keyword" }, "subscription"),
                ': ',
                React.createElement(TypeLink, { type: subscriptionType }))))));
}
//# sourceMappingURL=SchemaDoc.js.map