var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { useExplorerContext, useSchemaContext, } from '@graphiql/react';
import { isEnumType, isInterfaceType, isNamedType, isObjectType, isUnionType, } from 'graphql';
import React, { useState } from 'react';
import Argument from './Argument';
import DefaultValue from './DefaultValue';
import FieldLink from './FieldLink';
import MarkdownContent from './MarkdownContent';
import TypeLink from './TypeLink';
export default function TypeDoc() {
    var schema = useSchemaContext({ nonNull: true }).schema;
    var explorerNavStack = useExplorerContext({ nonNull: true }).explorerNavStack;
    var _a = __read(useState(false), 2), showDeprecated = _a[0], setShowDeprecated = _a[1];
    var navItem = explorerNavStack[explorerNavStack.length - 1];
    var type = navItem.def;
    if (!schema || !isNamedType(type)) {
        return null;
    }
    var typesTitle = null;
    var types = [];
    if (isUnionType(type)) {
        typesTitle = 'possible types';
        types = schema.getPossibleTypes(type);
    }
    else if (isInterfaceType(type)) {
        typesTitle = 'implementations';
        types = schema.getPossibleTypes(type);
    }
    else if (isObjectType(type)) {
        typesTitle = 'implements';
        types = type.getInterfaces();
    }
    var typesDef;
    if (types && types.length > 0) {
        typesDef = (React.createElement("div", { id: "doc-types", className: "doc-category" },
            React.createElement("div", { className: "doc-category-title" }, typesTitle),
            types.map(function (subtype) { return (React.createElement("div", { key: subtype.name, className: "doc-category-item" },
                React.createElement(TypeLink, { type: subtype }))); })));
    }
    var fieldsDef;
    var deprecatedFieldsDef;
    if (type && 'getFields' in type) {
        var fieldMap_1 = type.getFields();
        var fields = Object.keys(fieldMap_1).map(function (name) { return fieldMap_1[name]; });
        fieldsDef = (React.createElement("div", { id: "doc-fields", className: "doc-category" },
            React.createElement("div", { className: "doc-category-title" }, "fields"),
            fields
                .filter(function (field) { return !field.deprecationReason; })
                .map(function (field) { return (React.createElement(Field, { key: field.name, type: type, field: field })); })));
        var deprecatedFields = fields.filter(function (field) {
            return Boolean(field.deprecationReason);
        });
        if (deprecatedFields.length > 0) {
            deprecatedFieldsDef = (React.createElement("div", { id: "doc-deprecated-fields", className: "doc-category" },
                React.createElement("div", { className: "doc-category-title" }, "deprecated fields"),
                !showDeprecated ? (React.createElement("button", { type: "button", className: "show-btn", onClick: function () {
                        setShowDeprecated(true);
                    } }, "Show deprecated fields...")) : (deprecatedFields.map(function (field) { return (React.createElement(Field, { key: field.name, type: type, field: field })); }))));
        }
    }
    var valuesDef;
    var deprecatedValuesDef;
    if (isEnumType(type)) {
        var values = type.getValues();
        valuesDef = (React.createElement("div", { className: "doc-category" },
            React.createElement("div", { className: "doc-category-title" }, "values"),
            values
                .filter(function (value) { return Boolean(!value.deprecationReason); })
                .map(function (value) { return (React.createElement(EnumValue, { key: value.name, value: value })); })));
        var deprecatedValues = values.filter(function (value) {
            return Boolean(value.deprecationReason);
        });
        if (deprecatedValues.length > 0) {
            deprecatedValuesDef = (React.createElement("div", { className: "doc-category" },
                React.createElement("div", { className: "doc-category-title" }, "deprecated values"),
                !showDeprecated ? (React.createElement("button", { type: "button", className: "show-btn", onClick: function () {
                        setShowDeprecated(true);
                    } }, "Show deprecated values...")) : (deprecatedValues.map(function (value) { return (React.createElement(EnumValue, { key: value.name, value: value })); }))));
        }
    }
    return (React.createElement("div", null,
        React.createElement(MarkdownContent, { className: "doc-type-description", markdown: ('description' in type && type.description) || 'No Description' }),
        isObjectType(type) && typesDef,
        fieldsDef,
        deprecatedFieldsDef,
        valuesDef,
        deprecatedValuesDef,
        !isObjectType(type) && typesDef));
}
function Field(_a) {
    var field = _a.field;
    return (React.createElement("div", { className: "doc-category-item" },
        React.createElement(FieldLink, { field: field }),
        'args' in field &&
            field.args &&
            field.args.length > 0 && [
            '(',
            React.createElement("span", { key: "args" }, field.args
                .filter(function (arg) { return !arg.deprecationReason; })
                .map(function (arg) { return (React.createElement(Argument, { key: arg.name, arg: arg })); })),
            ')',
        ],
        ': ',
        React.createElement(TypeLink, { type: field.type }),
        React.createElement(DefaultValue, { field: field }),
        field.description && (React.createElement(MarkdownContent, { className: "field-short-description", markdown: field.description })),
        'deprecationReason' in field && field.deprecationReason && (React.createElement(MarkdownContent, { className: "doc-deprecation", markdown: field.deprecationReason }))));
}
function EnumValue(_a) {
    var value = _a.value;
    return (React.createElement("div", { className: "doc-category-item" },
        React.createElement("div", { className: "enum-value" }, value.name),
        React.createElement(MarkdownContent, { className: "doc-value-description", markdown: value.description }),
        value.deprecationReason && (React.createElement(MarkdownContent, { className: "doc-deprecation", markdown: value.deprecationReason }))));
}
//# sourceMappingURL=TypeDoc.js.map