import { useExplorerContext } from '@graphiql/react';
import { isListType, isNonNullType } from 'graphql';
import React from 'react';
export default function TypeLink(props) {
    var push = useExplorerContext({ nonNull: true, caller: TypeLink }).push;
    if (!props.type) {
        return null;
    }
    var type = props.type;
    if (isNonNullType(type)) {
        return (React.createElement(React.Fragment, null,
            React.createElement(TypeLink, { type: type.ofType }),
            "!"));
    }
    if (isListType(type)) {
        return (React.createElement(React.Fragment, null,
            "[",
            React.createElement(TypeLink, { type: type.ofType }),
            "]"));
    }
    return (React.createElement("a", { className: "type-name", onClick: function (event) {
            event.preventDefault();
            push({ name: type.name, def: type });
        }, href: "#" }, type.name));
}
//# sourceMappingURL=TypeLink.js.map