var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { useHistoryContext, useSelectHistoryItem, } from '@graphiql/react';
import React, { useEffect, useRef, useState } from 'react';
export function QueryHistory() {
    var _a = useHistoryContext({
        nonNull: true,
    }), hide = _a.hide, items = _a.items;
    return (React.createElement("section", { "aria-label": "History" },
        React.createElement("div", { className: "history-title-bar" },
            React.createElement("div", { className: "history-title" }, "History"),
            React.createElement("div", { className: "doc-explorer-rhs" },
                React.createElement("button", { type: "button", className: "docExplorerHide", onClick: function () { return hide(); }, "aria-label": "Close History" }, '\u2715'))),
        React.createElement("ul", { className: "history-contents" }, items
            .slice()
            .reverse()
            .map(function (item, i) {
            return (React.createElement(QueryHistoryItem, { key: "".concat(i, ":").concat(item.label || item.query), item: item }));
        }))));
}
export function QueryHistoryItem(props) {
    var _a;
    var _b = useHistoryContext({ nonNull: true }), editLabel = _b.editLabel, toggleFavorite = _b.toggleFavorite;
    var selectHistoryItem = useSelectHistoryItem();
    var editField = useRef(null);
    var _c = __read(useState(false), 2), isEditable = _c[0], setIsEditable = _c[1];
    useEffect(function () {
        if (isEditable && editField.current) {
            editField.current.focus();
        }
    }, [isEditable]);
    var displayName = props.item.label ||
        props.item.operationName ||
        ((_a = props.item.query) === null || _a === void 0 ? void 0 : _a.split('\n').filter(function (line) { return line.indexOf('#') !== 0; }).join(''));
    var starIcon = props.item.favorite ? '\u2605' : '\u2606';
    return (React.createElement("li", { className: isEditable ? 'editable' : undefined },
        isEditable ? (React.createElement("input", { type: "text", defaultValue: props.item.label, ref: editField, onBlur: function (e) {
                e.stopPropagation();
                setIsEditable(false);
                editLabel(__assign(__assign({}, props.item), { label: e.target.value }));
            }, onKeyDown: function (e) {
                if (e.keyCode === 13) {
                    e.stopPropagation();
                    setIsEditable(false);
                    editLabel(__assign(__assign({}, props.item), { label: e.currentTarget.value }));
                }
            }, placeholder: "Type a label" })) : (React.createElement("button", { type: "button", className: "history-label", onClick: function () {
                selectHistoryItem(props.item);
            } }, displayName)),
        React.createElement("button", { type: "button", onClick: function (e) {
                e.stopPropagation();
                setIsEditable(true);
            }, "aria-label": "Edit label" }, '\u270e'),
        React.createElement("button", { type: "button", onClick: function (e) {
                e.stopPropagation();
                toggleFavorite(props.item);
            }, "aria-label": props.item.favorite ? 'Remove favorite' : 'Add favorite' }, starIcon)));
}
//# sourceMappingURL=QueryHistory.js.map