import React from 'react';
import { QueryStoreItem } from '../utility/QueryStore';
import { HandleEditLabelFn, HandleSelectQueryFn, HandleToggleFavoriteFn } from './HistoryQuery';
import StorageAPI from '../utility/StorageAPI';
import HistoryStore from '../utility/HistoryStore';
declare type QueryHistoryProps = {
    query?: string;
    variables?: string;
    headers?: string;
    operationName?: string;
    queryID?: number;
    onSelectQuery: HandleSelectQueryFn;
    storage: StorageAPI;
    maxHistoryLength: number;
};
declare type QueryHistoryState = {
    queries: Array<QueryStoreItem>;
};
export declare class QueryHistory extends React.Component<QueryHistoryProps, QueryHistoryState> {
    historyStore: HistoryStore;
    constructor(props: QueryHistoryProps);
    onUpdateHistory: (query?: string | undefined, variables?: string | undefined, headers?: string | undefined, operationName?: string | undefined) => void;
    onHandleEditLabel: HandleEditLabelFn;
    onToggleFavorite: HandleToggleFavoriteFn;
    render(): JSX.Element;
}
export {};
//# sourceMappingURL=QueryHistory.d.ts.map