var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
import React from 'react';
import onHasCompletion from '../utility/onHasCompletion';
import commonKeys from '../utility/commonKeys';
import { importCodeMirror } from '../utility/importCodeMirror';
var HeaderEditor = (function (_super) {
    __extends(HeaderEditor, _super);
    function HeaderEditor(props) {
        var _this = _super.call(this, props) || this;
        _this.editor = null;
        _this._node = null;
        _this.ignoreChangeEvent = false;
        _this.addonModules = function () { return [import('codemirror/mode/javascript/javascript')]; };
        _this._onKeyUp = function (_cm, event) {
            var code = event.keyCode;
            if (!_this.editor) {
                return;
            }
            if ((code >= 65 && code <= 90) ||
                (!event.shiftKey && code >= 48 && code <= 57) ||
                (event.shiftKey && code === 189) ||
                (event.shiftKey && code === 222)) {
                _this.editor.execCommand('autocomplete');
            }
        };
        _this._onEdit = function () {
            if (!_this.editor) {
                return;
            }
            if (!_this.ignoreChangeEvent) {
                _this.cachedValue = _this.editor.getValue();
                if (_this.props.onEdit) {
                    _this.props.onEdit(_this.cachedValue);
                }
            }
        };
        _this._onHasCompletion = function (instance, changeObj) {
            onHasCompletion(instance, changeObj, _this.props.onHintInformationRender);
        };
        _this.cachedValue = props.value || '';
        return _this;
    }
    HeaderEditor.prototype.componentDidMount = function () {
        var _this = this;
        this.initializeEditor()
            .then(function (editor) {
            editor.on('change', _this._onEdit);
            editor.on('keyup', _this._onKeyUp);
            editor.on('hasCompletion', _this._onHasCompletion);
        })
            .catch(console.error);
    };
    HeaderEditor.prototype.componentDidUpdate = function (prevProps) {
        if (!this.editor) {
            return;
        }
        this.ignoreChangeEvent = true;
        if (this.props.value !== prevProps.value &&
            this.props.value !== this.cachedValue) {
            var thisValue = this.props.value || '';
            this.cachedValue = thisValue;
            this.editor.setValue(thisValue);
        }
        this.ignoreChangeEvent = false;
    };
    HeaderEditor.prototype.componentWillUnmount = function () {
        if (!this.editor) {
            return;
        }
        this.editor.off('change', this._onEdit);
        this.editor.off('keyup', this._onKeyUp);
        this.editor.off('hasCompletion', this._onHasCompletion);
        this.editor = null;
    };
    HeaderEditor.prototype.render = function () {
        var _this = this;
        return (React.createElement("div", { className: "codemirrorWrap", style: {
                position: this.props.active ? 'relative' : 'absolute',
                visibility: this.props.active ? 'visible' : 'hidden',
            }, ref: function (node) {
                _this._node = node;
            } }));
    };
    HeaderEditor.prototype.initializeEditor = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _a, editor;
            var _this = this;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this;
                        return [4, importCodeMirror(this.addonModules())];
                    case 1:
                        _a.CodeMirror = _b.sent();
                        editor = (this.editor = this.CodeMirror(this._node, {
                            value: this.props.value || '',
                            lineNumbers: true,
                            tabSize: 2,
                            mode: { name: 'javascript', json: true },
                            theme: this.props.editorTheme || 'graphiql',
                            keyMap: 'sublime',
                            autoCloseBrackets: true,
                            matchBrackets: true,
                            showCursorWhenSelecting: true,
                            readOnly: this.props.readOnly ? 'nocursor' : false,
                            foldGutter: {
                                minFoldSize: 4,
                            },
                            gutters: ['CodeMirror-linenumbers', 'CodeMirror-foldgutter'],
                            extraKeys: __assign({ 'Cmd-Space': function () {
                                    return _this.editor.showHint({
                                        completeSingle: false,
                                        container: _this._node,
                                    });
                                }, 'Ctrl-Space': function () {
                                    return _this.editor.showHint({
                                        completeSingle: false,
                                        container: _this._node,
                                    });
                                }, 'Alt-Space': function () {
                                    return _this.editor.showHint({
                                        completeSingle: false,
                                        container: _this._node,
                                    });
                                }, 'Shift-Space': function () {
                                    return _this.editor.showHint({
                                        completeSingle: false,
                                        container: _this._node,
                                    });
                                }, 'Cmd-Enter': function () {
                                    if (_this.props.onRunQuery) {
                                        _this.props.onRunQuery();
                                    }
                                }, 'Ctrl-Enter': function () {
                                    if (_this.props.onRunQuery) {
                                        _this.props.onRunQuery();
                                    }
                                }, 'Shift-Ctrl-P': function () {
                                    if (_this.props.onPrettifyQuery) {
                                        _this.props.onPrettifyQuery();
                                    }
                                }, 'Shift-Ctrl-M': function () {
                                    if (_this.props.onMergeQuery) {
                                        _this.props.onMergeQuery();
                                    }
                                } }, commonKeys),
                        }));
                        return [2, editor];
                }
            });
        });
    };
    HeaderEditor.prototype.getCodeMirror = function () {
        return this.editor;
    };
    HeaderEditor.prototype.getClientHeight = function () {
        return this._node && this._node.clientHeight;
    };
    return HeaderEditor;
}(React.Component));
export { HeaderEditor };
//# sourceMappingURL=HeaderEditor.js.map