var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import React from 'react';
function TabCloseButton(props) {
    return (React.createElement("div", { role: "button", "aria-pressed": false, className: "close", "aria-label": "Close Tab", title: "Close Tab", onClick: function (ev) {
            ev.stopPropagation();
            props.onClick();
        } }));
}
export function Tab(props) {
    return (React.createElement("button", __assign({}, props.tabProps, { role: "tab", type: "button", "aria-selected": props.isActive, title: props.title, className: "tab" + (props.isActive ? ' active' : ''), onClick: props.onSelect }),
        props.title,
        props.isCloseable ? (React.createElement(TabCloseButton, { onClick: function () { return props.onClose(); } })) : null));
}
export function TabAddButton(props) {
    return (React.createElement("button", { onClick: props.onClick, className: "tab-add", title: "Create new tab" },
        React.createElement("span", null, '+')));
}
export function Tabs(props) {
    return (React.createElement("div", __assign({ role: "tablist", className: "tabs" }, props.tabsProps), props.children));
}
//# sourceMappingURL=Tabs.js.map