"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var TypeLink_1 = __importDefault(require("./TypeLink"));
var MarkdownContent_1 = __importDefault(require("./MarkdownContent"));
var react_2 = require("@graphiql/react");
function SchemaDoc() {
    var _a, _b;
    var schema = (0, react_2.useSchemaContext)({ nonNull: true }).schema;
    if (!schema) {
        return null;
    }
    var queryType = schema.getQueryType();
    var mutationType = (_a = schema.getMutationType) === null || _a === void 0 ? void 0 : _a.call(schema);
    var subscriptionType = (_b = schema.getSubscriptionType) === null || _b === void 0 ? void 0 : _b.call(schema);
    return (react_1.default.createElement("div", null,
        react_1.default.createElement(MarkdownContent_1.default, { className: "doc-type-description", markdown: schema.description ||
                'A GraphQL schema provides a root type for each kind of operation.' }),
        react_1.default.createElement("div", { className: "doc-category" },
            react_1.default.createElement("div", { className: "doc-category-title" }, "root types"),
            queryType ? (react_1.default.createElement("div", { className: "doc-category-item" },
                react_1.default.createElement("span", { className: "keyword" }, "query"),
                ': ',
                react_1.default.createElement(TypeLink_1.default, { type: queryType }))) : null,
            mutationType && (react_1.default.createElement("div", { className: "doc-category-item" },
                react_1.default.createElement("span", { className: "keyword" }, "mutation"),
                ': ',
                react_1.default.createElement(TypeLink_1.default, { type: mutationType }))),
            subscriptionType && (react_1.default.createElement("div", { className: "doc-category-item" },
                react_1.default.createElement("span", { className: "keyword" }, "subscription"),
                ': ',
                react_1.default.createElement(TypeLink_1.default, { type: subscriptionType }))))));
}
exports.default = SchemaDoc;
//# sourceMappingURL=SchemaDoc.js.map