"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = require("@graphiql/react");
var graphql_1 = require("graphql");
var react_2 = __importDefault(require("react"));
function TypeLink(props) {
    var push = (0, react_1.useExplorerContext)({ nonNull: true, caller: TypeLink }).push;
    if (!props.type) {
        return null;
    }
    var type = props.type;
    if ((0, graphql_1.isNonNullType)(type)) {
        return (react_2.default.createElement(react_2.default.Fragment, null,
            react_2.default.createElement(TypeLink, { type: type.ofType }),
            "!"));
    }
    if ((0, graphql_1.isListType)(type)) {
        return (react_2.default.createElement(react_2.default.Fragment, null,
            "[",
            react_2.default.createElement(TypeLink, { type: type.ofType }),
            "]"));
    }
    return (react_2.default.createElement("a", { className: "type-name", onClick: function (event) {
            event.preventDefault();
            push({ name: type.name, def: type });
        }, href: "#" }, type.name));
}
exports.default = TypeLink;
//# sourceMappingURL=TypeLink.js.map