import React, { PropsWithChildren, ReactNode } from 'react';
import { GraphQLSchema, ValidationRule, FragmentDefinitionNode, DocumentNode } from 'graphql';
import { ExecutionContextType, useDragResize } from '@graphiql/react';
import type { EditorContextType, ExplorerContextType, HistoryContextType, ResponseTooltipType, SchemaContextType, StorageContextType, TabsState, KeyMap } from '@graphiql/react';
import { ToolbarButton } from './ToolbarButton';
import { ToolbarGroup } from './ToolbarGroup';
import { ToolbarMenu } from './ToolbarMenu';
import { QueryEditor } from './QueryEditor';
import { VariableEditor } from './VariableEditor';
import { HeaderEditor } from './HeaderEditor';
import { ResultViewer } from './ResultViewer';
import type { Fetcher, GetDefaultFieldNamesFn } from '@graphiql/toolkit';
export declare type GraphiQLToolbarConfig = {
    additionalContent?: React.ReactNode;
};
export declare type GraphiQLProps = {
    fetcher: Fetcher;
    schema?: GraphQLSchema | null;
    validationRules?: ValidationRule[];
    query?: string;
    variables?: string;
    headers?: string;
    operationName?: string;
    response?: string;
    storage?: Storage;
    defaultQuery?: string;
    defaultVariableEditorOpen?: boolean;
    defaultSecondaryEditorOpen?: boolean;
    headerEditorEnabled?: boolean;
    shouldPersistHeaders?: boolean;
    externalFragments?: string | FragmentDefinitionNode[];
    onCopyQuery?: (query?: string) => void;
    onEditQuery?: (query?: string, documentAST?: DocumentNode) => void;
    onEditVariables?: (value: string) => void;
    onEditHeaders?: (value: string) => void;
    onEditOperationName?: (operationName: string) => void;
    onToggleDocs?: (docExplorerOpen: boolean) => void;
    getDefaultFieldNames?: GetDefaultFieldNamesFn;
    editorTheme?: string;
    keyMap?: KeyMap;
    onToggleHistory?: (historyPaneOpen: boolean) => void;
    ResultsTooltip?: ResponseTooltipType;
    dangerouslyAssumeSchemaIsValid?: boolean;
    inputValueDeprecation?: boolean;
    schemaDescription?: boolean;
    introspectionQueryName?: string;
    readOnly?: boolean;
    docExplorerOpen?: boolean;
    toolbar?: GraphiQLToolbarConfig;
    maxHistoryLength?: number;
    onSchemaChange?: (schema: GraphQLSchema) => void;
    beforeTopBarContent?: React.ReactElement | null;
    tabs?: boolean | {
        onTabChange?: (tab: TabsState) => void;
    };
    children?: ReactNode;
};
export declare class GraphiQL extends React.Component<GraphiQLProps> {
    ref: GraphiQLWithContext | null;
    constructor(props: GraphiQLProps);
    componentDidMount(): void;
    render(): JSX.Element;
    getQueryEditor(): import("@graphiql/react/types/editor/context").CodeMirrorEditorWithOperationFacts | null;
    getVariableEditor(): import("@graphiql/react/types/editor/types").CodeMirrorEditor | null;
    getHeaderEditor(): import("@graphiql/react/types/editor/types").CodeMirrorEditor | null;
    refresh(): void;
    autoCompleteLeafs(): string | undefined;
    static formatResult: (result: any) => string;
    static formatError: (error: any) => string;
    static Logo: typeof GraphiQLLogo;
    static Toolbar: typeof GraphiQLToolbar;
    static Footer: typeof GraphiQLFooter;
    static QueryEditor: typeof QueryEditor;
    static VariableEditor: typeof VariableEditor;
    static HeaderEditor: typeof HeaderEditor;
    static ResultViewer: typeof ResultViewer;
    static Button: typeof ToolbarButton;
    static ToolbarButton: typeof ToolbarButton;
    static Group: typeof ToolbarGroup;
    static Menu: typeof ToolbarMenu;
    static MenuItem: React.FC<{
        onSelect: () => void;
        title: string;
        label: string;
    }>;
}
declare type GraphiQLWithContextProviderProps = Omit<GraphiQLProps, 'dangerouslyAssumeSchemaIsValid' | 'defaultQuery' | 'docExplorerOpen' | 'fetcher' | 'headers' | 'inputValueDeprecation' | 'introspectionQueryName' | 'maxHistoryLength' | 'onSchemaChange' | 'onToggleDocs' | 'onToggleHistory' | 'query' | 'schema' | 'schemaDescription' | 'storage' | 'variables'>;
declare type GraphiQLWithContextConsumerProps = Omit<GraphiQLWithContextProviderProps, 'fetcher' | 'getDefaultFieldNames'> & {
    editorContext: EditorContextType;
    executionContext: ExecutionContextType;
    explorerContext: ExplorerContextType | null;
    historyContext: HistoryContextType | null;
    schemaContext: SchemaContextType;
    storageContext: StorageContextType | null;
    autoCompleteLeafs(): string | undefined;
    copy(): void;
    merge(): void;
    prettify(): void;
    docResize: ReturnType<typeof useDragResize>;
    editorResize: ReturnType<typeof useDragResize>;
    secondaryEditorResize: ReturnType<typeof useDragResize>;
};
export declare type GraphiQLState = {
    activeSecondaryEditor: 'variable' | 'header';
};
declare class GraphiQLWithContext extends React.Component<GraphiQLWithContextConsumerProps, GraphiQLState> {
    constructor(props: GraphiQLWithContextConsumerProps);
    render(): JSX.Element;
    getQueryEditor(): import("@graphiql/react/types/editor/context").CodeMirrorEditorWithOperationFacts | null;
    getVariableEditor(): import("@graphiql/react/types/editor/types").CodeMirrorEditor | null;
    getHeaderEditor(): import("@graphiql/react/types/editor/types").CodeMirrorEditor | null;
    refresh(): void;
    autoCompleteLeafs(): string | undefined;
}
declare function GraphiQLLogo<TProps>(props: PropsWithChildren<TProps>): JSX.Element;
declare namespace GraphiQLLogo {
    var displayName: string;
}
declare function GraphiQLToolbar<TProps>(props: PropsWithChildren<TProps>): JSX.Element;
declare namespace GraphiQLToolbar {
    var displayName: string;
}
declare function GraphiQLFooter<TProps>(props: PropsWithChildren<TProps>): JSX.Element;
declare namespace GraphiQLFooter {
    var displayName: string;
}
export {};
//# sourceMappingURL=GraphiQL.d.ts.map