var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
import { useEditorContext, useExecutionContext } from '@graphiql/react';
import React, { useState } from 'react';
export function ExecuteButton() {
    var queryEditor = useEditorContext({ nonNull: true }).queryEditor;
    var _a = useExecutionContext({
        nonNull: true,
    }), isFetching = _a.isFetching, run = _a.run, stop = _a.stop, subscription = _a.subscription;
    var _b = __read(useState(false), 2), optionsOpen = _b[0], setOptionsOpen = _b[1];
    var _c = __read(useState(null), 2), highlight = _c[0], setHighlight = _c[1];
    var isRunning = isFetching || Boolean(subscription);
    var operations = (queryEditor === null || queryEditor === void 0 ? void 0 : queryEditor.operations) || [];
    var hasOptions = operations.length > 1;
    return (React.createElement("div", { className: "execute-button-wrap" },
        React.createElement("button", { type: "button", className: "execute-button", onMouseDown: !isRunning && hasOptions && !optionsOpen
                ? function (downEvent) {
                    var initialPress = true;
                    var downTarget = downEvent.currentTarget;
                    setHighlight(null);
                    setOptionsOpen(true);
                    var onMouseUp = function (upEvent) {
                        var _a;
                        if (initialPress && upEvent.target === downTarget) {
                            initialPress = false;
                        }
                        else {
                            document.removeEventListener('mouseup', onMouseUp);
                            onMouseUp = null;
                            var isOptionsMenuClicked = upEvent.currentTarget &&
                                ((_a = downTarget.parentNode) === null || _a === void 0 ? void 0 : _a.compareDocumentPosition(upEvent.currentTarget)) &&
                                Node.DOCUMENT_POSITION_CONTAINED_BY;
                            if (!isOptionsMenuClicked) {
                                setOptionsOpen(false);
                            }
                        }
                    };
                    document.addEventListener('mouseup', onMouseUp);
                }
                : undefined, onClick: isRunning || !hasOptions
                ? function () {
                    if (isRunning) {
                        stop();
                    }
                    else {
                        run();
                    }
                }
                : undefined, title: "Execute Query (Ctrl-Enter)" },
            React.createElement("svg", { width: "34", height: "34" }, isRunning ? (React.createElement("path", { d: "M 10 10 L 23 10 L 23 23 L 10 23 z" })) : (React.createElement("path", { d: "M 11 9 L 24 16 L 11 23 z" })))),
        hasOptions && optionsOpen ? (React.createElement("ul", { className: "execute-options" }, operations.map(function (operation, i) {
            var opName = operation.name
                ? operation.name.value
                : "<Unnamed ".concat(operation.operation, ">");
            return (React.createElement("li", { key: "".concat(opName, "-").concat(i), className: operation === highlight ? 'selected' : undefined, onMouseOver: function () { return setHighlight(operation); }, onMouseOut: function () { return setHighlight(null); }, onMouseUp: function () {
                    var _a;
                    setOptionsOpen(false);
                    run((_a = operation.name) === null || _a === void 0 ? void 0 : _a.value);
                } }, opName));
        }))) : null));
}
//# sourceMappingURL=ExecuteButton.js.map