"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExecuteButton = void 0;
var react_1 = require("@graphiql/react");
var react_2 = __importStar(require("react"));
function ExecuteButton() {
    var queryEditor = (0, react_1.useEditorContext)({ nonNull: true }).queryEditor;
    var _a = (0, react_1.useExecutionContext)({
        nonNull: true,
    }), isFetching = _a.isFetching, run = _a.run, stop = _a.stop, subscription = _a.subscription;
    var _b = __read((0, react_2.useState)(false), 2), optionsOpen = _b[0], setOptionsOpen = _b[1];
    var _c = __read((0, react_2.useState)(null), 2), highlight = _c[0], setHighlight = _c[1];
    var isRunning = isFetching || Boolean(subscription);
    var operations = (queryEditor === null || queryEditor === void 0 ? void 0 : queryEditor.operations) || [];
    var hasOptions = operations.length > 1;
    return (react_2.default.createElement("div", { className: "execute-button-wrap" },
        react_2.default.createElement("button", { type: "button", className: "execute-button", onMouseDown: !isRunning && hasOptions && !optionsOpen
                ? function (downEvent) {
                    var initialPress = true;
                    var downTarget = downEvent.currentTarget;
                    setHighlight(null);
                    setOptionsOpen(true);
                    var onMouseUp = function (upEvent) {
                        var _a;
                        if (initialPress && upEvent.target === downTarget) {
                            initialPress = false;
                        }
                        else {
                            document.removeEventListener('mouseup', onMouseUp);
                            onMouseUp = null;
                            var isOptionsMenuClicked = upEvent.currentTarget &&
                                ((_a = downTarget.parentNode) === null || _a === void 0 ? void 0 : _a.compareDocumentPosition(upEvent.currentTarget)) &&
                                Node.DOCUMENT_POSITION_CONTAINED_BY;
                            if (!isOptionsMenuClicked) {
                                setOptionsOpen(false);
                            }
                        }
                    };
                    document.addEventListener('mouseup', onMouseUp);
                }
                : undefined, onClick: isRunning || !hasOptions
                ? function () {
                    if (isRunning) {
                        stop();
                    }
                    else {
                        run();
                    }
                }
                : undefined, title: "Execute Query (Ctrl-Enter)" },
            react_2.default.createElement("svg", { width: "34", height: "34" }, isRunning ? (react_2.default.createElement("path", { d: "M 10 10 L 23 10 L 23 23 L 10 23 z" })) : (react_2.default.createElement("path", { d: "M 11 9 L 24 16 L 11 23 z" })))),
        hasOptions && optionsOpen ? (react_2.default.createElement("ul", { className: "execute-options" }, operations.map(function (operation, i) {
            var opName = operation.name
                ? operation.name.value
                : "<Unnamed ".concat(operation.operation, ">");
            return (react_2.default.createElement("li", { key: "".concat(opName, "-").concat(i), className: operation === highlight ? 'selected' : undefined, onMouseOver: function () { return setHighlight(operation); }, onMouseOut: function () { return setHighlight(null); }, onMouseUp: function () {
                    var _a;
                    setOptionsOpen(false);
                    run((_a = operation.name) === null || _a === void 0 ? void 0 : _a.value);
                } }, opName));
        }))) : null));
}
exports.ExecuteButton = ExecuteButton;
//# sourceMappingURL=ExecuteButton.js.map