import React from 'react';
import { isType } from 'graphql';
import { useExplorerContext, useSchemaContext } from '@graphiql/react';
import FieldDoc from './DocExplorer/FieldDoc';
import SchemaDoc from './DocExplorer/SchemaDoc';
import SearchBox from './DocExplorer/SearchBox';
import SearchResults from './DocExplorer/SearchResults';
import TypeDoc from './DocExplorer/TypeDoc';
export function DocExplorer(props) {
    var _a = useSchemaContext({ nonNull: true }), fetchError = _a.fetchError, isFetching = _a.isFetching, schemaFromContext = _a.schema, validationErrors = _a.validationErrors;
    var _b = useExplorerContext({
        nonNull: true,
    }), explorerNavStack = _b.explorerNavStack, hide = _b.hide, pop = _b.pop, showSearch = _b.showSearch;
    var navItem = explorerNavStack[explorerNavStack.length - 1];
    var schema = props.schema === undefined ? schemaFromContext : props.schema;
    var content = null;
    if (fetchError) {
        content = React.createElement("div", { className: "error-container" }, "Error fetching schema");
    }
    else if (validationErrors) {
        content = (React.createElement("div", { className: "error-container" },
            "Schema is invalid: ",
            validationErrors[0].message));
    }
    else if (isFetching) {
        content = React.createElement("div", { className: "graphiql-spinner" });
    }
    else if (!schema) {
        content = React.createElement("div", { className: "error-container" }, "No Schema Available");
    }
    else if (navItem.search) {
        content = React.createElement(SearchResults, null);
    }
    else if (explorerNavStack.length === 1) {
        content = React.createElement(SchemaDoc, null);
    }
    else if (isType(navItem.def)) {
        content = React.createElement(TypeDoc, null);
    }
    else if (navItem.def) {
        content = React.createElement(FieldDoc, null);
    }
    var shouldSearchBoxAppear = explorerNavStack.length === 1 ||
        (isType(navItem.def) && 'getFields' in navItem.def);
    var prevName;
    if (explorerNavStack.length > 1) {
        prevName = explorerNavStack[explorerNavStack.length - 2].name;
    }
    return (React.createElement("section", { className: "doc-explorer", key: navItem.name, "aria-label": "Documentation Explorer" },
        React.createElement("div", { className: "doc-explorer-title-bar" },
            prevName && (React.createElement("button", { className: "doc-explorer-back", onClick: pop, "aria-label": "Go back to ".concat(prevName) }, prevName)),
            React.createElement("div", { className: "doc-explorer-title" }, navItem.title || navItem.name),
            React.createElement("div", { className: "doc-explorer-rhs" },
                React.createElement("button", { className: "docExplorerHide", onClick: function () {
                        var _a;
                        hide();
                        (_a = props.onClose) === null || _a === void 0 ? void 0 : _a.call(props);
                    }, "aria-label": "Close Documentation Explorer" }, '\u2715'))),
        React.createElement("div", { className: "doc-explorer-contents" },
            shouldSearchBoxAppear && (React.createElement(SearchBox, { value: navItem.search, placeholder: "Search ".concat(navItem.name, "..."), onSearch: showSearch })),
            content)));
}
//# sourceMappingURL=DocExplorer.js.map