"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GraphiQL = void 0;
var react_1 = __importStar(require("react"));
var react_2 = require("@graphiql/react");
var ToolbarMenu_1 = require("./ToolbarMenu");
var find_1 = __importDefault(require("../utility/find"));
var toolkit_1 = require("@graphiql/toolkit");
var majorVersion = parseInt(react_1.default.version.slice(0, 2), 10);
if (majorVersion < 16) {
    throw Error([
        'GraphiQL 0.18.0 and after is not compatible with React 15 or below.',
        'If you are using a CDN source (jsdelivr, unpkg, etc), follow this example:',
        'https://github.com/graphql/graphiql/blob/master/examples/graphiql-cdn/index.html#L49',
    ].join('\n'));
}
var GraphiQL = (function (_super) {
    __extends(GraphiQL, _super);
    function GraphiQL(props) {
        var _this = _super.call(this, props) || this;
        _this.ref = null;
        return _this;
    }
    GraphiQL.prototype.componentDidMount = function () {
        if (typeof window !== 'undefined') {
            window.g = this;
        }
    };
    GraphiQL.prototype.render = function () {
        var _this = this;
        return (react_1.default.createElement(GraphiQLProviders, __assign({}, this.props, { ref: function (node) {
                _this.ref = node;
            } })));
    };
    GraphiQL.prototype.getQueryEditor = function () {
        var _a;
        console.warn('The method `GraphiQL.getQueryEditor` is deprecated and will be removed in the next major version. To set the value of the editor you can use the `query` prop. To react on changes of the editor value you can pass a callback to the `onEditQuery` prop.');
        return ((_a = this.ref) === null || _a === void 0 ? void 0 : _a.getQueryEditor()) || null;
    };
    GraphiQL.prototype.getVariableEditor = function () {
        var _a;
        console.warn('The method `GraphiQL.getVariableEditor` is deprecated and will be removed in the next major version. To set the value of the editor you can use the `variables` prop. To react on changes of the editor value you can pass a callback to the `onEditVariables` prop.');
        return ((_a = this.ref) === null || _a === void 0 ? void 0 : _a.getVariableEditor()) || null;
    };
    GraphiQL.prototype.getHeaderEditor = function () {
        var _a;
        console.warn('The method `GraphiQL.getHeaderEditor` is deprecated and will be removed in the next major version. To set the value of the editor you can use the `headers` prop. To react on changes of the editor value you can pass a callback to the `onEditHeaders` prop.');
        return ((_a = this.ref) === null || _a === void 0 ? void 0 : _a.getHeaderEditor()) || null;
    };
    GraphiQL.prototype.refresh = function () {
        var _a;
        console.warn('The method `GraphiQL.refresh` is deprecated and will be removed in the next major version. Already now, all editors should automatically refresh when their size changes.');
        (_a = this.ref) === null || _a === void 0 ? void 0 : _a.refresh();
    };
    GraphiQL.prototype.autoCompleteLeafs = function () {
        var _a;
        console.warn('The method `GraphiQL.autoCompleteLeafs` is deprecated and will be removed in the next major version. Please switch to using the `autoCompleteLeafs` function provided by the `EditorContext` from the `@graphiql/react` package.');
        return (_a = this.ref) === null || _a === void 0 ? void 0 : _a.autoCompleteLeafs();
    };
    GraphiQL.formatResult = function (result) {
        console.warn('The function `GraphiQL.formatResult` is deprecated and will be removed in the next major version. Please switch to using the `formatResult` function provided by the `@graphiql/toolkit` package.');
        return (0, toolkit_1.formatResult)(result);
    };
    GraphiQL.formatError = function (error) {
        console.warn('The function `GraphiQL.formatError` is deprecated and will be removed in the next major version. Please switch to using the `formatError` function provided by the `@graphiql/toolkit` package.');
        return (0, toolkit_1.formatError)(error);
    };
    GraphiQL.Logo = GraphiQLLogo;
    GraphiQL.Toolbar = GraphiQLToolbar;
    GraphiQL.Footer = GraphiQLFooter;
    GraphiQL.QueryEditor = react_2.QueryEditor;
    GraphiQL.VariableEditor = react_2.VariableEditor;
    GraphiQL.HeaderEditor = react_2.HeaderEditor;
    GraphiQL.ResultViewer = react_2.ResponseEditor;
    GraphiQL.Menu = ToolbarMenu_1.ToolbarMenu;
    GraphiQL.MenuItem = ToolbarMenu_1.ToolbarMenuItem;
    return GraphiQL;
}(react_1.default.Component));
exports.GraphiQL = GraphiQL;
var GraphiQLProviders = (0, react_1.forwardRef)(function GraphiQLProviders(_a, ref) {
    var dangerouslyAssumeSchemaIsValid = _a.dangerouslyAssumeSchemaIsValid, docExplorerOpen = _a.docExplorerOpen, fetcher = _a.fetcher, inputValueDeprecation = _a.inputValueDeprecation, introspectionQueryName = _a.introspectionQueryName, maxHistoryLength = _a.maxHistoryLength, onSchemaChange = _a.onSchemaChange, onTabChange = _a.onTabChange, onToggleHistory = _a.onToggleHistory, onToggleDocs = _a.onToggleDocs, storage = _a.storage, schema = _a.schema, schemaDescription = _a.schemaDescription, props = __rest(_a, ["dangerouslyAssumeSchemaIsValid", "docExplorerOpen", "fetcher", "inputValueDeprecation", "introspectionQueryName", "maxHistoryLength", "onSchemaChange", "onTabChange", "onToggleHistory", "onToggleDocs", "storage", "schema", "schemaDescription"]);
    if (typeof fetcher !== 'function') {
        throw new TypeError('GraphiQL requires a fetcher function.');
    }
    return (react_1.default.createElement(react_2.StorageContextProvider, { storage: storage },
        react_1.default.createElement(react_2.HistoryContextProvider, { maxHistoryLength: maxHistoryLength, onToggle: onToggleHistory },
            react_1.default.createElement(react_2.EditorContextProvider, { defaultQuery: props.defaultQuery, headers: props.headers, onTabChange: onTabChange, query: props.query, shouldPersistHeaders: props.shouldPersistHeaders, variables: props.variables },
                react_1.default.createElement(react_2.SchemaContextProvider, { dangerouslyAssumeSchemaIsValid: dangerouslyAssumeSchemaIsValid, fetcher: fetcher, inputValueDeprecation: inputValueDeprecation, introspectionQueryName: introspectionQueryName, onSchemaChange: onSchemaChange, schema: schema, schemaDescription: schemaDescription },
                    react_1.default.createElement(react_2.ExecutionContextProvider, { externalFragments: props.externalFragments, fetcher: fetcher, onEditOperationName: props.onEditOperationName, shouldPersistHeaders: props.shouldPersistHeaders },
                        react_1.default.createElement(react_2.ExplorerContextProvider, { isVisible: docExplorerOpen, onToggleVisibility: onToggleDocs },
                            react_1.default.createElement(GraphiQLConsumeContexts, __assign({}, props, { ref: ref })))))))));
});
var GraphiQLConsumeContexts = (0, react_1.forwardRef)(function GraphiQLConsumeContexts(_a, ref) {
    var getDefaultFieldNames = _a.getDefaultFieldNames, props = __rest(_a, ["getDefaultFieldNames"]);
    var editorContext = (0, react_2.useEditorContext)({ nonNull: true });
    var executionContext = (0, react_2.useExecutionContext)({ nonNull: true });
    var explorerContext = (0, react_2.useExplorerContext)();
    var historyContext = (0, react_2.useHistoryContext)();
    var schemaContext = (0, react_2.useSchemaContext)({ nonNull: true });
    var storageContext = (0, react_2.useStorageContext)();
    var autoCompleteLeafs = (0, react_2.useAutoCompleteLeafs)({ getDefaultFieldNames: getDefaultFieldNames });
    var copy = (0, react_2.useCopyQuery)({ onCopyQuery: props.onCopyQuery });
    var merge = (0, react_2.useMergeQuery)();
    var prettify = (0, react_2.usePrettifyEditors)();
    var pluginResize = (0, react_2.useDragResize)({
        defaultSizeRelation: 1 / 3,
        direction: 'horizontal',
        initiallyHidden: (explorerContext === null || explorerContext === void 0 ? void 0 : explorerContext.isVisible) || (historyContext === null || historyContext === void 0 ? void 0 : historyContext.isVisible)
            ? undefined
            : 'first',
        onHiddenElementChange: function (resizableElement) {
            if (resizableElement === 'first') {
                explorerContext === null || explorerContext === void 0 ? void 0 : explorerContext.hide();
                historyContext === null || historyContext === void 0 ? void 0 : historyContext.hide();
            }
        },
        sizeThresholdSecond: 200,
        storageKey: 'docExplorerFlex',
    });
    var editorResize = (0, react_2.useDragResize)({
        direction: 'horizontal',
        storageKey: 'editorFlex',
    });
    var editorToolsResize = (0, react_2.useDragResize)({
        defaultSizeRelation: 3,
        direction: 'vertical',
        initiallyHidden: (function () {
            if (props.defaultVariableEditorOpen !== undefined) {
                return props.defaultVariableEditorOpen ? undefined : 'second';
            }
            if (props.defaultSecondaryEditorOpen !== undefined) {
                return props.defaultSecondaryEditorOpen ? undefined : 'second';
            }
            return editorContext.initialVariables || editorContext.initialHeaders
                ? undefined
                : 'second';
        })(),
        sizeThresholdSecond: 60,
        storageKey: 'secondaryEditorFlex',
    });
    return (react_1.default.createElement(GraphiQLWithContext, __assign({}, props, { editorContext: editorContext, executionContext: executionContext, explorerContext: explorerContext, historyContext: historyContext, schemaContext: schemaContext, storageContext: storageContext, autoCompleteLeafs: autoCompleteLeafs, copy: copy, merge: merge, prettify: prettify, pluginResize: pluginResize, editorResize: editorResize, editorToolsResize: editorToolsResize, ref: ref })));
});
var GraphiQLWithContext = (function (_super) {
    __extends(GraphiQLWithContext, _super);
    function GraphiQLWithContext(props) {
        var _this = _super.call(this, props) || this;
        _this.state = { activeSecondaryEditor: 'variable' };
        return _this;
    }
    GraphiQLWithContext.prototype.render = function () {
        var _this = this;
        var _a, _b, _c, _d, _e, _f;
        var children = react_1.default.Children.toArray(this.props.children);
        var logo = (0, find_1.default)(children, function (child) {
            return isChildComponentType(child, GraphiQL.Logo);
        }) || react_1.default.createElement(GraphiQL.Logo, null);
        var toolbar = (0, find_1.default)(children, function (child) {
            return isChildComponentType(child, GraphiQL.Toolbar);
        }) || (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(react_2.ToolbarButton, { onClick: function () {
                    _this.props.prettify();
                }, title: "Prettify Query (Shift-Ctrl-P)", "aria-label": "Prettify" },
                react_1.default.createElement(react_2.PrettifyIcon, { className: "graphiql-toolbar-icon" })),
            react_1.default.createElement(react_2.ToolbarButton, { onClick: function () {
                    _this.props.merge();
                }, title: "Merge Query (Shift-Ctrl-M)", "aria-label": "Merge" },
                react_1.default.createElement(react_2.MergeIcon, { className: "graphiql-toolbar-icon" })),
            react_1.default.createElement(react_2.ToolbarButton, { onClick: function () {
                    _this.props.copy();
                }, title: "Copy Query (Shift-Ctrl-C)", "aria-label": "Copy" },
                react_1.default.createElement(react_2.CopyIcon, { className: "graphiql-toolbar-icon" })),
            ((_a = this.props.toolbar) === null || _a === void 0 ? void 0 : _a.additionalContent)
                ? this.props.toolbar.additionalContent
                : null));
        var footer = (0, find_1.default)(children, function (child) {
            return isChildComponentType(child, GraphiQL.Footer);
        });
        var headerEditorEnabled = (_b = this.props.headerEditorEnabled) !== null && _b !== void 0 ? _b : true;
        var onClickReference = function () {
            if (_this.props.pluginResize.hiddenElement === 'first') {
                _this.props.pluginResize.setHiddenElement(null);
            }
        };
        return (react_1.default.createElement("div", { "data-testid": "graphiql-container", className: "graphiql-container" },
            react_1.default.createElement("div", { className: "graphiql-sidebar" },
                react_1.default.createElement("div", null,
                    this.props.explorerContext ? (react_1.default.createElement(react_2.UnStyledButton, { className: this.props.explorerContext.isVisible ? 'active' : '', onClick: function () {
                            var _a, _b, _c, _d;
                            if ((_a = _this.props.explorerContext) === null || _a === void 0 ? void 0 : _a.isVisible) {
                                (_b = _this.props.explorerContext) === null || _b === void 0 ? void 0 : _b.hide();
                                _this.props.pluginResize.setHiddenElement('first');
                            }
                            else {
                                (_c = _this.props.explorerContext) === null || _c === void 0 ? void 0 : _c.show();
                                _this.props.pluginResize.setHiddenElement(null);
                                if ((_d = _this.props.historyContext) === null || _d === void 0 ? void 0 : _d.isVisible) {
                                    _this.props.historyContext.hide();
                                }
                            }
                        }, title: this.props.explorerContext.isVisible
                            ? 'Hide Documentation Explorer'
                            : 'Show Documentation Explorer' },
                        react_1.default.createElement(react_2.DocsIcon, null))) : null,
                    this.props.historyContext ? (react_1.default.createElement(react_2.UnStyledButton, { className: this.props.historyContext.isVisible ? 'active' : '', onClick: function () {
                            var _a;
                            if (!_this.props.historyContext) {
                                return;
                            }
                            _this.props.historyContext.toggle();
                            if (_this.props.historyContext.isVisible) {
                                _this.props.pluginResize.setHiddenElement('first');
                            }
                            else {
                                _this.props.pluginResize.setHiddenElement(null);
                                if ((_a = _this.props.explorerContext) === null || _a === void 0 ? void 0 : _a.isVisible) {
                                    _this.props.explorerContext.hide();
                                }
                            }
                        }, title: this.props.historyContext.isVisible
                            ? 'Hide History'
                            : 'Show History' },
                        react_1.default.createElement(react_2.HistoryIcon, null))) : null),
                react_1.default.createElement("div", null,
                    react_1.default.createElement(react_2.UnStyledButton, null,
                        react_1.default.createElement(react_2.KeyboardShortcutIcon, null)),
                    react_1.default.createElement(react_2.UnStyledButton, null,
                        react_1.default.createElement(react_2.SettingsIcon, null)))),
            react_1.default.createElement("div", { className: "graphiql-main" },
                react_1.default.createElement("div", { ref: this.props.pluginResize.firstRef, style: {
                        minWidth: '200px',
                    } },
                    react_1.default.createElement("div", { className: "graphiql-plugin" },
                        ((_c = this.props.explorerContext) === null || _c === void 0 ? void 0 : _c.isVisible) ? react_1.default.createElement(react_2.DocExplorer, null) : null,
                        ((_d = this.props.historyContext) === null || _d === void 0 ? void 0 : _d.isVisible) ? react_1.default.createElement(react_2.History, null) : null)),
                react_1.default.createElement("div", { ref: this.props.pluginResize.dragBarRef }, ((_e = this.props.explorerContext) === null || _e === void 0 ? void 0 : _e.isVisible) ||
                    ((_f = this.props.historyContext) === null || _f === void 0 ? void 0 : _f.isVisible) ? (react_1.default.createElement("div", { className: "graphiql-horizontal-drag-bar" })) : null),
                react_1.default.createElement("div", { ref: this.props.pluginResize.secondRef },
                    react_1.default.createElement("div", { className: "graphiql-sessions" },
                        react_1.default.createElement("div", { className: "graphiql-session-header" },
                            react_1.default.createElement(react_2.Tabs, { "aria-label": "Select active operation" }, this.props.editorContext.tabs.length > 1 ? (react_1.default.createElement(react_1.default.Fragment, null,
                                this.props.editorContext.tabs.map(function (tab, index) { return (react_1.default.createElement(react_2.Tab, { key: tab.id, isActive: index === _this.props.editorContext.activeTabIndex, title: tab.title },
                                    react_1.default.createElement(react_2.Tab.Button, { "aria-controls": "graphiql-session", id: "graphiql-session-tab-".concat(index), onClick: function () {
                                            _this.props.executionContext.stop();
                                            _this.props.editorContext.changeTab(index);
                                        } }, tab.title),
                                    react_1.default.createElement(react_2.Tab.Close, { onClick: function () {
                                            if (_this.props.editorContext.activeTabIndex ===
                                                index) {
                                                _this.props.executionContext.stop();
                                            }
                                            _this.props.editorContext.closeTab(index);
                                        } }))); }),
                                react_1.default.createElement(react_2.UnStyledButton, { className: "graphiql-tab-add", onClick: function () {
                                        _this.props.editorContext.addTab();
                                    } },
                                    react_1.default.createElement(react_2.PlusIcon, null)))) : null),
                            react_1.default.createElement("div", { className: "graphiql-session-header-right" },
                                this.props.editorContext.tabs.length === 1 ? (react_1.default.createElement(react_2.UnStyledButton, { className: "graphiql-tab-add", onClick: function () {
                                        _this.props.editorContext.addTab();
                                    } },
                                    react_1.default.createElement(react_2.PlusIcon, null))) : null,
                                react_1.default.createElement("div", { className: "graphiql-logo" }, logo))),
                        react_1.default.createElement("div", { role: "tabpanel", id: "graphiql-session", className: "graphiql-session", "aria-labelledby": "graphiql-session-tab-".concat(this.props.editorContext.activeTabIndex) },
                            react_1.default.createElement("div", { ref: this.props.editorResize.firstRef },
                                react_1.default.createElement("div", { className: "graphiql-editors".concat(this.props.editorContext.tabs.length === 1
                                        ? ' full-height'
                                        : '') },
                                    react_1.default.createElement("div", { ref: this.props.editorToolsResize.firstRef },
                                        react_1.default.createElement("section", { className: "graphiql-query-editor", "aria-label": "Query Editor" },
                                            react_1.default.createElement("div", { className: "graphiql-query-editor-wrapper" },
                                                react_1.default.createElement(react_2.QueryEditor, { editorTheme: this.props.editorTheme, externalFragments: this.props.externalFragments, keyMap: this.props.keyMap, onClickReference: onClickReference, onCopyQuery: this.props.onCopyQuery, onEdit: this.props.onEditQuery, onEditOperationName: this.props.onEditOperationName, readOnly: this.props.readOnly, validationRules: this.props.validationRules })),
                                            react_1.default.createElement("div", { className: "graphiql-toolbar", role: "toolbar", "aria-label": "Editor Commands" },
                                                react_1.default.createElement(react_2.ExecuteButton, null),
                                                toolbar))),
                                    react_1.default.createElement("div", { ref: this.props.editorToolsResize.dragBarRef },
                                        react_1.default.createElement("div", { className: "graphiql-editor-tools" },
                                            react_1.default.createElement("div", { className: "graphiql-editor-tools-tabs" },
                                                react_1.default.createElement(react_2.UnStyledButton, { className: this.state.activeSecondaryEditor === 'variable'
                                                        ? 'active'
                                                        : '', onClick: function () {
                                                        if (_this.props.editorToolsResize.hiddenElement ===
                                                            'second') {
                                                            _this.props.editorToolsResize.setHiddenElement(null);
                                                        }
                                                        _this.setState({
                                                            activeSecondaryEditor: 'variable',
                                                        });
                                                    } }, "Variables"),
                                                headerEditorEnabled ? (react_1.default.createElement(react_2.UnStyledButton, { className: this.state.activeSecondaryEditor === 'header'
                                                        ? 'active'
                                                        : '', onClick: function () {
                                                        if (_this.props.editorToolsResize.hiddenElement ===
                                                            'second') {
                                                            _this.props.editorToolsResize.setHiddenElement(null);
                                                        }
                                                        _this.setState({
                                                            activeSecondaryEditor: 'header',
                                                        });
                                                    } }, "Headers")) : null),
                                            react_1.default.createElement(react_2.UnStyledButton, { onClick: function () {
                                                    _this.props.editorToolsResize.setHiddenElement(_this.props.editorToolsResize.hiddenElement ===
                                                        'second'
                                                        ? null
                                                        : 'second');
                                                } }, this.props.editorToolsResize.hiddenElement ===
                                                'second' ? (react_1.default.createElement(react_2.ChevronUpIcon, { className: "graphiql-chevron-icon" })) : (react_1.default.createElement(react_2.ChevronDownIcon, { className: "graphiql-chevron-icon" }))))),
                                    react_1.default.createElement("div", { ref: this.props.editorToolsResize.secondRef },
                                        react_1.default.createElement("section", { className: "graphiql-editor-tool", "aria-label": this.state.activeSecondaryEditor === 'variable'
                                                ? 'Variables'
                                                : 'Headers' },
                                            react_1.default.createElement(react_2.VariableEditor, { editorTheme: this.props.editorTheme, isHidden: this.state.activeSecondaryEditor !== 'variable', keyMap: this.props.keyMap, onEdit: this.props.onEditVariables, onClickReference: onClickReference, readOnly: this.props.readOnly }),
                                            headerEditorEnabled && (react_1.default.createElement(react_2.HeaderEditor, { editorTheme: this.props.editorTheme, isHidden: this.state.activeSecondaryEditor !== 'header', keyMap: this.props.keyMap, onEdit: this.props.onEditHeaders, readOnly: this.props.readOnly, shouldPersistHeaders: this.props.shouldPersistHeaders })))))),
                            react_1.default.createElement("div", { ref: this.props.editorResize.dragBarRef },
                                react_1.default.createElement("div", { className: "graphiql-horizontal-drag-bar" })),
                            react_1.default.createElement("div", { ref: this.props.editorResize.secondRef },
                                react_1.default.createElement("div", { className: "graphiql-response" },
                                    this.props.executionContext.isFetching ? (react_1.default.createElement(react_2.Spinner, null)) : null,
                                    react_1.default.createElement(react_2.ResponseEditor, { value: this.props.response, editorTheme: this.props.editorTheme, ResponseTooltip: this.props.ResultsTooltip, keyMap: this.props.keyMap }),
                                    footer))))))));
    };
    GraphiQLWithContext.prototype.getQueryEditor = function () {
        return this.props.editorContext.queryEditor || null;
    };
    GraphiQLWithContext.prototype.getVariableEditor = function () {
        return this.props.editorContext.variableEditor || null;
    };
    GraphiQLWithContext.prototype.getHeaderEditor = function () {
        return this.props.editorContext.headerEditor || null;
    };
    GraphiQLWithContext.prototype.refresh = function () {
        var _a, _b, _c, _d;
        (_a = this.props.editorContext.queryEditor) === null || _a === void 0 ? void 0 : _a.refresh();
        (_b = this.props.editorContext.variableEditor) === null || _b === void 0 ? void 0 : _b.refresh();
        (_c = this.props.editorContext.headerEditor) === null || _c === void 0 ? void 0 : _c.refresh();
        (_d = this.props.editorContext.responseEditor) === null || _d === void 0 ? void 0 : _d.refresh();
    };
    GraphiQLWithContext.prototype.autoCompleteLeafs = function () {
        return this.props.autoCompleteLeafs();
    };
    return GraphiQLWithContext;
}(react_1.default.Component));
function GraphiQLLogo(props) {
    return (react_1.default.createElement("div", { className: "title" }, props.children || (react_1.default.createElement("span", null,
        "Graph",
        react_1.default.createElement("em", null, "i"),
        "QL"))));
}
GraphiQLLogo.displayName = 'GraphiQLLogo';
function GraphiQLToolbar(props) {
    return react_1.default.createElement(react_1.default.Fragment, null, props.children);
}
GraphiQLToolbar.displayName = 'GraphiQLToolbar';
function GraphiQLFooter(props) {
    return react_1.default.createElement("div", { className: "graphiql-footer" }, props.children);
}
GraphiQLFooter.displayName = 'GraphiQLFooter';
function isChildComponentType(child, component) {
    var _a;
    if (((_a = child === null || child === void 0 ? void 0 : child.type) === null || _a === void 0 ? void 0 : _a.displayName) &&
        child.type.displayName === component.displayName) {
        return true;
    }
    return child.type === component;
}
//# sourceMappingURL=GraphiQL.js.map