import { GraphiQLProvider } from '@graphiql/react';
import { GraphiQLProviderProps } from '@graphiql/react';
import { JSX as JSX_2 } from 'react/jsx-runtime';
import { JSXElementConstructor } from 'react';
import { PropsWithChildren } from 'react';
import { ReactNode } from 'react';
import { Theme } from '@graphiql/react';
import { UseHeaderEditorArgs } from '@graphiql/react';
import { UseQueryEditorArgs } from '@graphiql/react';
import { UseResponseEditorArgs } from '@graphiql/react';
import { UseVariableEditorArgs } from '@graphiql/react';
import { WriteableEditorProps } from '@graphiql/react';

declare type AddSuffix<Obj extends Record<string, any>, Suffix extends string> = {
    [Key in keyof Obj as `${string & Key}${Suffix}`]: Obj[Key];
};

declare function GraphiQL({ dangerouslyAssumeSchemaIsValid, confirmCloseTab, defaultQuery, defaultTabs, externalFragments, fetcher, getDefaultFieldNames, headers, inputValueDeprecation, introspectionQueryName, maxHistoryLength, onEditOperationName, onSchemaChange, onTabChange, onTogglePluginVisibility, operationName, plugins, query, response, schema, schemaDescription, shouldPersistHeaders, storage, validationRules, variables, visiblePlugin, defaultHeaders, ...props }: GraphiQLProps): JSX_2.Element;

declare namespace GraphiQL {
    var Logo: typeof GraphiQLLogo;
    var Toolbar: typeof GraphiQLToolbar;
    var Footer: typeof GraphiQLFooter;
}
export { GraphiQL }
export default GraphiQL;

declare function GraphiQLFooter<TProps>(props: PropsWithChildren<TProps>): JSX_2.Element;

declare namespace GraphiQLFooter {
    var displayName: string;
}

export declare function GraphiQLInterface(props: GraphiQLInterfaceProps): JSX_2.Element;

export declare type GraphiQLInterfaceProps = WriteableEditorProps & AddSuffix<Pick<UseQueryEditorArgs, 'onEdit'>, 'Query'> & Pick<UseQueryEditorArgs, 'onCopyQuery'> & AddSuffix<Pick<UseVariableEditorArgs, 'onEdit'>, 'Variables'> & AddSuffix<Pick<UseHeaderEditorArgs, 'onEdit'>, 'Headers'> & Pick<UseResponseEditorArgs, 'responseTooltip'> & {
    children?: ReactNode;
    defaultEditorToolsVisibility?: boolean | 'variables' | 'headers';
    isHeadersEditorEnabled?: boolean;
    toolbar?: GraphiQLToolbarConfig;
    showPersistHeadersSettings?: boolean;
    defaultTheme?: Theme;
    disableTabs?: boolean;
    forcedTheme?: (typeof THEMES)[number];
    className?: string;
    confirmCloseTab?(index: number): Promise<boolean> | boolean;
};

declare function GraphiQLLogo<TProps>(props: PropsWithChildren<TProps>): JSX_2.Element;

declare namespace GraphiQLLogo {
    var displayName: string;
}

export declare type GraphiQLProps = Omit<GraphiQLProviderProps, 'children'> & GraphiQLInterfaceProps;

export { GraphiQLProvider }

export { GraphiQLProviderProps }

declare function GraphiQLToolbar<TProps>(props: PropsWithChildren<TProps>): JSX_2.Element;

declare namespace GraphiQLToolbar {
    var displayName: string;
}

declare type GraphiQLToolbarConfig = {
    additionalContent?: ReactNode;
    additionalComponent?: JSXElementConstructor<any>;
};

declare const THEMES: readonly ["light", "dark", "system"];

export { }
