"use strict";
Object.defineProperties(exports, { __esModule: { value: true }, [Symbol.toStringTag]: { value: "Module" } });
const react = require("@graphiql/react");
const jsxRuntime = require("react/jsx-runtime");
const reactCompilerRuntime = require("react-compiler-runtime");
const react$1 = require("react");
const majorVersion = parseInt(react$1.version.slice(0, 2), 10);
if (majorVersion < 16) {
  throw new Error(["GraphiQL 0.18.0 and after is not compatible with React 15 or below.", "If you are using a CDN source (jsdelivr, unpkg, etc), follow this example:", "https://github.com/graphql/graphiql/blob/master/examples/graphiql-cdn/index.html#L49"].join("\n"));
}
function GraphiQL(t0) {
  const $ = reactCompilerRuntime.c(62);
  let confirmCloseTab;
  let dangerouslyAssumeSchemaIsValid;
  let defaultHeaders;
  let defaultQuery;
  let defaultTabs;
  let externalFragments;
  let fetcher;
  let getDefaultFieldNames;
  let headers;
  let inputValueDeprecation;
  let introspectionQueryName;
  let maxHistoryLength;
  let onEditOperationName;
  let onSchemaChange;
  let onTabChange;
  let onTogglePluginVisibility;
  let operationName;
  let plugins;
  let props;
  let query;
  let response;
  let schema;
  let schemaDescription;
  let shouldPersistHeaders;
  let storage;
  let validationRules;
  let variables;
  let visiblePlugin;
  if ($[0] !== t0) {
    ({
      dangerouslyAssumeSchemaIsValid,
      confirmCloseTab,
      defaultQuery,
      defaultTabs,
      externalFragments,
      fetcher,
      getDefaultFieldNames,
      headers,
      inputValueDeprecation,
      introspectionQueryName,
      maxHistoryLength,
      onEditOperationName,
      onSchemaChange,
      onTabChange,
      onTogglePluginVisibility,
      operationName,
      plugins,
      query,
      response,
      schema,
      schemaDescription,
      shouldPersistHeaders,
      storage,
      validationRules,
      variables,
      visiblePlugin,
      defaultHeaders,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = confirmCloseTab;
    $[2] = dangerouslyAssumeSchemaIsValid;
    $[3] = defaultHeaders;
    $[4] = defaultQuery;
    $[5] = defaultTabs;
    $[6] = externalFragments;
    $[7] = fetcher;
    $[8] = getDefaultFieldNames;
    $[9] = headers;
    $[10] = inputValueDeprecation;
    $[11] = introspectionQueryName;
    $[12] = maxHistoryLength;
    $[13] = onEditOperationName;
    $[14] = onSchemaChange;
    $[15] = onTabChange;
    $[16] = onTogglePluginVisibility;
    $[17] = operationName;
    $[18] = plugins;
    $[19] = props;
    $[20] = query;
    $[21] = response;
    $[22] = schema;
    $[23] = schemaDescription;
    $[24] = shouldPersistHeaders;
    $[25] = storage;
    $[26] = validationRules;
    $[27] = variables;
    $[28] = visiblePlugin;
  } else {
    confirmCloseTab = $[1];
    dangerouslyAssumeSchemaIsValid = $[2];
    defaultHeaders = $[3];
    defaultQuery = $[4];
    defaultTabs = $[5];
    externalFragments = $[6];
    fetcher = $[7];
    getDefaultFieldNames = $[8];
    headers = $[9];
    inputValueDeprecation = $[10];
    introspectionQueryName = $[11];
    maxHistoryLength = $[12];
    onEditOperationName = $[13];
    onSchemaChange = $[14];
    onTabChange = $[15];
    onTogglePluginVisibility = $[16];
    operationName = $[17];
    plugins = $[18];
    props = $[19];
    query = $[20];
    response = $[21];
    schema = $[22];
    schemaDescription = $[23];
    shouldPersistHeaders = $[24];
    storage = $[25];
    validationRules = $[26];
    variables = $[27];
    visiblePlugin = $[28];
  }
  if (typeof fetcher !== "function") {
    throw new TypeError("The `GraphiQL` component requires a `fetcher` function to be passed as prop.");
  }
  const t1 = shouldPersistHeaders !== false;
  const t2 = props.disableTabs ?? false;
  let t3;
  if ($[29] !== confirmCloseTab || $[30] !== props || $[31] !== t1 || $[32] !== t2) {
    t3 = /* @__PURE__ */ jsxRuntime.jsx(GraphiQLInterface, { confirmCloseTab, showPersistHeadersSettings: t1, disableTabs: t2, forcedTheme: props.forcedTheme, ...props });
    $[29] = confirmCloseTab;
    $[30] = props;
    $[31] = t1;
    $[32] = t2;
    $[33] = t3;
  } else {
    t3 = $[33];
  }
  let t4;
  if ($[34] !== dangerouslyAssumeSchemaIsValid || $[35] !== defaultHeaders || $[36] !== defaultQuery || $[37] !== defaultTabs || $[38] !== externalFragments || $[39] !== fetcher || $[40] !== getDefaultFieldNames || $[41] !== headers || $[42] !== inputValueDeprecation || $[43] !== introspectionQueryName || $[44] !== maxHistoryLength || $[45] !== onEditOperationName || $[46] !== onSchemaChange || $[47] !== onTabChange || $[48] !== onTogglePluginVisibility || $[49] !== operationName || $[50] !== plugins || $[51] !== query || $[52] !== response || $[53] !== schema || $[54] !== schemaDescription || $[55] !== shouldPersistHeaders || $[56] !== storage || $[57] !== t3 || $[58] !== validationRules || $[59] !== variables || $[60] !== visiblePlugin) {
    t4 = /* @__PURE__ */ jsxRuntime.jsx(react.GraphiQLProvider, { getDefaultFieldNames, dangerouslyAssumeSchemaIsValid, defaultQuery, defaultHeaders, defaultTabs, externalFragments, fetcher, headers, inputValueDeprecation, introspectionQueryName, maxHistoryLength, onEditOperationName, onSchemaChange, onTabChange, onTogglePluginVisibility, plugins, visiblePlugin, operationName, query, response, schema, schemaDescription, shouldPersistHeaders, storage, validationRules, variables, children: t3 });
    $[34] = dangerouslyAssumeSchemaIsValid;
    $[35] = defaultHeaders;
    $[36] = defaultQuery;
    $[37] = defaultTabs;
    $[38] = externalFragments;
    $[39] = fetcher;
    $[40] = getDefaultFieldNames;
    $[41] = headers;
    $[42] = inputValueDeprecation;
    $[43] = introspectionQueryName;
    $[44] = maxHistoryLength;
    $[45] = onEditOperationName;
    $[46] = onSchemaChange;
    $[47] = onTabChange;
    $[48] = onTogglePluginVisibility;
    $[49] = operationName;
    $[50] = plugins;
    $[51] = query;
    $[52] = response;
    $[53] = schema;
    $[54] = schemaDescription;
    $[55] = shouldPersistHeaders;
    $[56] = storage;
    $[57] = t3;
    $[58] = validationRules;
    $[59] = variables;
    $[60] = visiblePlugin;
    $[61] = t4;
  } else {
    t4 = $[61];
  }
  return t4;
}
GraphiQL.Logo = GraphiQLLogo;
GraphiQL.Toolbar = GraphiQLToolbar;
GraphiQL.Footer = GraphiQLFooter;
const THEMES = ["light", "dark", "system"];
const TAB_CLASS_PREFIX = "graphiql-session-tab-";
function GraphiQLInterface(props) {
  var _a, _b, _c;
  const $ = reactCompilerRuntime.c(226);
  const isHeadersEditorEnabled = props.isHeadersEditorEnabled ?? true;
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      nonNull: true
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const editorContext = react.useEditorContext(t0);
  let t1;
  if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = {
      nonNull: true
    };
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const executionContext = react.useExecutionContext(t1);
  let t2;
  if ($[2] === Symbol.for("react.memo_cache_sentinel")) {
    t2 = {
      nonNull: true
    };
    $[2] = t2;
  } else {
    t2 = $[2];
  }
  const schemaContext = react.useSchemaContext(t2);
  const storageContext = react.useStorageContext();
  const pluginContext = react.usePluginContext();
  const forcedTheme = props.forcedTheme && THEMES.includes(props.forcedTheme) ? props.forcedTheme : void 0;
  let t3;
  if ($[3] !== props.onCopyQuery) {
    t3 = {
      onCopyQuery: props.onCopyQuery
    };
    $[3] = props.onCopyQuery;
    $[4] = t3;
  } else {
    t3 = $[4];
  }
  const copy = react.useCopyQuery(t3);
  const merge = react.useMergeQuery();
  const prettify = react.usePrettifyEditors();
  const {
    theme,
    setTheme
  } = react.useTheme(props.defaultTheme);
  let t4;
  let t5;
  if ($[5] !== forcedTheme || $[6] !== setTheme) {
    t4 = () => {
      if (forcedTheme === "system") {
        setTheme(null);
      } else {
        if (forcedTheme === "light" || forcedTheme === "dark") {
          setTheme(forcedTheme);
        }
      }
    };
    t5 = [forcedTheme, setTheme];
    $[5] = forcedTheme;
    $[6] = setTheme;
    $[7] = t4;
    $[8] = t5;
  } else {
    t4 = $[7];
    t5 = $[8];
  }
  react$1.useEffect(t4, t5);
  const PluginContent = (_a = pluginContext == null ? void 0 : pluginContext.visiblePlugin) == null ? void 0 : _a.content;
  const t6 = (pluginContext == null ? void 0 : pluginContext.visiblePlugin) ? void 0 : "first";
  let t7;
  if ($[9] !== pluginContext || $[10] !== t6) {
    t7 = {
      defaultSizeRelation: 0.3333333333333333,
      direction: "horizontal",
      initiallyHidden: t6,
      onHiddenElementChange(resizableElement) {
        if (resizableElement === "first") {
          pluginContext == null ? void 0 : pluginContext.setVisiblePlugin(null);
        }
      },
      sizeThresholdSecond: 200,
      storageKey: "docExplorerFlex"
    };
    $[9] = pluginContext;
    $[10] = t6;
    $[11] = t7;
  } else {
    t7 = $[11];
  }
  const pluginResize = react.useDragResize(t7);
  let t8;
  if ($[12] === Symbol.for("react.memo_cache_sentinel")) {
    t8 = {
      direction: "horizontal",
      storageKey: "editorFlex"
    };
    $[12] = t8;
  } else {
    t8 = $[12];
  }
  const editorResize = react.useDragResize(t8);
  let t9;
  bb0: {
    if (props.defaultEditorToolsVisibility === "variables" || props.defaultEditorToolsVisibility === "headers") {
      t9 = void 0;
      break bb0;
    }
    if (typeof props.defaultEditorToolsVisibility === "boolean") {
      t9 = props.defaultEditorToolsVisibility ? void 0 : "second";
      break bb0;
    }
    t9 = editorContext.initialVariables || editorContext.initialHeaders ? void 0 : "second";
  }
  let t10;
  if ($[13] !== t9) {
    t10 = {
      defaultSizeRelation: 3,
      direction: "vertical",
      initiallyHidden: t9,
      sizeThresholdSecond: 60,
      storageKey: "secondaryEditorFlex"
    };
    $[13] = t9;
    $[14] = t10;
  } else {
    t10 = $[14];
  }
  const editorToolsResize = react.useDragResize(t10);
  let t11;
  if ($[15] !== editorContext.initialHeaders || $[16] !== editorContext.initialVariables || $[17] !== isHeadersEditorEnabled || $[18] !== props.defaultEditorToolsVisibility) {
    t11 = () => {
      if (props.defaultEditorToolsVisibility === "variables" || props.defaultEditorToolsVisibility === "headers") {
        return props.defaultEditorToolsVisibility;
      }
      return !editorContext.initialVariables && editorContext.initialHeaders && isHeadersEditorEnabled ? "headers" : "variables";
    };
    $[15] = editorContext.initialHeaders;
    $[16] = editorContext.initialVariables;
    $[17] = isHeadersEditorEnabled;
    $[18] = props.defaultEditorToolsVisibility;
    $[19] = t11;
  } else {
    t11 = $[19];
  }
  const [activeSecondaryEditor, setActiveSecondaryEditor] = react$1.useState(t11);
  const [showDialog, setShowDialog] = react$1.useState(null);
  const [clearStorageStatus, setClearStorageStatus] = react$1.useState(null);
  let logo;
  let t12;
  let toolbar;
  if ($[20] !== copy || $[21] !== merge || $[22] !== prettify || $[23] !== props.children || $[24] !== props.toolbar) {
    const children = react$1.Children.toArray(props.children);
    logo = children.find(_temp) || /* @__PURE__ */ jsxRuntime.jsx(GraphiQL.Logo, {});
    toolbar = children.find(_temp2) || /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
      /* @__PURE__ */ jsxRuntime.jsx(react.ToolbarButton, { onClick: prettify, label: "Prettify query (Shift-Ctrl-P)", children: /* @__PURE__ */ jsxRuntime.jsx(react.PrettifyIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" }) }),
      /* @__PURE__ */ jsxRuntime.jsx(react.ToolbarButton, { onClick: merge, label: "Merge fragments into query (Shift-Ctrl-M)", children: /* @__PURE__ */ jsxRuntime.jsx(react.MergeIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" }) }),
      /* @__PURE__ */ jsxRuntime.jsx(react.ToolbarButton, { onClick: copy, label: "Copy query (Shift-Ctrl-C)", children: /* @__PURE__ */ jsxRuntime.jsx(react.CopyIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" }) }),
      (_b = props.toolbar) == null ? void 0 : _b.additionalContent,
      ((_c = props.toolbar) == null ? void 0 : _c.additionalComponent) && /* @__PURE__ */ jsxRuntime.jsx(props.toolbar.additionalComponent, {})
    ] });
    t12 = children.find(_temp3);
    $[20] = copy;
    $[21] = merge;
    $[22] = prettify;
    $[23] = props.children;
    $[24] = props.toolbar;
    $[25] = logo;
    $[26] = t12;
    $[27] = toolbar;
  } else {
    logo = $[25];
    t12 = $[26];
    toolbar = $[27];
  }
  const footer = t12;
  let t13;
  if ($[28] !== pluginResize) {
    t13 = () => {
      if (pluginResize.hiddenElement === "first") {
        pluginResize.setHiddenElement(null);
      }
    };
    $[28] = pluginResize;
    $[29] = t13;
  } else {
    t13 = $[29];
  }
  const onClickReference = t13;
  let t14;
  if ($[30] !== storageContext) {
    t14 = () => {
      try {
        if (storageContext) {
          storageContext.clear();
        }
        setClearStorageStatus("success");
      } catch {
        setClearStorageStatus("error");
      }
    };
    $[30] = storageContext;
    $[31] = t14;
  } else {
    t14 = $[31];
  }
  const handleClearData = t14;
  let t15;
  if ($[32] !== editorContext) {
    t15 = (event) => {
      editorContext.setShouldPersistHeaders(event.currentTarget.dataset.value === "true");
    };
    $[32] = editorContext;
    $[33] = t15;
  } else {
    t15 = $[33];
  }
  const handlePersistHeaders = t15;
  let t16;
  if ($[34] !== setTheme) {
    t16 = (event_0) => {
      const selectedTheme = event_0.currentTarget.dataset.theme;
      setTheme(selectedTheme || null);
    };
    $[34] = setTheme;
    $[35] = t16;
  } else {
    t16 = $[35];
  }
  const handleChangeTheme = t16;
  const handleAddTab = editorContext.addTab;
  const handleRefetchSchema = schemaContext.introspect;
  const handleReorder = editorContext.moveTab;
  let t17;
  if ($[36] === Symbol.for("react.memo_cache_sentinel")) {
    t17 = (event_1) => {
      setShowDialog(event_1.currentTarget.dataset.value);
    };
    $[36] = t17;
  } else {
    t17 = $[36];
  }
  const handleShowDialog = t17;
  let t18;
  if ($[37] !== pluginContext || $[38] !== pluginResize) {
    t18 = (event_2) => {
      const context = pluginContext;
      const pluginIndex = Number(event_2.currentTarget.dataset.index);
      const plugin = context.plugins.find((_, index) => pluginIndex === index);
      const isVisible = plugin === context.visiblePlugin;
      if (isVisible) {
        context.setVisiblePlugin(null);
        pluginResize.setHiddenElement("first");
      } else {
        context.setVisiblePlugin(plugin);
        pluginResize.setHiddenElement(null);
      }
    };
    $[37] = pluginContext;
    $[38] = pluginResize;
    $[39] = t18;
  } else {
    t18 = $[39];
  }
  const handlePluginClick = t18;
  let t19;
  if ($[40] !== editorToolsResize) {
    t19 = (event_3) => {
      if (editorToolsResize.hiddenElement === "second") {
        editorToolsResize.setHiddenElement(null);
      }
      setActiveSecondaryEditor(event_3.currentTarget.dataset.name);
    };
    $[40] = editorToolsResize;
    $[41] = t19;
  } else {
    t19 = $[41];
  }
  const handleToolsTabClick = t19;
  let t20;
  if ($[42] !== editorToolsResize) {
    t20 = () => {
      editorToolsResize.setHiddenElement(editorToolsResize.hiddenElement === "second" ? null : "second");
    };
    $[42] = editorToolsResize;
    $[43] = t20;
  } else {
    t20 = $[43];
  }
  const toggleEditorTools = t20;
  let t21;
  if ($[44] === Symbol.for("react.memo_cache_sentinel")) {
    t21 = (isOpen) => {
      if (!isOpen) {
        setShowDialog(null);
      }
    };
    $[44] = t21;
  } else {
    t21 = $[44];
  }
  const handleOpenShortKeysDialog = t21;
  let t22;
  if ($[45] === Symbol.for("react.memo_cache_sentinel")) {
    t22 = (isOpen_0) => {
      if (!isOpen_0) {
        setShowDialog(null);
        setClearStorageStatus(null);
      }
    };
    $[45] = t22;
  } else {
    t22 = $[45];
  }
  const handleOpenSettingsDialog = t22;
  let t23;
  if ($[46] === Symbol.for("react.memo_cache_sentinel")) {
    t23 = /* @__PURE__ */ jsxRuntime.jsx(react.PlusIcon, { "aria-hidden": "true" });
    $[46] = t23;
  } else {
    t23 = $[46];
  }
  let t24;
  if ($[47] !== handleAddTab) {
    t24 = /* @__PURE__ */ jsxRuntime.jsx(react.Tooltip, { label: "Add tab", children: /* @__PURE__ */ jsxRuntime.jsx(react.UnStyledButton, { type: "button", className: "graphiql-tab-add", onClick: handleAddTab, "aria-label": "Add tab", children: t23 }) });
    $[47] = handleAddTab;
    $[48] = t24;
  } else {
    t24 = $[48];
  }
  const addTab = t24;
  const className = props.className ? ` ${props.className}` : "";
  const confirmClose = props.confirmCloseTab;
  let t25;
  if ($[49] !== confirmClose || $[50] !== editorContext || $[51] !== executionContext) {
    t25 = async (event_4) => {
      const tabButton = event_4.currentTarget.previousSibling;
      const index_0 = Number(tabButton.id.replace(TAB_CLASS_PREFIX, ""));
      const shouldCloseTab = confirmClose ? await confirmClose(index_0) : true;
      if (!shouldCloseTab) {
        return;
      }
      if (editorContext.activeTabIndex === index_0) {
        executionContext.stop();
      }
      editorContext.closeTab(index_0);
    };
    $[49] = confirmClose;
    $[50] = editorContext;
    $[51] = executionContext;
    $[52] = t25;
  } else {
    t25 = $[52];
  }
  const handleTabClose = t25;
  let t26;
  if ($[53] !== editorContext || $[54] !== executionContext) {
    t26 = (event_5) => {
      const index_1 = Number(event_5.currentTarget.id.replace(TAB_CLASS_PREFIX, ""));
      executionContext.stop();
      editorContext.changeTab(index_1);
    };
    $[53] = editorContext;
    $[54] = executionContext;
    $[55] = t26;
  } else {
    t26 = $[55];
  }
  const handleTabClick = t26;
  const t27 = `graphiql-container${className}`;
  let t28;
  if ($[56] !== handlePluginClick || $[57] !== pluginContext) {
    t28 = pluginContext == null ? void 0 : pluginContext.plugins.map((plugin_0, index_2) => {
      const isVisible_0 = plugin_0 === pluginContext.visiblePlugin;
      const label = `${isVisible_0 ? "Hide" : "Show"} ${plugin_0.title}`;
      return /* @__PURE__ */ jsxRuntime.jsx(react.Tooltip, { label, children: /* @__PURE__ */ jsxRuntime.jsx(react.UnStyledButton, { type: "button", className: isVisible_0 ? "active" : "", onClick: handlePluginClick, "data-index": index_2, "aria-label": label, children: /* @__PURE__ */ jsxRuntime.jsx(plugin_0.icon, { "aria-hidden": "true" }) }) }, plugin_0.title);
    });
    $[56] = handlePluginClick;
    $[57] = pluginContext;
    $[58] = t28;
  } else {
    t28 = $[58];
  }
  let t29;
  if ($[59] !== t28) {
    t29 = /* @__PURE__ */ jsxRuntime.jsx("div", { className: "graphiql-sidebar-section", children: t28 });
    $[59] = t28;
    $[60] = t29;
  } else {
    t29 = $[60];
  }
  const t30 = schemaContext.isFetching ? "graphiql-spin" : "";
  let t31;
  if ($[61] !== t30) {
    t31 = /* @__PURE__ */ jsxRuntime.jsx(react.ReloadIcon, { className: t30, "aria-hidden": "true" });
    $[61] = t30;
    $[62] = t31;
  } else {
    t31 = $[62];
  }
  let t32;
  if ($[63] !== handleRefetchSchema || $[64] !== schemaContext.isFetching || $[65] !== t31) {
    t32 = /* @__PURE__ */ jsxRuntime.jsx(react.Tooltip, { label: "Re-fetch GraphQL schema", children: /* @__PURE__ */ jsxRuntime.jsx(react.UnStyledButton, { type: "button", disabled: schemaContext.isFetching, onClick: handleRefetchSchema, "aria-label": "Re-fetch GraphQL schema", children: t31 }) });
    $[63] = handleRefetchSchema;
    $[64] = schemaContext.isFetching;
    $[65] = t31;
    $[66] = t32;
  } else {
    t32 = $[66];
  }
  let t33;
  if ($[67] === Symbol.for("react.memo_cache_sentinel")) {
    t33 = /* @__PURE__ */ jsxRuntime.jsx(react.Tooltip, { label: "Open short keys dialog", children: /* @__PURE__ */ jsxRuntime.jsx(react.UnStyledButton, { type: "button", "data-value": "short-keys", onClick: handleShowDialog, "aria-label": "Open short keys dialog", children: /* @__PURE__ */ jsxRuntime.jsx(react.KeyboardShortcutIcon, { "aria-hidden": "true" }) }) });
    $[67] = t33;
  } else {
    t33 = $[67];
  }
  let t34;
  if ($[68] === Symbol.for("react.memo_cache_sentinel")) {
    t34 = /* @__PURE__ */ jsxRuntime.jsx(react.Tooltip, { label: "Open settings dialog", children: /* @__PURE__ */ jsxRuntime.jsx(react.UnStyledButton, { type: "button", "data-value": "settings", onClick: handleShowDialog, "aria-label": "Open settings dialog", children: /* @__PURE__ */ jsxRuntime.jsx(react.SettingsIcon, { "aria-hidden": "true" }) }) });
    $[68] = t34;
  } else {
    t34 = $[68];
  }
  let t35;
  if ($[69] !== t32) {
    t35 = /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "graphiql-sidebar-section", children: [
      t32,
      t33,
      t34
    ] });
    $[69] = t32;
    $[70] = t35;
  } else {
    t35 = $[70];
  }
  let t36;
  if ($[71] !== t29 || $[72] !== t35) {
    t36 = /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "graphiql-sidebar", children: [
      t29,
      t35
    ] });
    $[71] = t29;
    $[72] = t35;
    $[73] = t36;
  } else {
    t36 = $[73];
  }
  let t37;
  if ($[74] === Symbol.for("react.memo_cache_sentinel")) {
    t37 = {
      minWidth: "200px"
    };
    $[74] = t37;
  } else {
    t37 = $[74];
  }
  let t38;
  if ($[75] !== PluginContent) {
    t38 = PluginContent ? /* @__PURE__ */ jsxRuntime.jsx(PluginContent, {}) : null;
    $[75] = PluginContent;
    $[76] = t38;
  } else {
    t38 = $[76];
  }
  let t39;
  if ($[77] !== t38) {
    t39 = /* @__PURE__ */ jsxRuntime.jsx("div", { className: "graphiql-plugin", children: t38 });
    $[77] = t38;
    $[78] = t39;
  } else {
    t39 = $[78];
  }
  let t40;
  if ($[79] !== pluginResize.firstRef || $[80] !== t39) {
    t40 = /* @__PURE__ */ jsxRuntime.jsx("div", { ref: pluginResize.firstRef, style: t37, children: t39 });
    $[79] = pluginResize.firstRef;
    $[80] = t39;
    $[81] = t40;
  } else {
    t40 = $[81];
  }
  let t41;
  if ($[82] !== (pluginContext == null ? void 0 : pluginContext.visiblePlugin) || $[83] !== pluginResize.dragBarRef) {
    t41 = (pluginContext == null ? void 0 : pluginContext.visiblePlugin) && /* @__PURE__ */ jsxRuntime.jsx("div", { className: "graphiql-horizontal-drag-bar", ref: pluginResize.dragBarRef });
    $[82] = pluginContext == null ? void 0 : pluginContext.visiblePlugin;
    $[83] = pluginResize.dragBarRef;
    $[84] = t41;
  } else {
    t41 = $[84];
  }
  let t42;
  if ($[85] !== addTab || $[86] !== editorContext.activeTabIndex || $[87] !== editorContext.tabs || $[88] !== handleReorder || $[89] !== handleTabClick || $[90] !== handleTabClose || $[91] !== props.disableTabs) {
    t42 = !props.disableTabs && /* @__PURE__ */ jsxRuntime.jsx(react.Tabs, { values: editorContext.tabs, onReorder: handleReorder, "aria-label": "Select active operation", children: editorContext.tabs.length > 1 && /* @__PURE__ */ jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [
      editorContext.tabs.map((tab, index_3) => /* @__PURE__ */ jsxRuntime.jsxs(react.Tab, { value: tab, isActive: index_3 === editorContext.activeTabIndex, children: [
        /* @__PURE__ */ jsxRuntime.jsx(react.Tab.Button, { "aria-controls": "graphiql-session", id: `${TAB_CLASS_PREFIX}${index_3}`, onClick: handleTabClick, children: tab.title }),
        /* @__PURE__ */ jsxRuntime.jsx(react.Tab.Close, { onClick: handleTabClose })
      ] }, tab.id)),
      addTab
    ] }) });
    $[85] = addTab;
    $[86] = editorContext.activeTabIndex;
    $[87] = editorContext.tabs;
    $[88] = handleReorder;
    $[89] = handleTabClick;
    $[90] = handleTabClose;
    $[91] = props.disableTabs;
    $[92] = t42;
  } else {
    t42 = $[92];
  }
  const t43 = editorContext.tabs.length === 1 && addTab;
  let t44;
  if ($[93] !== logo || $[94] !== t43) {
    t44 = /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "graphiql-session-header-right", children: [
      t43,
      logo
    ] });
    $[93] = logo;
    $[94] = t43;
    $[95] = t44;
  } else {
    t44 = $[95];
  }
  let t45;
  if ($[96] !== t42 || $[97] !== t44) {
    t45 = /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "graphiql-session-header", children: [
      t42,
      t44
    ] });
    $[96] = t42;
    $[97] = t44;
    $[98] = t45;
  } else {
    t45 = $[98];
  }
  const t46 = `${TAB_CLASS_PREFIX}${editorContext.activeTabIndex}`;
  const t47 = `graphiql-editors${editorContext.tabs.length === 1 ? " full-height" : ""}`;
  let t48;
  if ($[99] !== onClickReference || $[100] !== props.editorTheme || $[101] !== props.keyMap || $[102] !== props.onCopyQuery || $[103] !== props.onEditQuery || $[104] !== props.readOnly) {
    t48 = /* @__PURE__ */ jsxRuntime.jsx(react.QueryEditor, { editorTheme: props.editorTheme, keyMap: props.keyMap, onClickReference, onCopyQuery: props.onCopyQuery, onEdit: props.onEditQuery, readOnly: props.readOnly });
    $[99] = onClickReference;
    $[100] = props.editorTheme;
    $[101] = props.keyMap;
    $[102] = props.onCopyQuery;
    $[103] = props.onEditQuery;
    $[104] = props.readOnly;
    $[105] = t48;
  } else {
    t48 = $[105];
  }
  let t49;
  if ($[106] === Symbol.for("react.memo_cache_sentinel")) {
    t49 = /* @__PURE__ */ jsxRuntime.jsx(react.ExecuteButton, {});
    $[106] = t49;
  } else {
    t49 = $[106];
  }
  let t50;
  if ($[107] !== toolbar) {
    t50 = /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "graphiql-toolbar", role: "toolbar", "aria-label": "Editor Commands", children: [
      t49,
      toolbar
    ] });
    $[107] = toolbar;
    $[108] = t50;
  } else {
    t50 = $[108];
  }
  let t51;
  if ($[109] !== t48 || $[110] !== t50) {
    t51 = /* @__PURE__ */ jsxRuntime.jsxs("section", { className: "graphiql-query-editor", "aria-label": "Query Editor", children: [
      t48,
      t50
    ] });
    $[109] = t48;
    $[110] = t50;
    $[111] = t51;
  } else {
    t51 = $[111];
  }
  let t52;
  if ($[112] !== editorToolsResize.firstRef || $[113] !== t51) {
    t52 = /* @__PURE__ */ jsxRuntime.jsx("div", { ref: editorToolsResize.firstRef, children: t51 });
    $[112] = editorToolsResize.firstRef;
    $[113] = t51;
    $[114] = t52;
  } else {
    t52 = $[114];
  }
  const t53 = activeSecondaryEditor === "variables" && editorToolsResize.hiddenElement !== "second" ? "active" : "";
  let t54;
  if ($[115] !== handleToolsTabClick || $[116] !== t53) {
    t54 = /* @__PURE__ */ jsxRuntime.jsx(react.UnStyledButton, { type: "button", className: t53, onClick: handleToolsTabClick, "data-name": "variables", children: "Variables" });
    $[115] = handleToolsTabClick;
    $[116] = t53;
    $[117] = t54;
  } else {
    t54 = $[117];
  }
  let t55;
  if ($[118] !== activeSecondaryEditor || $[119] !== editorToolsResize.hiddenElement || $[120] !== handleToolsTabClick || $[121] !== isHeadersEditorEnabled) {
    t55 = isHeadersEditorEnabled && /* @__PURE__ */ jsxRuntime.jsx(react.UnStyledButton, { type: "button", className: activeSecondaryEditor === "headers" && editorToolsResize.hiddenElement !== "second" ? "active" : "", onClick: handleToolsTabClick, "data-name": "headers", children: "Headers" });
    $[118] = activeSecondaryEditor;
    $[119] = editorToolsResize.hiddenElement;
    $[120] = handleToolsTabClick;
    $[121] = isHeadersEditorEnabled;
    $[122] = t55;
  } else {
    t55 = $[122];
  }
  const t56 = editorToolsResize.hiddenElement === "second" ? "Show editor tools" : "Hide editor tools";
  const t57 = editorToolsResize.hiddenElement === "second" ? "Show editor tools" : "Hide editor tools";
  let t58;
  if ($[123] !== editorToolsResize.hiddenElement) {
    t58 = editorToolsResize.hiddenElement === "second" ? /* @__PURE__ */ jsxRuntime.jsx(react.ChevronUpIcon, { className: "graphiql-chevron-icon", "aria-hidden": "true" }) : /* @__PURE__ */ jsxRuntime.jsx(react.ChevronDownIcon, { className: "graphiql-chevron-icon", "aria-hidden": "true" });
    $[123] = editorToolsResize.hiddenElement;
    $[124] = t58;
  } else {
    t58 = $[124];
  }
  let t59;
  if ($[125] !== t57 || $[126] !== t58 || $[127] !== toggleEditorTools) {
    t59 = /* @__PURE__ */ jsxRuntime.jsx(react.UnStyledButton, { type: "button", onClick: toggleEditorTools, "aria-label": t57, className: "graphiql-toggle-editor-tools", children: t58 });
    $[125] = t57;
    $[126] = t58;
    $[127] = toggleEditorTools;
    $[128] = t59;
  } else {
    t59 = $[128];
  }
  let t60;
  if ($[129] !== t56 || $[130] !== t59) {
    t60 = /* @__PURE__ */ jsxRuntime.jsx(react.Tooltip, { label: t56, children: t59 });
    $[129] = t56;
    $[130] = t59;
    $[131] = t60;
  } else {
    t60 = $[131];
  }
  let t61;
  if ($[132] !== t54 || $[133] !== t55 || $[134] !== t60) {
    t61 = /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "graphiql-editor-tools", children: [
      t54,
      t55,
      t60
    ] });
    $[132] = t54;
    $[133] = t55;
    $[134] = t60;
    $[135] = t61;
  } else {
    t61 = $[135];
  }
  let t62;
  if ($[136] !== editorToolsResize.dragBarRef || $[137] !== t61) {
    t62 = /* @__PURE__ */ jsxRuntime.jsx("div", { ref: editorToolsResize.dragBarRef, children: t61 });
    $[136] = editorToolsResize.dragBarRef;
    $[137] = t61;
    $[138] = t62;
  } else {
    t62 = $[138];
  }
  const t63 = activeSecondaryEditor === "variables" ? "Variables" : "Headers";
  const t64 = activeSecondaryEditor !== "variables";
  let t65;
  if ($[139] !== onClickReference || $[140] !== props.editorTheme || $[141] !== props.keyMap || $[142] !== props.onEditVariables || $[143] !== props.readOnly || $[144] !== t64) {
    t65 = /* @__PURE__ */ jsxRuntime.jsx(react.VariableEditor, { editorTheme: props.editorTheme, isHidden: t64, keyMap: props.keyMap, onEdit: props.onEditVariables, onClickReference, readOnly: props.readOnly });
    $[139] = onClickReference;
    $[140] = props.editorTheme;
    $[141] = props.keyMap;
    $[142] = props.onEditVariables;
    $[143] = props.readOnly;
    $[144] = t64;
    $[145] = t65;
  } else {
    t65 = $[145];
  }
  let t66;
  if ($[146] !== activeSecondaryEditor || $[147] !== isHeadersEditorEnabled || $[148] !== props.editorTheme || $[149] !== props.keyMap || $[150] !== props.onEditHeaders || $[151] !== props.readOnly) {
    t66 = isHeadersEditorEnabled && /* @__PURE__ */ jsxRuntime.jsx(react.HeaderEditor, { editorTheme: props.editorTheme, isHidden: activeSecondaryEditor !== "headers", keyMap: props.keyMap, onEdit: props.onEditHeaders, readOnly: props.readOnly });
    $[146] = activeSecondaryEditor;
    $[147] = isHeadersEditorEnabled;
    $[148] = props.editorTheme;
    $[149] = props.keyMap;
    $[150] = props.onEditHeaders;
    $[151] = props.readOnly;
    $[152] = t66;
  } else {
    t66 = $[152];
  }
  let t67;
  if ($[153] !== t63 || $[154] !== t65 || $[155] !== t66) {
    t67 = /* @__PURE__ */ jsxRuntime.jsxs("section", { className: "graphiql-editor-tool", "aria-label": t63, children: [
      t65,
      t66
    ] });
    $[153] = t63;
    $[154] = t65;
    $[155] = t66;
    $[156] = t67;
  } else {
    t67 = $[156];
  }
  let t68;
  if ($[157] !== editorToolsResize.secondRef || $[158] !== t67) {
    t68 = /* @__PURE__ */ jsxRuntime.jsx("div", { ref: editorToolsResize.secondRef, children: t67 });
    $[157] = editorToolsResize.secondRef;
    $[158] = t67;
    $[159] = t68;
  } else {
    t68 = $[159];
  }
  let t69;
  if ($[160] !== t47 || $[161] !== t52 || $[162] !== t62 || $[163] !== t68) {
    t69 = /* @__PURE__ */ jsxRuntime.jsxs("div", { className: t47, children: [
      t52,
      t62,
      t68
    ] });
    $[160] = t47;
    $[161] = t52;
    $[162] = t62;
    $[163] = t68;
    $[164] = t69;
  } else {
    t69 = $[164];
  }
  let t70;
  if ($[165] !== editorResize.firstRef || $[166] !== t69) {
    t70 = /* @__PURE__ */ jsxRuntime.jsx("div", { ref: editorResize.firstRef, children: t69 });
    $[165] = editorResize.firstRef;
    $[166] = t69;
    $[167] = t70;
  } else {
    t70 = $[167];
  }
  let t71;
  if ($[168] !== editorResize.dragBarRef) {
    t71 = /* @__PURE__ */ jsxRuntime.jsx("div", { className: "graphiql-horizontal-drag-bar", ref: editorResize.dragBarRef });
    $[168] = editorResize.dragBarRef;
    $[169] = t71;
  } else {
    t71 = $[169];
  }
  let t72;
  if ($[170] !== executionContext.isFetching) {
    t72 = executionContext.isFetching ? /* @__PURE__ */ jsxRuntime.jsx(react.Spinner, {}) : null;
    $[170] = executionContext.isFetching;
    $[171] = t72;
  } else {
    t72 = $[171];
  }
  let t73;
  if ($[172] !== props.editorTheme || $[173] !== props.keyMap || $[174] !== props.responseTooltip) {
    t73 = /* @__PURE__ */ jsxRuntime.jsx(react.ResponseEditor, { editorTheme: props.editorTheme, responseTooltip: props.responseTooltip, keyMap: props.keyMap });
    $[172] = props.editorTheme;
    $[173] = props.keyMap;
    $[174] = props.responseTooltip;
    $[175] = t73;
  } else {
    t73 = $[175];
  }
  let t74;
  if ($[176] !== footer || $[177] !== t72 || $[178] !== t73) {
    t74 = /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "graphiql-response", children: [
      t72,
      t73,
      footer
    ] });
    $[176] = footer;
    $[177] = t72;
    $[178] = t73;
    $[179] = t74;
  } else {
    t74 = $[179];
  }
  let t75;
  if ($[180] !== editorResize.secondRef || $[181] !== t74) {
    t75 = /* @__PURE__ */ jsxRuntime.jsx("div", { ref: editorResize.secondRef, children: t74 });
    $[180] = editorResize.secondRef;
    $[181] = t74;
    $[182] = t75;
  } else {
    t75 = $[182];
  }
  let t76;
  if ($[183] !== t46 || $[184] !== t70 || $[185] !== t71 || $[186] !== t75) {
    t76 = /* @__PURE__ */ jsxRuntime.jsxs("div", { role: "tabpanel", id: "graphiql-session", className: "graphiql-session", "aria-labelledby": t46, children: [
      t70,
      t71,
      t75
    ] });
    $[183] = t46;
    $[184] = t70;
    $[185] = t71;
    $[186] = t75;
    $[187] = t76;
  } else {
    t76 = $[187];
  }
  let t77;
  if ($[188] !== pluginResize.secondRef || $[189] !== t45 || $[190] !== t76) {
    t77 = /* @__PURE__ */ jsxRuntime.jsxs("div", { ref: pluginResize.secondRef, className: "graphiql-sessions", children: [
      t45,
      t76
    ] });
    $[188] = pluginResize.secondRef;
    $[189] = t45;
    $[190] = t76;
    $[191] = t77;
  } else {
    t77 = $[191];
  }
  let t78;
  if ($[192] !== t40 || $[193] !== t41 || $[194] !== t77) {
    t78 = /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "graphiql-main", children: [
      t40,
      t41,
      t77
    ] });
    $[192] = t40;
    $[193] = t41;
    $[194] = t77;
    $[195] = t78;
  } else {
    t78 = $[195];
  }
  const t79 = showDialog === "short-keys";
  let t80;
  if ($[196] === Symbol.for("react.memo_cache_sentinel")) {
    t80 = /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "graphiql-dialog-header", children: [
      /* @__PURE__ */ jsxRuntime.jsx(react.Dialog.Title, { className: "graphiql-dialog-title", children: "Short Keys" }),
      /* @__PURE__ */ jsxRuntime.jsx(react.Dialog.Close, {})
    ] });
    $[196] = t80;
  } else {
    t80 = $[196];
  }
  const t81 = props.keyMap || "sublime";
  let t82;
  if ($[197] !== t81) {
    t82 = /* @__PURE__ */ jsxRuntime.jsx("div", { className: "graphiql-dialog-section", children: /* @__PURE__ */ jsxRuntime.jsx(ShortKeys, { keyMap: t81 }) });
    $[197] = t81;
    $[198] = t82;
  } else {
    t82 = $[198];
  }
  let t83;
  if ($[199] !== t79 || $[200] !== t82) {
    t83 = /* @__PURE__ */ jsxRuntime.jsxs(react.Dialog, { open: t79, onOpenChange: handleOpenShortKeysDialog, children: [
      t80,
      t82
    ] });
    $[199] = t79;
    $[200] = t82;
    $[201] = t83;
  } else {
    t83 = $[201];
  }
  const t84 = showDialog === "settings";
  let t85;
  if ($[202] === Symbol.for("react.memo_cache_sentinel")) {
    t85 = /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "graphiql-dialog-header", children: [
      /* @__PURE__ */ jsxRuntime.jsx(react.Dialog.Title, { className: "graphiql-dialog-title", children: "Settings" }),
      /* @__PURE__ */ jsxRuntime.jsx(react.Dialog.Close, {})
    ] });
    $[202] = t85;
  } else {
    t85 = $[202];
  }
  let t86;
  if ($[203] !== editorContext.shouldPersistHeaders || $[204] !== handlePersistHeaders || $[205] !== props.showPersistHeadersSettings) {
    t86 = props.showPersistHeadersSettings ? /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "graphiql-dialog-section", children: [
      /* @__PURE__ */ jsxRuntime.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntime.jsx("div", { className: "graphiql-dialog-section-title", children: "Persist headers" }),
        /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "graphiql-dialog-section-caption", children: [
          "Save headers upon reloading.",
          " ",
          /* @__PURE__ */ jsxRuntime.jsx("span", { className: "graphiql-warning-text", children: "Only enable if you trust this device." })
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntime.jsxs(react.ButtonGroup, { children: [
        /* @__PURE__ */ jsxRuntime.jsx(react.Button, { type: "button", id: "enable-persist-headers", className: editorContext.shouldPersistHeaders ? "active" : "", "data-value": "true", onClick: handlePersistHeaders, children: "On" }),
        /* @__PURE__ */ jsxRuntime.jsx(react.Button, { type: "button", id: "disable-persist-headers", className: editorContext.shouldPersistHeaders ? "" : "active", onClick: handlePersistHeaders, children: "Off" })
      ] })
    ] }) : null;
    $[203] = editorContext.shouldPersistHeaders;
    $[204] = handlePersistHeaders;
    $[205] = props.showPersistHeadersSettings;
    $[206] = t86;
  } else {
    t86 = $[206];
  }
  let t87;
  if ($[207] !== forcedTheme || $[208] !== handleChangeTheme || $[209] !== theme) {
    t87 = !forcedTheme && /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "graphiql-dialog-section", children: [
      /* @__PURE__ */ jsxRuntime.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntime.jsx("div", { className: "graphiql-dialog-section-title", children: "Theme" }),
        /* @__PURE__ */ jsxRuntime.jsx("div", { className: "graphiql-dialog-section-caption", children: "Adjust how the interface appears." })
      ] }),
      /* @__PURE__ */ jsxRuntime.jsxs(react.ButtonGroup, { children: [
        /* @__PURE__ */ jsxRuntime.jsx(react.Button, { type: "button", className: theme === null ? "active" : "", onClick: handleChangeTheme, children: "System" }),
        /* @__PURE__ */ jsxRuntime.jsx(react.Button, { type: "button", className: theme === "light" ? "active" : "", "data-theme": "light", onClick: handleChangeTheme, children: "Light" }),
        /* @__PURE__ */ jsxRuntime.jsx(react.Button, { type: "button", className: theme === "dark" ? "active" : "", "data-theme": "dark", onClick: handleChangeTheme, children: "Dark" })
      ] })
    ] });
    $[207] = forcedTheme;
    $[208] = handleChangeTheme;
    $[209] = theme;
    $[210] = t87;
  } else {
    t87 = $[210];
  }
  let t88;
  if ($[211] !== clearStorageStatus || $[212] !== handleClearData || $[213] !== storageContext) {
    t88 = storageContext ? /* @__PURE__ */ jsxRuntime.jsxs("div", { className: "graphiql-dialog-section", children: [
      /* @__PURE__ */ jsxRuntime.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntime.jsx("div", { className: "graphiql-dialog-section-title", children: "Clear storage" }),
        /* @__PURE__ */ jsxRuntime.jsx("div", { className: "graphiql-dialog-section-caption", children: "Remove all locally stored data and start fresh." })
      ] }),
      /* @__PURE__ */ jsxRuntime.jsx(react.Button, { type: "button", state: clearStorageStatus || void 0, disabled: clearStorageStatus === "success", onClick: handleClearData, children: {
        success: "Cleared data",
        error: "Failed"
      }[clearStorageStatus] || "Clear data" })
    ] }) : null;
    $[211] = clearStorageStatus;
    $[212] = handleClearData;
    $[213] = storageContext;
    $[214] = t88;
  } else {
    t88 = $[214];
  }
  let t89;
  if ($[215] !== t84 || $[216] !== t86 || $[217] !== t87 || $[218] !== t88) {
    t89 = /* @__PURE__ */ jsxRuntime.jsxs(react.Dialog, { open: t84, onOpenChange: handleOpenSettingsDialog, children: [
      t85,
      t86,
      t87,
      t88
    ] });
    $[215] = t84;
    $[216] = t86;
    $[217] = t87;
    $[218] = t88;
    $[219] = t89;
  } else {
    t89 = $[219];
  }
  let t90;
  if ($[220] !== t27 || $[221] !== t36 || $[222] !== t78 || $[223] !== t83 || $[224] !== t89) {
    t90 = /* @__PURE__ */ jsxRuntime.jsx(react.Tooltip.Provider, { children: /* @__PURE__ */ jsxRuntime.jsxs("div", { "data-testid": "graphiql-container", className: t27, children: [
      t36,
      t78,
      t83,
      t89
    ] }) });
    $[220] = t27;
    $[221] = t36;
    $[222] = t78;
    $[223] = t83;
    $[224] = t89;
    $[225] = t90;
  } else {
    t90 = $[225];
  }
  return t90;
}
function _temp3(child_1) {
  return isChildComponentType(child_1, GraphiQL.Footer);
}
function _temp2(child_0) {
  return isChildComponentType(child_0, GraphiQL.Toolbar);
}
function _temp(child) {
  return isChildComponentType(child, GraphiQL.Logo);
}
const modifier = react.isMacOs ? "⌘" : "Ctrl";
const SHORT_KEYS = Object.entries({
  "Search in editor": [modifier, "F"],
  "Search in documentation": [modifier, "K"],
  "Execute query": [modifier, "Enter"],
  "Prettify editors": ["Ctrl", "Shift", "P"],
  "Merge fragments definitions into operation definition": ["Ctrl", "Shift", "M"],
  "Copy query": ["Ctrl", "Shift", "C"],
  "Re-fetch schema using introspection": ["Ctrl", "Shift", "R"]
});
function ShortKeys(t0) {
  const $ = reactCompilerRuntime.c(5);
  const {
    keyMap
  } = t0;
  let t1;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = /* @__PURE__ */ jsxRuntime.jsxs("table", { className: "graphiql-table", children: [
      /* @__PURE__ */ jsxRuntime.jsx("thead", { children: /* @__PURE__ */ jsxRuntime.jsxs("tr", { children: [
        /* @__PURE__ */ jsxRuntime.jsx("th", { children: "Short Key" }),
        /* @__PURE__ */ jsxRuntime.jsx("th", { children: "Function" })
      ] }) }),
      /* @__PURE__ */ jsxRuntime.jsx("tbody", { children: SHORT_KEYS.map(_temp5) })
    ] });
    $[0] = t1;
  } else {
    t1 = $[0];
  }
  let t2;
  if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
    t2 = /* @__PURE__ */ jsxRuntime.jsx("a", { href: "https://codemirror.net/5/doc/manual.html#keymaps", target: "_blank", rel: "noopener noreferrer", children: "CodeMirror Key Maps" });
    $[1] = t2;
  } else {
    t2 = $[1];
  }
  let t3;
  if ($[2] === Symbol.for("react.memo_cache_sentinel")) {
    t3 = /* @__PURE__ */ jsxRuntime.jsx("em", { children: "i" });
    $[2] = t3;
  } else {
    t3 = $[2];
  }
  let t4;
  if ($[3] !== keyMap) {
    t4 = /* @__PURE__ */ jsxRuntime.jsxs("div", { children: [
      t1,
      /* @__PURE__ */ jsxRuntime.jsxs("p", { children: [
        "The editors use",
        " ",
        t2,
        " ",
        "that add more short keys. This instance of Graph",
        t3,
        "QL uses",
        " ",
        /* @__PURE__ */ jsxRuntime.jsx("code", { children: keyMap }),
        "."
      ] })
    ] });
    $[3] = keyMap;
    $[4] = t4;
  } else {
    t4 = $[4];
  }
  return t4;
}
function _temp5(t0) {
  const [title, keys] = t0;
  return /* @__PURE__ */ jsxRuntime.jsxs("tr", { children: [
    /* @__PURE__ */ jsxRuntime.jsx("td", { children: keys.map(_temp4) }),
    /* @__PURE__ */ jsxRuntime.jsx("td", { children: title })
  ] }, title);
}
function _temp4(key, index, array) {
  return /* @__PURE__ */ jsxRuntime.jsxs(react$1.Fragment, { children: [
    /* @__PURE__ */ jsxRuntime.jsx("code", { className: "graphiql-key", children: key }),
    index !== array.length - 1 && " + "
  ] }, key);
}
function GraphiQLLogo(props) {
  const $ = reactCompilerRuntime.c(4);
  let t0;
  if ($[0] !== props.children) {
    t0 = props.children || /* @__PURE__ */ jsxRuntime.jsxs("a", { className: "graphiql-logo-link", href: "https://github.com/graphql/graphiql", target: "_blank", rel: "noreferrer", children: [
      "Graph",
      /* @__PURE__ */ jsxRuntime.jsx("em", { children: "i" }),
      "QL"
    ] });
    $[0] = props.children;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  let t1;
  if ($[2] !== t0) {
    t1 = /* @__PURE__ */ jsxRuntime.jsx("div", { className: "graphiql-logo", children: t0 });
    $[2] = t0;
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  return t1;
}
GraphiQLLogo.displayName = "GraphiQLLogo";
function GraphiQLToolbar(props) {
  const $ = reactCompilerRuntime.c(2);
  let t0;
  if ($[0] !== props.children) {
    t0 = /* @__PURE__ */ jsxRuntime.jsx(jsxRuntime.Fragment, { children: props.children });
    $[0] = props.children;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  return t0;
}
GraphiQLToolbar.displayName = "GraphiQLToolbar";
function GraphiQLFooter(props) {
  const $ = reactCompilerRuntime.c(2);
  let t0;
  if ($[0] !== props.children) {
    t0 = /* @__PURE__ */ jsxRuntime.jsx("div", { className: "graphiql-footer", children: props.children });
    $[0] = props.children;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  return t0;
}
GraphiQLFooter.displayName = "GraphiQLFooter";
function isChildComponentType(child, component) {
  var _a;
  if (((_a = child == null ? void 0 : child.type) == null ? void 0 : _a.displayName) && child.type.displayName === component.displayName) {
    return true;
  }
  return child.type === component;
}
Object.defineProperty(exports, "GraphiQLProvider", {
  enumerable: true,
  get: () => react.GraphiQLProvider
});
exports.GraphiQL = GraphiQL;
exports.GraphiQLInterface = GraphiQLInterface;
exports.default = GraphiQL;
//# sourceMappingURL=index.js.map
