import { jsx, jsxs, Fragment as Fragment$1 } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { useEffect, useState, Children, version, cloneElement, Fragment } from "react";
import { useEditorContext, useExecutionContext, useSchemaContext, useStorageContext, usePluginContext, useTheme, useDragResize, Tooltip, UnStyledButton, QueryEditor, ChevronUpIcon, ChevronDownIcon, VariableEditor, HeaderEditor, Spinner, ResponseEditor, Dialog, ButtonGroup, Button, GraphiQLProvider, ReloadIcon, KeyboardShortcutIcon, SettingsIcon, Tab, Tabs, PlusIcon, ExecuteButton, useCopyQuery, useMergeQuery, usePrettifyEditors, ToolbarButton, PrettifyIcon, MergeIcon, CopyIcon, isMacOs } from "@graphiql/react";
const majorVersion = parseInt(version.slice(0, 2), 10);
if (majorVersion < 16) {
  throw new Error(["GraphiQL 0.18.0 and after is not compatible with React 15 or below.", "If you are using a CDN source (jsdelivr, unpkg, etc), follow this example:", "https://github.com/graphql/graphiql/blob/master/examples/graphiql-cdn/index.html#L49"].join("\n"));
}
function GraphiQL(t0) {
  var _a, _b;
  const $ = c(61);
  let confirmCloseTab;
  let dangerouslyAssumeSchemaIsValid;
  let defaultHeaders;
  let defaultQuery;
  let defaultTabs;
  let externalFragments;
  let fetcher;
  let getDefaultFieldNames;
  let headers;
  let inputValueDeprecation;
  let introspectionQueryName;
  let maxHistoryLength;
  let onEditOperationName;
  let onSchemaChange;
  let onTabChange;
  let onTogglePluginVisibility;
  let operationName;
  let plugins;
  let props;
  let query;
  let response;
  let schema;
  let schemaDescription;
  let shouldPersistHeaders;
  let storage;
  let validationRules;
  let variables;
  let visiblePlugin;
  if ($[0] !== t0) {
    ({
      dangerouslyAssumeSchemaIsValid,
      confirmCloseTab,
      defaultQuery,
      defaultTabs,
      externalFragments,
      fetcher,
      getDefaultFieldNames,
      headers,
      inputValueDeprecation,
      introspectionQueryName,
      maxHistoryLength,
      onEditOperationName,
      onSchemaChange,
      onTabChange,
      onTogglePluginVisibility,
      operationName,
      plugins,
      query,
      response,
      schema,
      schemaDescription,
      shouldPersistHeaders,
      storage,
      validationRules,
      variables,
      visiblePlugin,
      defaultHeaders,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = confirmCloseTab;
    $[2] = dangerouslyAssumeSchemaIsValid;
    $[3] = defaultHeaders;
    $[4] = defaultQuery;
    $[5] = defaultTabs;
    $[6] = externalFragments;
    $[7] = fetcher;
    $[8] = getDefaultFieldNames;
    $[9] = headers;
    $[10] = inputValueDeprecation;
    $[11] = introspectionQueryName;
    $[12] = maxHistoryLength;
    $[13] = onEditOperationName;
    $[14] = onSchemaChange;
    $[15] = onTabChange;
    $[16] = onTogglePluginVisibility;
    $[17] = operationName;
    $[18] = plugins;
    $[19] = props;
    $[20] = query;
    $[21] = response;
    $[22] = schema;
    $[23] = schemaDescription;
    $[24] = shouldPersistHeaders;
    $[25] = storage;
    $[26] = validationRules;
    $[27] = variables;
    $[28] = visiblePlugin;
  } else {
    confirmCloseTab = $[1];
    dangerouslyAssumeSchemaIsValid = $[2];
    defaultHeaders = $[3];
    defaultQuery = $[4];
    defaultTabs = $[5];
    externalFragments = $[6];
    fetcher = $[7];
    getDefaultFieldNames = $[8];
    headers = $[9];
    inputValueDeprecation = $[10];
    introspectionQueryName = $[11];
    maxHistoryLength = $[12];
    onEditOperationName = $[13];
    onSchemaChange = $[14];
    onTabChange = $[15];
    onTogglePluginVisibility = $[16];
    operationName = $[17];
    plugins = $[18];
    props = $[19];
    query = $[20];
    response = $[21];
    schema = $[22];
    schemaDescription = $[23];
    shouldPersistHeaders = $[24];
    storage = $[25];
    validationRules = $[26];
    variables = $[27];
    visiblePlugin = $[28];
  }
  if (typeof fetcher !== "function") {
    throw new TypeError("The `GraphiQL` component requires a `fetcher` function to be passed as prop.");
  }
  if ((_a = props.toolbar) == null ? void 0 : _a.additionalContent) {
    throw new TypeError("`toolbar.additionalContent` was removed. Use render props on `GraphiQL.Toolbar` component instead.");
  }
  if ((_b = props.toolbar) == null ? void 0 : _b.additionalComponent) {
    throw new TypeError("`toolbar.additionalComponent` was removed. Use render props on `GraphiQL.Toolbar` component instead.");
  }
  const t1 = shouldPersistHeaders !== false;
  let t2;
  if ($[29] !== confirmCloseTab || $[30] !== props || $[31] !== t1) {
    t2 = /* @__PURE__ */ jsx(GraphiQLInterface, { confirmCloseTab, showPersistHeadersSettings: t1, forcedTheme: props.forcedTheme, ...props });
    $[29] = confirmCloseTab;
    $[30] = props;
    $[31] = t1;
    $[32] = t2;
  } else {
    t2 = $[32];
  }
  let t3;
  if ($[33] !== dangerouslyAssumeSchemaIsValid || $[34] !== defaultHeaders || $[35] !== defaultQuery || $[36] !== defaultTabs || $[37] !== externalFragments || $[38] !== fetcher || $[39] !== getDefaultFieldNames || $[40] !== headers || $[41] !== inputValueDeprecation || $[42] !== introspectionQueryName || $[43] !== maxHistoryLength || $[44] !== onEditOperationName || $[45] !== onSchemaChange || $[46] !== onTabChange || $[47] !== onTogglePluginVisibility || $[48] !== operationName || $[49] !== plugins || $[50] !== query || $[51] !== response || $[52] !== schema || $[53] !== schemaDescription || $[54] !== shouldPersistHeaders || $[55] !== storage || $[56] !== t2 || $[57] !== validationRules || $[58] !== variables || $[59] !== visiblePlugin) {
    t3 = /* @__PURE__ */ jsx(GraphiQLProvider, { getDefaultFieldNames, dangerouslyAssumeSchemaIsValid, defaultQuery, defaultHeaders, defaultTabs, externalFragments, fetcher, headers, inputValueDeprecation, introspectionQueryName, maxHistoryLength, onEditOperationName, onSchemaChange, onTabChange, onTogglePluginVisibility, plugins, visiblePlugin, operationName, query, response, schema, schemaDescription, shouldPersistHeaders, storage, validationRules, variables, children: t2 });
    $[33] = dangerouslyAssumeSchemaIsValid;
    $[34] = defaultHeaders;
    $[35] = defaultQuery;
    $[36] = defaultTabs;
    $[37] = externalFragments;
    $[38] = fetcher;
    $[39] = getDefaultFieldNames;
    $[40] = headers;
    $[41] = inputValueDeprecation;
    $[42] = introspectionQueryName;
    $[43] = maxHistoryLength;
    $[44] = onEditOperationName;
    $[45] = onSchemaChange;
    $[46] = onTabChange;
    $[47] = onTogglePluginVisibility;
    $[48] = operationName;
    $[49] = plugins;
    $[50] = query;
    $[51] = response;
    $[52] = schema;
    $[53] = schemaDescription;
    $[54] = shouldPersistHeaders;
    $[55] = storage;
    $[56] = t2;
    $[57] = validationRules;
    $[58] = variables;
    $[59] = visiblePlugin;
    $[60] = t3;
  } else {
    t3 = $[60];
  }
  return t3;
}
GraphiQL.Logo = GraphiQLLogo;
GraphiQL.Toolbar = GraphiQLToolbar;
GraphiQL.Footer = GraphiQLFooter;
const THEMES = ["light", "dark", "system"];
const TAB_CLASS_PREFIX = "graphiql-session-tab-";
function GraphiQLInterface(props) {
  var _a;
  const $ = c(227);
  const isHeadersEditorEnabled = props.isHeadersEditorEnabled ?? true;
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      nonNull: true
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const editorContext = useEditorContext(t0);
  let t1;
  if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = {
      nonNull: true
    };
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const executionContext = useExecutionContext(t1);
  let t2;
  if ($[2] === Symbol.for("react.memo_cache_sentinel")) {
    t2 = {
      nonNull: true
    };
    $[2] = t2;
  } else {
    t2 = $[2];
  }
  const schemaContext = useSchemaContext(t2);
  const storageContext = useStorageContext();
  const pluginContext = usePluginContext();
  const forcedTheme = props.forcedTheme && THEMES.includes(props.forcedTheme) ? props.forcedTheme : void 0;
  const {
    theme,
    setTheme
  } = useTheme(props.defaultTheme);
  let t3;
  let t4;
  if ($[3] !== forcedTheme || $[4] !== setTheme) {
    t3 = () => {
      if (forcedTheme === "system") {
        setTheme(null);
      } else {
        if (forcedTheme === "light" || forcedTheme === "dark") {
          setTheme(forcedTheme);
        }
      }
    };
    t4 = [forcedTheme, setTheme];
    $[3] = forcedTheme;
    $[4] = setTheme;
    $[5] = t3;
    $[6] = t4;
  } else {
    t3 = $[5];
    t4 = $[6];
  }
  useEffect(t3, t4);
  const PluginContent = (_a = pluginContext == null ? void 0 : pluginContext.visiblePlugin) == null ? void 0 : _a.content;
  const t5 = (pluginContext == null ? void 0 : pluginContext.visiblePlugin) ? void 0 : "first";
  let t6;
  if ($[7] !== pluginContext || $[8] !== t5) {
    t6 = {
      defaultSizeRelation: 0.3333333333333333,
      direction: "horizontal",
      initiallyHidden: t5,
      onHiddenElementChange(resizableElement) {
        if (resizableElement === "first") {
          pluginContext == null ? void 0 : pluginContext.setVisiblePlugin(null);
        }
      },
      sizeThresholdSecond: 200,
      storageKey: "docExplorerFlex"
    };
    $[7] = pluginContext;
    $[8] = t5;
    $[9] = t6;
  } else {
    t6 = $[9];
  }
  const pluginResize = useDragResize(t6);
  let t7;
  if ($[10] === Symbol.for("react.memo_cache_sentinel")) {
    t7 = {
      direction: "horizontal",
      storageKey: "editorFlex"
    };
    $[10] = t7;
  } else {
    t7 = $[10];
  }
  const editorResize = useDragResize(t7);
  let t8;
  bb0: {
    if (props.defaultEditorToolsVisibility === "variables" || props.defaultEditorToolsVisibility === "headers") {
      t8 = void 0;
      break bb0;
    }
    if (typeof props.defaultEditorToolsVisibility === "boolean") {
      t8 = props.defaultEditorToolsVisibility ? void 0 : "second";
      break bb0;
    }
    t8 = editorContext.initialVariables || editorContext.initialHeaders ? void 0 : "second";
  }
  let t9;
  if ($[11] !== t8) {
    t9 = {
      defaultSizeRelation: 3,
      direction: "vertical",
      initiallyHidden: t8,
      sizeThresholdSecond: 60,
      storageKey: "secondaryEditorFlex"
    };
    $[11] = t8;
    $[12] = t9;
  } else {
    t9 = $[12];
  }
  const editorToolsResize = useDragResize(t9);
  let t10;
  if ($[13] !== editorContext.initialHeaders || $[14] !== editorContext.initialVariables || $[15] !== isHeadersEditorEnabled || $[16] !== props.defaultEditorToolsVisibility) {
    t10 = () => {
      if (props.defaultEditorToolsVisibility === "variables" || props.defaultEditorToolsVisibility === "headers") {
        return props.defaultEditorToolsVisibility;
      }
      return !editorContext.initialVariables && editorContext.initialHeaders && isHeadersEditorEnabled ? "headers" : "variables";
    };
    $[13] = editorContext.initialHeaders;
    $[14] = editorContext.initialVariables;
    $[15] = isHeadersEditorEnabled;
    $[16] = props.defaultEditorToolsVisibility;
    $[17] = t10;
  } else {
    t10 = $[17];
  }
  const [activeSecondaryEditor, setActiveSecondaryEditor] = useState(t10);
  const [showDialog, setShowDialog] = useState(null);
  const [clearStorageStatus, setClearStorageStatus] = useState(null);
  let t11;
  if ($[18] !== props.children || $[19] !== props.onCopyQuery || $[20] !== props.onPrettifyQuery) {
    let t122;
    if ($[22] !== props.onCopyQuery || $[23] !== props.onPrettifyQuery) {
      t122 = (acc, curr) => {
        bb94: switch (getChildComponentType(curr)) {
          case GraphiQL.Logo: {
            acc.logo = curr;
            break bb94;
          }
          case GraphiQL.Toolbar: {
            acc.toolbar = cloneElement(curr, {
              onCopyQuery: props.onCopyQuery,
              onPrettifyQuery: props.onPrettifyQuery
            });
            break bb94;
          }
          case GraphiQL.Footer: {
            acc.footer = curr;
          }
        }
        return acc;
      };
      $[22] = props.onCopyQuery;
      $[23] = props.onPrettifyQuery;
      $[24] = t122;
    } else {
      t122 = $[24];
    }
    let t132;
    if ($[25] === Symbol.for("react.memo_cache_sentinel")) {
      t132 = /* @__PURE__ */ jsx(GraphiQL.Logo, {});
      $[25] = t132;
    } else {
      t132 = $[25];
    }
    let t142;
    if ($[26] !== props.onCopyQuery || $[27] !== props.onPrettifyQuery) {
      t142 = /* @__PURE__ */ jsx(GraphiQL.Toolbar, { onCopyQuery: props.onCopyQuery, onPrettifyQuery: props.onPrettifyQuery });
      $[26] = props.onCopyQuery;
      $[27] = props.onPrettifyQuery;
      $[28] = t142;
    } else {
      t142 = $[28];
    }
    t11 = Children.toArray(props.children).reduce(t122, {
      logo: t132,
      toolbar: t142
    });
    $[18] = props.children;
    $[19] = props.onCopyQuery;
    $[20] = props.onPrettifyQuery;
    $[21] = t11;
  } else {
    t11 = $[21];
  }
  const {
    logo,
    toolbar,
    footer
  } = t11;
  let t12;
  if ($[29] !== pluginResize) {
    t12 = () => {
      if (pluginResize.hiddenElement === "first") {
        pluginResize.setHiddenElement(null);
      }
    };
    $[29] = pluginResize;
    $[30] = t12;
  } else {
    t12 = $[30];
  }
  const onClickReference = t12;
  let t13;
  if ($[31] !== storageContext) {
    t13 = () => {
      try {
        if (storageContext) {
          storageContext.clear();
        }
        setClearStorageStatus("success");
      } catch {
        setClearStorageStatus("error");
      }
    };
    $[31] = storageContext;
    $[32] = t13;
  } else {
    t13 = $[32];
  }
  const handleClearData = t13;
  let t14;
  if ($[33] !== editorContext) {
    t14 = (event) => {
      editorContext.setShouldPersistHeaders(event.currentTarget.dataset.value === "true");
    };
    $[33] = editorContext;
    $[34] = t14;
  } else {
    t14 = $[34];
  }
  const handlePersistHeaders = t14;
  let t15;
  if ($[35] !== setTheme) {
    t15 = (event_0) => {
      const selectedTheme = event_0.currentTarget.dataset.theme;
      setTheme(selectedTheme || null);
    };
    $[35] = setTheme;
    $[36] = t15;
  } else {
    t15 = $[36];
  }
  const handleChangeTheme = t15;
  const handleAddTab = editorContext.addTab;
  const handleRefetchSchema = schemaContext.introspect;
  const handleReorder = editorContext.moveTab;
  let t16;
  if ($[37] === Symbol.for("react.memo_cache_sentinel")) {
    t16 = (event_1) => {
      setShowDialog(event_1.currentTarget.dataset.value);
    };
    $[37] = t16;
  } else {
    t16 = $[37];
  }
  const handleShowDialog = t16;
  let t17;
  if ($[38] !== pluginContext || $[39] !== pluginResize) {
    t17 = (event_2) => {
      const context = pluginContext;
      const pluginIndex = Number(event_2.currentTarget.dataset.index);
      const plugin = context.plugins.find((_, index) => pluginIndex === index);
      const isVisible = plugin === context.visiblePlugin;
      if (isVisible) {
        context.setVisiblePlugin(null);
        pluginResize.setHiddenElement("first");
      } else {
        context.setVisiblePlugin(plugin);
        pluginResize.setHiddenElement(null);
      }
    };
    $[38] = pluginContext;
    $[39] = pluginResize;
    $[40] = t17;
  } else {
    t17 = $[40];
  }
  const handlePluginClick = t17;
  let t18;
  if ($[41] !== editorToolsResize) {
    t18 = (event_3) => {
      if (editorToolsResize.hiddenElement === "second") {
        editorToolsResize.setHiddenElement(null);
      }
      setActiveSecondaryEditor(event_3.currentTarget.dataset.name);
    };
    $[41] = editorToolsResize;
    $[42] = t18;
  } else {
    t18 = $[42];
  }
  const handleToolsTabClick = t18;
  let t19;
  if ($[43] !== editorToolsResize) {
    t19 = () => {
      editorToolsResize.setHiddenElement(editorToolsResize.hiddenElement === "second" ? null : "second");
    };
    $[43] = editorToolsResize;
    $[44] = t19;
  } else {
    t19 = $[44];
  }
  const toggleEditorTools = t19;
  let t20;
  if ($[45] === Symbol.for("react.memo_cache_sentinel")) {
    t20 = (isOpen) => {
      if (!isOpen) {
        setShowDialog(null);
      }
    };
    $[45] = t20;
  } else {
    t20 = $[45];
  }
  const handleOpenShortKeysDialog = t20;
  let t21;
  if ($[46] === Symbol.for("react.memo_cache_sentinel")) {
    t21 = (isOpen_0) => {
      if (!isOpen_0) {
        setShowDialog(null);
        setClearStorageStatus(null);
      }
    };
    $[46] = t21;
  } else {
    t21 = $[46];
  }
  const handleOpenSettingsDialog = t21;
  const className = props.className ? ` ${props.className}` : "";
  const confirmClose = props.confirmCloseTab;
  let t22;
  if ($[47] !== confirmClose || $[48] !== editorContext || $[49] !== executionContext) {
    t22 = async (event_4) => {
      const tabButton = event_4.currentTarget.previousSibling;
      const index_0 = Number(tabButton.id.replace(TAB_CLASS_PREFIX, ""));
      const shouldCloseTab = confirmClose ? await confirmClose(index_0) : true;
      if (!shouldCloseTab) {
        return;
      }
      if (editorContext.activeTabIndex === index_0) {
        executionContext.stop();
      }
      editorContext.closeTab(index_0);
    };
    $[47] = confirmClose;
    $[48] = editorContext;
    $[49] = executionContext;
    $[50] = t22;
  } else {
    t22 = $[50];
  }
  const handleTabClose = t22;
  let t23;
  if ($[51] !== editorContext || $[52] !== executionContext) {
    t23 = (event_5) => {
      const index_1 = Number(event_5.currentTarget.id.replace(TAB_CLASS_PREFIX, ""));
      executionContext.stop();
      editorContext.changeTab(index_1);
    };
    $[51] = editorContext;
    $[52] = executionContext;
    $[53] = t23;
  } else {
    t23 = $[53];
  }
  const handleTabClick = t23;
  const t24 = `graphiql-container${className}`;
  let t25;
  if ($[54] !== handlePluginClick || $[55] !== pluginContext) {
    t25 = pluginContext == null ? void 0 : pluginContext.plugins.map((plugin_0, index_2) => {
      const isVisible_0 = plugin_0 === pluginContext.visiblePlugin;
      const label = `${isVisible_0 ? "Hide" : "Show"} ${plugin_0.title}`;
      return /* @__PURE__ */ jsx(Tooltip, { label, children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: isVisible_0 ? "active" : "", onClick: handlePluginClick, "data-index": index_2, "aria-label": label, children: /* @__PURE__ */ jsx(plugin_0.icon, { "aria-hidden": "true" }) }) }, plugin_0.title);
    });
    $[54] = handlePluginClick;
    $[55] = pluginContext;
    $[56] = t25;
  } else {
    t25 = $[56];
  }
  let t26;
  if ($[57] === Symbol.for("react.memo_cache_sentinel")) {
    t26 = {
      marginTop: "auto"
    };
    $[57] = t26;
  } else {
    t26 = $[57];
  }
  const t27 = schemaContext.isFetching ? "graphiql-spin" : "";
  let t28;
  if ($[58] !== t27) {
    t28 = /* @__PURE__ */ jsx(ReloadIcon, { className: t27, "aria-hidden": "true" });
    $[58] = t27;
    $[59] = t28;
  } else {
    t28 = $[59];
  }
  let t29;
  if ($[60] !== handleRefetchSchema || $[61] !== schemaContext.isFetching || $[62] !== t28) {
    t29 = /* @__PURE__ */ jsx(Tooltip, { label: "Re-fetch GraphQL schema", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", disabled: schemaContext.isFetching, onClick: handleRefetchSchema, "aria-label": "Re-fetch GraphQL schema", style: t26, children: t28 }) });
    $[60] = handleRefetchSchema;
    $[61] = schemaContext.isFetching;
    $[62] = t28;
    $[63] = t29;
  } else {
    t29 = $[63];
  }
  let t30;
  if ($[64] === Symbol.for("react.memo_cache_sentinel")) {
    t30 = /* @__PURE__ */ jsx(Tooltip, { label: "Open short keys dialog", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", "data-value": "short-keys", onClick: handleShowDialog, "aria-label": "Open short keys dialog", children: /* @__PURE__ */ jsx(KeyboardShortcutIcon, { "aria-hidden": "true" }) }) });
    $[64] = t30;
  } else {
    t30 = $[64];
  }
  let t31;
  if ($[65] === Symbol.for("react.memo_cache_sentinel")) {
    t31 = /* @__PURE__ */ jsx(Tooltip, { label: "Open settings dialog", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", "data-value": "settings", onClick: handleShowDialog, "aria-label": "Open settings dialog", children: /* @__PURE__ */ jsx(SettingsIcon, { "aria-hidden": "true" }) }) });
    $[65] = t31;
  } else {
    t31 = $[65];
  }
  let t32;
  if ($[66] !== t25 || $[67] !== t29) {
    t32 = /* @__PURE__ */ jsxs("div", { className: "graphiql-sidebar", children: [
      t25,
      t29,
      t30,
      t31
    ] });
    $[66] = t25;
    $[67] = t29;
    $[68] = t32;
  } else {
    t32 = $[68];
  }
  let t33;
  if ($[69] === Symbol.for("react.memo_cache_sentinel")) {
    t33 = {
      minWidth: "200px"
    };
    $[69] = t33;
  } else {
    t33 = $[69];
  }
  let t34;
  if ($[70] !== PluginContent) {
    t34 = PluginContent ? /* @__PURE__ */ jsx(PluginContent, {}) : null;
    $[70] = PluginContent;
    $[71] = t34;
  } else {
    t34 = $[71];
  }
  let t35;
  if ($[72] !== t34) {
    t35 = /* @__PURE__ */ jsx("div", { className: "graphiql-plugin", children: t34 });
    $[72] = t34;
    $[73] = t35;
  } else {
    t35 = $[73];
  }
  let t36;
  if ($[74] !== pluginResize.firstRef || $[75] !== t35) {
    t36 = /* @__PURE__ */ jsx("div", { ref: pluginResize.firstRef, style: t33, children: t35 });
    $[74] = pluginResize.firstRef;
    $[75] = t35;
    $[76] = t36;
  } else {
    t36 = $[76];
  }
  let t37;
  if ($[77] !== (pluginContext == null ? void 0 : pluginContext.visiblePlugin) || $[78] !== pluginResize.dragBarRef) {
    t37 = (pluginContext == null ? void 0 : pluginContext.visiblePlugin) && /* @__PURE__ */ jsx("div", { className: "graphiql-horizontal-drag-bar", ref: pluginResize.dragBarRef });
    $[77] = pluginContext == null ? void 0 : pluginContext.visiblePlugin;
    $[78] = pluginResize.dragBarRef;
    $[79] = t37;
  } else {
    t37 = $[79];
  }
  const t38 = pluginResize.secondRef;
  const t39 = editorContext.tabs;
  let t40;
  if ($[80] !== editorContext.activeTabIndex || $[81] !== editorContext.tabs || $[82] !== handleTabClick || $[83] !== handleTabClose) {
    let t412;
    if ($[85] !== editorContext.activeTabIndex || $[86] !== handleTabClick || $[87] !== handleTabClose) {
      t412 = (tab, index_3, tabs) => /* @__PURE__ */ jsxs(Tab, { value: tab, isActive: index_3 === editorContext.activeTabIndex, children: [
        /* @__PURE__ */ jsx(Tab.Button, { "aria-controls": "graphiql-session", id: `graphiql-session-tab-${index_3}`, title: tab.title, onClick: handleTabClick, children: tab.title }),
        tabs.length > 1 && /* @__PURE__ */ jsx(Tab.Close, { onClick: handleTabClose })
      ] }, tab.id);
      $[85] = editorContext.activeTabIndex;
      $[86] = handleTabClick;
      $[87] = handleTabClose;
      $[88] = t412;
    } else {
      t412 = $[88];
    }
    t40 = editorContext.tabs.map(t412);
    $[80] = editorContext.activeTabIndex;
    $[81] = editorContext.tabs;
    $[82] = handleTabClick;
    $[83] = handleTabClose;
    $[84] = t40;
  } else {
    t40 = $[84];
  }
  let t41;
  if ($[89] !== editorContext.tabs || $[90] !== handleReorder || $[91] !== t40) {
    t41 = /* @__PURE__ */ jsx(Tabs, { values: t39, onReorder: handleReorder, "aria-label": "Select active operation", children: t40 });
    $[89] = editorContext.tabs;
    $[90] = handleReorder;
    $[91] = t40;
    $[92] = t41;
  } else {
    t41 = $[92];
  }
  let t42;
  if ($[93] === Symbol.for("react.memo_cache_sentinel")) {
    t42 = /* @__PURE__ */ jsx(PlusIcon, { "aria-hidden": "true" });
    $[93] = t42;
  } else {
    t42 = $[93];
  }
  let t43;
  if ($[94] !== handleAddTab) {
    t43 = /* @__PURE__ */ jsx(Tooltip, { label: "New tab", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: "graphiql-tab-add", onClick: handleAddTab, "aria-label": "New tab", children: t42 }) });
    $[94] = handleAddTab;
    $[95] = t43;
  } else {
    t43 = $[95];
  }
  let t44;
  if ($[96] !== logo || $[97] !== t41 || $[98] !== t43) {
    t44 = /* @__PURE__ */ jsxs("div", { className: "graphiql-session-header", children: [
      t41,
      t43,
      logo
    ] });
    $[96] = logo;
    $[97] = t41;
    $[98] = t43;
    $[99] = t44;
  } else {
    t44 = $[99];
  }
  const t45 = `${TAB_CLASS_PREFIX}${editorContext.activeTabIndex}`;
  let t46;
  if ($[100] !== onClickReference || $[101] !== props.editorTheme || $[102] !== props.keyMap || $[103] !== props.onCopyQuery || $[104] !== props.onEditQuery || $[105] !== props.onPrettifyQuery || $[106] !== props.readOnly) {
    t46 = /* @__PURE__ */ jsx(QueryEditor, { editorTheme: props.editorTheme, keyMap: props.keyMap, onClickReference, onCopyQuery: props.onCopyQuery, onPrettifyQuery: props.onPrettifyQuery, onEdit: props.onEditQuery, readOnly: props.readOnly });
    $[100] = onClickReference;
    $[101] = props.editorTheme;
    $[102] = props.keyMap;
    $[103] = props.onCopyQuery;
    $[104] = props.onEditQuery;
    $[105] = props.onPrettifyQuery;
    $[106] = props.readOnly;
    $[107] = t46;
  } else {
    t46 = $[107];
  }
  let t47;
  if ($[108] === Symbol.for("react.memo_cache_sentinel")) {
    t47 = /* @__PURE__ */ jsx(ExecuteButton, {});
    $[108] = t47;
  } else {
    t47 = $[108];
  }
  let t48;
  if ($[109] !== toolbar) {
    t48 = /* @__PURE__ */ jsxs("div", { className: "graphiql-toolbar", role: "toolbar", "aria-label": "Editor Commands", children: [
      t47,
      toolbar
    ] });
    $[109] = toolbar;
    $[110] = t48;
  } else {
    t48 = $[110];
  }
  let t49;
  if ($[111] !== t46 || $[112] !== t48) {
    t49 = /* @__PURE__ */ jsxs("section", { className: "graphiql-query-editor", "aria-label": "Query Editor", children: [
      t46,
      t48
    ] });
    $[111] = t46;
    $[112] = t48;
    $[113] = t49;
  } else {
    t49 = $[113];
  }
  let t50;
  if ($[114] !== editorToolsResize.firstRef || $[115] !== t49) {
    t50 = /* @__PURE__ */ jsx("div", { ref: editorToolsResize.firstRef, children: t49 });
    $[114] = editorToolsResize.firstRef;
    $[115] = t49;
    $[116] = t50;
  } else {
    t50 = $[116];
  }
  const t51 = activeSecondaryEditor === "variables" && editorToolsResize.hiddenElement !== "second" ? "active" : "";
  let t52;
  if ($[117] !== handleToolsTabClick || $[118] !== t51) {
    t52 = /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: t51, onClick: handleToolsTabClick, "data-name": "variables", children: "Variables" });
    $[117] = handleToolsTabClick;
    $[118] = t51;
    $[119] = t52;
  } else {
    t52 = $[119];
  }
  let t53;
  if ($[120] !== activeSecondaryEditor || $[121] !== editorToolsResize.hiddenElement || $[122] !== handleToolsTabClick || $[123] !== isHeadersEditorEnabled) {
    t53 = isHeadersEditorEnabled && /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: activeSecondaryEditor === "headers" && editorToolsResize.hiddenElement !== "second" ? "active" : "", onClick: handleToolsTabClick, "data-name": "headers", children: "Headers" });
    $[120] = activeSecondaryEditor;
    $[121] = editorToolsResize.hiddenElement;
    $[122] = handleToolsTabClick;
    $[123] = isHeadersEditorEnabled;
    $[124] = t53;
  } else {
    t53 = $[124];
  }
  const t54 = editorToolsResize.hiddenElement === "second" ? "Show editor tools" : "Hide editor tools";
  const t55 = editorToolsResize.hiddenElement === "second" ? "Show editor tools" : "Hide editor tools";
  let t56;
  if ($[125] !== editorToolsResize.hiddenElement) {
    t56 = editorToolsResize.hiddenElement === "second" ? /* @__PURE__ */ jsx(ChevronUpIcon, { className: "graphiql-chevron-icon", "aria-hidden": "true" }) : /* @__PURE__ */ jsx(ChevronDownIcon, { className: "graphiql-chevron-icon", "aria-hidden": "true" });
    $[125] = editorToolsResize.hiddenElement;
    $[126] = t56;
  } else {
    t56 = $[126];
  }
  let t57;
  if ($[127] !== t55 || $[128] !== t56 || $[129] !== toggleEditorTools) {
    t57 = /* @__PURE__ */ jsx(UnStyledButton, { type: "button", onClick: toggleEditorTools, "aria-label": t55, className: "graphiql-toggle-editor-tools", children: t56 });
    $[127] = t55;
    $[128] = t56;
    $[129] = toggleEditorTools;
    $[130] = t57;
  } else {
    t57 = $[130];
  }
  let t58;
  if ($[131] !== t54 || $[132] !== t57) {
    t58 = /* @__PURE__ */ jsx(Tooltip, { label: t54, children: t57 });
    $[131] = t54;
    $[132] = t57;
    $[133] = t58;
  } else {
    t58 = $[133];
  }
  let t59;
  if ($[134] !== t52 || $[135] !== t53 || $[136] !== t58) {
    t59 = /* @__PURE__ */ jsxs("div", { className: "graphiql-editor-tools", children: [
      t52,
      t53,
      t58
    ] });
    $[134] = t52;
    $[135] = t53;
    $[136] = t58;
    $[137] = t59;
  } else {
    t59 = $[137];
  }
  let t60;
  if ($[138] !== editorToolsResize.dragBarRef || $[139] !== t59) {
    t60 = /* @__PURE__ */ jsx("div", { ref: editorToolsResize.dragBarRef, children: t59 });
    $[138] = editorToolsResize.dragBarRef;
    $[139] = t59;
    $[140] = t60;
  } else {
    t60 = $[140];
  }
  const t61 = activeSecondaryEditor === "variables" ? "Variables" : "Headers";
  const t62 = activeSecondaryEditor !== "variables";
  let t63;
  if ($[141] !== onClickReference || $[142] !== props.editorTheme || $[143] !== props.keyMap || $[144] !== props.onEditVariables || $[145] !== props.readOnly || $[146] !== t62) {
    t63 = /* @__PURE__ */ jsx(VariableEditor, { editorTheme: props.editorTheme, isHidden: t62, keyMap: props.keyMap, onEdit: props.onEditVariables, onClickReference, readOnly: props.readOnly });
    $[141] = onClickReference;
    $[142] = props.editorTheme;
    $[143] = props.keyMap;
    $[144] = props.onEditVariables;
    $[145] = props.readOnly;
    $[146] = t62;
    $[147] = t63;
  } else {
    t63 = $[147];
  }
  let t64;
  if ($[148] !== activeSecondaryEditor || $[149] !== isHeadersEditorEnabled || $[150] !== props.editorTheme || $[151] !== props.keyMap || $[152] !== props.onEditHeaders || $[153] !== props.readOnly) {
    t64 = isHeadersEditorEnabled && /* @__PURE__ */ jsx(HeaderEditor, { editorTheme: props.editorTheme, isHidden: activeSecondaryEditor !== "headers", keyMap: props.keyMap, onEdit: props.onEditHeaders, readOnly: props.readOnly });
    $[148] = activeSecondaryEditor;
    $[149] = isHeadersEditorEnabled;
    $[150] = props.editorTheme;
    $[151] = props.keyMap;
    $[152] = props.onEditHeaders;
    $[153] = props.readOnly;
    $[154] = t64;
  } else {
    t64 = $[154];
  }
  let t65;
  if ($[155] !== t61 || $[156] !== t63 || $[157] !== t64) {
    t65 = /* @__PURE__ */ jsxs("section", { className: "graphiql-editor-tool", "aria-label": t61, children: [
      t63,
      t64
    ] });
    $[155] = t61;
    $[156] = t63;
    $[157] = t64;
    $[158] = t65;
  } else {
    t65 = $[158];
  }
  let t66;
  if ($[159] !== editorToolsResize.secondRef || $[160] !== t65) {
    t66 = /* @__PURE__ */ jsx("div", { ref: editorToolsResize.secondRef, children: t65 });
    $[159] = editorToolsResize.secondRef;
    $[160] = t65;
    $[161] = t66;
  } else {
    t66 = $[161];
  }
  let t67;
  if ($[162] !== t50 || $[163] !== t60 || $[164] !== t66) {
    t67 = /* @__PURE__ */ jsxs("div", { className: "graphiql-editors", children: [
      t50,
      t60,
      t66
    ] });
    $[162] = t50;
    $[163] = t60;
    $[164] = t66;
    $[165] = t67;
  } else {
    t67 = $[165];
  }
  let t68;
  if ($[166] !== editorResize.firstRef || $[167] !== t67) {
    t68 = /* @__PURE__ */ jsx("div", { ref: editorResize.firstRef, children: t67 });
    $[166] = editorResize.firstRef;
    $[167] = t67;
    $[168] = t68;
  } else {
    t68 = $[168];
  }
  let t69;
  if ($[169] !== editorResize.dragBarRef) {
    t69 = /* @__PURE__ */ jsx("div", { className: "graphiql-horizontal-drag-bar", ref: editorResize.dragBarRef });
    $[169] = editorResize.dragBarRef;
    $[170] = t69;
  } else {
    t69 = $[170];
  }
  let t70;
  if ($[171] !== executionContext.isFetching) {
    t70 = executionContext.isFetching ? /* @__PURE__ */ jsx(Spinner, {}) : null;
    $[171] = executionContext.isFetching;
    $[172] = t70;
  } else {
    t70 = $[172];
  }
  let t71;
  if ($[173] !== props.editorTheme || $[174] !== props.keyMap || $[175] !== props.responseTooltip) {
    t71 = /* @__PURE__ */ jsx(ResponseEditor, { editorTheme: props.editorTheme, responseTooltip: props.responseTooltip, keyMap: props.keyMap });
    $[173] = props.editorTheme;
    $[174] = props.keyMap;
    $[175] = props.responseTooltip;
    $[176] = t71;
  } else {
    t71 = $[176];
  }
  let t72;
  if ($[177] !== footer || $[178] !== t70 || $[179] !== t71) {
    t72 = /* @__PURE__ */ jsxs("div", { className: "graphiql-response", children: [
      t70,
      t71,
      footer
    ] });
    $[177] = footer;
    $[178] = t70;
    $[179] = t71;
    $[180] = t72;
  } else {
    t72 = $[180];
  }
  let t73;
  if ($[181] !== editorResize.secondRef || $[182] !== t72) {
    t73 = /* @__PURE__ */ jsx("div", { ref: editorResize.secondRef, children: t72 });
    $[181] = editorResize.secondRef;
    $[182] = t72;
    $[183] = t73;
  } else {
    t73 = $[183];
  }
  let t74;
  if ($[184] !== t45 || $[185] !== t68 || $[186] !== t69 || $[187] !== t73) {
    t74 = /* @__PURE__ */ jsxs("div", { role: "tabpanel", id: "graphiql-session", "aria-labelledby": t45, children: [
      t68,
      t69,
      t73
    ] });
    $[184] = t45;
    $[185] = t68;
    $[186] = t69;
    $[187] = t73;
    $[188] = t74;
  } else {
    t74 = $[188];
  }
  let t75;
  if ($[189] !== pluginResize.secondRef || $[190] !== t44 || $[191] !== t74) {
    t75 = /* @__PURE__ */ jsxs("div", { ref: t38, className: "graphiql-sessions", children: [
      t44,
      t74
    ] });
    $[189] = pluginResize.secondRef;
    $[190] = t44;
    $[191] = t74;
    $[192] = t75;
  } else {
    t75 = $[192];
  }
  let t76;
  if ($[193] !== t36 || $[194] !== t37 || $[195] !== t75) {
    t76 = /* @__PURE__ */ jsxs("div", { className: "graphiql-main", children: [
      t36,
      t37,
      t75
    ] });
    $[193] = t36;
    $[194] = t37;
    $[195] = t75;
    $[196] = t76;
  } else {
    t76 = $[196];
  }
  const t77 = showDialog === "short-keys";
  let t78;
  if ($[197] === Symbol.for("react.memo_cache_sentinel")) {
    t78 = /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-header", children: [
      /* @__PURE__ */ jsx(Dialog.Title, { className: "graphiql-dialog-title", children: "Short Keys" }),
      /* @__PURE__ */ jsx(Dialog.Close, {})
    ] });
    $[197] = t78;
  } else {
    t78 = $[197];
  }
  const t79 = props.keyMap || "sublime";
  let t80;
  if ($[198] !== t79) {
    t80 = /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section", children: /* @__PURE__ */ jsx(ShortKeys, { keyMap: t79 }) });
    $[198] = t79;
    $[199] = t80;
  } else {
    t80 = $[199];
  }
  let t81;
  if ($[200] !== t77 || $[201] !== t80) {
    t81 = /* @__PURE__ */ jsxs(Dialog, { open: t77, onOpenChange: handleOpenShortKeysDialog, children: [
      t78,
      t80
    ] });
    $[200] = t77;
    $[201] = t80;
    $[202] = t81;
  } else {
    t81 = $[202];
  }
  const t82 = showDialog === "settings";
  let t83;
  if ($[203] === Symbol.for("react.memo_cache_sentinel")) {
    t83 = /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-header", children: [
      /* @__PURE__ */ jsx(Dialog.Title, { className: "graphiql-dialog-title", children: "Settings" }),
      /* @__PURE__ */ jsx(Dialog.Close, {})
    ] });
    $[203] = t83;
  } else {
    t83 = $[203];
  }
  let t84;
  if ($[204] !== editorContext.shouldPersistHeaders || $[205] !== handlePersistHeaders || $[206] !== props.showPersistHeadersSettings) {
    t84 = props.showPersistHeadersSettings ? /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-title", children: "Persist headers" }),
        /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section-caption", children: [
          "Save headers upon reloading.",
          " ",
          /* @__PURE__ */ jsx("span", { className: "graphiql-warning-text", children: "Only enable if you trust this device." })
        ] })
      ] }),
      /* @__PURE__ */ jsxs(ButtonGroup, { children: [
        /* @__PURE__ */ jsx(Button, { type: "button", id: "enable-persist-headers", className: editorContext.shouldPersistHeaders ? "active" : "", "data-value": "true", onClick: handlePersistHeaders, children: "On" }),
        /* @__PURE__ */ jsx(Button, { type: "button", id: "disable-persist-headers", className: editorContext.shouldPersistHeaders ? "" : "active", onClick: handlePersistHeaders, children: "Off" })
      ] })
    ] }) : null;
    $[204] = editorContext.shouldPersistHeaders;
    $[205] = handlePersistHeaders;
    $[206] = props.showPersistHeadersSettings;
    $[207] = t84;
  } else {
    t84 = $[207];
  }
  let t85;
  if ($[208] !== forcedTheme || $[209] !== handleChangeTheme || $[210] !== theme) {
    t85 = !forcedTheme && /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-title", children: "Theme" }),
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-caption", children: "Adjust how the interface appears." })
      ] }),
      /* @__PURE__ */ jsxs(ButtonGroup, { children: [
        /* @__PURE__ */ jsx(Button, { type: "button", className: theme === null ? "active" : "", onClick: handleChangeTheme, children: "System" }),
        /* @__PURE__ */ jsx(Button, { type: "button", className: theme === "light" ? "active" : "", "data-theme": "light", onClick: handleChangeTheme, children: "Light" }),
        /* @__PURE__ */ jsx(Button, { type: "button", className: theme === "dark" ? "active" : "", "data-theme": "dark", onClick: handleChangeTheme, children: "Dark" })
      ] })
    ] });
    $[208] = forcedTheme;
    $[209] = handleChangeTheme;
    $[210] = theme;
    $[211] = t85;
  } else {
    t85 = $[211];
  }
  let t86;
  if ($[212] !== clearStorageStatus || $[213] !== handleClearData || $[214] !== storageContext) {
    t86 = storageContext ? /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-title", children: "Clear storage" }),
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-caption", children: "Remove all locally stored data and start fresh." })
      ] }),
      /* @__PURE__ */ jsx(Button, { type: "button", state: clearStorageStatus || void 0, disabled: clearStorageStatus === "success", onClick: handleClearData, children: {
        success: "Cleared data",
        error: "Failed"
      }[clearStorageStatus] || "Clear data" })
    ] }) : null;
    $[212] = clearStorageStatus;
    $[213] = handleClearData;
    $[214] = storageContext;
    $[215] = t86;
  } else {
    t86 = $[215];
  }
  let t87;
  if ($[216] !== t82 || $[217] !== t84 || $[218] !== t85 || $[219] !== t86) {
    t87 = /* @__PURE__ */ jsxs(Dialog, { open: t82, onOpenChange: handleOpenSettingsDialog, children: [
      t83,
      t84,
      t85,
      t86
    ] });
    $[216] = t82;
    $[217] = t84;
    $[218] = t85;
    $[219] = t86;
    $[220] = t87;
  } else {
    t87 = $[220];
  }
  let t88;
  if ($[221] !== t24 || $[222] !== t32 || $[223] !== t76 || $[224] !== t81 || $[225] !== t87) {
    t88 = /* @__PURE__ */ jsx(Tooltip.Provider, { children: /* @__PURE__ */ jsxs("div", { className: t24, children: [
      t32,
      t76,
      t81,
      t87
    ] }) });
    $[221] = t24;
    $[222] = t32;
    $[223] = t76;
    $[224] = t81;
    $[225] = t87;
    $[226] = t88;
  } else {
    t88 = $[226];
  }
  return t88;
}
const modifier = isMacOs ? "⌘" : "Ctrl";
const SHORT_KEYS = Object.entries({
  "Search in editor": [modifier, "F"],
  "Search in documentation": [modifier, "K"],
  "Execute query": [modifier, "Enter"],
  "Prettify editors": ["Ctrl", "Shift", "P"],
  "Merge fragments definitions into operation definition": ["Ctrl", "Shift", "M"],
  "Copy query": ["Ctrl", "Shift", "C"],
  "Re-fetch schema using introspection": ["Ctrl", "Shift", "R"]
});
function ShortKeys(t0) {
  const $ = c(5);
  const {
    keyMap
  } = t0;
  let t1;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = /* @__PURE__ */ jsxs("table", { className: "graphiql-table", children: [
      /* @__PURE__ */ jsx("thead", { children: /* @__PURE__ */ jsxs("tr", { children: [
        /* @__PURE__ */ jsx("th", { children: "Short Key" }),
        /* @__PURE__ */ jsx("th", { children: "Function" })
      ] }) }),
      /* @__PURE__ */ jsx("tbody", { children: SHORT_KEYS.map(_temp2) })
    ] });
    $[0] = t1;
  } else {
    t1 = $[0];
  }
  let t2;
  if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
    t2 = /* @__PURE__ */ jsx("a", { href: "https://codemirror.net/5/doc/manual.html#keymaps", target: "_blank", rel: "noopener noreferrer", children: "CodeMirror Key Maps" });
    $[1] = t2;
  } else {
    t2 = $[1];
  }
  let t3;
  if ($[2] === Symbol.for("react.memo_cache_sentinel")) {
    t3 = /* @__PURE__ */ jsx("em", { children: "i" });
    $[2] = t3;
  } else {
    t3 = $[2];
  }
  let t4;
  if ($[3] !== keyMap) {
    t4 = /* @__PURE__ */ jsxs("div", { children: [
      t1,
      /* @__PURE__ */ jsxs("p", { children: [
        "The editors use",
        " ",
        t2,
        " ",
        "that add more short keys. This instance of Graph",
        t3,
        "QL uses",
        " ",
        /* @__PURE__ */ jsx("code", { children: keyMap }),
        "."
      ] })
    ] });
    $[3] = keyMap;
    $[4] = t4;
  } else {
    t4 = $[4];
  }
  return t4;
}
function _temp2(t0) {
  const [title, keys] = t0;
  return /* @__PURE__ */ jsxs("tr", { children: [
    /* @__PURE__ */ jsx("td", { children: keys.map(_temp) }),
    /* @__PURE__ */ jsx("td", { children: title })
  ] }, title);
}
function _temp(key, index, array) {
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx("code", { className: "graphiql-key", children: key }),
    index !== array.length - 1 && " + "
  ] }, key);
}
const defaultGraphiqlLogo = /* @__PURE__ */ jsxs("a", { className: "graphiql-logo-link", href: "https://github.com/graphql/graphiql", target: "_blank", rel: "noreferrer", children: [
  "Graph",
  /* @__PURE__ */ jsx("em", { children: "i" }),
  "QL"
] });
function GraphiQLLogo(t0) {
  const $ = c(2);
  const {
    children: t1
  } = t0;
  const children = t1 === void 0 ? defaultGraphiqlLogo : t1;
  let t2;
  if ($[0] !== children) {
    t2 = /* @__PURE__ */ jsx("div", { className: "graphiql-logo", children });
    $[0] = children;
    $[1] = t2;
  } else {
    t2 = $[1];
  }
  return t2;
}
const DefaultToolbarRenderProps = (t0) => {
  const $ = c(4);
  const {
    prettify,
    copy,
    merge
  } = t0;
  let t1;
  if ($[0] !== copy || $[1] !== merge || $[2] !== prettify) {
    t1 = /* @__PURE__ */ jsxs(Fragment$1, { children: [
      prettify,
      merge,
      copy
    ] });
    $[0] = copy;
    $[1] = merge;
    $[2] = prettify;
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  return t1;
};
function GraphiQLToolbar({
  children = DefaultToolbarRenderProps,
  // @ts-expect-error -- Hide this prop for user, we use cloneElement to pass onCopyQuery
  onCopyQuery,
  // @ts-expect-error -- Hide this prop for user, we use cloneElement to pass onPrettifyQuery
  onPrettifyQuery
}) {
  "use no memo";
  if (typeof children !== "function") {
    throw new TypeError("The `GraphiQL.Toolbar` component requires a render prop function as its child.");
  }
  const onCopy = useCopyQuery({
    onCopyQuery
  });
  const onMerge = useMergeQuery();
  const onPrettify = usePrettifyEditors({
    onPrettifyQuery
  });
  const prettify = /* @__PURE__ */ jsx(ToolbarButton, { onClick: onPrettify, label: "Prettify query (Shift-Ctrl-P)", children: /* @__PURE__ */ jsx(PrettifyIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" }) });
  const merge = /* @__PURE__ */ jsx(ToolbarButton, { onClick: onMerge, label: "Merge fragments into query (Shift-Ctrl-M)", children: /* @__PURE__ */ jsx(MergeIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" }) });
  const copy = /* @__PURE__ */ jsx(ToolbarButton, { onClick: onCopy, label: "Copy query (Shift-Ctrl-C)", children: /* @__PURE__ */ jsx(CopyIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" }) });
  return children({
    prettify,
    copy,
    merge
  });
}
function GraphiQLFooter(props) {
  const $ = c(2);
  let t0;
  if ($[0] !== props.children) {
    t0 = /* @__PURE__ */ jsx("div", { className: "graphiql-footer", children: props.children });
    $[0] = props.children;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  return t0;
}
function getChildComponentType(child) {
  if (child && typeof child === "object" && "type" in child && typeof child.type === "function") {
    return child.type;
  }
}
export {
  GraphiQL,
  GraphiQLInterface
};
//# sourceMappingURL=GraphiQL.js.map
