import { GraphiQLProvider } from '@graphiql/react';
import { GraphiQLProviderProps } from '@graphiql/react';
import { JSX } from 'react/jsx-runtime';
import { JSX as JSX_2 } from 'react';
import { PropsWithChildren } from 'react';
import { ReactNode } from 'react';
import { Theme } from '@graphiql/react';
import { UseHeaderEditorArgs } from '@graphiql/react';
import { UseQueryEditorArgs } from '@graphiql/react';
import { UseResponseEditorArgs } from '@graphiql/react';
import { UseVariableEditorArgs } from '@graphiql/react';
import { WriteableEditorProps } from '@graphiql/react';

declare type AddSuffix<Obj extends Record<string, any>, Suffix extends string> = {
    [Key in keyof Obj as `${string & Key}${Suffix}`]: Obj[Key];
};

declare function GraphiQL_2({ dangerouslyAssumeSchemaIsValid, confirmCloseTab, defaultQuery, defaultTabs, externalFragments, fetcher, getDefaultFieldNames, headers, inputValueDeprecation, introspectionQueryName, maxHistoryLength, onEditOperationName, onSchemaChange, onTabChange, onTogglePluginVisibility, operationName, plugins, query, response, schema, schemaDescription, shouldPersistHeaders, storage, validationRules, variables, visiblePlugin, defaultHeaders, ...props }: GraphiQLProps): JSX.Element;

declare namespace GraphiQL_2 {
    var Logo: typeof GraphiQLLogo;
    var Toolbar: typeof GraphiQLToolbar;
    var Footer: typeof GraphiQLFooter;
}
export { GraphiQL_2 as GraphiQL }

declare function GraphiQLFooter<TProps>(props: PropsWithChildren<TProps>): JSX.Element;

export declare function GraphiQLInterface(props: GraphiQLInterfaceProps): JSX.Element;

export declare type GraphiQLInterfaceProps = WriteableEditorProps & AddSuffix<Pick<UseQueryEditorArgs, 'onEdit'>, 'Query'> & Pick<UseQueryEditorArgs, 'onCopyQuery' | 'onPrettifyQuery'> & AddSuffix<Pick<UseVariableEditorArgs, 'onEdit'>, 'Variables'> & AddSuffix<Pick<UseHeaderEditorArgs, 'onEdit'>, 'Headers'> & Pick<UseResponseEditorArgs, 'responseTooltip'> & {
    children?: ReactNode;
    defaultEditorToolsVisibility?: boolean | 'variables' | 'headers';
    isHeadersEditorEnabled?: boolean;
    showPersistHeadersSettings?: boolean;
    defaultTheme?: Theme;
    forcedTheme?: (typeof THEMES)[number];
    className?: string;
    confirmCloseTab?(index: number): Promise<boolean> | boolean;
};

declare function GraphiQLLogo<TProps>({ children, }: PropsWithChildren<TProps>): JSX.Element;

export declare type GraphiQLProps = Omit<GraphiQLProviderProps, 'children'> & GraphiQLInterfaceProps;

export { GraphiQLProvider }

export { GraphiQLProviderProps }

declare function GraphiQLToolbar({ children, onCopyQuery, onPrettifyQuery, }: {
    children?: ToolbarRenderProps;
}): JSX_2.Element;

declare const THEMES: readonly ["light", "dark", "system"];

declare type ToolbarRenderProps = (props: {
    prettify: ReactNode;
    copy: ReactNode;
    merge: ReactNode;
}) => JSX_2.Element;

export { }
