import { jsx, jsxs, Fragment } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { useEffect, useState, Children, cloneElement, Fragment as Fragment$1 } from "react";
import { useEditorContext, useExecutionContext, useSchemaContext, useStorageContext, usePluginContext, useTheme, useDragResize, cn, Tooltip, UnStyledButton, QueryEditor, ChevronUpIcon, ChevronDownIcon, VariableEditor, HeaderEditor, Spinner, ResponseEditor, Dialog, ButtonGroup, Button, GraphiQLProvider, useCopyQuery, useMergeQuery, usePrettifyEditors, ToolbarButton, MergeIcon, CopyIcon, PrettifyIcon, ReloadIcon, KeyboardShortcutIcon, SettingsIcon, Tab, Tabs, PlusIcon, ExecuteButton, isMacOs } from "@graphiql/react";
import { HISTORY_PLUGIN, HistoryContextProvider } from "@graphiql/plugin-history";
import { DOC_EXPLORER_PLUGIN, ExplorerContextProvider } from "@graphiql/plugin-doc-explorer";
const GraphiQL_ = (t0) => {
  var _a, _b;
  const $ = c(69);
  let confirmCloseTab;
  let dangerouslyAssumeSchemaIsValid;
  let defaultHeaders;
  let defaultQuery;
  let defaultTabs;
  let externalFragments;
  let fetcher;
  let getDefaultFieldNames;
  let headers;
  let inputValueDeprecation;
  let introspectionQueryName;
  let maxHistoryLength;
  let onEditOperationName;
  let onSchemaChange;
  let onTabChange;
  let onTogglePluginVisibility;
  let operationName;
  let props;
  let query;
  let response;
  let schema;
  let schemaDescription;
  let shouldPersistHeaders;
  let storage;
  let t1;
  let validationRules;
  let variables;
  let visiblePlugin;
  if ($[0] !== t0) {
    ({
      dangerouslyAssumeSchemaIsValid,
      confirmCloseTab,
      defaultQuery,
      defaultTabs,
      externalFragments,
      fetcher,
      getDefaultFieldNames,
      headers,
      inputValueDeprecation,
      introspectionQueryName,
      maxHistoryLength,
      onEditOperationName,
      onSchemaChange,
      onTabChange,
      onTogglePluginVisibility,
      operationName,
      plugins: t1,
      query,
      response,
      schema,
      schemaDescription,
      shouldPersistHeaders,
      storage,
      validationRules,
      variables,
      visiblePlugin,
      defaultHeaders,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = confirmCloseTab;
    $[2] = dangerouslyAssumeSchemaIsValid;
    $[3] = defaultHeaders;
    $[4] = defaultQuery;
    $[5] = defaultTabs;
    $[6] = externalFragments;
    $[7] = fetcher;
    $[8] = getDefaultFieldNames;
    $[9] = headers;
    $[10] = inputValueDeprecation;
    $[11] = introspectionQueryName;
    $[12] = maxHistoryLength;
    $[13] = onEditOperationName;
    $[14] = onSchemaChange;
    $[15] = onTabChange;
    $[16] = onTogglePluginVisibility;
    $[17] = operationName;
    $[18] = props;
    $[19] = query;
    $[20] = response;
    $[21] = schema;
    $[22] = schemaDescription;
    $[23] = shouldPersistHeaders;
    $[24] = storage;
    $[25] = t1;
    $[26] = validationRules;
    $[27] = variables;
    $[28] = visiblePlugin;
  } else {
    confirmCloseTab = $[1];
    dangerouslyAssumeSchemaIsValid = $[2];
    defaultHeaders = $[3];
    defaultQuery = $[4];
    defaultTabs = $[5];
    externalFragments = $[6];
    fetcher = $[7];
    getDefaultFieldNames = $[8];
    headers = $[9];
    inputValueDeprecation = $[10];
    introspectionQueryName = $[11];
    maxHistoryLength = $[12];
    onEditOperationName = $[13];
    onSchemaChange = $[14];
    onTabChange = $[15];
    onTogglePluginVisibility = $[16];
    operationName = $[17];
    props = $[18];
    query = $[19];
    response = $[20];
    schema = $[21];
    schemaDescription = $[22];
    shouldPersistHeaders = $[23];
    storage = $[24];
    t1 = $[25];
    validationRules = $[26];
    variables = $[27];
    visiblePlugin = $[28];
  }
  let t2;
  if ($[29] !== t1) {
    t2 = t1 === void 0 ? [] : t1;
    $[29] = t1;
    $[30] = t2;
  } else {
    t2 = $[30];
  }
  const plugins = t2;
  if ((_a = props.toolbar) == null ? void 0 : _a.additionalContent) {
    throw new TypeError("`toolbar.additionalContent` was removed. Use render props on `GraphiQL.Toolbar` component instead.");
  }
  if ((_b = props.toolbar) == null ? void 0 : _b.additionalComponent) {
    throw new TypeError("`toolbar.additionalComponent` was removed. Use render props on `GraphiQL.Toolbar` component instead.");
  }
  let t3;
  if ($[31] !== plugins) {
    t3 = [DOC_EXPLORER_PLUGIN, HISTORY_PLUGIN, ...plugins];
    $[31] = plugins;
    $[32] = t3;
  } else {
    t3 = $[32];
  }
  let t4;
  if ($[33] !== dangerouslyAssumeSchemaIsValid || $[34] !== defaultHeaders || $[35] !== defaultQuery || $[36] !== defaultTabs || $[37] !== externalFragments || $[38] !== fetcher || $[39] !== getDefaultFieldNames || $[40] !== headers || $[41] !== inputValueDeprecation || $[42] !== introspectionQueryName || $[43] !== onEditOperationName || $[44] !== onSchemaChange || $[45] !== onTabChange || $[46] !== onTogglePluginVisibility || $[47] !== operationName || $[48] !== query || $[49] !== response || $[50] !== schema || $[51] !== schemaDescription || $[52] !== shouldPersistHeaders || $[53] !== storage || $[54] !== t3 || $[55] !== validationRules || $[56] !== variables || $[57] !== visiblePlugin) {
    t4 = {
      getDefaultFieldNames,
      dangerouslyAssumeSchemaIsValid,
      defaultQuery,
      defaultHeaders,
      defaultTabs,
      externalFragments,
      fetcher,
      headers,
      inputValueDeprecation,
      introspectionQueryName,
      onEditOperationName,
      onSchemaChange,
      onTabChange,
      onTogglePluginVisibility,
      plugins: t3,
      referencePlugin: DOC_EXPLORER_PLUGIN,
      visiblePlugin,
      operationName,
      query,
      response,
      schema,
      schemaDescription,
      shouldPersistHeaders,
      storage,
      validationRules,
      variables
    };
    $[33] = dangerouslyAssumeSchemaIsValid;
    $[34] = defaultHeaders;
    $[35] = defaultQuery;
    $[36] = defaultTabs;
    $[37] = externalFragments;
    $[38] = fetcher;
    $[39] = getDefaultFieldNames;
    $[40] = headers;
    $[41] = inputValueDeprecation;
    $[42] = introspectionQueryName;
    $[43] = onEditOperationName;
    $[44] = onSchemaChange;
    $[45] = onTabChange;
    $[46] = onTogglePluginVisibility;
    $[47] = operationName;
    $[48] = query;
    $[49] = response;
    $[50] = schema;
    $[51] = schemaDescription;
    $[52] = shouldPersistHeaders;
    $[53] = storage;
    $[54] = t3;
    $[55] = validationRules;
    $[56] = variables;
    $[57] = visiblePlugin;
    $[58] = t4;
  } else {
    t4 = $[58];
  }
  const graphiqlProps = t4;
  const t5 = shouldPersistHeaders !== false;
  let t6;
  if ($[59] !== confirmCloseTab || $[60] !== props || $[61] !== t5) {
    t6 = /* @__PURE__ */ jsx(ExplorerContextProvider, { children: /* @__PURE__ */ jsx(GraphiQLInterface, { confirmCloseTab, showPersistHeadersSettings: t5, forcedTheme: props.forcedTheme, ...props }) });
    $[59] = confirmCloseTab;
    $[60] = props;
    $[61] = t5;
    $[62] = t6;
  } else {
    t6 = $[62];
  }
  let t7;
  if ($[63] !== maxHistoryLength || $[64] !== t6) {
    t7 = /* @__PURE__ */ jsx(HistoryContextProvider, { maxHistoryLength, children: t6 });
    $[63] = maxHistoryLength;
    $[64] = t6;
    $[65] = t7;
  } else {
    t7 = $[65];
  }
  let t8;
  if ($[66] !== graphiqlProps || $[67] !== t7) {
    t8 = /* @__PURE__ */ jsx(GraphiQLProvider, { ...graphiqlProps, children: t7 });
    $[66] = graphiqlProps;
    $[67] = t7;
    $[68] = t8;
  } else {
    t8 = $[68];
  }
  return t8;
};
const THEMES = ["light", "dark", "system"];
const TAB_CLASS_PREFIX = "graphiql-session-tab-";
const GraphiQLInterface = (props) => {
  var _a;
  const $ = c(233);
  const isHeadersEditorEnabled = props.isHeadersEditorEnabled ?? true;
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      nonNull: true
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const editorContext = useEditorContext(t0);
  let t1;
  if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = {
      nonNull: true
    };
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const executionContext = useExecutionContext(t1);
  let t2;
  if ($[2] === Symbol.for("react.memo_cache_sentinel")) {
    t2 = {
      nonNull: true
    };
    $[2] = t2;
  } else {
    t2 = $[2];
  }
  const schemaContext = useSchemaContext(t2);
  const storageContext = useStorageContext();
  const pluginContext = usePluginContext();
  const forcedTheme = props.forcedTheme && THEMES.includes(props.forcedTheme) ? props.forcedTheme : void 0;
  const {
    theme,
    setTheme
  } = useTheme(props.defaultTheme);
  let t3;
  let t4;
  if ($[3] !== forcedTheme || $[4] !== setTheme) {
    t3 = () => {
      if (forcedTheme === "system") {
        setTheme(null);
      } else {
        if (forcedTheme === "light" || forcedTheme === "dark") {
          setTheme(forcedTheme);
        }
      }
    };
    t4 = [forcedTheme, setTheme];
    $[3] = forcedTheme;
    $[4] = setTheme;
    $[5] = t3;
    $[6] = t4;
  } else {
    t3 = $[5];
    t4 = $[6];
  }
  useEffect(t3, t4);
  const PluginContent = (_a = pluginContext == null ? void 0 : pluginContext.visiblePlugin) == null ? void 0 : _a.content;
  const t5 = (pluginContext == null ? void 0 : pluginContext.visiblePlugin) ? void 0 : "first";
  let t6;
  if ($[7] !== pluginContext || $[8] !== t5) {
    t6 = {
      defaultSizeRelation: 0.3333333333333333,
      direction: "horizontal",
      initiallyHidden: t5,
      onHiddenElementChange(resizableElement) {
        if (resizableElement === "first") {
          pluginContext == null ? void 0 : pluginContext.setVisiblePlugin(null);
        }
      },
      sizeThresholdSecond: 200,
      storageKey: "docExplorerFlex"
    };
    $[7] = pluginContext;
    $[8] = t5;
    $[9] = t6;
  } else {
    t6 = $[9];
  }
  const pluginResize = useDragResize(t6);
  let t7;
  if ($[10] === Symbol.for("react.memo_cache_sentinel")) {
    t7 = {
      direction: "horizontal",
      storageKey: "editorFlex"
    };
    $[10] = t7;
  } else {
    t7 = $[10];
  }
  const editorResize = useDragResize(t7);
  let t8;
  bb0: {
    if (props.defaultEditorToolsVisibility === "variables" || props.defaultEditorToolsVisibility === "headers") {
      t8 = void 0;
      break bb0;
    }
    if (typeof props.defaultEditorToolsVisibility === "boolean") {
      t8 = props.defaultEditorToolsVisibility ? void 0 : "second";
      break bb0;
    }
    t8 = editorContext.initialVariables || editorContext.initialHeaders ? void 0 : "second";
  }
  let t9;
  if ($[11] !== t8) {
    t9 = {
      defaultSizeRelation: 3,
      direction: "vertical",
      initiallyHidden: t8,
      sizeThresholdSecond: 60,
      storageKey: "secondaryEditorFlex"
    };
    $[11] = t8;
    $[12] = t9;
  } else {
    t9 = $[12];
  }
  const editorToolsResize = useDragResize(t9);
  let t10;
  if ($[13] !== editorContext.initialHeaders || $[14] !== editorContext.initialVariables || $[15] !== isHeadersEditorEnabled || $[16] !== props.defaultEditorToolsVisibility) {
    t10 = () => {
      if (props.defaultEditorToolsVisibility === "variables" || props.defaultEditorToolsVisibility === "headers") {
        return props.defaultEditorToolsVisibility;
      }
      return !editorContext.initialVariables && editorContext.initialHeaders && isHeadersEditorEnabled ? "headers" : "variables";
    };
    $[13] = editorContext.initialHeaders;
    $[14] = editorContext.initialVariables;
    $[15] = isHeadersEditorEnabled;
    $[16] = props.defaultEditorToolsVisibility;
    $[17] = t10;
  } else {
    t10 = $[17];
  }
  const [activeSecondaryEditor, setActiveSecondaryEditor] = useState(t10);
  const [showDialog, setShowDialog] = useState(null);
  const [clearStorageStatus, setClearStorageStatus] = useState(null);
  let t11;
  if ($[18] !== props.children || $[19] !== props.onCopyQuery || $[20] !== props.onPrettifyQuery) {
    let t122;
    if ($[22] !== props.onCopyQuery || $[23] !== props.onPrettifyQuery) {
      t122 = (acc, curr) => {
        bb94: switch (getChildComponentType(curr)) {
          case GraphiQL.Logo: {
            acc.logo = curr;
            break bb94;
          }
          case GraphiQL.Toolbar: {
            acc.toolbar = cloneElement(curr, {
              onCopyQuery: props.onCopyQuery,
              onPrettifyQuery: props.onPrettifyQuery
            });
            break bb94;
          }
          case GraphiQL.Footer: {
            acc.footer = curr;
          }
        }
        return acc;
      };
      $[22] = props.onCopyQuery;
      $[23] = props.onPrettifyQuery;
      $[24] = t122;
    } else {
      t122 = $[24];
    }
    let t132;
    if ($[25] === Symbol.for("react.memo_cache_sentinel")) {
      t132 = /* @__PURE__ */ jsx(GraphiQL.Logo, {});
      $[25] = t132;
    } else {
      t132 = $[25];
    }
    let t142;
    if ($[26] !== props.onCopyQuery || $[27] !== props.onPrettifyQuery) {
      t142 = /* @__PURE__ */ jsx(GraphiQL.Toolbar, { onCopyQuery: props.onCopyQuery, onPrettifyQuery: props.onPrettifyQuery });
      $[26] = props.onCopyQuery;
      $[27] = props.onPrettifyQuery;
      $[28] = t142;
    } else {
      t142 = $[28];
    }
    t11 = Children.toArray(props.children).reduce(t122, {
      logo: t132,
      toolbar: t142
    });
    $[18] = props.children;
    $[19] = props.onCopyQuery;
    $[20] = props.onPrettifyQuery;
    $[21] = t11;
  } else {
    t11 = $[21];
  }
  const {
    logo,
    toolbar,
    footer
  } = t11;
  let t12;
  if ($[29] !== pluginResize) {
    t12 = () => {
      if (pluginResize.hiddenElement === "first") {
        pluginResize.setHiddenElement(null);
      }
    };
    $[29] = pluginResize;
    $[30] = t12;
  } else {
    t12 = $[30];
  }
  const onClickReference = t12;
  let t13;
  if ($[31] !== storageContext) {
    t13 = () => {
      try {
        if (storageContext) {
          storageContext.clear();
        }
        setClearStorageStatus("success");
      } catch {
        setClearStorageStatus("error");
      }
    };
    $[31] = storageContext;
    $[32] = t13;
  } else {
    t13 = $[32];
  }
  const handleClearData = t13;
  let t14;
  if ($[33] !== editorContext) {
    t14 = (event) => {
      editorContext.setShouldPersistHeaders(event.currentTarget.dataset.value === "true");
    };
    $[33] = editorContext;
    $[34] = t14;
  } else {
    t14 = $[34];
  }
  const handlePersistHeaders = t14;
  let t15;
  if ($[35] !== setTheme) {
    t15 = (event_0) => {
      const selectedTheme = event_0.currentTarget.dataset.theme;
      setTheme(selectedTheme || null);
    };
    $[35] = setTheme;
    $[36] = t15;
  } else {
    t15 = $[36];
  }
  const handleChangeTheme = t15;
  const handleAddTab = editorContext.addTab;
  const handleRefetchSchema = schemaContext.introspect;
  const handleReorder = editorContext.moveTab;
  let t16;
  if ($[37] === Symbol.for("react.memo_cache_sentinel")) {
    t16 = (event_1) => {
      setShowDialog(event_1.currentTarget.dataset.value);
    };
    $[37] = t16;
  } else {
    t16 = $[37];
  }
  const handleShowDialog = t16;
  let t17;
  if ($[38] !== pluginContext || $[39] !== pluginResize) {
    t17 = (event_2) => {
      const context = pluginContext;
      const pluginIndex = Number(event_2.currentTarget.dataset.index);
      const plugin = context.plugins.find((_, index) => pluginIndex === index);
      const isVisible = plugin === context.visiblePlugin;
      if (isVisible) {
        context.setVisiblePlugin(null);
        pluginResize.setHiddenElement("first");
      } else {
        context.setVisiblePlugin(plugin);
        pluginResize.setHiddenElement(null);
      }
    };
    $[38] = pluginContext;
    $[39] = pluginResize;
    $[40] = t17;
  } else {
    t17 = $[40];
  }
  const handlePluginClick = t17;
  let t18;
  if ($[41] !== editorToolsResize) {
    t18 = (event_3) => {
      if (editorToolsResize.hiddenElement === "second") {
        editorToolsResize.setHiddenElement(null);
      }
      setActiveSecondaryEditor(event_3.currentTarget.dataset.name);
    };
    $[41] = editorToolsResize;
    $[42] = t18;
  } else {
    t18 = $[42];
  }
  const handleToolsTabClick = t18;
  let t19;
  if ($[43] !== editorToolsResize) {
    t19 = () => {
      editorToolsResize.setHiddenElement(editorToolsResize.hiddenElement === "second" ? null : "second");
    };
    $[43] = editorToolsResize;
    $[44] = t19;
  } else {
    t19 = $[44];
  }
  const toggleEditorTools = t19;
  let t20;
  if ($[45] === Symbol.for("react.memo_cache_sentinel")) {
    t20 = (isOpen) => {
      if (!isOpen) {
        setShowDialog(null);
      }
    };
    $[45] = t20;
  } else {
    t20 = $[45];
  }
  const handleOpenShortKeysDialog = t20;
  let t21;
  if ($[46] === Symbol.for("react.memo_cache_sentinel")) {
    t21 = (isOpen_0) => {
      if (!isOpen_0) {
        setShowDialog(null);
        setClearStorageStatus(null);
      }
    };
    $[46] = t21;
  } else {
    t21 = $[46];
  }
  const handleOpenSettingsDialog = t21;
  const confirmClose = props.confirmCloseTab;
  let t22;
  if ($[47] !== confirmClose || $[48] !== editorContext || $[49] !== executionContext) {
    t22 = async (event_4) => {
      const tabButton = event_4.currentTarget.previousSibling;
      const index_0 = Number(tabButton.id.replace(TAB_CLASS_PREFIX, ""));
      const shouldCloseTab = confirmClose ? await confirmClose(index_0) : true;
      if (!shouldCloseTab) {
        return;
      }
      if (editorContext.activeTabIndex === index_0) {
        executionContext.stop();
      }
      editorContext.closeTab(index_0);
    };
    $[47] = confirmClose;
    $[48] = editorContext;
    $[49] = executionContext;
    $[50] = t22;
  } else {
    t22 = $[50];
  }
  const handleTabClose = t22;
  let t23;
  if ($[51] !== editorContext || $[52] !== executionContext) {
    t23 = (event_5) => {
      const index_1 = Number(event_5.currentTarget.id.replace(TAB_CLASS_PREFIX, ""));
      executionContext.stop();
      editorContext.changeTab(index_1);
    };
    $[51] = editorContext;
    $[52] = executionContext;
    $[53] = t23;
  } else {
    t23 = $[53];
  }
  const handleTabClick = t23;
  let t24;
  if ($[54] !== props.className) {
    t24 = cn("graphiql-container", props.className);
    $[54] = props.className;
    $[55] = t24;
  } else {
    t24 = $[55];
  }
  let t25;
  if ($[56] !== handlePluginClick || $[57] !== pluginContext) {
    t25 = pluginContext == null ? void 0 : pluginContext.plugins.map((plugin_0, index_2) => {
      const isVisible_0 = plugin_0 === pluginContext.visiblePlugin;
      const label = `${isVisible_0 ? "Hide" : "Show"} ${plugin_0.title}`;
      return /* @__PURE__ */ jsx(Tooltip, { label, children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: cn(isVisible_0 && "active"), onClick: handlePluginClick, "data-index": index_2, "aria-label": label, children: /* @__PURE__ */ jsx(plugin_0.icon, { "aria-hidden": "true" }) }) }, plugin_0.title);
    });
    $[56] = handlePluginClick;
    $[57] = pluginContext;
    $[58] = t25;
  } else {
    t25 = $[58];
  }
  const t26 = schemaContext.isFetching;
  let t27;
  if ($[59] === Symbol.for("react.memo_cache_sentinel")) {
    t27 = {
      marginTop: "auto"
    };
    $[59] = t27;
  } else {
    t27 = $[59];
  }
  const t28 = schemaContext.isFetching && "graphiql-spin";
  let t29;
  if ($[60] !== t28) {
    t29 = cn(t28);
    $[60] = t28;
    $[61] = t29;
  } else {
    t29 = $[61];
  }
  let t30;
  if ($[62] !== t29) {
    t30 = /* @__PURE__ */ jsx(ReloadIcon, { className: t29, "aria-hidden": "true" });
    $[62] = t29;
    $[63] = t30;
  } else {
    t30 = $[63];
  }
  let t31;
  if ($[64] !== handleRefetchSchema || $[65] !== schemaContext.isFetching || $[66] !== t30) {
    t31 = /* @__PURE__ */ jsx(Tooltip, { label: "Re-fetch GraphQL schema", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", disabled: t26, onClick: handleRefetchSchema, "aria-label": "Re-fetch GraphQL schema", style: t27, children: t30 }) });
    $[64] = handleRefetchSchema;
    $[65] = schemaContext.isFetching;
    $[66] = t30;
    $[67] = t31;
  } else {
    t31 = $[67];
  }
  let t32;
  if ($[68] === Symbol.for("react.memo_cache_sentinel")) {
    t32 = /* @__PURE__ */ jsx(Tooltip, { label: "Open short keys dialog", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", "data-value": "short-keys", onClick: handleShowDialog, "aria-label": "Open short keys dialog", children: /* @__PURE__ */ jsx(KeyboardShortcutIcon, { "aria-hidden": "true" }) }) });
    $[68] = t32;
  } else {
    t32 = $[68];
  }
  let t33;
  if ($[69] === Symbol.for("react.memo_cache_sentinel")) {
    t33 = /* @__PURE__ */ jsx(Tooltip, { label: "Open settings dialog", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", "data-value": "settings", onClick: handleShowDialog, "aria-label": "Open settings dialog", children: /* @__PURE__ */ jsx(SettingsIcon, { "aria-hidden": "true" }) }) });
    $[69] = t33;
  } else {
    t33 = $[69];
  }
  let t34;
  if ($[70] !== t25 || $[71] !== t31) {
    t34 = /* @__PURE__ */ jsxs("div", { className: "graphiql-sidebar", children: [
      t25,
      t31,
      t32,
      t33
    ] });
    $[70] = t25;
    $[71] = t31;
    $[72] = t34;
  } else {
    t34 = $[72];
  }
  let t35;
  if ($[73] === Symbol.for("react.memo_cache_sentinel")) {
    t35 = {
      minWidth: "200px"
    };
    $[73] = t35;
  } else {
    t35 = $[73];
  }
  let t36;
  if ($[74] !== PluginContent) {
    t36 = PluginContent ? /* @__PURE__ */ jsx(PluginContent, {}) : null;
    $[74] = PluginContent;
    $[75] = t36;
  } else {
    t36 = $[75];
  }
  let t37;
  if ($[76] !== t36) {
    t37 = /* @__PURE__ */ jsx("div", { className: "graphiql-plugin", children: t36 });
    $[76] = t36;
    $[77] = t37;
  } else {
    t37 = $[77];
  }
  let t38;
  if ($[78] !== pluginResize.firstRef || $[79] !== t37) {
    t38 = /* @__PURE__ */ jsx("div", { ref: pluginResize.firstRef, style: t35, children: t37 });
    $[78] = pluginResize.firstRef;
    $[79] = t37;
    $[80] = t38;
  } else {
    t38 = $[80];
  }
  let t39;
  if ($[81] !== (pluginContext == null ? void 0 : pluginContext.visiblePlugin) || $[82] !== pluginResize.dragBarRef) {
    t39 = (pluginContext == null ? void 0 : pluginContext.visiblePlugin) && /* @__PURE__ */ jsx("div", { className: "graphiql-horizontal-drag-bar", ref: pluginResize.dragBarRef });
    $[81] = pluginContext == null ? void 0 : pluginContext.visiblePlugin;
    $[82] = pluginResize.dragBarRef;
    $[83] = t39;
  } else {
    t39 = $[83];
  }
  const t40 = pluginResize.secondRef;
  const t41 = editorContext.tabs;
  let t42;
  if ($[84] !== editorContext.activeTabIndex || $[85] !== editorContext.tabs || $[86] !== handleTabClick || $[87] !== handleTabClose) {
    let t432;
    if ($[89] !== editorContext.activeTabIndex || $[90] !== handleTabClick || $[91] !== handleTabClose) {
      t432 = (tab, index_3, tabs) => /* @__PURE__ */ jsxs(Tab, { value: tab, isActive: index_3 === editorContext.activeTabIndex, children: [
        /* @__PURE__ */ jsx(Tab.Button, { "aria-controls": "graphiql-session", id: `graphiql-session-tab-${index_3}`, title: tab.title, onClick: handleTabClick, children: tab.title }),
        tabs.length > 1 && /* @__PURE__ */ jsx(Tab.Close, { onClick: handleTabClose })
      ] }, tab.id);
      $[89] = editorContext.activeTabIndex;
      $[90] = handleTabClick;
      $[91] = handleTabClose;
      $[92] = t432;
    } else {
      t432 = $[92];
    }
    t42 = editorContext.tabs.map(t432);
    $[84] = editorContext.activeTabIndex;
    $[85] = editorContext.tabs;
    $[86] = handleTabClick;
    $[87] = handleTabClose;
    $[88] = t42;
  } else {
    t42 = $[88];
  }
  let t43;
  if ($[93] !== editorContext.tabs || $[94] !== handleReorder || $[95] !== t42) {
    t43 = /* @__PURE__ */ jsx(Tabs, { values: t41, onReorder: handleReorder, "aria-label": "Select active operation", children: t42 });
    $[93] = editorContext.tabs;
    $[94] = handleReorder;
    $[95] = t42;
    $[96] = t43;
  } else {
    t43 = $[96];
  }
  let t44;
  if ($[97] === Symbol.for("react.memo_cache_sentinel")) {
    t44 = /* @__PURE__ */ jsx(PlusIcon, { "aria-hidden": "true" });
    $[97] = t44;
  } else {
    t44 = $[97];
  }
  let t45;
  if ($[98] !== handleAddTab) {
    t45 = /* @__PURE__ */ jsx(Tooltip, { label: "New tab", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: "graphiql-tab-add", onClick: handleAddTab, "aria-label": "New tab", children: t44 }) });
    $[98] = handleAddTab;
    $[99] = t45;
  } else {
    t45 = $[99];
  }
  let t46;
  if ($[100] !== logo || $[101] !== t43 || $[102] !== t45) {
    t46 = /* @__PURE__ */ jsxs("div", { className: "graphiql-session-header", children: [
      t43,
      t45,
      logo
    ] });
    $[100] = logo;
    $[101] = t43;
    $[102] = t45;
    $[103] = t46;
  } else {
    t46 = $[103];
  }
  const t47 = `${TAB_CLASS_PREFIX}${editorContext.activeTabIndex}`;
  const t48 = editorResize.firstRef;
  let t49;
  if ($[104] !== onClickReference || $[105] !== props.editorTheme || $[106] !== props.keyMap || $[107] !== props.onCopyQuery || $[108] !== props.onEditQuery || $[109] !== props.onPrettifyQuery || $[110] !== props.readOnly) {
    t49 = /* @__PURE__ */ jsx(QueryEditor, { editorTheme: props.editorTheme, keyMap: props.keyMap, onClickReference, onCopyQuery: props.onCopyQuery, onPrettifyQuery: props.onPrettifyQuery, onEdit: props.onEditQuery, readOnly: props.readOnly });
    $[104] = onClickReference;
    $[105] = props.editorTheme;
    $[106] = props.keyMap;
    $[107] = props.onCopyQuery;
    $[108] = props.onEditQuery;
    $[109] = props.onPrettifyQuery;
    $[110] = props.readOnly;
    $[111] = t49;
  } else {
    t49 = $[111];
  }
  let t50;
  if ($[112] === Symbol.for("react.memo_cache_sentinel")) {
    t50 = /* @__PURE__ */ jsx(ExecuteButton, {});
    $[112] = t50;
  } else {
    t50 = $[112];
  }
  let t51;
  if ($[113] !== toolbar) {
    t51 = /* @__PURE__ */ jsxs("div", { className: "graphiql-toolbar", role: "toolbar", "aria-label": "Editor Commands", children: [
      t50,
      toolbar
    ] });
    $[113] = toolbar;
    $[114] = t51;
  } else {
    t51 = $[114];
  }
  let t52;
  if ($[115] !== t49 || $[116] !== t51) {
    t52 = /* @__PURE__ */ jsxs("section", { className: "graphiql-query-editor", "aria-label": "Query Editor", children: [
      t49,
      t51
    ] });
    $[115] = t49;
    $[116] = t51;
    $[117] = t52;
  } else {
    t52 = $[117];
  }
  let t53;
  if ($[118] !== editorToolsResize.firstRef || $[119] !== t52) {
    t53 = /* @__PURE__ */ jsx("div", { ref: editorToolsResize.firstRef, children: t52 });
    $[118] = editorToolsResize.firstRef;
    $[119] = t52;
    $[120] = t53;
  } else {
    t53 = $[120];
  }
  const t54 = editorToolsResize.dragBarRef;
  const t55 = activeSecondaryEditor === "variables" && editorToolsResize.hiddenElement !== "second" && "active";
  let t56;
  if ($[121] !== t55) {
    t56 = cn(t55);
    $[121] = t55;
    $[122] = t56;
  } else {
    t56 = $[122];
  }
  let t57;
  if ($[123] !== handleToolsTabClick || $[124] !== t56) {
    t57 = /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: t56, onClick: handleToolsTabClick, "data-name": "variables", children: "Variables" });
    $[123] = handleToolsTabClick;
    $[124] = t56;
    $[125] = t57;
  } else {
    t57 = $[125];
  }
  let t58;
  if ($[126] !== activeSecondaryEditor || $[127] !== editorToolsResize.hiddenElement || $[128] !== handleToolsTabClick || $[129] !== isHeadersEditorEnabled) {
    t58 = isHeadersEditorEnabled && /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: cn(activeSecondaryEditor === "headers" && editorToolsResize.hiddenElement !== "second" && "active"), onClick: handleToolsTabClick, "data-name": "headers", children: "Headers" });
    $[126] = activeSecondaryEditor;
    $[127] = editorToolsResize.hiddenElement;
    $[128] = handleToolsTabClick;
    $[129] = isHeadersEditorEnabled;
    $[130] = t58;
  } else {
    t58 = $[130];
  }
  const t59 = editorToolsResize.hiddenElement === "second" ? "Show editor tools" : "Hide editor tools";
  const t60 = editorToolsResize.hiddenElement === "second" ? "Show editor tools" : "Hide editor tools";
  let t61;
  if ($[131] !== editorToolsResize.hiddenElement) {
    t61 = editorToolsResize.hiddenElement === "second" ? /* @__PURE__ */ jsx(ChevronUpIcon, { className: "graphiql-chevron-icon", "aria-hidden": "true" }) : /* @__PURE__ */ jsx(ChevronDownIcon, { className: "graphiql-chevron-icon", "aria-hidden": "true" });
    $[131] = editorToolsResize.hiddenElement;
    $[132] = t61;
  } else {
    t61 = $[132];
  }
  let t62;
  if ($[133] !== t60 || $[134] !== t61 || $[135] !== toggleEditorTools) {
    t62 = /* @__PURE__ */ jsx(UnStyledButton, { type: "button", onClick: toggleEditorTools, "aria-label": t60, className: "graphiql-toggle-editor-tools", children: t61 });
    $[133] = t60;
    $[134] = t61;
    $[135] = toggleEditorTools;
    $[136] = t62;
  } else {
    t62 = $[136];
  }
  let t63;
  if ($[137] !== t59 || $[138] !== t62) {
    t63 = /* @__PURE__ */ jsx(Tooltip, { label: t59, children: t62 });
    $[137] = t59;
    $[138] = t62;
    $[139] = t63;
  } else {
    t63 = $[139];
  }
  let t64;
  if ($[140] !== t57 || $[141] !== t58 || $[142] !== t63) {
    t64 = /* @__PURE__ */ jsxs("div", { className: "graphiql-editor-tools", children: [
      t57,
      t58,
      t63
    ] });
    $[140] = t57;
    $[141] = t58;
    $[142] = t63;
    $[143] = t64;
  } else {
    t64 = $[143];
  }
  let t65;
  if ($[144] !== editorToolsResize.dragBarRef || $[145] !== t64) {
    t65 = /* @__PURE__ */ jsx("div", { ref: t54, children: t64 });
    $[144] = editorToolsResize.dragBarRef;
    $[145] = t64;
    $[146] = t65;
  } else {
    t65 = $[146];
  }
  const t66 = activeSecondaryEditor === "variables" ? "Variables" : "Headers";
  const t67 = activeSecondaryEditor !== "variables";
  let t68;
  if ($[147] !== onClickReference || $[148] !== props.editorTheme || $[149] !== props.keyMap || $[150] !== props.onEditVariables || $[151] !== props.readOnly || $[152] !== t67) {
    t68 = /* @__PURE__ */ jsx(VariableEditor, { editorTheme: props.editorTheme, isHidden: t67, keyMap: props.keyMap, onEdit: props.onEditVariables, onClickReference, readOnly: props.readOnly });
    $[147] = onClickReference;
    $[148] = props.editorTheme;
    $[149] = props.keyMap;
    $[150] = props.onEditVariables;
    $[151] = props.readOnly;
    $[152] = t67;
    $[153] = t68;
  } else {
    t68 = $[153];
  }
  let t69;
  if ($[154] !== activeSecondaryEditor || $[155] !== isHeadersEditorEnabled || $[156] !== props.editorTheme || $[157] !== props.keyMap || $[158] !== props.onEditHeaders || $[159] !== props.readOnly) {
    t69 = isHeadersEditorEnabled && /* @__PURE__ */ jsx(HeaderEditor, { editorTheme: props.editorTheme, isHidden: activeSecondaryEditor !== "headers", keyMap: props.keyMap, onEdit: props.onEditHeaders, readOnly: props.readOnly });
    $[154] = activeSecondaryEditor;
    $[155] = isHeadersEditorEnabled;
    $[156] = props.editorTheme;
    $[157] = props.keyMap;
    $[158] = props.onEditHeaders;
    $[159] = props.readOnly;
    $[160] = t69;
  } else {
    t69 = $[160];
  }
  let t70;
  if ($[161] !== t66 || $[162] !== t68 || $[163] !== t69) {
    t70 = /* @__PURE__ */ jsxs("section", { className: "graphiql-editor-tool", "aria-label": t66, children: [
      t68,
      t69
    ] });
    $[161] = t66;
    $[162] = t68;
    $[163] = t69;
    $[164] = t70;
  } else {
    t70 = $[164];
  }
  let t71;
  if ($[165] !== editorToolsResize.secondRef || $[166] !== t70) {
    t71 = /* @__PURE__ */ jsx("div", { ref: editorToolsResize.secondRef, children: t70 });
    $[165] = editorToolsResize.secondRef;
    $[166] = t70;
    $[167] = t71;
  } else {
    t71 = $[167];
  }
  let t72;
  if ($[168] !== t53 || $[169] !== t65 || $[170] !== t71) {
    t72 = /* @__PURE__ */ jsxs("div", { className: "graphiql-editors", children: [
      t53,
      t65,
      t71
    ] });
    $[168] = t53;
    $[169] = t65;
    $[170] = t71;
    $[171] = t72;
  } else {
    t72 = $[171];
  }
  let t73;
  if ($[172] !== editorResize.firstRef || $[173] !== t72) {
    t73 = /* @__PURE__ */ jsx("div", { ref: t48, children: t72 });
    $[172] = editorResize.firstRef;
    $[173] = t72;
    $[174] = t73;
  } else {
    t73 = $[174];
  }
  let t74;
  if ($[175] !== editorResize.dragBarRef) {
    t74 = /* @__PURE__ */ jsx("div", { className: "graphiql-horizontal-drag-bar", ref: editorResize.dragBarRef });
    $[175] = editorResize.dragBarRef;
    $[176] = t74;
  } else {
    t74 = $[176];
  }
  let t75;
  if ($[177] !== executionContext.isFetching) {
    t75 = executionContext.isFetching ? /* @__PURE__ */ jsx(Spinner, {}) : null;
    $[177] = executionContext.isFetching;
    $[178] = t75;
  } else {
    t75 = $[178];
  }
  let t76;
  if ($[179] !== props.editorTheme || $[180] !== props.keyMap || $[181] !== props.responseTooltip) {
    t76 = /* @__PURE__ */ jsx(ResponseEditor, { editorTheme: props.editorTheme, responseTooltip: props.responseTooltip, keyMap: props.keyMap });
    $[179] = props.editorTheme;
    $[180] = props.keyMap;
    $[181] = props.responseTooltip;
    $[182] = t76;
  } else {
    t76 = $[182];
  }
  let t77;
  if ($[183] !== footer || $[184] !== t75 || $[185] !== t76) {
    t77 = /* @__PURE__ */ jsxs("div", { className: "graphiql-response", children: [
      t75,
      t76,
      footer
    ] });
    $[183] = footer;
    $[184] = t75;
    $[185] = t76;
    $[186] = t77;
  } else {
    t77 = $[186];
  }
  let t78;
  if ($[187] !== editorResize.secondRef || $[188] !== t77) {
    t78 = /* @__PURE__ */ jsx("div", { ref: editorResize.secondRef, children: t77 });
    $[187] = editorResize.secondRef;
    $[188] = t77;
    $[189] = t78;
  } else {
    t78 = $[189];
  }
  let t79;
  if ($[190] !== t47 || $[191] !== t73 || $[192] !== t74 || $[193] !== t78) {
    t79 = /* @__PURE__ */ jsxs("div", { role: "tabpanel", id: "graphiql-session", "aria-labelledby": t47, children: [
      t73,
      t74,
      t78
    ] });
    $[190] = t47;
    $[191] = t73;
    $[192] = t74;
    $[193] = t78;
    $[194] = t79;
  } else {
    t79 = $[194];
  }
  let t80;
  if ($[195] !== pluginResize.secondRef || $[196] !== t46 || $[197] !== t79) {
    t80 = /* @__PURE__ */ jsxs("div", { ref: t40, className: "graphiql-sessions", children: [
      t46,
      t79
    ] });
    $[195] = pluginResize.secondRef;
    $[196] = t46;
    $[197] = t79;
    $[198] = t80;
  } else {
    t80 = $[198];
  }
  let t81;
  if ($[199] !== t38 || $[200] !== t39 || $[201] !== t80) {
    t81 = /* @__PURE__ */ jsxs("div", { className: "graphiql-main", children: [
      t38,
      t39,
      t80
    ] });
    $[199] = t38;
    $[200] = t39;
    $[201] = t80;
    $[202] = t81;
  } else {
    t81 = $[202];
  }
  const t82 = showDialog === "short-keys";
  let t83;
  if ($[203] === Symbol.for("react.memo_cache_sentinel")) {
    t83 = /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-header", children: [
      /* @__PURE__ */ jsx(Dialog.Title, { className: "graphiql-dialog-title", children: "Short Keys" }),
      /* @__PURE__ */ jsx(Dialog.Close, {})
    ] });
    $[203] = t83;
  } else {
    t83 = $[203];
  }
  const t84 = props.keyMap || "sublime";
  let t85;
  if ($[204] !== t84) {
    t85 = /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section", children: /* @__PURE__ */ jsx(ShortKeys, { keyMap: t84 }) });
    $[204] = t84;
    $[205] = t85;
  } else {
    t85 = $[205];
  }
  let t86;
  if ($[206] !== t82 || $[207] !== t85) {
    t86 = /* @__PURE__ */ jsxs(Dialog, { open: t82, onOpenChange: handleOpenShortKeysDialog, children: [
      t83,
      t85
    ] });
    $[206] = t82;
    $[207] = t85;
    $[208] = t86;
  } else {
    t86 = $[208];
  }
  const t87 = showDialog === "settings";
  let t88;
  if ($[209] === Symbol.for("react.memo_cache_sentinel")) {
    t88 = /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-header", children: [
      /* @__PURE__ */ jsx(Dialog.Title, { className: "graphiql-dialog-title", children: "Settings" }),
      /* @__PURE__ */ jsx(Dialog.Close, {})
    ] });
    $[209] = t88;
  } else {
    t88 = $[209];
  }
  let t89;
  if ($[210] !== editorContext.shouldPersistHeaders || $[211] !== handlePersistHeaders || $[212] !== props.showPersistHeadersSettings) {
    t89 = props.showPersistHeadersSettings ? /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-title", children: "Persist headers" }),
        /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section-caption", children: [
          "Save headers upon reloading.",
          " ",
          /* @__PURE__ */ jsx("span", { className: "graphiql-warning-text", children: "Only enable if you trust this device." })
        ] })
      ] }),
      /* @__PURE__ */ jsxs(ButtonGroup, { children: [
        /* @__PURE__ */ jsx(Button, { type: "button", id: "enable-persist-headers", className: cn(editorContext.shouldPersistHeaders && "active"), "data-value": "true", onClick: handlePersistHeaders, children: "On" }),
        /* @__PURE__ */ jsx(Button, { type: "button", id: "disable-persist-headers", className: cn(!editorContext.shouldPersistHeaders && "active"), onClick: handlePersistHeaders, children: "Off" })
      ] })
    ] }) : null;
    $[210] = editorContext.shouldPersistHeaders;
    $[211] = handlePersistHeaders;
    $[212] = props.showPersistHeadersSettings;
    $[213] = t89;
  } else {
    t89 = $[213];
  }
  let t90;
  if ($[214] !== forcedTheme || $[215] !== handleChangeTheme || $[216] !== theme) {
    t90 = !forcedTheme && /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-title", children: "Theme" }),
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-caption", children: "Adjust how the interface appears." })
      ] }),
      /* @__PURE__ */ jsxs(ButtonGroup, { children: [
        /* @__PURE__ */ jsx(Button, { type: "button", className: cn(theme === null && "active"), onClick: handleChangeTheme, children: "System" }),
        /* @__PURE__ */ jsx(Button, { type: "button", className: cn(theme === "light" && "active"), "data-theme": "light", onClick: handleChangeTheme, children: "Light" }),
        /* @__PURE__ */ jsx(Button, { type: "button", className: cn(theme === "dark" && "active"), "data-theme": "dark", onClick: handleChangeTheme, children: "Dark" })
      ] })
    ] });
    $[214] = forcedTheme;
    $[215] = handleChangeTheme;
    $[216] = theme;
    $[217] = t90;
  } else {
    t90 = $[217];
  }
  let t91;
  if ($[218] !== clearStorageStatus || $[219] !== handleClearData || $[220] !== storageContext) {
    t91 = storageContext ? /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-title", children: "Clear storage" }),
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-caption", children: "Remove all locally stored data and start fresh." })
      ] }),
      /* @__PURE__ */ jsx(Button, { type: "button", state: clearStorageStatus || void 0, disabled: clearStorageStatus === "success", onClick: handleClearData, children: {
        success: "Cleared data",
        error: "Failed"
      }[clearStorageStatus] || "Clear data" })
    ] }) : null;
    $[218] = clearStorageStatus;
    $[219] = handleClearData;
    $[220] = storageContext;
    $[221] = t91;
  } else {
    t91 = $[221];
  }
  let t92;
  if ($[222] !== t87 || $[223] !== t89 || $[224] !== t90 || $[225] !== t91) {
    t92 = /* @__PURE__ */ jsxs(Dialog, { open: t87, onOpenChange: handleOpenSettingsDialog, children: [
      t88,
      t89,
      t90,
      t91
    ] });
    $[222] = t87;
    $[223] = t89;
    $[224] = t90;
    $[225] = t91;
    $[226] = t92;
  } else {
    t92 = $[226];
  }
  let t93;
  if ($[227] !== t24 || $[228] !== t34 || $[229] !== t81 || $[230] !== t86 || $[231] !== t92) {
    t93 = /* @__PURE__ */ jsx(Tooltip.Provider, { children: /* @__PURE__ */ jsxs("div", { className: t24, children: [
      t34,
      t81,
      t86,
      t92
    ] }) });
    $[227] = t24;
    $[228] = t34;
    $[229] = t81;
    $[230] = t86;
    $[231] = t92;
    $[232] = t93;
  } else {
    t93 = $[232];
  }
  return t93;
};
const modifier = isMacOs ? "⌘" : "Ctrl";
const SHORT_KEYS = Object.entries({
  "Search in editor": [modifier, "F"],
  "Search in documentation": [modifier, "K"],
  "Execute query": [modifier, "Enter"],
  "Prettify editors": ["Ctrl", "Shift", "P"],
  "Merge fragments definitions into operation definition": ["Ctrl", "Shift", "M"],
  "Copy query": ["Ctrl", "Shift", "C"],
  "Re-fetch schema using introspection": ["Ctrl", "Shift", "R"]
});
const ShortKeys = (t0) => {
  const $ = c(5);
  const {
    keyMap
  } = t0;
  let t1;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = /* @__PURE__ */ jsxs("table", { className: "graphiql-table", children: [
      /* @__PURE__ */ jsx("thead", { children: /* @__PURE__ */ jsxs("tr", { children: [
        /* @__PURE__ */ jsx("th", { children: "Short Key" }),
        /* @__PURE__ */ jsx("th", { children: "Function" })
      ] }) }),
      /* @__PURE__ */ jsx("tbody", { children: SHORT_KEYS.map(_temp2) })
    ] });
    $[0] = t1;
  } else {
    t1 = $[0];
  }
  let t2;
  if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
    t2 = /* @__PURE__ */ jsx("a", { href: "https://codemirror.net/5/doc/manual.html#keymaps", target: "_blank", rel: "noopener noreferrer", children: "CodeMirror Key Maps" });
    $[1] = t2;
  } else {
    t2 = $[1];
  }
  let t3;
  if ($[2] === Symbol.for("react.memo_cache_sentinel")) {
    t3 = /* @__PURE__ */ jsx("em", { children: "i" });
    $[2] = t3;
  } else {
    t3 = $[2];
  }
  let t4;
  if ($[3] !== keyMap) {
    t4 = /* @__PURE__ */ jsxs("div", { children: [
      t1,
      /* @__PURE__ */ jsxs("p", { children: [
        "The editors use",
        " ",
        t2,
        " ",
        "that add more short keys. This instance of Graph",
        t3,
        "QL uses",
        " ",
        /* @__PURE__ */ jsx("code", { children: keyMap }),
        "."
      ] })
    ] });
    $[3] = keyMap;
    $[4] = t4;
  } else {
    t4 = $[4];
  }
  return t4;
};
const defaultGraphiqlLogo = /* @__PURE__ */ jsxs("a", { className: "graphiql-logo-link", href: "https://github.com/graphql/graphiql", target: "_blank", rel: "noreferrer", children: [
  "Graph",
  /* @__PURE__ */ jsx("em", { children: "i" }),
  "QL"
] });
const GraphiQLLogo = (t0) => {
  const $ = c(2);
  const {
    children: t1
  } = t0;
  const children = t1 === void 0 ? defaultGraphiqlLogo : t1;
  let t2;
  if ($[0] !== children) {
    t2 = /* @__PURE__ */ jsx("div", { className: "graphiql-logo", children });
    $[0] = children;
    $[1] = t2;
  } else {
    t2 = $[1];
  }
  return t2;
};
const DefaultToolbarRenderProps = (t0) => {
  const $ = c(4);
  const {
    prettify,
    copy,
    merge
  } = t0;
  let t1;
  if ($[0] !== copy || $[1] !== merge || $[2] !== prettify) {
    t1 = /* @__PURE__ */ jsxs(Fragment, { children: [
      prettify,
      merge,
      copy
    ] });
    $[0] = copy;
    $[1] = merge;
    $[2] = prettify;
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  return t1;
};
const GraphiQLToolbar = ({
  children = DefaultToolbarRenderProps,
  // @ts-expect-error -- Hide this prop for user, we use cloneElement to pass onCopyQuery
  onCopyQuery,
  // @ts-expect-error -- Hide this prop for user, we use cloneElement to pass onPrettifyQuery
  onPrettifyQuery
}) => {
  "use no memo";
  if (typeof children !== "function") {
    throw new TypeError("The `GraphiQL.Toolbar` component requires a render prop function as its child.");
  }
  const onCopy = useCopyQuery({
    onCopyQuery
  });
  const onMerge = useMergeQuery();
  const onPrettify = usePrettifyEditors({
    onPrettifyQuery
  });
  const prettify = /* @__PURE__ */ jsx(ToolbarButton, { onClick: onPrettify, label: "Prettify query (Shift-Ctrl-P)", children: /* @__PURE__ */ jsx(PrettifyIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" }) });
  const merge = /* @__PURE__ */ jsx(ToolbarButton, { onClick: onMerge, label: "Merge fragments into query (Shift-Ctrl-M)", children: /* @__PURE__ */ jsx(MergeIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" }) });
  const copy = /* @__PURE__ */ jsx(ToolbarButton, { onClick: onCopy, label: "Copy query (Shift-Ctrl-C)", children: /* @__PURE__ */ jsx(CopyIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" }) });
  return children({
    prettify,
    copy,
    merge
  });
};
const GraphiQLFooter = (props) => {
  const $ = c(2);
  let t0;
  if ($[0] !== props.children) {
    t0 = /* @__PURE__ */ jsx("div", { className: "graphiql-footer", children: props.children });
    $[0] = props.children;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  return t0;
};
function getChildComponentType(child) {
  if (child && typeof child === "object" && "type" in child && typeof child.type === "function") {
    return child.type;
  }
}
const GraphiQL = Object.assign(GraphiQL_, {
  Logo: GraphiQLLogo,
  Toolbar: GraphiQLToolbar,
  Footer: GraphiQLFooter
});
function _temp(key, index, array) {
  return /* @__PURE__ */ jsxs(Fragment$1, { children: [
    /* @__PURE__ */ jsx("code", { className: "graphiql-key", children: key }),
    index !== array.length - 1 && " + "
  ] }, key);
}
function _temp2(t0) {
  const [title, keys] = t0;
  return /* @__PURE__ */ jsxs("tr", { children: [
    /* @__PURE__ */ jsx("td", { children: keys.map(_temp) }),
    /* @__PURE__ */ jsx("td", { children: title })
  ] }, title);
}
export {
  GraphiQL,
  GraphiQLInterface
};
//# sourceMappingURL=GraphiQL.js.map
