import { ComponentPropsWithoutRef } from 'react';
import { FC } from 'react';
import { GraphiQLProvider } from '@graphiql/react';
import { HistoryContextProvider } from '@graphiql/plugin-history';
import { ReactNode } from 'react';
import { Theme } from '@graphiql/react';
import { UseHeaderEditorArgs } from '@graphiql/react';
import { UseQueryEditorArgs } from '@graphiql/react';
import { UseResponseEditorArgs } from '@graphiql/react';
import { UseVariableEditorArgs } from '@graphiql/react';
import { WriteableEditorProps } from '@graphiql/react';

declare type AddSuffix<Obj extends Record<string, any>, Suffix extends string> = {
    [Key in keyof Obj as `${string & Key}${Suffix}`]: Obj[Key];
};

declare const GraphiQL_2: FC<GraphiQLProps> & {
    Logo: FC<{
        children?: ReactNode;
    }>;
    Toolbar: FC<{
        children?: FC<{
            prettify: ReactNode;
            copy: ReactNode;
            merge: ReactNode;
        }> | undefined;
    }>;
    Footer: FC<{
        children: ReactNode;
    }>;
};
export { GraphiQL_2 as GraphiQL }

export declare const GraphiQLInterface: FC<GraphiQLInterfaceProps>;

export declare type GraphiQLInterfaceProps = WriteableEditorProps & AddSuffix<Pick<UseQueryEditorArgs, 'onEdit'>, 'Query'> & Pick<UseQueryEditorArgs, 'onCopyQuery' | 'onPrettifyQuery'> & AddSuffix<Pick<UseVariableEditorArgs, 'onEdit'>, 'Variables'> & AddSuffix<Pick<UseHeaderEditorArgs, 'onEdit'>, 'Headers'> & Pick<UseResponseEditorArgs, 'responseTooltip'> & {
    children?: ReactNode;
    defaultEditorToolsVisibility?: boolean | 'variables' | 'headers';
    isHeadersEditorEnabled?: boolean;
    showPersistHeadersSettings?: boolean;
    defaultTheme?: Theme;
    forcedTheme?: (typeof THEMES)[number];
    className?: string;
    confirmCloseTab?(index: number): Promise<boolean> | boolean;
};

export declare type GraphiQLProps = Omit<ComponentPropsWithoutRef<typeof GraphiQLProvider>, 'children'> & Omit<ComponentPropsWithoutRef<typeof HistoryContextProvider>, 'children'> & GraphiQLInterfaceProps;

export { GraphiQLProvider }

declare const THEMES: readonly ["light", "dark", "system"];

export { }
