import { jsx, jsxs, Fragment as Fragment$1 } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { useEffect, useState, Children, Fragment, cloneElement } from "react";
import { useEditorContext, useExecutionContext, useSchemaContext, useStorageContext, usePluginContext, useTheme, useDragResize, cn, Tooltip, UnStyledButton, QueryEditor, ChevronUpIcon, ChevronDownIcon, VariableEditor, HeaderEditor, Spinner, ResponseEditor, Dialog, ButtonGroup, Button, GraphiQLProvider, useCopyQuery, useMergeQuery, usePrettifyEditors, ToolbarButton, MergeIcon, CopyIcon, PrettifyIcon, isMacOs, ReloadIcon, KeyboardShortcutIcon, SettingsIcon, Tab, Tabs, PlusIcon, ExecuteButton } from "@graphiql/react";
import { HISTORY_PLUGIN, HistoryContextProvider } from "@graphiql/plugin-history";
import { DOC_EXPLORER_PLUGIN, DocExplorerContextProvider } from "@graphiql/plugin-doc-explorer";
const GraphiQL_ = (t0) => {
  var _a, _b;
  const $ = c(72);
  let confirmCloseTab;
  let dangerouslyAssumeSchemaIsValid;
  let defaultHeaders;
  let defaultQuery;
  let defaultTabs;
  let externalFragments;
  let fetcher;
  let getDefaultFieldNames;
  let headers;
  let inputValueDeprecation;
  let introspectionQueryName;
  let maxHistoryLength;
  let onEditOperationName;
  let onSchemaChange;
  let onTabChange;
  let onTogglePluginVisibility;
  let operationName;
  let props;
  let query;
  let response;
  let schema;
  let schemaDescription;
  let shouldPersistHeaders;
  let storage;
  let t1;
  let t2;
  let validationRules;
  let variables;
  let visiblePlugin;
  if ($[0] !== t0) {
    ({
      dangerouslyAssumeSchemaIsValid,
      confirmCloseTab,
      defaultQuery,
      defaultTabs,
      externalFragments,
      fetcher,
      getDefaultFieldNames,
      headers,
      inputValueDeprecation,
      introspectionQueryName,
      maxHistoryLength,
      onEditOperationName,
      onSchemaChange,
      onTabChange,
      onTogglePluginVisibility,
      operationName,
      plugins: t1,
      referencePlugin: t2,
      query,
      response,
      schema,
      schemaDescription,
      shouldPersistHeaders,
      storage,
      validationRules,
      variables,
      visiblePlugin,
      defaultHeaders,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = confirmCloseTab;
    $[2] = dangerouslyAssumeSchemaIsValid;
    $[3] = defaultHeaders;
    $[4] = defaultQuery;
    $[5] = defaultTabs;
    $[6] = externalFragments;
    $[7] = fetcher;
    $[8] = getDefaultFieldNames;
    $[9] = headers;
    $[10] = inputValueDeprecation;
    $[11] = introspectionQueryName;
    $[12] = maxHistoryLength;
    $[13] = onEditOperationName;
    $[14] = onSchemaChange;
    $[15] = onTabChange;
    $[16] = onTogglePluginVisibility;
    $[17] = operationName;
    $[18] = props;
    $[19] = query;
    $[20] = response;
    $[21] = schema;
    $[22] = schemaDescription;
    $[23] = shouldPersistHeaders;
    $[24] = storage;
    $[25] = t1;
    $[26] = t2;
    $[27] = validationRules;
    $[28] = variables;
    $[29] = visiblePlugin;
  } else {
    confirmCloseTab = $[1];
    dangerouslyAssumeSchemaIsValid = $[2];
    defaultHeaders = $[3];
    defaultQuery = $[4];
    defaultTabs = $[5];
    externalFragments = $[6];
    fetcher = $[7];
    getDefaultFieldNames = $[8];
    headers = $[9];
    inputValueDeprecation = $[10];
    introspectionQueryName = $[11];
    maxHistoryLength = $[12];
    onEditOperationName = $[13];
    onSchemaChange = $[14];
    onTabChange = $[15];
    onTogglePluginVisibility = $[16];
    operationName = $[17];
    props = $[18];
    query = $[19];
    response = $[20];
    schema = $[21];
    schemaDescription = $[22];
    shouldPersistHeaders = $[23];
    storage = $[24];
    t1 = $[25];
    t2 = $[26];
    validationRules = $[27];
    variables = $[28];
    visiblePlugin = $[29];
  }
  let t3;
  if ($[30] !== t1) {
    t3 = t1 === void 0 ? [] : t1;
    $[30] = t1;
    $[31] = t3;
  } else {
    t3 = $[31];
  }
  const plugins = t3;
  const referencePlugin = t2 === void 0 ? DOC_EXPLORER_PLUGIN : t2;
  if ((_a = props.toolbar) == null ? void 0 : _a.additionalContent) {
    throw new TypeError("`toolbar.additionalContent` was removed. Use render props on `GraphiQL.Toolbar` component instead.");
  }
  if ((_b = props.toolbar) == null ? void 0 : _b.additionalComponent) {
    throw new TypeError("`toolbar.additionalComponent` was removed. Use render props on `GraphiQL.Toolbar` component instead.");
  }
  let t4;
  if ($[32] !== plugins || $[33] !== referencePlugin) {
    t4 = [referencePlugin, HISTORY_PLUGIN, ...plugins];
    $[32] = plugins;
    $[33] = referencePlugin;
    $[34] = t4;
  } else {
    t4 = $[34];
  }
  let t5;
  if ($[35] !== dangerouslyAssumeSchemaIsValid || $[36] !== defaultHeaders || $[37] !== defaultQuery || $[38] !== defaultTabs || $[39] !== externalFragments || $[40] !== fetcher || $[41] !== getDefaultFieldNames || $[42] !== headers || $[43] !== inputValueDeprecation || $[44] !== introspectionQueryName || $[45] !== onEditOperationName || $[46] !== onSchemaChange || $[47] !== onTabChange || $[48] !== onTogglePluginVisibility || $[49] !== operationName || $[50] !== query || $[51] !== referencePlugin || $[52] !== response || $[53] !== schema || $[54] !== schemaDescription || $[55] !== shouldPersistHeaders || $[56] !== storage || $[57] !== t4 || $[58] !== validationRules || $[59] !== variables || $[60] !== visiblePlugin) {
    t5 = {
      getDefaultFieldNames,
      dangerouslyAssumeSchemaIsValid,
      defaultQuery,
      defaultHeaders,
      defaultTabs,
      externalFragments,
      fetcher,
      headers,
      inputValueDeprecation,
      introspectionQueryName,
      onEditOperationName,
      onSchemaChange,
      onTabChange,
      onTogglePluginVisibility,
      plugins: t4,
      referencePlugin,
      visiblePlugin,
      operationName,
      query,
      response,
      schema,
      schemaDescription,
      shouldPersistHeaders,
      storage,
      validationRules,
      variables
    };
    $[35] = dangerouslyAssumeSchemaIsValid;
    $[36] = defaultHeaders;
    $[37] = defaultQuery;
    $[38] = defaultTabs;
    $[39] = externalFragments;
    $[40] = fetcher;
    $[41] = getDefaultFieldNames;
    $[42] = headers;
    $[43] = inputValueDeprecation;
    $[44] = introspectionQueryName;
    $[45] = onEditOperationName;
    $[46] = onSchemaChange;
    $[47] = onTabChange;
    $[48] = onTogglePluginVisibility;
    $[49] = operationName;
    $[50] = query;
    $[51] = referencePlugin;
    $[52] = response;
    $[53] = schema;
    $[54] = schemaDescription;
    $[55] = shouldPersistHeaders;
    $[56] = storage;
    $[57] = t4;
    $[58] = validationRules;
    $[59] = variables;
    $[60] = visiblePlugin;
    $[61] = t5;
  } else {
    t5 = $[61];
  }
  const graphiqlProps = t5;
  const t6 = shouldPersistHeaders !== false;
  let t7;
  if ($[62] !== confirmCloseTab || $[63] !== props || $[64] !== t6) {
    t7 = /* @__PURE__ */ jsx(DocExplorerContextProvider, { children: /* @__PURE__ */ jsx(GraphiQLInterface, { confirmCloseTab, showPersistHeadersSettings: t6, forcedTheme: props.forcedTheme, ...props }) });
    $[62] = confirmCloseTab;
    $[63] = props;
    $[64] = t6;
    $[65] = t7;
  } else {
    t7 = $[65];
  }
  let t8;
  if ($[66] !== maxHistoryLength || $[67] !== t7) {
    t8 = /* @__PURE__ */ jsx(HistoryContextProvider, { maxHistoryLength, children: t7 });
    $[66] = maxHistoryLength;
    $[67] = t7;
    $[68] = t8;
  } else {
    t8 = $[68];
  }
  let t9;
  if ($[69] !== graphiqlProps || $[70] !== t8) {
    t9 = /* @__PURE__ */ jsx(GraphiQLProvider, { ...graphiqlProps, children: t8 });
    $[69] = graphiqlProps;
    $[70] = t8;
    $[71] = t9;
  } else {
    t9 = $[71];
  }
  return t9;
};
const THEMES = ["light", "dark", "system"];
const TAB_CLASS_PREFIX = "graphiql-session-tab-";
const GraphiQLInterface = (props) => {
  var _a;
  const $ = c(221);
  const isHeadersEditorEnabled = props.isHeadersEditorEnabled ?? true;
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      nonNull: true
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const editorContext = useEditorContext(t0);
  let t1;
  if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = {
      nonNull: true
    };
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const executionContext = useExecutionContext(t1);
  let t2;
  if ($[2] === Symbol.for("react.memo_cache_sentinel")) {
    t2 = {
      nonNull: true
    };
    $[2] = t2;
  } else {
    t2 = $[2];
  }
  const schemaContext = useSchemaContext(t2);
  const storageContext = useStorageContext();
  const pluginContext = usePluginContext();
  const forcedTheme = props.forcedTheme && THEMES.includes(props.forcedTheme) ? props.forcedTheme : void 0;
  const {
    theme,
    setTheme
  } = useTheme(props.defaultTheme);
  let t3;
  let t4;
  if ($[3] !== forcedTheme || $[4] !== setTheme) {
    t3 = () => {
      if (forcedTheme === "system") {
        setTheme(null);
      } else {
        if (forcedTheme === "light" || forcedTheme === "dark") {
          setTheme(forcedTheme);
        }
      }
    };
    t4 = [forcedTheme, setTheme];
    $[3] = forcedTheme;
    $[4] = setTheme;
    $[5] = t3;
    $[6] = t4;
  } else {
    t3 = $[5];
    t4 = $[6];
  }
  useEffect(t3, t4);
  const PluginContent = (_a = pluginContext == null ? void 0 : pluginContext.visiblePlugin) == null ? void 0 : _a.content;
  const t5 = (pluginContext == null ? void 0 : pluginContext.visiblePlugin) ? void 0 : "first";
  let t6;
  if ($[7] !== pluginContext || $[8] !== t5) {
    t6 = {
      defaultSizeRelation: 0.3333333333333333,
      direction: "horizontal",
      initiallyHidden: t5,
      onHiddenElementChange(resizableElement) {
        if (resizableElement === "first") {
          pluginContext == null ? void 0 : pluginContext.setVisiblePlugin(null);
        }
      },
      sizeThresholdSecond: 200,
      storageKey: "docExplorerFlex"
    };
    $[7] = pluginContext;
    $[8] = t5;
    $[9] = t6;
  } else {
    t6 = $[9];
  }
  const pluginResize = useDragResize(t6);
  let t7;
  if ($[10] === Symbol.for("react.memo_cache_sentinel")) {
    t7 = {
      direction: "horizontal",
      storageKey: "editorFlex"
    };
    $[10] = t7;
  } else {
    t7 = $[10];
  }
  const editorResize = useDragResize(t7);
  let t8;
  bb0: {
    if (props.defaultEditorToolsVisibility === "variables" || props.defaultEditorToolsVisibility === "headers") {
      t8 = void 0;
      break bb0;
    }
    if (typeof props.defaultEditorToolsVisibility === "boolean") {
      t8 = props.defaultEditorToolsVisibility ? void 0 : "second";
      break bb0;
    }
    t8 = editorContext.initialVariables || editorContext.initialHeaders ? void 0 : "second";
  }
  let t9;
  if ($[11] !== t8) {
    t9 = {
      defaultSizeRelation: 3,
      direction: "vertical",
      initiallyHidden: t8,
      sizeThresholdSecond: 60,
      storageKey: "secondaryEditorFlex"
    };
    $[11] = t8;
    $[12] = t9;
  } else {
    t9 = $[12];
  }
  const editorToolsResize = useDragResize(t9);
  let t10;
  if ($[13] !== editorContext.initialHeaders || $[14] !== editorContext.initialVariables || $[15] !== isHeadersEditorEnabled || $[16] !== props.defaultEditorToolsVisibility) {
    t10 = () => {
      if (props.defaultEditorToolsVisibility === "variables" || props.defaultEditorToolsVisibility === "headers") {
        return props.defaultEditorToolsVisibility;
      }
      return !editorContext.initialVariables && editorContext.initialHeaders && isHeadersEditorEnabled ? "headers" : "variables";
    };
    $[13] = editorContext.initialHeaders;
    $[14] = editorContext.initialVariables;
    $[15] = isHeadersEditorEnabled;
    $[16] = props.defaultEditorToolsVisibility;
    $[17] = t10;
  } else {
    t10 = $[17];
  }
  const [activeSecondaryEditor, setActiveSecondaryEditor] = useState(t10);
  const [showDialog, setShowDialog] = useState(null);
  const [clearStorageStatus, setClearStorageStatus] = useState(null);
  let t11;
  if ($[18] !== props.children || $[19] !== props.onCopyQuery || $[20] !== props.onPrettifyQuery) {
    let t122;
    if ($[22] !== props.onCopyQuery || $[23] !== props.onPrettifyQuery) {
      t122 = (acc, curr) => {
        bb94: switch (getChildComponentType(curr)) {
          case GraphiQL.Logo: {
            acc.logo = curr;
            break bb94;
          }
          case GraphiQL.Toolbar: {
            acc.toolbar = cloneElement(curr, {
              onCopyQuery: props.onCopyQuery,
              onPrettifyQuery: props.onPrettifyQuery
            });
            break bb94;
          }
          case GraphiQL.Footer: {
            acc.footer = curr;
          }
        }
        return acc;
      };
      $[22] = props.onCopyQuery;
      $[23] = props.onPrettifyQuery;
      $[24] = t122;
    } else {
      t122 = $[24];
    }
    let t132;
    if ($[25] === Symbol.for("react.memo_cache_sentinel")) {
      t132 = /* @__PURE__ */ jsx(GraphiQL.Logo, {});
      $[25] = t132;
    } else {
      t132 = $[25];
    }
    let t142;
    if ($[26] !== props.onCopyQuery || $[27] !== props.onPrettifyQuery) {
      t142 = /* @__PURE__ */ jsx(GraphiQL.Toolbar, { onCopyQuery: props.onCopyQuery, onPrettifyQuery: props.onPrettifyQuery });
      $[26] = props.onCopyQuery;
      $[27] = props.onPrettifyQuery;
      $[28] = t142;
    } else {
      t142 = $[28];
    }
    t11 = Children.toArray(props.children).reduce(t122, {
      logo: t132,
      toolbar: t142
    });
    $[18] = props.children;
    $[19] = props.onCopyQuery;
    $[20] = props.onPrettifyQuery;
    $[21] = t11;
  } else {
    t11 = $[21];
  }
  const {
    logo,
    toolbar,
    footer
  } = t11;
  let t12;
  if ($[29] !== pluginResize) {
    t12 = () => {
      if (pluginResize.hiddenElement === "first") {
        pluginResize.setHiddenElement(null);
      }
    };
    $[29] = pluginResize;
    $[30] = t12;
  } else {
    t12 = $[30];
  }
  const onClickReference = t12;
  let t13;
  if ($[31] !== storageContext) {
    t13 = () => {
      try {
        if (storageContext) {
          storageContext.clear();
        }
        setClearStorageStatus("success");
      } catch {
        setClearStorageStatus("error");
      }
    };
    $[31] = storageContext;
    $[32] = t13;
  } else {
    t13 = $[32];
  }
  const handleClearData = t13;
  let t14;
  if ($[33] !== editorContext) {
    t14 = (event) => {
      editorContext.setShouldPersistHeaders(event.currentTarget.dataset.value === "true");
    };
    $[33] = editorContext;
    $[34] = t14;
  } else {
    t14 = $[34];
  }
  const handlePersistHeaders = t14;
  let t15;
  if ($[35] !== setTheme) {
    t15 = (event_0) => {
      const selectedTheme = event_0.currentTarget.dataset.theme;
      setTheme(selectedTheme || null);
    };
    $[35] = setTheme;
    $[36] = t15;
  } else {
    t15 = $[36];
  }
  const handleChangeTheme = t15;
  const handleAddTab = editorContext.addTab;
  const handleRefetchSchema = schemaContext.introspect;
  const handleReorder = editorContext.moveTab;
  let t16;
  if ($[37] === Symbol.for("react.memo_cache_sentinel")) {
    t16 = (event_1) => {
      setShowDialog(event_1.currentTarget.dataset.value);
    };
    $[37] = t16;
  } else {
    t16 = $[37];
  }
  const handleShowDialog = t16;
  let t17;
  if ($[38] !== pluginContext || $[39] !== pluginResize) {
    t17 = (event_2) => {
      const context = pluginContext;
      const pluginIndex = Number(event_2.currentTarget.dataset.index);
      const plugin = context.plugins.find((_, index) => pluginIndex === index);
      const isVisible = plugin === context.visiblePlugin;
      if (isVisible) {
        context.setVisiblePlugin(null);
        pluginResize.setHiddenElement("first");
      } else {
        context.setVisiblePlugin(plugin);
        pluginResize.setHiddenElement(null);
      }
    };
    $[38] = pluginContext;
    $[39] = pluginResize;
    $[40] = t17;
  } else {
    t17 = $[40];
  }
  const handlePluginClick = t17;
  let t18;
  if ($[41] !== editorToolsResize) {
    t18 = (event_3) => {
      if (editorToolsResize.hiddenElement === "second") {
        editorToolsResize.setHiddenElement(null);
      }
      setActiveSecondaryEditor(event_3.currentTarget.dataset.name);
    };
    $[41] = editorToolsResize;
    $[42] = t18;
  } else {
    t18 = $[42];
  }
  const handleToolsTabClick = t18;
  let t19;
  if ($[43] !== editorToolsResize) {
    t19 = () => {
      editorToolsResize.setHiddenElement(editorToolsResize.hiddenElement === "second" ? null : "second");
    };
    $[43] = editorToolsResize;
    $[44] = t19;
  } else {
    t19 = $[44];
  }
  const toggleEditorTools = t19;
  let t20;
  if ($[45] === Symbol.for("react.memo_cache_sentinel")) {
    t20 = (isOpen) => {
      if (!isOpen) {
        setShowDialog(null);
      }
    };
    $[45] = t20;
  } else {
    t20 = $[45];
  }
  const handleOpenShortKeysDialog = t20;
  let t21;
  if ($[46] === Symbol.for("react.memo_cache_sentinel")) {
    t21 = (isOpen_0) => {
      if (!isOpen_0) {
        setShowDialog(null);
        setClearStorageStatus(null);
      }
    };
    $[46] = t21;
  } else {
    t21 = $[46];
  }
  const handleOpenSettingsDialog = t21;
  const confirmClose = props.confirmCloseTab;
  let t22;
  if ($[47] !== confirmClose || $[48] !== editorContext || $[49] !== executionContext) {
    t22 = async (event_4) => {
      const tabButton = event_4.currentTarget.previousSibling;
      const index_0 = Number(tabButton.id.replace(TAB_CLASS_PREFIX, ""));
      const shouldCloseTab = confirmClose ? await confirmClose(index_0) : true;
      if (!shouldCloseTab) {
        return;
      }
      if (editorContext.activeTabIndex === index_0) {
        executionContext.stop();
      }
      editorContext.closeTab(index_0);
    };
    $[47] = confirmClose;
    $[48] = editorContext;
    $[49] = executionContext;
    $[50] = t22;
  } else {
    t22 = $[50];
  }
  const handleTabClose = t22;
  let t23;
  if ($[51] !== editorContext || $[52] !== executionContext) {
    t23 = (event_5) => {
      const index_1 = Number(event_5.currentTarget.id.replace(TAB_CLASS_PREFIX, ""));
      executionContext.stop();
      editorContext.changeTab(index_1);
    };
    $[51] = editorContext;
    $[52] = executionContext;
    $[53] = t23;
  } else {
    t23 = $[53];
  }
  const handleTabClick = t23;
  let t24;
  if ($[54] !== props.className) {
    t24 = cn("graphiql-container", props.className);
    $[54] = props.className;
    $[55] = t24;
  } else {
    t24 = $[55];
  }
  let t25;
  if ($[56] !== handlePluginClick || $[57] !== pluginContext) {
    t25 = pluginContext == null ? void 0 : pluginContext.plugins.map((plugin_0, index_2) => {
      const isVisible_0 = plugin_0 === pluginContext.visiblePlugin;
      const label = `${isVisible_0 ? "Hide" : "Show"} ${plugin_0.title}`;
      return /* @__PURE__ */ jsx(Tooltip, { label, children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: cn(isVisible_0 && "active"), onClick: handlePluginClick, "data-index": index_2, "aria-label": label, children: /* @__PURE__ */ jsx(plugin_0.icon, { "aria-hidden": "true" }) }) }, plugin_0.title);
    });
    $[56] = handlePluginClick;
    $[57] = pluginContext;
    $[58] = t25;
  } else {
    t25 = $[58];
  }
  const t26 = schemaContext.isFetching;
  let t27;
  if ($[59] === Symbol.for("react.memo_cache_sentinel")) {
    t27 = {
      marginTop: "auto"
    };
    $[59] = t27;
  } else {
    t27 = $[59];
  }
  const t28 = schemaContext.isFetching && "graphiql-spin";
  let t29;
  if ($[60] !== t28) {
    t29 = cn(t28);
    $[60] = t28;
    $[61] = t29;
  } else {
    t29 = $[61];
  }
  let t30;
  if ($[62] !== t29) {
    t30 = /* @__PURE__ */ jsx(ReloadIcon, { className: t29, "aria-hidden": "true" });
    $[62] = t29;
    $[63] = t30;
  } else {
    t30 = $[63];
  }
  let t31;
  if ($[64] !== handleRefetchSchema || $[65] !== schemaContext.isFetching || $[66] !== t30) {
    t31 = /* @__PURE__ */ jsx(Tooltip, { label: "Re-fetch GraphQL schema", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", disabled: t26, onClick: handleRefetchSchema, "aria-label": "Re-fetch GraphQL schema", style: t27, children: t30 }) });
    $[64] = handleRefetchSchema;
    $[65] = schemaContext.isFetching;
    $[66] = t30;
    $[67] = t31;
  } else {
    t31 = $[67];
  }
  let t32;
  if ($[68] === Symbol.for("react.memo_cache_sentinel")) {
    t32 = /* @__PURE__ */ jsx(Tooltip, { label: "Open short keys dialog", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", "data-value": "short-keys", onClick: handleShowDialog, "aria-label": "Open short keys dialog", children: /* @__PURE__ */ jsx(KeyboardShortcutIcon, { "aria-hidden": "true" }) }) });
    $[68] = t32;
  } else {
    t32 = $[68];
  }
  let t33;
  if ($[69] === Symbol.for("react.memo_cache_sentinel")) {
    t33 = /* @__PURE__ */ jsx(Tooltip, { label: "Open settings dialog", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", "data-value": "settings", onClick: handleShowDialog, "aria-label": "Open settings dialog", children: /* @__PURE__ */ jsx(SettingsIcon, { "aria-hidden": "true" }) }) });
    $[69] = t33;
  } else {
    t33 = $[69];
  }
  let t34;
  if ($[70] !== t25 || $[71] !== t31) {
    t34 = /* @__PURE__ */ jsxs("div", { className: "graphiql-sidebar", children: [
      t25,
      t31,
      t32,
      t33
    ] });
    $[70] = t25;
    $[71] = t31;
    $[72] = t34;
  } else {
    t34 = $[72];
  }
  let t35;
  if ($[73] === Symbol.for("react.memo_cache_sentinel")) {
    t35 = {
      minWidth: "200px"
    };
    $[73] = t35;
  } else {
    t35 = $[73];
  }
  let t36;
  if ($[74] !== PluginContent) {
    t36 = PluginContent ? /* @__PURE__ */ jsx(PluginContent, {}) : null;
    $[74] = PluginContent;
    $[75] = t36;
  } else {
    t36 = $[75];
  }
  let t37;
  if ($[76] !== pluginResize.firstRef || $[77] !== t36) {
    t37 = /* @__PURE__ */ jsx("div", { ref: pluginResize.firstRef, className: "graphiql-plugin", style: t35, children: t36 });
    $[76] = pluginResize.firstRef;
    $[77] = t36;
    $[78] = t37;
  } else {
    t37 = $[78];
  }
  let t38;
  if ($[79] !== (pluginContext == null ? void 0 : pluginContext.visiblePlugin) || $[80] !== pluginResize.dragBarRef) {
    t38 = (pluginContext == null ? void 0 : pluginContext.visiblePlugin) && /* @__PURE__ */ jsx("div", { className: "graphiql-horizontal-drag-bar", ref: pluginResize.dragBarRef });
    $[79] = pluginContext == null ? void 0 : pluginContext.visiblePlugin;
    $[80] = pluginResize.dragBarRef;
    $[81] = t38;
  } else {
    t38 = $[81];
  }
  const t39 = pluginResize.secondRef;
  const t40 = editorContext.tabs;
  let t41;
  if ($[82] !== editorContext.activeTabIndex || $[83] !== editorContext.tabs || $[84] !== handleTabClick || $[85] !== handleTabClose) {
    let t422;
    if ($[87] !== editorContext.activeTabIndex || $[88] !== handleTabClick || $[89] !== handleTabClose) {
      t422 = (tab, index_3, tabs) => /* @__PURE__ */ jsxs(Tab, { value: tab, isActive: index_3 === editorContext.activeTabIndex, children: [
        /* @__PURE__ */ jsx(Tab.Button, { "aria-controls": "graphiql-session", id: `graphiql-session-tab-${index_3}`, title: tab.title, onClick: handleTabClick, children: tab.title }),
        tabs.length > 1 && /* @__PURE__ */ jsx(Tab.Close, { onClick: handleTabClose })
      ] }, tab.id);
      $[87] = editorContext.activeTabIndex;
      $[88] = handleTabClick;
      $[89] = handleTabClose;
      $[90] = t422;
    } else {
      t422 = $[90];
    }
    t41 = editorContext.tabs.map(t422);
    $[82] = editorContext.activeTabIndex;
    $[83] = editorContext.tabs;
    $[84] = handleTabClick;
    $[85] = handleTabClose;
    $[86] = t41;
  } else {
    t41 = $[86];
  }
  let t42;
  if ($[91] !== editorContext.tabs || $[92] !== handleReorder || $[93] !== t41) {
    t42 = /* @__PURE__ */ jsx(Tabs, { values: t40, onReorder: handleReorder, "aria-label": "Select active operation", className: "no-scrollbar", children: t41 });
    $[91] = editorContext.tabs;
    $[92] = handleReorder;
    $[93] = t41;
    $[94] = t42;
  } else {
    t42 = $[94];
  }
  let t43;
  if ($[95] === Symbol.for("react.memo_cache_sentinel")) {
    t43 = /* @__PURE__ */ jsx(PlusIcon, { "aria-hidden": "true" });
    $[95] = t43;
  } else {
    t43 = $[95];
  }
  let t44;
  if ($[96] !== handleAddTab) {
    t44 = /* @__PURE__ */ jsx(Tooltip, { label: "New tab", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: "graphiql-tab-add", onClick: handleAddTab, "aria-label": "New tab", children: t43 }) });
    $[96] = handleAddTab;
    $[97] = t44;
  } else {
    t44 = $[97];
  }
  let t45;
  if ($[98] !== logo || $[99] !== t42 || $[100] !== t44) {
    t45 = /* @__PURE__ */ jsxs("div", { className: "graphiql-session-header", children: [
      t42,
      t44,
      logo
    ] });
    $[98] = logo;
    $[99] = t42;
    $[100] = t44;
    $[101] = t45;
  } else {
    t45 = $[101];
  }
  const t46 = `${TAB_CLASS_PREFIX}${editorContext.activeTabIndex}`;
  const t47 = editorResize.firstRef;
  let t48;
  if ($[102] !== onClickReference || $[103] !== props.editorTheme || $[104] !== props.keyMap || $[105] !== props.onCopyQuery || $[106] !== props.onEditQuery || $[107] !== props.onPrettifyQuery || $[108] !== props.readOnly) {
    t48 = /* @__PURE__ */ jsx(QueryEditor, { editorTheme: props.editorTheme, keyMap: props.keyMap, onClickReference, onCopyQuery: props.onCopyQuery, onPrettifyQuery: props.onPrettifyQuery, onEdit: props.onEditQuery, readOnly: props.readOnly });
    $[102] = onClickReference;
    $[103] = props.editorTheme;
    $[104] = props.keyMap;
    $[105] = props.onCopyQuery;
    $[106] = props.onEditQuery;
    $[107] = props.onPrettifyQuery;
    $[108] = props.readOnly;
    $[109] = t48;
  } else {
    t48 = $[109];
  }
  let t49;
  if ($[110] === Symbol.for("react.memo_cache_sentinel")) {
    t49 = /* @__PURE__ */ jsx(ExecuteButton, {});
    $[110] = t49;
  } else {
    t49 = $[110];
  }
  let t50;
  if ($[111] !== toolbar) {
    t50 = /* @__PURE__ */ jsxs("div", { className: "graphiql-toolbar", role: "toolbar", "aria-label": "Editor Commands", children: [
      t49,
      toolbar
    ] });
    $[111] = toolbar;
    $[112] = t50;
  } else {
    t50 = $[112];
  }
  let t51;
  if ($[113] !== editorToolsResize.firstRef || $[114] !== t48 || $[115] !== t50) {
    t51 = /* @__PURE__ */ jsxs("section", { className: "graphiql-query-editor", "aria-label": "Query Editor", ref: editorToolsResize.firstRef, children: [
      t48,
      t50
    ] });
    $[113] = editorToolsResize.firstRef;
    $[114] = t48;
    $[115] = t50;
    $[116] = t51;
  } else {
    t51 = $[116];
  }
  const t52 = editorToolsResize.dragBarRef;
  const t53 = activeSecondaryEditor === "variables" && editorToolsResize.hiddenElement !== "second" && "active";
  let t54;
  if ($[117] !== t53) {
    t54 = cn(t53);
    $[117] = t53;
    $[118] = t54;
  } else {
    t54 = $[118];
  }
  let t55;
  if ($[119] !== handleToolsTabClick || $[120] !== t54) {
    t55 = /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: t54, onClick: handleToolsTabClick, "data-name": "variables", children: "Variables" });
    $[119] = handleToolsTabClick;
    $[120] = t54;
    $[121] = t55;
  } else {
    t55 = $[121];
  }
  let t56;
  if ($[122] !== activeSecondaryEditor || $[123] !== editorToolsResize.hiddenElement || $[124] !== handleToolsTabClick || $[125] !== isHeadersEditorEnabled) {
    t56 = isHeadersEditorEnabled && /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: cn(activeSecondaryEditor === "headers" && editorToolsResize.hiddenElement !== "second" && "active"), onClick: handleToolsTabClick, "data-name": "headers", children: "Headers" });
    $[122] = activeSecondaryEditor;
    $[123] = editorToolsResize.hiddenElement;
    $[124] = handleToolsTabClick;
    $[125] = isHeadersEditorEnabled;
    $[126] = t56;
  } else {
    t56 = $[126];
  }
  const t57 = editorToolsResize.hiddenElement === "second" ? "Show editor tools" : "Hide editor tools";
  const t58 = editorToolsResize.hiddenElement === "second" ? "Show editor tools" : "Hide editor tools";
  let t59;
  if ($[127] !== editorToolsResize.hiddenElement) {
    t59 = editorToolsResize.hiddenElement === "second" ? /* @__PURE__ */ jsx(ChevronUpIcon, { className: "graphiql-chevron-icon", "aria-hidden": "true" }) : /* @__PURE__ */ jsx(ChevronDownIcon, { className: "graphiql-chevron-icon", "aria-hidden": "true" });
    $[127] = editorToolsResize.hiddenElement;
    $[128] = t59;
  } else {
    t59 = $[128];
  }
  let t60;
  if ($[129] !== t58 || $[130] !== t59 || $[131] !== toggleEditorTools) {
    t60 = /* @__PURE__ */ jsx(UnStyledButton, { type: "button", onClick: toggleEditorTools, "aria-label": t58, className: "graphiql-toggle-editor-tools", children: t59 });
    $[129] = t58;
    $[130] = t59;
    $[131] = toggleEditorTools;
    $[132] = t60;
  } else {
    t60 = $[132];
  }
  let t61;
  if ($[133] !== t57 || $[134] !== t60) {
    t61 = /* @__PURE__ */ jsx(Tooltip, { label: t57, children: t60 });
    $[133] = t57;
    $[134] = t60;
    $[135] = t61;
  } else {
    t61 = $[135];
  }
  let t62;
  if ($[136] !== editorToolsResize.dragBarRef || $[137] !== t55 || $[138] !== t56 || $[139] !== t61) {
    t62 = /* @__PURE__ */ jsxs("div", { ref: t52, className: "graphiql-editor-tools", children: [
      t55,
      t56,
      t61
    ] });
    $[136] = editorToolsResize.dragBarRef;
    $[137] = t55;
    $[138] = t56;
    $[139] = t61;
    $[140] = t62;
  } else {
    t62 = $[140];
  }
  const t63 = activeSecondaryEditor === "variables" ? "Variables" : "Headers";
  const t64 = activeSecondaryEditor !== "variables";
  let t65;
  if ($[141] !== onClickReference || $[142] !== props.editorTheme || $[143] !== props.keyMap || $[144] !== props.onEditVariables || $[145] !== props.readOnly || $[146] !== t64) {
    t65 = /* @__PURE__ */ jsx(VariableEditor, { editorTheme: props.editorTheme, isHidden: t64, keyMap: props.keyMap, onEdit: props.onEditVariables, onClickReference, readOnly: props.readOnly });
    $[141] = onClickReference;
    $[142] = props.editorTheme;
    $[143] = props.keyMap;
    $[144] = props.onEditVariables;
    $[145] = props.readOnly;
    $[146] = t64;
    $[147] = t65;
  } else {
    t65 = $[147];
  }
  let t66;
  if ($[148] !== activeSecondaryEditor || $[149] !== isHeadersEditorEnabled || $[150] !== props.editorTheme || $[151] !== props.keyMap || $[152] !== props.onEditHeaders || $[153] !== props.readOnly) {
    t66 = isHeadersEditorEnabled && /* @__PURE__ */ jsx(HeaderEditor, { editorTheme: props.editorTheme, isHidden: activeSecondaryEditor !== "headers", keyMap: props.keyMap, onEdit: props.onEditHeaders, readOnly: props.readOnly });
    $[148] = activeSecondaryEditor;
    $[149] = isHeadersEditorEnabled;
    $[150] = props.editorTheme;
    $[151] = props.keyMap;
    $[152] = props.onEditHeaders;
    $[153] = props.readOnly;
    $[154] = t66;
  } else {
    t66 = $[154];
  }
  let t67;
  if ($[155] !== editorToolsResize.secondRef || $[156] !== t63 || $[157] !== t65 || $[158] !== t66) {
    t67 = /* @__PURE__ */ jsxs("section", { className: "graphiql-editor-tool", "aria-label": t63, ref: editorToolsResize.secondRef, children: [
      t65,
      t66
    ] });
    $[155] = editorToolsResize.secondRef;
    $[156] = t63;
    $[157] = t65;
    $[158] = t66;
    $[159] = t67;
  } else {
    t67 = $[159];
  }
  let t68;
  if ($[160] !== editorResize.firstRef || $[161] !== t51 || $[162] !== t62 || $[163] !== t67) {
    t68 = /* @__PURE__ */ jsxs("div", { className: "graphiql-editors", ref: t47, children: [
      t51,
      t62,
      t67
    ] });
    $[160] = editorResize.firstRef;
    $[161] = t51;
    $[162] = t62;
    $[163] = t67;
    $[164] = t68;
  } else {
    t68 = $[164];
  }
  let t69;
  if ($[165] !== editorResize.dragBarRef) {
    t69 = /* @__PURE__ */ jsx("div", { className: "graphiql-horizontal-drag-bar", ref: editorResize.dragBarRef });
    $[165] = editorResize.dragBarRef;
    $[166] = t69;
  } else {
    t69 = $[166];
  }
  let t70;
  if ($[167] !== executionContext.isFetching) {
    t70 = executionContext.isFetching ? /* @__PURE__ */ jsx(Spinner, {}) : null;
    $[167] = executionContext.isFetching;
    $[168] = t70;
  } else {
    t70 = $[168];
  }
  let t71;
  if ($[169] !== props.editorTheme || $[170] !== props.keyMap || $[171] !== props.responseTooltip) {
    t71 = /* @__PURE__ */ jsx(ResponseEditor, { editorTheme: props.editorTheme, responseTooltip: props.responseTooltip, keyMap: props.keyMap });
    $[169] = props.editorTheme;
    $[170] = props.keyMap;
    $[171] = props.responseTooltip;
    $[172] = t71;
  } else {
    t71 = $[172];
  }
  let t72;
  if ($[173] !== editorResize.secondRef || $[174] !== footer || $[175] !== t70 || $[176] !== t71) {
    t72 = /* @__PURE__ */ jsxs("div", { className: "graphiql-response", ref: editorResize.secondRef, children: [
      t70,
      t71,
      footer
    ] });
    $[173] = editorResize.secondRef;
    $[174] = footer;
    $[175] = t70;
    $[176] = t71;
    $[177] = t72;
  } else {
    t72 = $[177];
  }
  let t73;
  if ($[178] !== t46 || $[179] !== t68 || $[180] !== t69 || $[181] !== t72) {
    t73 = /* @__PURE__ */ jsxs("div", { role: "tabpanel", id: "graphiql-session", "aria-labelledby": t46, children: [
      t68,
      t69,
      t72
    ] });
    $[178] = t46;
    $[179] = t68;
    $[180] = t69;
    $[181] = t72;
    $[182] = t73;
  } else {
    t73 = $[182];
  }
  let t74;
  if ($[183] !== pluginResize.secondRef || $[184] !== t45 || $[185] !== t73) {
    t74 = /* @__PURE__ */ jsxs("div", { ref: t39, className: "graphiql-sessions", children: [
      t45,
      t73
    ] });
    $[183] = pluginResize.secondRef;
    $[184] = t45;
    $[185] = t73;
    $[186] = t74;
  } else {
    t74 = $[186];
  }
  let t75;
  if ($[187] !== t37 || $[188] !== t38 || $[189] !== t74) {
    t75 = /* @__PURE__ */ jsxs("div", { className: "graphiql-main", children: [
      t37,
      t38,
      t74
    ] });
    $[187] = t37;
    $[188] = t38;
    $[189] = t74;
    $[190] = t75;
  } else {
    t75 = $[190];
  }
  const t76 = showDialog === "short-keys";
  let t77;
  if ($[191] === Symbol.for("react.memo_cache_sentinel")) {
    t77 = /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-header", children: [
      /* @__PURE__ */ jsx(Dialog.Title, { className: "graphiql-dialog-title", children: "Short Keys" }),
      /* @__PURE__ */ jsx(Dialog.Close, {})
    ] });
    $[191] = t77;
  } else {
    t77 = $[191];
  }
  let t78;
  if ($[192] !== props.keyMap) {
    t78 = /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section", children: /* @__PURE__ */ jsx(ShortKeys, { keyMap: props.keyMap }) });
    $[192] = props.keyMap;
    $[193] = t78;
  } else {
    t78 = $[193];
  }
  let t79;
  if ($[194] !== t76 || $[195] !== t78) {
    t79 = /* @__PURE__ */ jsxs(Dialog, { open: t76, onOpenChange: handleOpenShortKeysDialog, children: [
      t77,
      t78
    ] });
    $[194] = t76;
    $[195] = t78;
    $[196] = t79;
  } else {
    t79 = $[196];
  }
  const t80 = showDialog === "settings";
  let t81;
  if ($[197] === Symbol.for("react.memo_cache_sentinel")) {
    t81 = /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-header", children: [
      /* @__PURE__ */ jsx(Dialog.Title, { className: "graphiql-dialog-title", children: "Settings" }),
      /* @__PURE__ */ jsx(Dialog.Close, {})
    ] });
    $[197] = t81;
  } else {
    t81 = $[197];
  }
  let t82;
  if ($[198] !== editorContext.shouldPersistHeaders || $[199] !== handlePersistHeaders || $[200] !== props.showPersistHeadersSettings) {
    t82 = props.showPersistHeadersSettings ? /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-title", children: "Persist headers" }),
        /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section-caption", children: [
          "Save headers upon reloading.",
          " ",
          /* @__PURE__ */ jsx("span", { className: "graphiql-warning-text", children: "Only enable if you trust this device." })
        ] })
      ] }),
      /* @__PURE__ */ jsxs(ButtonGroup, { children: [
        /* @__PURE__ */ jsx(Button, { type: "button", id: "enable-persist-headers", className: cn(editorContext.shouldPersistHeaders && "active"), "data-value": "true", onClick: handlePersistHeaders, children: "On" }),
        /* @__PURE__ */ jsx(Button, { type: "button", id: "disable-persist-headers", className: cn(!editorContext.shouldPersistHeaders && "active"), onClick: handlePersistHeaders, children: "Off" })
      ] })
    ] }) : null;
    $[198] = editorContext.shouldPersistHeaders;
    $[199] = handlePersistHeaders;
    $[200] = props.showPersistHeadersSettings;
    $[201] = t82;
  } else {
    t82 = $[201];
  }
  let t83;
  if ($[202] !== forcedTheme || $[203] !== handleChangeTheme || $[204] !== theme) {
    t83 = !forcedTheme && /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-title", children: "Theme" }),
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-caption", children: "Adjust how the interface appears." })
      ] }),
      /* @__PURE__ */ jsxs(ButtonGroup, { children: [
        /* @__PURE__ */ jsx(Button, { type: "button", className: cn(theme === null && "active"), onClick: handleChangeTheme, children: "System" }),
        /* @__PURE__ */ jsx(Button, { type: "button", className: cn(theme === "light" && "active"), "data-theme": "light", onClick: handleChangeTheme, children: "Light" }),
        /* @__PURE__ */ jsx(Button, { type: "button", className: cn(theme === "dark" && "active"), "data-theme": "dark", onClick: handleChangeTheme, children: "Dark" })
      ] })
    ] });
    $[202] = forcedTheme;
    $[203] = handleChangeTheme;
    $[204] = theme;
    $[205] = t83;
  } else {
    t83 = $[205];
  }
  let t84;
  if ($[206] !== clearStorageStatus || $[207] !== handleClearData || $[208] !== storageContext) {
    t84 = storageContext ? /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-title", children: "Clear storage" }),
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-caption", children: "Remove all locally stored data and start fresh." })
      ] }),
      /* @__PURE__ */ jsx(Button, { type: "button", state: clearStorageStatus || void 0, disabled: clearStorageStatus === "success", onClick: handleClearData, children: {
        success: "Cleared data",
        error: "Failed"
      }[clearStorageStatus] || "Clear data" })
    ] }) : null;
    $[206] = clearStorageStatus;
    $[207] = handleClearData;
    $[208] = storageContext;
    $[209] = t84;
  } else {
    t84 = $[209];
  }
  let t85;
  if ($[210] !== t80 || $[211] !== t82 || $[212] !== t83 || $[213] !== t84) {
    t85 = /* @__PURE__ */ jsxs(Dialog, { open: t80, onOpenChange: handleOpenSettingsDialog, children: [
      t81,
      t82,
      t83,
      t84
    ] });
    $[210] = t80;
    $[211] = t82;
    $[212] = t83;
    $[213] = t84;
    $[214] = t85;
  } else {
    t85 = $[214];
  }
  let t86;
  if ($[215] !== t24 || $[216] !== t34 || $[217] !== t75 || $[218] !== t79 || $[219] !== t85) {
    t86 = /* @__PURE__ */ jsx(Tooltip.Provider, { children: /* @__PURE__ */ jsxs("div", { className: t24, children: [
      t34,
      t75,
      t79,
      t85
    ] }) });
    $[215] = t24;
    $[216] = t34;
    $[217] = t75;
    $[218] = t79;
    $[219] = t85;
    $[220] = t86;
  } else {
    t86 = $[220];
  }
  return t86;
};
const modifier = isMacOs ? "⌘" : "Ctrl";
const SHORT_KEYS = Object.entries({
  "Search in editor": [modifier, "F"],
  "Search in documentation": [modifier, "K"],
  "Execute query": [modifier, "Enter"],
  "Prettify editors": ["Ctrl", "Shift", "P"],
  "Merge fragments definitions into operation definition": ["Ctrl", "Shift", "M"],
  "Copy query": ["Ctrl", "Shift", "C"],
  "Re-fetch schema using introspection": ["Ctrl", "Shift", "R"]
});
const ShortKeys = (t0) => {
  const $ = c(5);
  const {
    keyMap: t1
  } = t0;
  const keyMap = t1 === void 0 ? "sublime" : t1;
  let t2;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t2 = /* @__PURE__ */ jsxs("table", { className: "graphiql-table", children: [
      /* @__PURE__ */ jsx("thead", { children: /* @__PURE__ */ jsxs("tr", { children: [
        /* @__PURE__ */ jsx("th", { children: "Short Key" }),
        /* @__PURE__ */ jsx("th", { children: "Function" })
      ] }) }),
      /* @__PURE__ */ jsx("tbody", { children: SHORT_KEYS.map(_temp2) })
    ] });
    $[0] = t2;
  } else {
    t2 = $[0];
  }
  let t3;
  if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
    t3 = /* @__PURE__ */ jsx("a", { href: "https://codemirror.net/5/doc/manual.html#keymaps", target: "_blank", rel: "noopener noreferrer", children: "CodeMirror Key Maps" });
    $[1] = t3;
  } else {
    t3 = $[1];
  }
  let t4;
  if ($[2] === Symbol.for("react.memo_cache_sentinel")) {
    t4 = /* @__PURE__ */ jsx("em", { children: "i" });
    $[2] = t4;
  } else {
    t4 = $[2];
  }
  let t5;
  if ($[3] !== keyMap) {
    t5 = /* @__PURE__ */ jsxs("div", { children: [
      t2,
      /* @__PURE__ */ jsxs("p", { children: [
        "The editors use",
        " ",
        t3,
        " ",
        "that add more short keys. This instance of Graph",
        t4,
        "QL uses",
        " ",
        /* @__PURE__ */ jsx("code", { children: keyMap }),
        "."
      ] })
    ] });
    $[3] = keyMap;
    $[4] = t5;
  } else {
    t5 = $[4];
  }
  return t5;
};
const defaultGraphiqlLogo = /* @__PURE__ */ jsxs("a", { className: "graphiql-logo-link", href: "https://github.com/graphql/graphiql", target: "_blank", rel: "noreferrer", children: [
  "Graph",
  /* @__PURE__ */ jsx("em", { children: "i" }),
  "QL"
] });
const GraphiQLLogo = (t0) => {
  const $ = c(2);
  const {
    children: t1
  } = t0;
  const children = t1 === void 0 ? defaultGraphiqlLogo : t1;
  let t2;
  if ($[0] !== children) {
    t2 = /* @__PURE__ */ jsx("div", { className: "graphiql-logo", children });
    $[0] = children;
    $[1] = t2;
  } else {
    t2 = $[1];
  }
  return t2;
};
const DefaultToolbarRenderProps = (t0) => {
  const $ = c(4);
  const {
    prettify,
    copy,
    merge
  } = t0;
  let t1;
  if ($[0] !== copy || $[1] !== merge || $[2] !== prettify) {
    t1 = /* @__PURE__ */ jsxs(Fragment$1, { children: [
      prettify,
      merge,
      copy
    ] });
    $[0] = copy;
    $[1] = merge;
    $[2] = prettify;
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  return t1;
};
const GraphiQLToolbar = ({
  children = DefaultToolbarRenderProps,
  // @ts-expect-error -- Hide this prop for user, we use cloneElement to pass onCopyQuery
  onCopyQuery,
  // @ts-expect-error -- Hide this prop for user, we use cloneElement to pass onPrettifyQuery
  onPrettifyQuery
}) => {
  "use no memo";
  if (typeof children !== "function") {
    throw new TypeError("The `GraphiQL.Toolbar` component requires a render prop function as its child.");
  }
  const onCopy = useCopyQuery({
    onCopyQuery
  });
  const onMerge = useMergeQuery();
  const onPrettify = usePrettifyEditors({
    onPrettifyQuery
  });
  const prettify = /* @__PURE__ */ jsx(ToolbarButton, { onClick: onPrettify, label: "Prettify query (Shift-Ctrl-P)", children: /* @__PURE__ */ jsx(PrettifyIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" }) });
  const merge = /* @__PURE__ */ jsx(ToolbarButton, { onClick: onMerge, label: "Merge fragments into query (Shift-Ctrl-M)", children: /* @__PURE__ */ jsx(MergeIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" }) });
  const copy = /* @__PURE__ */ jsx(ToolbarButton, { onClick: onCopy, label: "Copy query (Shift-Ctrl-C)", children: /* @__PURE__ */ jsx(CopyIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" }) });
  return children({
    prettify,
    copy,
    merge
  });
};
const GraphiQLFooter = (props) => {
  const $ = c(2);
  let t0;
  if ($[0] !== props.children) {
    t0 = /* @__PURE__ */ jsx("div", { className: "graphiql-footer", children: props.children });
    $[0] = props.children;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  return t0;
};
function getChildComponentType(child) {
  if (child && typeof child === "object" && "type" in child && typeof child.type === "function") {
    return child.type;
  }
}
const GraphiQL = Object.assign(GraphiQL_, {
  Logo: GraphiQLLogo,
  Toolbar: GraphiQLToolbar,
  Footer: GraphiQLFooter
});
function _temp(key, index, array) {
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx("code", { className: "graphiql-key", children: key }),
    index !== array.length - 1 && " + "
  ] }, key);
}
function _temp2(t0) {
  const [title, keys] = t0;
  return /* @__PURE__ */ jsxs("tr", { children: [
    /* @__PURE__ */ jsx("td", { children: keys.map(_temp) }),
    /* @__PURE__ */ jsx("td", { children: title })
  ] }, title);
}
export {
  GraphiQL,
  GraphiQLInterface
};
//# sourceMappingURL=GraphiQL.js.map
