import { jsx, jsxs, Fragment as Fragment$1 } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { useEffect, useState, Children, Fragment, cloneElement } from "react";
import { useEditorContext, useExecutionContext, useSchemaStore, useStorage, usePluginStore, useTheme, useDragResize, cn, QueryEditor, UnStyledButton, ChevronUpIcon, ChevronDownIcon, VariableEditor, HeaderEditor, Spinner, ResponseEditor, Dialog, ButtonGroup, Button, Tooltip, GraphiQLProvider, useCopyQuery, useMergeQuery, usePrettifyEditors, ToolbarButton, MergeIcon, CopyIcon, PrettifyIcon, isMacOs, ReloadIcon, KeyboardShortcutIcon, SettingsIcon, Tab, Tabs, PlusIcon, ExecuteButton } from "@graphiql/react";
import { HISTORY_PLUGIN, HistoryContextProvider } from "@graphiql/plugin-history";
import { DOC_EXPLORER_PLUGIN, DocExplorerContextProvider } from "@graphiql/plugin-doc-explorer";
const GraphiQL_ = (t0) => {
  var _a, _b;
  const $ = c(72);
  let confirmCloseTab;
  let dangerouslyAssumeSchemaIsValid;
  let defaultHeaders;
  let defaultQuery;
  let defaultTabs;
  let externalFragments;
  let fetcher;
  let getDefaultFieldNames;
  let headers;
  let inputValueDeprecation;
  let introspectionQueryName;
  let maxHistoryLength;
  let onEditOperationName;
  let onSchemaChange;
  let onTabChange;
  let onTogglePluginVisibility;
  let operationName;
  let props;
  let query;
  let response;
  let schema;
  let schemaDescription;
  let shouldPersistHeaders;
  let storage;
  let t1;
  let t2;
  let validationRules;
  let variables;
  let visiblePlugin;
  if ($[0] !== t0) {
    ({
      dangerouslyAssumeSchemaIsValid,
      confirmCloseTab,
      defaultQuery,
      defaultTabs,
      externalFragments,
      fetcher,
      getDefaultFieldNames,
      headers,
      inputValueDeprecation,
      introspectionQueryName,
      maxHistoryLength,
      onEditOperationName,
      onSchemaChange,
      onTabChange,
      onTogglePluginVisibility,
      operationName,
      plugins: t1,
      referencePlugin: t2,
      query,
      response,
      schema,
      schemaDescription,
      shouldPersistHeaders,
      storage,
      validationRules,
      variables,
      visiblePlugin,
      defaultHeaders,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = confirmCloseTab;
    $[2] = dangerouslyAssumeSchemaIsValid;
    $[3] = defaultHeaders;
    $[4] = defaultQuery;
    $[5] = defaultTabs;
    $[6] = externalFragments;
    $[7] = fetcher;
    $[8] = getDefaultFieldNames;
    $[9] = headers;
    $[10] = inputValueDeprecation;
    $[11] = introspectionQueryName;
    $[12] = maxHistoryLength;
    $[13] = onEditOperationName;
    $[14] = onSchemaChange;
    $[15] = onTabChange;
    $[16] = onTogglePluginVisibility;
    $[17] = operationName;
    $[18] = props;
    $[19] = query;
    $[20] = response;
    $[21] = schema;
    $[22] = schemaDescription;
    $[23] = shouldPersistHeaders;
    $[24] = storage;
    $[25] = t1;
    $[26] = t2;
    $[27] = validationRules;
    $[28] = variables;
    $[29] = visiblePlugin;
  } else {
    confirmCloseTab = $[1];
    dangerouslyAssumeSchemaIsValid = $[2];
    defaultHeaders = $[3];
    defaultQuery = $[4];
    defaultTabs = $[5];
    externalFragments = $[6];
    fetcher = $[7];
    getDefaultFieldNames = $[8];
    headers = $[9];
    inputValueDeprecation = $[10];
    introspectionQueryName = $[11];
    maxHistoryLength = $[12];
    onEditOperationName = $[13];
    onSchemaChange = $[14];
    onTabChange = $[15];
    onTogglePluginVisibility = $[16];
    operationName = $[17];
    props = $[18];
    query = $[19];
    response = $[20];
    schema = $[21];
    schemaDescription = $[22];
    shouldPersistHeaders = $[23];
    storage = $[24];
    t1 = $[25];
    t2 = $[26];
    validationRules = $[27];
    variables = $[28];
    visiblePlugin = $[29];
  }
  let t3;
  if ($[30] !== t1) {
    t3 = t1 === void 0 ? [] : t1;
    $[30] = t1;
    $[31] = t3;
  } else {
    t3 = $[31];
  }
  const plugins = t3;
  const referencePlugin = t2 === void 0 ? DOC_EXPLORER_PLUGIN : t2;
  if ((_a = props.toolbar) == null ? void 0 : _a.additionalContent) {
    throw new TypeError("`toolbar.additionalContent` was removed. Use render props on `GraphiQL.Toolbar` component instead.");
  }
  if ((_b = props.toolbar) == null ? void 0 : _b.additionalComponent) {
    throw new TypeError("`toolbar.additionalComponent` was removed. Use render props on `GraphiQL.Toolbar` component instead.");
  }
  let t4;
  if ($[32] !== plugins || $[33] !== referencePlugin) {
    t4 = [referencePlugin, HISTORY_PLUGIN, ...plugins];
    $[32] = plugins;
    $[33] = referencePlugin;
    $[34] = t4;
  } else {
    t4 = $[34];
  }
  let t5;
  if ($[35] !== dangerouslyAssumeSchemaIsValid || $[36] !== defaultHeaders || $[37] !== defaultQuery || $[38] !== defaultTabs || $[39] !== externalFragments || $[40] !== fetcher || $[41] !== getDefaultFieldNames || $[42] !== headers || $[43] !== inputValueDeprecation || $[44] !== introspectionQueryName || $[45] !== onEditOperationName || $[46] !== onSchemaChange || $[47] !== onTabChange || $[48] !== onTogglePluginVisibility || $[49] !== operationName || $[50] !== query || $[51] !== referencePlugin || $[52] !== response || $[53] !== schema || $[54] !== schemaDescription || $[55] !== shouldPersistHeaders || $[56] !== storage || $[57] !== t4 || $[58] !== validationRules || $[59] !== variables || $[60] !== visiblePlugin) {
    t5 = {
      getDefaultFieldNames,
      dangerouslyAssumeSchemaIsValid,
      defaultQuery,
      defaultHeaders,
      defaultTabs,
      externalFragments,
      fetcher,
      headers,
      inputValueDeprecation,
      introspectionQueryName,
      onEditOperationName,
      onSchemaChange,
      onTabChange,
      onTogglePluginVisibility,
      plugins: t4,
      referencePlugin,
      visiblePlugin,
      operationName,
      query,
      response,
      schema,
      schemaDescription,
      shouldPersistHeaders,
      storage,
      validationRules,
      variables
    };
    $[35] = dangerouslyAssumeSchemaIsValid;
    $[36] = defaultHeaders;
    $[37] = defaultQuery;
    $[38] = defaultTabs;
    $[39] = externalFragments;
    $[40] = fetcher;
    $[41] = getDefaultFieldNames;
    $[42] = headers;
    $[43] = inputValueDeprecation;
    $[44] = introspectionQueryName;
    $[45] = onEditOperationName;
    $[46] = onSchemaChange;
    $[47] = onTabChange;
    $[48] = onTogglePluginVisibility;
    $[49] = operationName;
    $[50] = query;
    $[51] = referencePlugin;
    $[52] = response;
    $[53] = schema;
    $[54] = schemaDescription;
    $[55] = shouldPersistHeaders;
    $[56] = storage;
    $[57] = t4;
    $[58] = validationRules;
    $[59] = variables;
    $[60] = visiblePlugin;
    $[61] = t5;
  } else {
    t5 = $[61];
  }
  const graphiqlProps = t5;
  const t6 = shouldPersistHeaders !== false;
  let t7;
  if ($[62] !== confirmCloseTab || $[63] !== props || $[64] !== t6) {
    t7 = /* @__PURE__ */ jsx(DocExplorerContextProvider, { children: /* @__PURE__ */ jsx(GraphiQLInterface, { confirmCloseTab, showPersistHeadersSettings: t6, forcedTheme: props.forcedTheme, ...props }) });
    $[62] = confirmCloseTab;
    $[63] = props;
    $[64] = t6;
    $[65] = t7;
  } else {
    t7 = $[65];
  }
  let t8;
  if ($[66] !== maxHistoryLength || $[67] !== t7) {
    t8 = /* @__PURE__ */ jsx(HistoryContextProvider, { maxHistoryLength, children: t7 });
    $[66] = maxHistoryLength;
    $[67] = t7;
    $[68] = t8;
  } else {
    t8 = $[68];
  }
  let t9;
  if ($[69] !== graphiqlProps || $[70] !== t8) {
    t9 = /* @__PURE__ */ jsx(GraphiQLProvider, { ...graphiqlProps, children: t8 });
    $[69] = graphiqlProps;
    $[70] = t8;
    $[71] = t9;
  } else {
    t9 = $[71];
  }
  return t9;
};
const THEMES = ["light", "dark", "system"];
const TAB_CLASS_PREFIX = "graphiql-session-tab-";
const GraphiQLInterface = (props) => {
  const $ = c(231);
  const isHeadersEditorEnabled = props.isHeadersEditorEnabled ?? true;
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = {
      nonNull: true
    };
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const {
    initialVariables,
    initialHeaders,
    setShouldPersistHeaders,
    addTab,
    moveTab,
    closeTab,
    changeTab,
    shouldPersistHeaders,
    tabs,
    activeTabIndex
  } = useEditorContext(t0);
  let t1;
  if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = {
      nonNull: true
    };
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const executionContext = useExecutionContext(t1);
  const {
    isFetching: isSchemaFetching,
    introspect
  } = useSchemaStore();
  const storageContext = useStorage();
  const {
    visiblePlugin,
    setVisiblePlugin,
    plugins
  } = usePluginStore();
  const forcedTheme = props.forcedTheme && THEMES.includes(props.forcedTheme) ? props.forcedTheme : void 0;
  const {
    theme,
    setTheme
  } = useTheme(props.defaultTheme);
  let t2;
  let t3;
  if ($[2] !== forcedTheme || $[3] !== setTheme) {
    t2 = () => {
      if (forcedTheme === "system") {
        setTheme(null);
      } else {
        if (forcedTheme === "light" || forcedTheme === "dark") {
          setTheme(forcedTheme);
        }
      }
    };
    t3 = [forcedTheme, setTheme];
    $[2] = forcedTheme;
    $[3] = setTheme;
    $[4] = t2;
    $[5] = t3;
  } else {
    t2 = $[4];
    t3 = $[5];
  }
  useEffect(t2, t3);
  const PluginContent = visiblePlugin == null ? void 0 : visiblePlugin.content;
  const t4 = visiblePlugin ? void 0 : "first";
  let t5;
  if ($[6] !== setVisiblePlugin || $[7] !== t4) {
    t5 = {
      defaultSizeRelation: 0.3333333333333333,
      direction: "horizontal",
      initiallyHidden: t4,
      onHiddenElementChange(resizableElement) {
        if (resizableElement === "first") {
          setVisiblePlugin(null);
        }
      },
      sizeThresholdSecond: 200,
      storageKey: "docExplorerFlex"
    };
    $[6] = setVisiblePlugin;
    $[7] = t4;
    $[8] = t5;
  } else {
    t5 = $[8];
  }
  const pluginResize = useDragResize(t5);
  let t6;
  if ($[9] === Symbol.for("react.memo_cache_sentinel")) {
    t6 = {
      direction: "horizontal",
      storageKey: "editorFlex"
    };
    $[9] = t6;
  } else {
    t6 = $[9];
  }
  const editorResize = useDragResize(t6);
  let t7;
  bb0: {
    if (props.defaultEditorToolsVisibility === "variables" || props.defaultEditorToolsVisibility === "headers") {
      t7 = void 0;
      break bb0;
    }
    if (typeof props.defaultEditorToolsVisibility === "boolean") {
      t7 = props.defaultEditorToolsVisibility ? void 0 : "second";
      break bb0;
    }
    t7 = initialVariables || initialHeaders ? void 0 : "second";
  }
  let t8;
  if ($[10] !== t7) {
    t8 = {
      defaultSizeRelation: 3,
      direction: "vertical",
      initiallyHidden: t7,
      sizeThresholdSecond: 60,
      storageKey: "secondaryEditorFlex"
    };
    $[10] = t7;
    $[11] = t8;
  } else {
    t8 = $[11];
  }
  const editorToolsResize = useDragResize(t8);
  let t9;
  if ($[12] !== initialHeaders || $[13] !== initialVariables || $[14] !== isHeadersEditorEnabled || $[15] !== props.defaultEditorToolsVisibility) {
    t9 = () => {
      if (props.defaultEditorToolsVisibility === "variables" || props.defaultEditorToolsVisibility === "headers") {
        return props.defaultEditorToolsVisibility;
      }
      return !initialVariables && initialHeaders && isHeadersEditorEnabled ? "headers" : "variables";
    };
    $[12] = initialHeaders;
    $[13] = initialVariables;
    $[14] = isHeadersEditorEnabled;
    $[15] = props.defaultEditorToolsVisibility;
    $[16] = t9;
  } else {
    t9 = $[16];
  }
  const [activeSecondaryEditor, setActiveSecondaryEditor] = useState(t9);
  const [showDialog, setShowDialog] = useState(null);
  const [clearStorageStatus, setClearStorageStatus] = useState(null);
  let t10;
  if ($[17] !== props.children || $[18] !== props.onCopyQuery || $[19] !== props.onPrettifyQuery) {
    let t112;
    if ($[21] !== props.onCopyQuery || $[22] !== props.onPrettifyQuery) {
      t112 = (acc, curr) => {
        bb80: switch (getChildComponentType(curr)) {
          case GraphiQL.Logo: {
            acc.logo = curr;
            break bb80;
          }
          case GraphiQL.Toolbar: {
            acc.toolbar = cloneElement(curr, {
              onCopyQuery: props.onCopyQuery,
              onPrettifyQuery: props.onPrettifyQuery
            });
            break bb80;
          }
          case GraphiQL.Footer: {
            acc.footer = curr;
          }
        }
        return acc;
      };
      $[21] = props.onCopyQuery;
      $[22] = props.onPrettifyQuery;
      $[23] = t112;
    } else {
      t112 = $[23];
    }
    let t122;
    if ($[24] === Symbol.for("react.memo_cache_sentinel")) {
      t122 = /* @__PURE__ */ jsx(GraphiQL.Logo, {});
      $[24] = t122;
    } else {
      t122 = $[24];
    }
    let t132;
    if ($[25] !== props.onCopyQuery || $[26] !== props.onPrettifyQuery) {
      t132 = /* @__PURE__ */ jsx(GraphiQL.Toolbar, { onCopyQuery: props.onCopyQuery, onPrettifyQuery: props.onPrettifyQuery });
      $[25] = props.onCopyQuery;
      $[26] = props.onPrettifyQuery;
      $[27] = t132;
    } else {
      t132 = $[27];
    }
    t10 = Children.toArray(props.children).reduce(t112, {
      logo: t122,
      toolbar: t132
    });
    $[17] = props.children;
    $[18] = props.onCopyQuery;
    $[19] = props.onPrettifyQuery;
    $[20] = t10;
  } else {
    t10 = $[20];
  }
  const {
    logo,
    toolbar,
    footer
  } = t10;
  let t11;
  if ($[28] !== pluginResize) {
    t11 = () => {
      if (pluginResize.hiddenElement === "first") {
        pluginResize.setHiddenElement(null);
      }
    };
    $[28] = pluginResize;
    $[29] = t11;
  } else {
    t11 = $[29];
  }
  const onClickReference = t11;
  let t12;
  if ($[30] !== storageContext) {
    t12 = () => {
      try {
        storageContext.clear();
        setClearStorageStatus("success");
      } catch {
        setClearStorageStatus("error");
      }
    };
    $[30] = storageContext;
    $[31] = t12;
  } else {
    t12 = $[31];
  }
  const handleClearData = t12;
  let t13;
  if ($[32] !== setShouldPersistHeaders) {
    t13 = (event) => {
      setShouldPersistHeaders(event.currentTarget.dataset.value === "true");
    };
    $[32] = setShouldPersistHeaders;
    $[33] = t13;
  } else {
    t13 = $[33];
  }
  const handlePersistHeaders = t13;
  let t14;
  if ($[34] !== setTheme) {
    t14 = (event_0) => {
      const selectedTheme = event_0.currentTarget.dataset.theme;
      setTheme(selectedTheme || null);
    };
    $[34] = setTheme;
    $[35] = t14;
  } else {
    t14 = $[35];
  }
  const handleChangeTheme = t14;
  let t15;
  if ($[36] === Symbol.for("react.memo_cache_sentinel")) {
    t15 = (event_1) => {
      setShowDialog(event_1.currentTarget.dataset.value);
    };
    $[36] = t15;
  } else {
    t15 = $[36];
  }
  const handleShowDialog = t15;
  let t16;
  if ($[37] !== pluginResize || $[38] !== plugins || $[39] !== setVisiblePlugin || $[40] !== visiblePlugin) {
    t16 = (event_2) => {
      const pluginIndex = Number(event_2.currentTarget.dataset.index);
      const plugin = plugins.find((_, index) => pluginIndex === index);
      const isVisible = plugin === visiblePlugin;
      if (isVisible) {
        setVisiblePlugin(null);
        pluginResize.setHiddenElement("first");
      } else {
        setVisiblePlugin(plugin);
        pluginResize.setHiddenElement(null);
      }
    };
    $[37] = pluginResize;
    $[38] = plugins;
    $[39] = setVisiblePlugin;
    $[40] = visiblePlugin;
    $[41] = t16;
  } else {
    t16 = $[41];
  }
  const handlePluginClick = t16;
  let t17;
  if ($[42] !== editorToolsResize) {
    t17 = (event_3) => {
      if (editorToolsResize.hiddenElement === "second") {
        editorToolsResize.setHiddenElement(null);
      }
      setActiveSecondaryEditor(event_3.currentTarget.dataset.name);
    };
    $[42] = editorToolsResize;
    $[43] = t17;
  } else {
    t17 = $[43];
  }
  const handleToolsTabClick = t17;
  let t18;
  if ($[44] !== editorToolsResize) {
    t18 = () => {
      editorToolsResize.setHiddenElement(editorToolsResize.hiddenElement === "second" ? null : "second");
    };
    $[44] = editorToolsResize;
    $[45] = t18;
  } else {
    t18 = $[45];
  }
  const toggleEditorTools = t18;
  let t19;
  if ($[46] === Symbol.for("react.memo_cache_sentinel")) {
    t19 = (isOpen) => {
      if (!isOpen) {
        setShowDialog(null);
      }
    };
    $[46] = t19;
  } else {
    t19 = $[46];
  }
  const handleOpenShortKeysDialog = t19;
  let t20;
  if ($[47] === Symbol.for("react.memo_cache_sentinel")) {
    t20 = (isOpen_0) => {
      if (!isOpen_0) {
        setShowDialog(null);
        setClearStorageStatus(null);
      }
    };
    $[47] = t20;
  } else {
    t20 = $[47];
  }
  const handleOpenSettingsDialog = t20;
  const confirmClose = props.confirmCloseTab;
  let t21;
  if ($[48] !== activeTabIndex || $[49] !== closeTab || $[50] !== confirmClose || $[51] !== executionContext) {
    t21 = async (event_4) => {
      const tabButton = event_4.currentTarget.previousSibling;
      const index_0 = Number(tabButton.id.replace(TAB_CLASS_PREFIX, ""));
      const shouldCloseTab = confirmClose ? await confirmClose(index_0) : true;
      if (!shouldCloseTab) {
        return;
      }
      if (activeTabIndex === index_0) {
        executionContext.stop();
      }
      closeTab(index_0);
    };
    $[48] = activeTabIndex;
    $[49] = closeTab;
    $[50] = confirmClose;
    $[51] = executionContext;
    $[52] = t21;
  } else {
    t21 = $[52];
  }
  const handleTabClose = t21;
  let t22;
  if ($[53] !== changeTab || $[54] !== executionContext) {
    t22 = (event_5) => {
      const index_1 = Number(event_5.currentTarget.id.replace(TAB_CLASS_PREFIX, ""));
      executionContext.stop();
      changeTab(index_1);
    };
    $[53] = changeTab;
    $[54] = executionContext;
    $[55] = t22;
  } else {
    t22 = $[55];
  }
  const handleTabClick = t22;
  let t23;
  if ($[56] !== props.className) {
    t23 = cn("graphiql-container", props.className);
    $[56] = props.className;
    $[57] = t23;
  } else {
    t23 = $[57];
  }
  let t24;
  if ($[58] !== handlePluginClick || $[59] !== plugins || $[60] !== visiblePlugin) {
    let t252;
    if ($[62] !== handlePluginClick || $[63] !== visiblePlugin) {
      t252 = (plugin_0, index_2) => {
        const isVisible_0 = plugin_0 === visiblePlugin;
        const label = `${isVisible_0 ? "Hide" : "Show"} ${plugin_0.title}`;
        return /* @__PURE__ */ jsx(Tooltip, { label, children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: cn(isVisible_0 && "active"), onClick: handlePluginClick, "data-index": index_2, "aria-label": label, children: /* @__PURE__ */ jsx(plugin_0.icon, { "aria-hidden": "true" }) }) }, plugin_0.title);
      };
      $[62] = handlePluginClick;
      $[63] = visiblePlugin;
      $[64] = t252;
    } else {
      t252 = $[64];
    }
    t24 = plugins.map(t252);
    $[58] = handlePluginClick;
    $[59] = plugins;
    $[60] = visiblePlugin;
    $[61] = t24;
  } else {
    t24 = $[61];
  }
  let t25;
  if ($[65] === Symbol.for("react.memo_cache_sentinel")) {
    t25 = {
      marginTop: "auto"
    };
    $[65] = t25;
  } else {
    t25 = $[65];
  }
  const t26 = isSchemaFetching && "graphiql-spin";
  let t27;
  if ($[66] !== t26) {
    t27 = cn(t26);
    $[66] = t26;
    $[67] = t27;
  } else {
    t27 = $[67];
  }
  let t28;
  if ($[68] !== t27) {
    t28 = /* @__PURE__ */ jsx(ReloadIcon, { className: t27, "aria-hidden": "true" });
    $[68] = t27;
    $[69] = t28;
  } else {
    t28 = $[69];
  }
  let t29;
  if ($[70] !== introspect || $[71] !== isSchemaFetching || $[72] !== t28) {
    t29 = /* @__PURE__ */ jsx(Tooltip, { label: "Re-fetch GraphQL schema", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", disabled: isSchemaFetching, onClick: introspect, "aria-label": "Re-fetch GraphQL schema", style: t25, children: t28 }) });
    $[70] = introspect;
    $[71] = isSchemaFetching;
    $[72] = t28;
    $[73] = t29;
  } else {
    t29 = $[73];
  }
  let t30;
  if ($[74] === Symbol.for("react.memo_cache_sentinel")) {
    t30 = /* @__PURE__ */ jsx(Tooltip, { label: "Open short keys dialog", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", "data-value": "short-keys", onClick: handleShowDialog, "aria-label": "Open short keys dialog", children: /* @__PURE__ */ jsx(KeyboardShortcutIcon, { "aria-hidden": "true" }) }) });
    $[74] = t30;
  } else {
    t30 = $[74];
  }
  let t31;
  if ($[75] === Symbol.for("react.memo_cache_sentinel")) {
    t31 = /* @__PURE__ */ jsx(Tooltip, { label: "Open settings dialog", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", "data-value": "settings", onClick: handleShowDialog, "aria-label": "Open settings dialog", children: /* @__PURE__ */ jsx(SettingsIcon, { "aria-hidden": "true" }) }) });
    $[75] = t31;
  } else {
    t31 = $[75];
  }
  let t32;
  if ($[76] !== t24 || $[77] !== t29) {
    t32 = /* @__PURE__ */ jsxs("div", { className: "graphiql-sidebar", children: [
      t24,
      t29,
      t30,
      t31
    ] });
    $[76] = t24;
    $[77] = t29;
    $[78] = t32;
  } else {
    t32 = $[78];
  }
  let t33;
  if ($[79] === Symbol.for("react.memo_cache_sentinel")) {
    t33 = {
      minWidth: "200px"
    };
    $[79] = t33;
  } else {
    t33 = $[79];
  }
  let t34;
  if ($[80] !== PluginContent) {
    t34 = PluginContent ? /* @__PURE__ */ jsx(PluginContent, {}) : null;
    $[80] = PluginContent;
    $[81] = t34;
  } else {
    t34 = $[81];
  }
  let t35;
  if ($[82] !== pluginResize.firstRef || $[83] !== t34) {
    t35 = /* @__PURE__ */ jsx("div", { ref: pluginResize.firstRef, className: "graphiql-plugin", style: t33, children: t34 });
    $[82] = pluginResize.firstRef;
    $[83] = t34;
    $[84] = t35;
  } else {
    t35 = $[84];
  }
  let t36;
  if ($[85] !== pluginResize.dragBarRef || $[86] !== visiblePlugin) {
    t36 = visiblePlugin && /* @__PURE__ */ jsx("div", { className: "graphiql-horizontal-drag-bar", ref: pluginResize.dragBarRef });
    $[85] = pluginResize.dragBarRef;
    $[86] = visiblePlugin;
    $[87] = t36;
  } else {
    t36 = $[87];
  }
  const t37 = pluginResize.secondRef;
  let t38;
  if ($[88] !== activeTabIndex || $[89] !== handleTabClick || $[90] !== handleTabClose || $[91] !== tabs) {
    let t392;
    if ($[93] !== activeTabIndex || $[94] !== handleTabClick || $[95] !== handleTabClose) {
      t392 = (tab, index_3, arr) => /* @__PURE__ */ jsxs(Tab, { value: tab, isActive: index_3 === activeTabIndex, children: [
        /* @__PURE__ */ jsx(Tab.Button, { "aria-controls": "graphiql-session", id: `graphiql-session-tab-${index_3}`, title: tab.title, onClick: handleTabClick, children: tab.title }),
        arr.length > 1 && /* @__PURE__ */ jsx(Tab.Close, { onClick: handleTabClose })
      ] }, tab.id);
      $[93] = activeTabIndex;
      $[94] = handleTabClick;
      $[95] = handleTabClose;
      $[96] = t392;
    } else {
      t392 = $[96];
    }
    t38 = tabs.map(t392);
    $[88] = activeTabIndex;
    $[89] = handleTabClick;
    $[90] = handleTabClose;
    $[91] = tabs;
    $[92] = t38;
  } else {
    t38 = $[92];
  }
  let t39;
  if ($[97] !== moveTab || $[98] !== t38 || $[99] !== tabs) {
    t39 = /* @__PURE__ */ jsx(Tabs, { values: tabs, onReorder: moveTab, "aria-label": "Select active operation", className: "no-scrollbar", children: t38 });
    $[97] = moveTab;
    $[98] = t38;
    $[99] = tabs;
    $[100] = t39;
  } else {
    t39 = $[100];
  }
  let t40;
  if ($[101] === Symbol.for("react.memo_cache_sentinel")) {
    t40 = /* @__PURE__ */ jsx(PlusIcon, { "aria-hidden": "true" });
    $[101] = t40;
  } else {
    t40 = $[101];
  }
  let t41;
  if ($[102] !== addTab) {
    t41 = /* @__PURE__ */ jsx(Tooltip, { label: "New tab", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: "graphiql-tab-add", onClick: addTab, "aria-label": "New tab", children: t40 }) });
    $[102] = addTab;
    $[103] = t41;
  } else {
    t41 = $[103];
  }
  let t42;
  if ($[104] !== logo || $[105] !== t39 || $[106] !== t41) {
    t42 = /* @__PURE__ */ jsxs("div", { className: "graphiql-session-header", children: [
      t39,
      t41,
      logo
    ] });
    $[104] = logo;
    $[105] = t39;
    $[106] = t41;
    $[107] = t42;
  } else {
    t42 = $[107];
  }
  const t43 = `${TAB_CLASS_PREFIX}${activeTabIndex}`;
  const t44 = editorResize.firstRef;
  let t45;
  if ($[108] !== onClickReference || $[109] !== props.editorTheme || $[110] !== props.keyMap || $[111] !== props.onCopyQuery || $[112] !== props.onEditQuery || $[113] !== props.onPrettifyQuery || $[114] !== props.readOnly) {
    t45 = /* @__PURE__ */ jsx(QueryEditor, { editorTheme: props.editorTheme, keyMap: props.keyMap, onClickReference, onCopyQuery: props.onCopyQuery, onPrettifyQuery: props.onPrettifyQuery, onEdit: props.onEditQuery, readOnly: props.readOnly });
    $[108] = onClickReference;
    $[109] = props.editorTheme;
    $[110] = props.keyMap;
    $[111] = props.onCopyQuery;
    $[112] = props.onEditQuery;
    $[113] = props.onPrettifyQuery;
    $[114] = props.readOnly;
    $[115] = t45;
  } else {
    t45 = $[115];
  }
  let t46;
  if ($[116] === Symbol.for("react.memo_cache_sentinel")) {
    t46 = /* @__PURE__ */ jsx(ExecuteButton, {});
    $[116] = t46;
  } else {
    t46 = $[116];
  }
  let t47;
  if ($[117] !== toolbar) {
    t47 = /* @__PURE__ */ jsxs("div", { className: "graphiql-toolbar", role: "toolbar", "aria-label": "Editor Commands", children: [
      t46,
      toolbar
    ] });
    $[117] = toolbar;
    $[118] = t47;
  } else {
    t47 = $[118];
  }
  let t48;
  if ($[119] !== editorToolsResize.firstRef || $[120] !== t45 || $[121] !== t47) {
    t48 = /* @__PURE__ */ jsxs("section", { className: "graphiql-query-editor", "aria-label": "Query Editor", ref: editorToolsResize.firstRef, children: [
      t45,
      t47
    ] });
    $[119] = editorToolsResize.firstRef;
    $[120] = t45;
    $[121] = t47;
    $[122] = t48;
  } else {
    t48 = $[122];
  }
  const t49 = editorToolsResize.dragBarRef;
  const t50 = activeSecondaryEditor === "variables" && editorToolsResize.hiddenElement !== "second" && "active";
  let t51;
  if ($[123] !== t50) {
    t51 = cn(t50);
    $[123] = t50;
    $[124] = t51;
  } else {
    t51 = $[124];
  }
  let t52;
  if ($[125] !== handleToolsTabClick || $[126] !== t51) {
    t52 = /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: t51, onClick: handleToolsTabClick, "data-name": "variables", children: "Variables" });
    $[125] = handleToolsTabClick;
    $[126] = t51;
    $[127] = t52;
  } else {
    t52 = $[127];
  }
  let t53;
  if ($[128] !== activeSecondaryEditor || $[129] !== editorToolsResize.hiddenElement || $[130] !== handleToolsTabClick || $[131] !== isHeadersEditorEnabled) {
    t53 = isHeadersEditorEnabled && /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: cn(activeSecondaryEditor === "headers" && editorToolsResize.hiddenElement !== "second" && "active"), onClick: handleToolsTabClick, "data-name": "headers", children: "Headers" });
    $[128] = activeSecondaryEditor;
    $[129] = editorToolsResize.hiddenElement;
    $[130] = handleToolsTabClick;
    $[131] = isHeadersEditorEnabled;
    $[132] = t53;
  } else {
    t53 = $[132];
  }
  const t54 = editorToolsResize.hiddenElement === "second" ? "Show editor tools" : "Hide editor tools";
  const t55 = editorToolsResize.hiddenElement === "second" ? "Show editor tools" : "Hide editor tools";
  let t56;
  if ($[133] !== editorToolsResize.hiddenElement) {
    t56 = editorToolsResize.hiddenElement === "second" ? /* @__PURE__ */ jsx(ChevronUpIcon, { className: "graphiql-chevron-icon", "aria-hidden": "true" }) : /* @__PURE__ */ jsx(ChevronDownIcon, { className: "graphiql-chevron-icon", "aria-hidden": "true" });
    $[133] = editorToolsResize.hiddenElement;
    $[134] = t56;
  } else {
    t56 = $[134];
  }
  let t57;
  if ($[135] !== t55 || $[136] !== t56 || $[137] !== toggleEditorTools) {
    t57 = /* @__PURE__ */ jsx(UnStyledButton, { type: "button", onClick: toggleEditorTools, "aria-label": t55, className: "graphiql-toggle-editor-tools", children: t56 });
    $[135] = t55;
    $[136] = t56;
    $[137] = toggleEditorTools;
    $[138] = t57;
  } else {
    t57 = $[138];
  }
  let t58;
  if ($[139] !== t54 || $[140] !== t57) {
    t58 = /* @__PURE__ */ jsx(Tooltip, { label: t54, children: t57 });
    $[139] = t54;
    $[140] = t57;
    $[141] = t58;
  } else {
    t58 = $[141];
  }
  let t59;
  if ($[142] !== editorToolsResize.dragBarRef || $[143] !== t52 || $[144] !== t53 || $[145] !== t58) {
    t59 = /* @__PURE__ */ jsxs("div", { ref: t49, className: "graphiql-editor-tools", children: [
      t52,
      t53,
      t58
    ] });
    $[142] = editorToolsResize.dragBarRef;
    $[143] = t52;
    $[144] = t53;
    $[145] = t58;
    $[146] = t59;
  } else {
    t59 = $[146];
  }
  const t60 = activeSecondaryEditor === "variables" ? "Variables" : "Headers";
  const t61 = activeSecondaryEditor !== "variables";
  let t62;
  if ($[147] !== onClickReference || $[148] !== props.editorTheme || $[149] !== props.keyMap || $[150] !== props.onEditVariables || $[151] !== props.readOnly || $[152] !== t61) {
    t62 = /* @__PURE__ */ jsx(VariableEditor, { editorTheme: props.editorTheme, isHidden: t61, keyMap: props.keyMap, onEdit: props.onEditVariables, onClickReference, readOnly: props.readOnly });
    $[147] = onClickReference;
    $[148] = props.editorTheme;
    $[149] = props.keyMap;
    $[150] = props.onEditVariables;
    $[151] = props.readOnly;
    $[152] = t61;
    $[153] = t62;
  } else {
    t62 = $[153];
  }
  let t63;
  if ($[154] !== activeSecondaryEditor || $[155] !== isHeadersEditorEnabled || $[156] !== props.editorTheme || $[157] !== props.keyMap || $[158] !== props.onEditHeaders || $[159] !== props.readOnly) {
    t63 = isHeadersEditorEnabled && /* @__PURE__ */ jsx(HeaderEditor, { editorTheme: props.editorTheme, isHidden: activeSecondaryEditor !== "headers", keyMap: props.keyMap, onEdit: props.onEditHeaders, readOnly: props.readOnly });
    $[154] = activeSecondaryEditor;
    $[155] = isHeadersEditorEnabled;
    $[156] = props.editorTheme;
    $[157] = props.keyMap;
    $[158] = props.onEditHeaders;
    $[159] = props.readOnly;
    $[160] = t63;
  } else {
    t63 = $[160];
  }
  let t64;
  if ($[161] !== editorToolsResize.secondRef || $[162] !== t60 || $[163] !== t62 || $[164] !== t63) {
    t64 = /* @__PURE__ */ jsxs("section", { className: "graphiql-editor-tool", "aria-label": t60, ref: editorToolsResize.secondRef, children: [
      t62,
      t63
    ] });
    $[161] = editorToolsResize.secondRef;
    $[162] = t60;
    $[163] = t62;
    $[164] = t63;
    $[165] = t64;
  } else {
    t64 = $[165];
  }
  let t65;
  if ($[166] !== editorResize.firstRef || $[167] !== t48 || $[168] !== t59 || $[169] !== t64) {
    t65 = /* @__PURE__ */ jsxs("div", { className: "graphiql-editors", ref: t44, children: [
      t48,
      t59,
      t64
    ] });
    $[166] = editorResize.firstRef;
    $[167] = t48;
    $[168] = t59;
    $[169] = t64;
    $[170] = t65;
  } else {
    t65 = $[170];
  }
  let t66;
  if ($[171] !== editorResize.dragBarRef) {
    t66 = /* @__PURE__ */ jsx("div", { className: "graphiql-horizontal-drag-bar", ref: editorResize.dragBarRef });
    $[171] = editorResize.dragBarRef;
    $[172] = t66;
  } else {
    t66 = $[172];
  }
  let t67;
  if ($[173] !== executionContext.isFetching) {
    t67 = executionContext.isFetching ? /* @__PURE__ */ jsx(Spinner, {}) : null;
    $[173] = executionContext.isFetching;
    $[174] = t67;
  } else {
    t67 = $[174];
  }
  let t68;
  if ($[175] !== props.editorTheme || $[176] !== props.keyMap || $[177] !== props.responseTooltip) {
    t68 = /* @__PURE__ */ jsx(ResponseEditor, { editorTheme: props.editorTheme, responseTooltip: props.responseTooltip, keyMap: props.keyMap });
    $[175] = props.editorTheme;
    $[176] = props.keyMap;
    $[177] = props.responseTooltip;
    $[178] = t68;
  } else {
    t68 = $[178];
  }
  let t69;
  if ($[179] !== editorResize.secondRef || $[180] !== footer || $[181] !== t67 || $[182] !== t68) {
    t69 = /* @__PURE__ */ jsxs("div", { className: "graphiql-response", ref: editorResize.secondRef, children: [
      t67,
      t68,
      footer
    ] });
    $[179] = editorResize.secondRef;
    $[180] = footer;
    $[181] = t67;
    $[182] = t68;
    $[183] = t69;
  } else {
    t69 = $[183];
  }
  let t70;
  if ($[184] !== t43 || $[185] !== t65 || $[186] !== t66 || $[187] !== t69) {
    t70 = /* @__PURE__ */ jsxs("div", { role: "tabpanel", id: "graphiql-session", "aria-labelledby": t43, children: [
      t65,
      t66,
      t69
    ] });
    $[184] = t43;
    $[185] = t65;
    $[186] = t66;
    $[187] = t69;
    $[188] = t70;
  } else {
    t70 = $[188];
  }
  let t71;
  if ($[189] !== pluginResize.secondRef || $[190] !== t42 || $[191] !== t70) {
    t71 = /* @__PURE__ */ jsxs("div", { ref: t37, className: "graphiql-sessions", children: [
      t42,
      t70
    ] });
    $[189] = pluginResize.secondRef;
    $[190] = t42;
    $[191] = t70;
    $[192] = t71;
  } else {
    t71 = $[192];
  }
  let t72;
  if ($[193] !== t35 || $[194] !== t36 || $[195] !== t71) {
    t72 = /* @__PURE__ */ jsxs("div", { className: "graphiql-main", children: [
      t35,
      t36,
      t71
    ] });
    $[193] = t35;
    $[194] = t36;
    $[195] = t71;
    $[196] = t72;
  } else {
    t72 = $[196];
  }
  const t73 = showDialog === "short-keys";
  let t74;
  if ($[197] === Symbol.for("react.memo_cache_sentinel")) {
    t74 = /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-header", children: [
      /* @__PURE__ */ jsx(Dialog.Title, { className: "graphiql-dialog-title", children: "Short Keys" }),
      /* @__PURE__ */ jsx(Dialog.Close, {})
    ] });
    $[197] = t74;
  } else {
    t74 = $[197];
  }
  let t75;
  if ($[198] !== props.keyMap) {
    t75 = /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section", children: /* @__PURE__ */ jsx(ShortKeys, { keyMap: props.keyMap }) });
    $[198] = props.keyMap;
    $[199] = t75;
  } else {
    t75 = $[199];
  }
  let t76;
  if ($[200] !== t73 || $[201] !== t75) {
    t76 = /* @__PURE__ */ jsxs(Dialog, { open: t73, onOpenChange: handleOpenShortKeysDialog, children: [
      t74,
      t75
    ] });
    $[200] = t73;
    $[201] = t75;
    $[202] = t76;
  } else {
    t76 = $[202];
  }
  const t77 = showDialog === "settings";
  let t78;
  if ($[203] === Symbol.for("react.memo_cache_sentinel")) {
    t78 = /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-header", children: [
      /* @__PURE__ */ jsx(Dialog.Title, { className: "graphiql-dialog-title", children: "Settings" }),
      /* @__PURE__ */ jsx(Dialog.Close, {})
    ] });
    $[203] = t78;
  } else {
    t78 = $[203];
  }
  let t79;
  if ($[204] !== handlePersistHeaders || $[205] !== props.showPersistHeadersSettings || $[206] !== shouldPersistHeaders) {
    t79 = props.showPersistHeadersSettings ? /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-title", children: "Persist headers" }),
        /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section-caption", children: [
          "Save headers upon reloading.",
          " ",
          /* @__PURE__ */ jsx("span", { className: "graphiql-warning-text", children: "Only enable if you trust this device." })
        ] })
      ] }),
      /* @__PURE__ */ jsxs(ButtonGroup, { children: [
        /* @__PURE__ */ jsx(Button, { type: "button", id: "enable-persist-headers", className: cn(shouldPersistHeaders && "active"), "data-value": "true", onClick: handlePersistHeaders, children: "On" }),
        /* @__PURE__ */ jsx(Button, { type: "button", id: "disable-persist-headers", className: cn(!shouldPersistHeaders && "active"), onClick: handlePersistHeaders, children: "Off" })
      ] })
    ] }) : null;
    $[204] = handlePersistHeaders;
    $[205] = props.showPersistHeadersSettings;
    $[206] = shouldPersistHeaders;
    $[207] = t79;
  } else {
    t79 = $[207];
  }
  let t80;
  if ($[208] !== forcedTheme || $[209] !== handleChangeTheme || $[210] !== theme) {
    t80 = !forcedTheme && /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-title", children: "Theme" }),
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-caption", children: "Adjust how the interface appears." })
      ] }),
      /* @__PURE__ */ jsxs(ButtonGroup, { children: [
        /* @__PURE__ */ jsx(Button, { type: "button", className: cn(theme === null && "active"), onClick: handleChangeTheme, children: "System" }),
        /* @__PURE__ */ jsx(Button, { type: "button", className: cn(theme === "light" && "active"), "data-theme": "light", onClick: handleChangeTheme, children: "Light" }),
        /* @__PURE__ */ jsx(Button, { type: "button", className: cn(theme === "dark" && "active"), "data-theme": "dark", onClick: handleChangeTheme, children: "Dark" })
      ] })
    ] });
    $[208] = forcedTheme;
    $[209] = handleChangeTheme;
    $[210] = theme;
    $[211] = t80;
  } else {
    t80 = $[211];
  }
  let t81;
  if ($[212] === Symbol.for("react.memo_cache_sentinel")) {
    t81 = /* @__PURE__ */ jsxs("div", { children: [
      /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-title", children: "Clear storage" }),
      /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-caption", children: "Remove all locally stored data and start fresh." })
    ] });
    $[212] = t81;
  } else {
    t81 = $[212];
  }
  const t82 = clearStorageStatus || void 0;
  const t83 = clearStorageStatus === "success";
  let t84;
  if ($[213] !== clearStorageStatus) {
    t84 = {
      success: "Cleared data",
      error: "Failed"
    }[clearStorageStatus] || "Clear data";
    $[213] = clearStorageStatus;
    $[214] = t84;
  } else {
    t84 = $[214];
  }
  let t85;
  if ($[215] !== handleClearData || $[216] !== t82 || $[217] !== t83 || $[218] !== t84) {
    t85 = /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section", children: [
      t81,
      /* @__PURE__ */ jsx(Button, { type: "button", state: t82, disabled: t83, onClick: handleClearData, children: t84 })
    ] });
    $[215] = handleClearData;
    $[216] = t82;
    $[217] = t83;
    $[218] = t84;
    $[219] = t85;
  } else {
    t85 = $[219];
  }
  let t86;
  if ($[220] !== t77 || $[221] !== t79 || $[222] !== t80 || $[223] !== t85) {
    t86 = /* @__PURE__ */ jsxs(Dialog, { open: t77, onOpenChange: handleOpenSettingsDialog, children: [
      t78,
      t79,
      t80,
      t85
    ] });
    $[220] = t77;
    $[221] = t79;
    $[222] = t80;
    $[223] = t85;
    $[224] = t86;
  } else {
    t86 = $[224];
  }
  let t87;
  if ($[225] !== t23 || $[226] !== t32 || $[227] !== t72 || $[228] !== t76 || $[229] !== t86) {
    t87 = /* @__PURE__ */ jsx(Tooltip.Provider, { children: /* @__PURE__ */ jsxs("div", { className: t23, children: [
      t32,
      t72,
      t76,
      t86
    ] }) });
    $[225] = t23;
    $[226] = t32;
    $[227] = t72;
    $[228] = t76;
    $[229] = t86;
    $[230] = t87;
  } else {
    t87 = $[230];
  }
  return t87;
};
const modifier = isMacOs ? "⌘" : "Ctrl";
const SHORT_KEYS = Object.entries({
  "Search in editor": [modifier, "F"],
  "Search in documentation": [modifier, "K"],
  "Execute query": [modifier, "Enter"],
  "Prettify editors": ["Ctrl", "Shift", "P"],
  "Merge fragments definitions into operation definition": ["Ctrl", "Shift", "M"],
  "Copy query": ["Ctrl", "Shift", "C"],
  "Re-fetch schema using introspection": ["Ctrl", "Shift", "R"]
});
const ShortKeys = (t0) => {
  const $ = c(5);
  const {
    keyMap: t1
  } = t0;
  const keyMap = t1 === void 0 ? "sublime" : t1;
  let t2;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t2 = /* @__PURE__ */ jsxs("table", { className: "graphiql-table", children: [
      /* @__PURE__ */ jsx("thead", { children: /* @__PURE__ */ jsxs("tr", { children: [
        /* @__PURE__ */ jsx("th", { children: "Short Key" }),
        /* @__PURE__ */ jsx("th", { children: "Function" })
      ] }) }),
      /* @__PURE__ */ jsx("tbody", { children: SHORT_KEYS.map(_temp2) })
    ] });
    $[0] = t2;
  } else {
    t2 = $[0];
  }
  let t3;
  if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
    t3 = /* @__PURE__ */ jsx("a", { href: "https://codemirror.net/5/doc/manual.html#keymaps", target: "_blank", rel: "noopener noreferrer", children: "CodeMirror Key Maps" });
    $[1] = t3;
  } else {
    t3 = $[1];
  }
  let t4;
  if ($[2] === Symbol.for("react.memo_cache_sentinel")) {
    t4 = /* @__PURE__ */ jsx("em", { children: "i" });
    $[2] = t4;
  } else {
    t4 = $[2];
  }
  let t5;
  if ($[3] !== keyMap) {
    t5 = /* @__PURE__ */ jsxs("div", { children: [
      t2,
      /* @__PURE__ */ jsxs("p", { children: [
        "The editors use",
        " ",
        t3,
        " ",
        "that add more short keys. This instance of Graph",
        t4,
        "QL uses",
        " ",
        /* @__PURE__ */ jsx("code", { children: keyMap }),
        "."
      ] })
    ] });
    $[3] = keyMap;
    $[4] = t5;
  } else {
    t5 = $[4];
  }
  return t5;
};
const defaultGraphiqlLogo = /* @__PURE__ */ jsxs("a", { className: "graphiql-logo-link", href: "https://github.com/graphql/graphiql", target: "_blank", rel: "noreferrer", children: [
  "Graph",
  /* @__PURE__ */ jsx("em", { children: "i" }),
  "QL"
] });
const GraphiQLLogo = (t0) => {
  const $ = c(2);
  const {
    children: t1
  } = t0;
  const children = t1 === void 0 ? defaultGraphiqlLogo : t1;
  let t2;
  if ($[0] !== children) {
    t2 = /* @__PURE__ */ jsx("div", { className: "graphiql-logo", children });
    $[0] = children;
    $[1] = t2;
  } else {
    t2 = $[1];
  }
  return t2;
};
const DefaultToolbarRenderProps = (t0) => {
  const $ = c(4);
  const {
    prettify,
    copy,
    merge
  } = t0;
  let t1;
  if ($[0] !== copy || $[1] !== merge || $[2] !== prettify) {
    t1 = /* @__PURE__ */ jsxs(Fragment$1, { children: [
      prettify,
      merge,
      copy
    ] });
    $[0] = copy;
    $[1] = merge;
    $[2] = prettify;
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  return t1;
};
const GraphiQLToolbar = ({
  children = DefaultToolbarRenderProps,
  // @ts-expect-error -- Hide this prop for user, we use cloneElement to pass onCopyQuery
  onCopyQuery,
  // @ts-expect-error -- Hide this prop for user, we use cloneElement to pass onPrettifyQuery
  onPrettifyQuery
}) => {
  "use no memo";
  if (typeof children !== "function") {
    throw new TypeError("The `GraphiQL.Toolbar` component requires a render prop function as its child.");
  }
  const onCopy = useCopyQuery({
    onCopyQuery
  });
  const onMerge = useMergeQuery();
  const onPrettify = usePrettifyEditors({
    onPrettifyQuery
  });
  const prettify = /* @__PURE__ */ jsx(ToolbarButton, { onClick: onPrettify, label: "Prettify query (Shift-Ctrl-P)", children: /* @__PURE__ */ jsx(PrettifyIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" }) });
  const merge = /* @__PURE__ */ jsx(ToolbarButton, { onClick: onMerge, label: "Merge fragments into query (Shift-Ctrl-M)", children: /* @__PURE__ */ jsx(MergeIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" }) });
  const copy = /* @__PURE__ */ jsx(ToolbarButton, { onClick: onCopy, label: "Copy query (Shift-Ctrl-C)", children: /* @__PURE__ */ jsx(CopyIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" }) });
  return children({
    prettify,
    copy,
    merge
  });
};
const GraphiQLFooter = (props) => {
  const $ = c(2);
  let t0;
  if ($[0] !== props.children) {
    t0 = /* @__PURE__ */ jsx("div", { className: "graphiql-footer", children: props.children });
    $[0] = props.children;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  return t0;
};
function getChildComponentType(child) {
  if (child && typeof child === "object" && "type" in child && typeof child.type === "function") {
    return child.type;
  }
}
const GraphiQL = Object.assign(GraphiQL_, {
  Logo: GraphiQLLogo,
  Toolbar: GraphiQLToolbar,
  Footer: GraphiQLFooter
});
function _temp(key, index, array) {
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx("code", { className: "graphiql-key", children: key }),
    index !== array.length - 1 && " + "
  ] }, key);
}
function _temp2(t0) {
  const [title, keys] = t0;
  return /* @__PURE__ */ jsxs("tr", { children: [
    /* @__PURE__ */ jsx("td", { children: keys.map(_temp) }),
    /* @__PURE__ */ jsx("td", { children: title })
  ] }, title);
}
export {
  GraphiQL,
  GraphiQLInterface
};
//# sourceMappingURL=GraphiQL.js.map
