import { jsx, jsxs, Fragment as Fragment$1 } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { useEffect, useState, Children, Fragment, cloneElement } from "react";
import { useEditorStore, useExecutionStore, useSchemaStore, useStorage, usePluginStore, useTheme, useDragResize, cn, QueryEditor, UnStyledButton, ChevronUpIcon, ChevronDownIcon, VariableEditor, HeaderEditor, Spinner, ResponseEditor, Dialog, ButtonGroup, Button, Tooltip, GraphiQLProvider, useCopyQuery, useMergeQuery, usePrettifyEditors, ToolbarButton, MergeIcon, CopyIcon, PrettifyIcon, isMacOs, ReloadIcon, KeyboardShortcutIcon, SettingsIcon, Tab, Tabs, PlusIcon, ExecuteButton } from "@graphiql/react";
import { HISTORY_PLUGIN, HistoryContextProvider } from "@graphiql/plugin-history";
import { DOC_EXPLORER_PLUGIN, DocExplorerContextProvider } from "@graphiql/plugin-doc-explorer";
const GraphiQL_ = (t0) => {
  var _a, _b;
  const $ = c(72);
  let confirmCloseTab;
  let dangerouslyAssumeSchemaIsValid;
  let defaultHeaders;
  let defaultQuery;
  let defaultTabs;
  let externalFragments;
  let fetcher;
  let getDefaultFieldNames;
  let headers;
  let inputValueDeprecation;
  let introspectionQueryName;
  let maxHistoryLength;
  let onEditOperationName;
  let onSchemaChange;
  let onTabChange;
  let onTogglePluginVisibility;
  let operationName;
  let props;
  let query;
  let response;
  let schema;
  let schemaDescription;
  let shouldPersistHeaders;
  let storage;
  let t1;
  let t2;
  let validationRules;
  let variables;
  let visiblePlugin;
  if ($[0] !== t0) {
    ({
      dangerouslyAssumeSchemaIsValid,
      confirmCloseTab,
      defaultQuery,
      defaultTabs,
      externalFragments,
      fetcher,
      getDefaultFieldNames,
      headers,
      inputValueDeprecation,
      introspectionQueryName,
      maxHistoryLength,
      onEditOperationName,
      onSchemaChange,
      onTabChange,
      onTogglePluginVisibility,
      operationName,
      plugins: t1,
      referencePlugin: t2,
      query,
      response,
      schema,
      schemaDescription,
      shouldPersistHeaders,
      storage,
      validationRules,
      variables,
      visiblePlugin,
      defaultHeaders,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = confirmCloseTab;
    $[2] = dangerouslyAssumeSchemaIsValid;
    $[3] = defaultHeaders;
    $[4] = defaultQuery;
    $[5] = defaultTabs;
    $[6] = externalFragments;
    $[7] = fetcher;
    $[8] = getDefaultFieldNames;
    $[9] = headers;
    $[10] = inputValueDeprecation;
    $[11] = introspectionQueryName;
    $[12] = maxHistoryLength;
    $[13] = onEditOperationName;
    $[14] = onSchemaChange;
    $[15] = onTabChange;
    $[16] = onTogglePluginVisibility;
    $[17] = operationName;
    $[18] = props;
    $[19] = query;
    $[20] = response;
    $[21] = schema;
    $[22] = schemaDescription;
    $[23] = shouldPersistHeaders;
    $[24] = storage;
    $[25] = t1;
    $[26] = t2;
    $[27] = validationRules;
    $[28] = variables;
    $[29] = visiblePlugin;
  } else {
    confirmCloseTab = $[1];
    dangerouslyAssumeSchemaIsValid = $[2];
    defaultHeaders = $[3];
    defaultQuery = $[4];
    defaultTabs = $[5];
    externalFragments = $[6];
    fetcher = $[7];
    getDefaultFieldNames = $[8];
    headers = $[9];
    inputValueDeprecation = $[10];
    introspectionQueryName = $[11];
    maxHistoryLength = $[12];
    onEditOperationName = $[13];
    onSchemaChange = $[14];
    onTabChange = $[15];
    onTogglePluginVisibility = $[16];
    operationName = $[17];
    props = $[18];
    query = $[19];
    response = $[20];
    schema = $[21];
    schemaDescription = $[22];
    shouldPersistHeaders = $[23];
    storage = $[24];
    t1 = $[25];
    t2 = $[26];
    validationRules = $[27];
    variables = $[28];
    visiblePlugin = $[29];
  }
  let t3;
  if ($[30] !== t1) {
    t3 = t1 === void 0 ? [] : t1;
    $[30] = t1;
    $[31] = t3;
  } else {
    t3 = $[31];
  }
  const plugins = t3;
  const referencePlugin = t2 === void 0 ? DOC_EXPLORER_PLUGIN : t2;
  if ((_a = props.toolbar) == null ? void 0 : _a.additionalContent) {
    throw new TypeError("`toolbar.additionalContent` was removed. Use render props on `GraphiQL.Toolbar` component instead.");
  }
  if ((_b = props.toolbar) == null ? void 0 : _b.additionalComponent) {
    throw new TypeError("`toolbar.additionalComponent` was removed. Use render props on `GraphiQL.Toolbar` component instead.");
  }
  let t4;
  if ($[32] !== plugins || $[33] !== referencePlugin) {
    t4 = [referencePlugin, HISTORY_PLUGIN, ...plugins];
    $[32] = plugins;
    $[33] = referencePlugin;
    $[34] = t4;
  } else {
    t4 = $[34];
  }
  let t5;
  if ($[35] !== dangerouslyAssumeSchemaIsValid || $[36] !== defaultHeaders || $[37] !== defaultQuery || $[38] !== defaultTabs || $[39] !== externalFragments || $[40] !== fetcher || $[41] !== getDefaultFieldNames || $[42] !== headers || $[43] !== inputValueDeprecation || $[44] !== introspectionQueryName || $[45] !== onEditOperationName || $[46] !== onSchemaChange || $[47] !== onTabChange || $[48] !== onTogglePluginVisibility || $[49] !== operationName || $[50] !== query || $[51] !== referencePlugin || $[52] !== response || $[53] !== schema || $[54] !== schemaDescription || $[55] !== shouldPersistHeaders || $[56] !== storage || $[57] !== t4 || $[58] !== validationRules || $[59] !== variables || $[60] !== visiblePlugin) {
    t5 = {
      getDefaultFieldNames,
      dangerouslyAssumeSchemaIsValid,
      defaultQuery,
      defaultHeaders,
      defaultTabs,
      externalFragments,
      fetcher,
      headers,
      inputValueDeprecation,
      introspectionQueryName,
      onEditOperationName,
      onSchemaChange,
      onTabChange,
      onTogglePluginVisibility,
      plugins: t4,
      referencePlugin,
      visiblePlugin,
      operationName,
      query,
      response,
      schema,
      schemaDescription,
      shouldPersistHeaders,
      storage,
      validationRules,
      variables
    };
    $[35] = dangerouslyAssumeSchemaIsValid;
    $[36] = defaultHeaders;
    $[37] = defaultQuery;
    $[38] = defaultTabs;
    $[39] = externalFragments;
    $[40] = fetcher;
    $[41] = getDefaultFieldNames;
    $[42] = headers;
    $[43] = inputValueDeprecation;
    $[44] = introspectionQueryName;
    $[45] = onEditOperationName;
    $[46] = onSchemaChange;
    $[47] = onTabChange;
    $[48] = onTogglePluginVisibility;
    $[49] = operationName;
    $[50] = query;
    $[51] = referencePlugin;
    $[52] = response;
    $[53] = schema;
    $[54] = schemaDescription;
    $[55] = shouldPersistHeaders;
    $[56] = storage;
    $[57] = t4;
    $[58] = validationRules;
    $[59] = variables;
    $[60] = visiblePlugin;
    $[61] = t5;
  } else {
    t5 = $[61];
  }
  const graphiqlProps = t5;
  const t6 = shouldPersistHeaders !== false;
  let t7;
  if ($[62] !== confirmCloseTab || $[63] !== props || $[64] !== t6) {
    t7 = /* @__PURE__ */ jsx(DocExplorerContextProvider, { children: /* @__PURE__ */ jsx(GraphiQLInterface, { confirmCloseTab, showPersistHeadersSettings: t6, forcedTheme: props.forcedTheme, ...props }) });
    $[62] = confirmCloseTab;
    $[63] = props;
    $[64] = t6;
    $[65] = t7;
  } else {
    t7 = $[65];
  }
  let t8;
  if ($[66] !== maxHistoryLength || $[67] !== t7) {
    t8 = /* @__PURE__ */ jsx(HistoryContextProvider, { maxHistoryLength, children: t7 });
    $[66] = maxHistoryLength;
    $[67] = t7;
    $[68] = t8;
  } else {
    t8 = $[68];
  }
  let t9;
  if ($[69] !== graphiqlProps || $[70] !== t8) {
    t9 = /* @__PURE__ */ jsx(GraphiQLProvider, { ...graphiqlProps, children: t8 });
    $[69] = graphiqlProps;
    $[70] = t8;
    $[71] = t9;
  } else {
    t9 = $[71];
  }
  return t9;
};
const THEMES = ["light", "dark", "system"];
const TAB_CLASS_PREFIX = "graphiql-session-tab-";
const GraphiQLInterface = (props) => {
  const $ = c(229);
  const isHeadersEditorEnabled = props.isHeadersEditorEnabled ?? true;
  const {
    initialVariables,
    initialHeaders,
    setShouldPersistHeaders,
    addTab,
    moveTab,
    closeTab,
    changeTab,
    shouldPersistHeaders,
    tabs,
    activeTabIndex
  } = useEditorStore();
  const executionContext = useExecutionStore();
  const {
    isFetching: isSchemaFetching,
    introspect
  } = useSchemaStore();
  const storageContext = useStorage();
  const {
    visiblePlugin,
    setVisiblePlugin,
    plugins
  } = usePluginStore();
  const forcedTheme = props.forcedTheme && THEMES.includes(props.forcedTheme) ? props.forcedTheme : void 0;
  const {
    theme,
    setTheme
  } = useTheme(props.defaultTheme);
  let t0;
  let t1;
  if ($[0] !== forcedTheme || $[1] !== setTheme) {
    t0 = () => {
      if (forcedTheme === "system") {
        setTheme(null);
      } else {
        if (forcedTheme === "light" || forcedTheme === "dark") {
          setTheme(forcedTheme);
        }
      }
    };
    t1 = [forcedTheme, setTheme];
    $[0] = forcedTheme;
    $[1] = setTheme;
    $[2] = t0;
    $[3] = t1;
  } else {
    t0 = $[2];
    t1 = $[3];
  }
  useEffect(t0, t1);
  const PluginContent = visiblePlugin == null ? void 0 : visiblePlugin.content;
  const t2 = visiblePlugin ? void 0 : "first";
  let t3;
  if ($[4] !== setVisiblePlugin || $[5] !== t2) {
    t3 = {
      defaultSizeRelation: 0.3333333333333333,
      direction: "horizontal",
      initiallyHidden: t2,
      onHiddenElementChange(resizableElement) {
        if (resizableElement === "first") {
          setVisiblePlugin(null);
        }
      },
      sizeThresholdSecond: 200,
      storageKey: "docExplorerFlex"
    };
    $[4] = setVisiblePlugin;
    $[5] = t2;
    $[6] = t3;
  } else {
    t3 = $[6];
  }
  const pluginResize = useDragResize(t3);
  let t4;
  if ($[7] === Symbol.for("react.memo_cache_sentinel")) {
    t4 = {
      direction: "horizontal",
      storageKey: "editorFlex"
    };
    $[7] = t4;
  } else {
    t4 = $[7];
  }
  const editorResize = useDragResize(t4);
  let t5;
  bb0: {
    if (props.defaultEditorToolsVisibility === "variables" || props.defaultEditorToolsVisibility === "headers") {
      t5 = void 0;
      break bb0;
    }
    if (typeof props.defaultEditorToolsVisibility === "boolean") {
      t5 = props.defaultEditorToolsVisibility ? void 0 : "second";
      break bb0;
    }
    t5 = initialVariables || initialHeaders ? void 0 : "second";
  }
  let t6;
  if ($[8] !== t5) {
    t6 = {
      defaultSizeRelation: 3,
      direction: "vertical",
      initiallyHidden: t5,
      sizeThresholdSecond: 60,
      storageKey: "secondaryEditorFlex"
    };
    $[8] = t5;
    $[9] = t6;
  } else {
    t6 = $[9];
  }
  const editorToolsResize = useDragResize(t6);
  let t7;
  if ($[10] !== initialHeaders || $[11] !== initialVariables || $[12] !== isHeadersEditorEnabled || $[13] !== props.defaultEditorToolsVisibility) {
    t7 = () => {
      if (props.defaultEditorToolsVisibility === "variables" || props.defaultEditorToolsVisibility === "headers") {
        return props.defaultEditorToolsVisibility;
      }
      return !initialVariables && initialHeaders && isHeadersEditorEnabled ? "headers" : "variables";
    };
    $[10] = initialHeaders;
    $[11] = initialVariables;
    $[12] = isHeadersEditorEnabled;
    $[13] = props.defaultEditorToolsVisibility;
    $[14] = t7;
  } else {
    t7 = $[14];
  }
  const [activeSecondaryEditor, setActiveSecondaryEditor] = useState(t7);
  const [showDialog, setShowDialog] = useState(null);
  const [clearStorageStatus, setClearStorageStatus] = useState(null);
  let t8;
  if ($[15] !== props.children || $[16] !== props.onCopyQuery || $[17] !== props.onPrettifyQuery) {
    let t92;
    if ($[19] !== props.onCopyQuery || $[20] !== props.onPrettifyQuery) {
      t92 = (acc, curr) => {
        bb80: switch (getChildComponentType(curr)) {
          case GraphiQL.Logo: {
            acc.logo = curr;
            break bb80;
          }
          case GraphiQL.Toolbar: {
            acc.toolbar = cloneElement(curr, {
              onCopyQuery: props.onCopyQuery,
              onPrettifyQuery: props.onPrettifyQuery
            });
            break bb80;
          }
          case GraphiQL.Footer: {
            acc.footer = curr;
          }
        }
        return acc;
      };
      $[19] = props.onCopyQuery;
      $[20] = props.onPrettifyQuery;
      $[21] = t92;
    } else {
      t92 = $[21];
    }
    let t102;
    if ($[22] === Symbol.for("react.memo_cache_sentinel")) {
      t102 = /* @__PURE__ */ jsx(GraphiQL.Logo, {});
      $[22] = t102;
    } else {
      t102 = $[22];
    }
    let t112;
    if ($[23] !== props.onCopyQuery || $[24] !== props.onPrettifyQuery) {
      t112 = /* @__PURE__ */ jsx(GraphiQL.Toolbar, { onCopyQuery: props.onCopyQuery, onPrettifyQuery: props.onPrettifyQuery });
      $[23] = props.onCopyQuery;
      $[24] = props.onPrettifyQuery;
      $[25] = t112;
    } else {
      t112 = $[25];
    }
    t8 = Children.toArray(props.children).reduce(t92, {
      logo: t102,
      toolbar: t112
    });
    $[15] = props.children;
    $[16] = props.onCopyQuery;
    $[17] = props.onPrettifyQuery;
    $[18] = t8;
  } else {
    t8 = $[18];
  }
  const {
    logo,
    toolbar,
    footer
  } = t8;
  let t9;
  if ($[26] !== pluginResize) {
    t9 = () => {
      if (pluginResize.hiddenElement === "first") {
        pluginResize.setHiddenElement(null);
      }
    };
    $[26] = pluginResize;
    $[27] = t9;
  } else {
    t9 = $[27];
  }
  const onClickReference = t9;
  let t10;
  if ($[28] !== storageContext) {
    t10 = () => {
      try {
        storageContext.clear();
        setClearStorageStatus("success");
      } catch {
        setClearStorageStatus("error");
      }
    };
    $[28] = storageContext;
    $[29] = t10;
  } else {
    t10 = $[29];
  }
  const handleClearData = t10;
  let t11;
  if ($[30] !== setShouldPersistHeaders) {
    t11 = (event) => {
      setShouldPersistHeaders(event.currentTarget.dataset.value === "true");
    };
    $[30] = setShouldPersistHeaders;
    $[31] = t11;
  } else {
    t11 = $[31];
  }
  const handlePersistHeaders = t11;
  let t12;
  if ($[32] !== setTheme) {
    t12 = (event_0) => {
      const selectedTheme = event_0.currentTarget.dataset.theme;
      setTheme(selectedTheme || null);
    };
    $[32] = setTheme;
    $[33] = t12;
  } else {
    t12 = $[33];
  }
  const handleChangeTheme = t12;
  let t13;
  if ($[34] === Symbol.for("react.memo_cache_sentinel")) {
    t13 = (event_1) => {
      setShowDialog(event_1.currentTarget.dataset.value);
    };
    $[34] = t13;
  } else {
    t13 = $[34];
  }
  const handleShowDialog = t13;
  let t14;
  if ($[35] !== pluginResize || $[36] !== plugins || $[37] !== setVisiblePlugin || $[38] !== visiblePlugin) {
    t14 = (event_2) => {
      const pluginIndex = Number(event_2.currentTarget.dataset.index);
      const plugin = plugins.find((_, index) => pluginIndex === index);
      const isVisible = plugin === visiblePlugin;
      if (isVisible) {
        setVisiblePlugin(null);
        pluginResize.setHiddenElement("first");
      } else {
        setVisiblePlugin(plugin);
        pluginResize.setHiddenElement(null);
      }
    };
    $[35] = pluginResize;
    $[36] = plugins;
    $[37] = setVisiblePlugin;
    $[38] = visiblePlugin;
    $[39] = t14;
  } else {
    t14 = $[39];
  }
  const handlePluginClick = t14;
  let t15;
  if ($[40] !== editorToolsResize) {
    t15 = (event_3) => {
      if (editorToolsResize.hiddenElement === "second") {
        editorToolsResize.setHiddenElement(null);
      }
      setActiveSecondaryEditor(event_3.currentTarget.dataset.name);
    };
    $[40] = editorToolsResize;
    $[41] = t15;
  } else {
    t15 = $[41];
  }
  const handleToolsTabClick = t15;
  let t16;
  if ($[42] !== editorToolsResize) {
    t16 = () => {
      editorToolsResize.setHiddenElement(editorToolsResize.hiddenElement === "second" ? null : "second");
    };
    $[42] = editorToolsResize;
    $[43] = t16;
  } else {
    t16 = $[43];
  }
  const toggleEditorTools = t16;
  let t17;
  if ($[44] === Symbol.for("react.memo_cache_sentinel")) {
    t17 = (isOpen) => {
      if (!isOpen) {
        setShowDialog(null);
      }
    };
    $[44] = t17;
  } else {
    t17 = $[44];
  }
  const handleOpenShortKeysDialog = t17;
  let t18;
  if ($[45] === Symbol.for("react.memo_cache_sentinel")) {
    t18 = (isOpen_0) => {
      if (!isOpen_0) {
        setShowDialog(null);
        setClearStorageStatus(null);
      }
    };
    $[45] = t18;
  } else {
    t18 = $[45];
  }
  const handleOpenSettingsDialog = t18;
  const confirmClose = props.confirmCloseTab;
  let t19;
  if ($[46] !== activeTabIndex || $[47] !== closeTab || $[48] !== confirmClose || $[49] !== executionContext) {
    t19 = async (event_4) => {
      const tabButton = event_4.currentTarget.previousSibling;
      const index_0 = Number(tabButton.id.replace(TAB_CLASS_PREFIX, ""));
      const shouldCloseTab = confirmClose ? await confirmClose(index_0) : true;
      if (!shouldCloseTab) {
        return;
      }
      if (activeTabIndex === index_0) {
        executionContext.stop();
      }
      closeTab(index_0);
    };
    $[46] = activeTabIndex;
    $[47] = closeTab;
    $[48] = confirmClose;
    $[49] = executionContext;
    $[50] = t19;
  } else {
    t19 = $[50];
  }
  const handleTabClose = t19;
  let t20;
  if ($[51] !== changeTab || $[52] !== executionContext) {
    t20 = (event_5) => {
      const index_1 = Number(event_5.currentTarget.id.replace(TAB_CLASS_PREFIX, ""));
      executionContext.stop();
      changeTab(index_1);
    };
    $[51] = changeTab;
    $[52] = executionContext;
    $[53] = t20;
  } else {
    t20 = $[53];
  }
  const handleTabClick = t20;
  let t21;
  if ($[54] !== props.className) {
    t21 = cn("graphiql-container", props.className);
    $[54] = props.className;
    $[55] = t21;
  } else {
    t21 = $[55];
  }
  let t22;
  if ($[56] !== handlePluginClick || $[57] !== plugins || $[58] !== visiblePlugin) {
    let t232;
    if ($[60] !== handlePluginClick || $[61] !== visiblePlugin) {
      t232 = (plugin_0, index_2) => {
        const isVisible_0 = plugin_0 === visiblePlugin;
        const label = `${isVisible_0 ? "Hide" : "Show"} ${plugin_0.title}`;
        return /* @__PURE__ */ jsx(Tooltip, { label, children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: cn(isVisible_0 && "active"), onClick: handlePluginClick, "data-index": index_2, "aria-label": label, children: /* @__PURE__ */ jsx(plugin_0.icon, { "aria-hidden": "true" }) }) }, plugin_0.title);
      };
      $[60] = handlePluginClick;
      $[61] = visiblePlugin;
      $[62] = t232;
    } else {
      t232 = $[62];
    }
    t22 = plugins.map(t232);
    $[56] = handlePluginClick;
    $[57] = plugins;
    $[58] = visiblePlugin;
    $[59] = t22;
  } else {
    t22 = $[59];
  }
  let t23;
  if ($[63] === Symbol.for("react.memo_cache_sentinel")) {
    t23 = {
      marginTop: "auto"
    };
    $[63] = t23;
  } else {
    t23 = $[63];
  }
  const t24 = isSchemaFetching && "graphiql-spin";
  let t25;
  if ($[64] !== t24) {
    t25 = cn(t24);
    $[64] = t24;
    $[65] = t25;
  } else {
    t25 = $[65];
  }
  let t26;
  if ($[66] !== t25) {
    t26 = /* @__PURE__ */ jsx(ReloadIcon, { className: t25, "aria-hidden": "true" });
    $[66] = t25;
    $[67] = t26;
  } else {
    t26 = $[67];
  }
  let t27;
  if ($[68] !== introspect || $[69] !== isSchemaFetching || $[70] !== t26) {
    t27 = /* @__PURE__ */ jsx(Tooltip, { label: "Re-fetch GraphQL schema", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", disabled: isSchemaFetching, onClick: introspect, "aria-label": "Re-fetch GraphQL schema", style: t23, children: t26 }) });
    $[68] = introspect;
    $[69] = isSchemaFetching;
    $[70] = t26;
    $[71] = t27;
  } else {
    t27 = $[71];
  }
  let t28;
  if ($[72] === Symbol.for("react.memo_cache_sentinel")) {
    t28 = /* @__PURE__ */ jsx(Tooltip, { label: "Open short keys dialog", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", "data-value": "short-keys", onClick: handleShowDialog, "aria-label": "Open short keys dialog", children: /* @__PURE__ */ jsx(KeyboardShortcutIcon, { "aria-hidden": "true" }) }) });
    $[72] = t28;
  } else {
    t28 = $[72];
  }
  let t29;
  if ($[73] === Symbol.for("react.memo_cache_sentinel")) {
    t29 = /* @__PURE__ */ jsx(Tooltip, { label: "Open settings dialog", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", "data-value": "settings", onClick: handleShowDialog, "aria-label": "Open settings dialog", children: /* @__PURE__ */ jsx(SettingsIcon, { "aria-hidden": "true" }) }) });
    $[73] = t29;
  } else {
    t29 = $[73];
  }
  let t30;
  if ($[74] !== t22 || $[75] !== t27) {
    t30 = /* @__PURE__ */ jsxs("div", { className: "graphiql-sidebar", children: [
      t22,
      t27,
      t28,
      t29
    ] });
    $[74] = t22;
    $[75] = t27;
    $[76] = t30;
  } else {
    t30 = $[76];
  }
  let t31;
  if ($[77] === Symbol.for("react.memo_cache_sentinel")) {
    t31 = {
      minWidth: "200px"
    };
    $[77] = t31;
  } else {
    t31 = $[77];
  }
  let t32;
  if ($[78] !== PluginContent) {
    t32 = PluginContent ? /* @__PURE__ */ jsx(PluginContent, {}) : null;
    $[78] = PluginContent;
    $[79] = t32;
  } else {
    t32 = $[79];
  }
  let t33;
  if ($[80] !== pluginResize.firstRef || $[81] !== t32) {
    t33 = /* @__PURE__ */ jsx("div", { ref: pluginResize.firstRef, className: "graphiql-plugin", style: t31, children: t32 });
    $[80] = pluginResize.firstRef;
    $[81] = t32;
    $[82] = t33;
  } else {
    t33 = $[82];
  }
  let t34;
  if ($[83] !== pluginResize.dragBarRef || $[84] !== visiblePlugin) {
    t34 = visiblePlugin && /* @__PURE__ */ jsx("div", { className: "graphiql-horizontal-drag-bar", ref: pluginResize.dragBarRef });
    $[83] = pluginResize.dragBarRef;
    $[84] = visiblePlugin;
    $[85] = t34;
  } else {
    t34 = $[85];
  }
  const t35 = pluginResize.secondRef;
  let t36;
  if ($[86] !== activeTabIndex || $[87] !== handleTabClick || $[88] !== handleTabClose || $[89] !== tabs) {
    let t372;
    if ($[91] !== activeTabIndex || $[92] !== handleTabClick || $[93] !== handleTabClose) {
      t372 = (tab, index_3, arr) => /* @__PURE__ */ jsxs(Tab, { value: tab, isActive: index_3 === activeTabIndex, children: [
        /* @__PURE__ */ jsx(Tab.Button, { "aria-controls": "graphiql-session", id: `graphiql-session-tab-${index_3}`, title: tab.title, onClick: handleTabClick, children: tab.title }),
        arr.length > 1 && /* @__PURE__ */ jsx(Tab.Close, { onClick: handleTabClose })
      ] }, tab.id);
      $[91] = activeTabIndex;
      $[92] = handleTabClick;
      $[93] = handleTabClose;
      $[94] = t372;
    } else {
      t372 = $[94];
    }
    t36 = tabs.map(t372);
    $[86] = activeTabIndex;
    $[87] = handleTabClick;
    $[88] = handleTabClose;
    $[89] = tabs;
    $[90] = t36;
  } else {
    t36 = $[90];
  }
  let t37;
  if ($[95] !== moveTab || $[96] !== t36 || $[97] !== tabs) {
    t37 = /* @__PURE__ */ jsx(Tabs, { values: tabs, onReorder: moveTab, "aria-label": "Select active operation", className: "no-scrollbar", children: t36 });
    $[95] = moveTab;
    $[96] = t36;
    $[97] = tabs;
    $[98] = t37;
  } else {
    t37 = $[98];
  }
  let t38;
  if ($[99] === Symbol.for("react.memo_cache_sentinel")) {
    t38 = /* @__PURE__ */ jsx(PlusIcon, { "aria-hidden": "true" });
    $[99] = t38;
  } else {
    t38 = $[99];
  }
  let t39;
  if ($[100] !== addTab) {
    t39 = /* @__PURE__ */ jsx(Tooltip, { label: "New tab", children: /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: "graphiql-tab-add", onClick: addTab, "aria-label": "New tab", children: t38 }) });
    $[100] = addTab;
    $[101] = t39;
  } else {
    t39 = $[101];
  }
  let t40;
  if ($[102] !== logo || $[103] !== t37 || $[104] !== t39) {
    t40 = /* @__PURE__ */ jsxs("div", { className: "graphiql-session-header", children: [
      t37,
      t39,
      logo
    ] });
    $[102] = logo;
    $[103] = t37;
    $[104] = t39;
    $[105] = t40;
  } else {
    t40 = $[105];
  }
  const t41 = `${TAB_CLASS_PREFIX}${activeTabIndex}`;
  const t42 = editorResize.firstRef;
  let t43;
  if ($[106] !== onClickReference || $[107] !== props.editorTheme || $[108] !== props.keyMap || $[109] !== props.onCopyQuery || $[110] !== props.onEditQuery || $[111] !== props.onPrettifyQuery || $[112] !== props.readOnly) {
    t43 = /* @__PURE__ */ jsx(QueryEditor, { editorTheme: props.editorTheme, keyMap: props.keyMap, onClickReference, onCopyQuery: props.onCopyQuery, onPrettifyQuery: props.onPrettifyQuery, onEdit: props.onEditQuery, readOnly: props.readOnly });
    $[106] = onClickReference;
    $[107] = props.editorTheme;
    $[108] = props.keyMap;
    $[109] = props.onCopyQuery;
    $[110] = props.onEditQuery;
    $[111] = props.onPrettifyQuery;
    $[112] = props.readOnly;
    $[113] = t43;
  } else {
    t43 = $[113];
  }
  let t44;
  if ($[114] === Symbol.for("react.memo_cache_sentinel")) {
    t44 = /* @__PURE__ */ jsx(ExecuteButton, {});
    $[114] = t44;
  } else {
    t44 = $[114];
  }
  let t45;
  if ($[115] !== toolbar) {
    t45 = /* @__PURE__ */ jsxs("div", { className: "graphiql-toolbar", role: "toolbar", "aria-label": "Editor Commands", children: [
      t44,
      toolbar
    ] });
    $[115] = toolbar;
    $[116] = t45;
  } else {
    t45 = $[116];
  }
  let t46;
  if ($[117] !== editorToolsResize.firstRef || $[118] !== t43 || $[119] !== t45) {
    t46 = /* @__PURE__ */ jsxs("section", { className: "graphiql-query-editor", "aria-label": "Query Editor", ref: editorToolsResize.firstRef, children: [
      t43,
      t45
    ] });
    $[117] = editorToolsResize.firstRef;
    $[118] = t43;
    $[119] = t45;
    $[120] = t46;
  } else {
    t46 = $[120];
  }
  const t47 = editorToolsResize.dragBarRef;
  const t48 = activeSecondaryEditor === "variables" && editorToolsResize.hiddenElement !== "second" && "active";
  let t49;
  if ($[121] !== t48) {
    t49 = cn(t48);
    $[121] = t48;
    $[122] = t49;
  } else {
    t49 = $[122];
  }
  let t50;
  if ($[123] !== handleToolsTabClick || $[124] !== t49) {
    t50 = /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: t49, onClick: handleToolsTabClick, "data-name": "variables", children: "Variables" });
    $[123] = handleToolsTabClick;
    $[124] = t49;
    $[125] = t50;
  } else {
    t50 = $[125];
  }
  let t51;
  if ($[126] !== activeSecondaryEditor || $[127] !== editorToolsResize.hiddenElement || $[128] !== handleToolsTabClick || $[129] !== isHeadersEditorEnabled) {
    t51 = isHeadersEditorEnabled && /* @__PURE__ */ jsx(UnStyledButton, { type: "button", className: cn(activeSecondaryEditor === "headers" && editorToolsResize.hiddenElement !== "second" && "active"), onClick: handleToolsTabClick, "data-name": "headers", children: "Headers" });
    $[126] = activeSecondaryEditor;
    $[127] = editorToolsResize.hiddenElement;
    $[128] = handleToolsTabClick;
    $[129] = isHeadersEditorEnabled;
    $[130] = t51;
  } else {
    t51 = $[130];
  }
  const t52 = editorToolsResize.hiddenElement === "second" ? "Show editor tools" : "Hide editor tools";
  const t53 = editorToolsResize.hiddenElement === "second" ? "Show editor tools" : "Hide editor tools";
  let t54;
  if ($[131] !== editorToolsResize.hiddenElement) {
    t54 = editorToolsResize.hiddenElement === "second" ? /* @__PURE__ */ jsx(ChevronUpIcon, { className: "graphiql-chevron-icon", "aria-hidden": "true" }) : /* @__PURE__ */ jsx(ChevronDownIcon, { className: "graphiql-chevron-icon", "aria-hidden": "true" });
    $[131] = editorToolsResize.hiddenElement;
    $[132] = t54;
  } else {
    t54 = $[132];
  }
  let t55;
  if ($[133] !== t53 || $[134] !== t54 || $[135] !== toggleEditorTools) {
    t55 = /* @__PURE__ */ jsx(UnStyledButton, { type: "button", onClick: toggleEditorTools, "aria-label": t53, className: "graphiql-toggle-editor-tools", children: t54 });
    $[133] = t53;
    $[134] = t54;
    $[135] = toggleEditorTools;
    $[136] = t55;
  } else {
    t55 = $[136];
  }
  let t56;
  if ($[137] !== t52 || $[138] !== t55) {
    t56 = /* @__PURE__ */ jsx(Tooltip, { label: t52, children: t55 });
    $[137] = t52;
    $[138] = t55;
    $[139] = t56;
  } else {
    t56 = $[139];
  }
  let t57;
  if ($[140] !== editorToolsResize.dragBarRef || $[141] !== t50 || $[142] !== t51 || $[143] !== t56) {
    t57 = /* @__PURE__ */ jsxs("div", { ref: t47, className: "graphiql-editor-tools", children: [
      t50,
      t51,
      t56
    ] });
    $[140] = editorToolsResize.dragBarRef;
    $[141] = t50;
    $[142] = t51;
    $[143] = t56;
    $[144] = t57;
  } else {
    t57 = $[144];
  }
  const t58 = activeSecondaryEditor === "variables" ? "Variables" : "Headers";
  const t59 = activeSecondaryEditor !== "variables";
  let t60;
  if ($[145] !== onClickReference || $[146] !== props.editorTheme || $[147] !== props.keyMap || $[148] !== props.onEditVariables || $[149] !== props.readOnly || $[150] !== t59) {
    t60 = /* @__PURE__ */ jsx(VariableEditor, { editorTheme: props.editorTheme, isHidden: t59, keyMap: props.keyMap, onEdit: props.onEditVariables, onClickReference, readOnly: props.readOnly });
    $[145] = onClickReference;
    $[146] = props.editorTheme;
    $[147] = props.keyMap;
    $[148] = props.onEditVariables;
    $[149] = props.readOnly;
    $[150] = t59;
    $[151] = t60;
  } else {
    t60 = $[151];
  }
  let t61;
  if ($[152] !== activeSecondaryEditor || $[153] !== isHeadersEditorEnabled || $[154] !== props.editorTheme || $[155] !== props.keyMap || $[156] !== props.onEditHeaders || $[157] !== props.readOnly) {
    t61 = isHeadersEditorEnabled && /* @__PURE__ */ jsx(HeaderEditor, { editorTheme: props.editorTheme, isHidden: activeSecondaryEditor !== "headers", keyMap: props.keyMap, onEdit: props.onEditHeaders, readOnly: props.readOnly });
    $[152] = activeSecondaryEditor;
    $[153] = isHeadersEditorEnabled;
    $[154] = props.editorTheme;
    $[155] = props.keyMap;
    $[156] = props.onEditHeaders;
    $[157] = props.readOnly;
    $[158] = t61;
  } else {
    t61 = $[158];
  }
  let t62;
  if ($[159] !== editorToolsResize.secondRef || $[160] !== t58 || $[161] !== t60 || $[162] !== t61) {
    t62 = /* @__PURE__ */ jsxs("section", { className: "graphiql-editor-tool", "aria-label": t58, ref: editorToolsResize.secondRef, children: [
      t60,
      t61
    ] });
    $[159] = editorToolsResize.secondRef;
    $[160] = t58;
    $[161] = t60;
    $[162] = t61;
    $[163] = t62;
  } else {
    t62 = $[163];
  }
  let t63;
  if ($[164] !== editorResize.firstRef || $[165] !== t46 || $[166] !== t57 || $[167] !== t62) {
    t63 = /* @__PURE__ */ jsxs("div", { className: "graphiql-editors", ref: t42, children: [
      t46,
      t57,
      t62
    ] });
    $[164] = editorResize.firstRef;
    $[165] = t46;
    $[166] = t57;
    $[167] = t62;
    $[168] = t63;
  } else {
    t63 = $[168];
  }
  let t64;
  if ($[169] !== editorResize.dragBarRef) {
    t64 = /* @__PURE__ */ jsx("div", { className: "graphiql-horizontal-drag-bar", ref: editorResize.dragBarRef });
    $[169] = editorResize.dragBarRef;
    $[170] = t64;
  } else {
    t64 = $[170];
  }
  let t65;
  if ($[171] !== executionContext.isFetching) {
    t65 = executionContext.isFetching ? /* @__PURE__ */ jsx(Spinner, {}) : null;
    $[171] = executionContext.isFetching;
    $[172] = t65;
  } else {
    t65 = $[172];
  }
  let t66;
  if ($[173] !== props.editorTheme || $[174] !== props.keyMap || $[175] !== props.responseTooltip) {
    t66 = /* @__PURE__ */ jsx(ResponseEditor, { editorTheme: props.editorTheme, responseTooltip: props.responseTooltip, keyMap: props.keyMap });
    $[173] = props.editorTheme;
    $[174] = props.keyMap;
    $[175] = props.responseTooltip;
    $[176] = t66;
  } else {
    t66 = $[176];
  }
  let t67;
  if ($[177] !== editorResize.secondRef || $[178] !== footer || $[179] !== t65 || $[180] !== t66) {
    t67 = /* @__PURE__ */ jsxs("div", { className: "graphiql-response", ref: editorResize.secondRef, children: [
      t65,
      t66,
      footer
    ] });
    $[177] = editorResize.secondRef;
    $[178] = footer;
    $[179] = t65;
    $[180] = t66;
    $[181] = t67;
  } else {
    t67 = $[181];
  }
  let t68;
  if ($[182] !== t41 || $[183] !== t63 || $[184] !== t64 || $[185] !== t67) {
    t68 = /* @__PURE__ */ jsxs("div", { role: "tabpanel", id: "graphiql-session", "aria-labelledby": t41, children: [
      t63,
      t64,
      t67
    ] });
    $[182] = t41;
    $[183] = t63;
    $[184] = t64;
    $[185] = t67;
    $[186] = t68;
  } else {
    t68 = $[186];
  }
  let t69;
  if ($[187] !== pluginResize.secondRef || $[188] !== t40 || $[189] !== t68) {
    t69 = /* @__PURE__ */ jsxs("div", { ref: t35, className: "graphiql-sessions", children: [
      t40,
      t68
    ] });
    $[187] = pluginResize.secondRef;
    $[188] = t40;
    $[189] = t68;
    $[190] = t69;
  } else {
    t69 = $[190];
  }
  let t70;
  if ($[191] !== t33 || $[192] !== t34 || $[193] !== t69) {
    t70 = /* @__PURE__ */ jsxs("div", { className: "graphiql-main", children: [
      t33,
      t34,
      t69
    ] });
    $[191] = t33;
    $[192] = t34;
    $[193] = t69;
    $[194] = t70;
  } else {
    t70 = $[194];
  }
  const t71 = showDialog === "short-keys";
  let t72;
  if ($[195] === Symbol.for("react.memo_cache_sentinel")) {
    t72 = /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-header", children: [
      /* @__PURE__ */ jsx(Dialog.Title, { className: "graphiql-dialog-title", children: "Short Keys" }),
      /* @__PURE__ */ jsx(Dialog.Close, {})
    ] });
    $[195] = t72;
  } else {
    t72 = $[195];
  }
  let t73;
  if ($[196] !== props.keyMap) {
    t73 = /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section", children: /* @__PURE__ */ jsx(ShortKeys, { keyMap: props.keyMap }) });
    $[196] = props.keyMap;
    $[197] = t73;
  } else {
    t73 = $[197];
  }
  let t74;
  if ($[198] !== t71 || $[199] !== t73) {
    t74 = /* @__PURE__ */ jsxs(Dialog, { open: t71, onOpenChange: handleOpenShortKeysDialog, children: [
      t72,
      t73
    ] });
    $[198] = t71;
    $[199] = t73;
    $[200] = t74;
  } else {
    t74 = $[200];
  }
  const t75 = showDialog === "settings";
  let t76;
  if ($[201] === Symbol.for("react.memo_cache_sentinel")) {
    t76 = /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-header", children: [
      /* @__PURE__ */ jsx(Dialog.Title, { className: "graphiql-dialog-title", children: "Settings" }),
      /* @__PURE__ */ jsx(Dialog.Close, {})
    ] });
    $[201] = t76;
  } else {
    t76 = $[201];
  }
  let t77;
  if ($[202] !== handlePersistHeaders || $[203] !== props.showPersistHeadersSettings || $[204] !== shouldPersistHeaders) {
    t77 = props.showPersistHeadersSettings ? /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-title", children: "Persist headers" }),
        /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section-caption", children: [
          "Save headers upon reloading.",
          " ",
          /* @__PURE__ */ jsx("span", { className: "graphiql-warning-text", children: "Only enable if you trust this device." })
        ] })
      ] }),
      /* @__PURE__ */ jsxs(ButtonGroup, { children: [
        /* @__PURE__ */ jsx(Button, { type: "button", id: "enable-persist-headers", className: cn(shouldPersistHeaders && "active"), "data-value": "true", onClick: handlePersistHeaders, children: "On" }),
        /* @__PURE__ */ jsx(Button, { type: "button", id: "disable-persist-headers", className: cn(!shouldPersistHeaders && "active"), onClick: handlePersistHeaders, children: "Off" })
      ] })
    ] }) : null;
    $[202] = handlePersistHeaders;
    $[203] = props.showPersistHeadersSettings;
    $[204] = shouldPersistHeaders;
    $[205] = t77;
  } else {
    t77 = $[205];
  }
  let t78;
  if ($[206] !== forcedTheme || $[207] !== handleChangeTheme || $[208] !== theme) {
    t78 = !forcedTheme && /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-title", children: "Theme" }),
        /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-caption", children: "Adjust how the interface appears." })
      ] }),
      /* @__PURE__ */ jsxs(ButtonGroup, { children: [
        /* @__PURE__ */ jsx(Button, { type: "button", className: cn(theme === null && "active"), onClick: handleChangeTheme, children: "System" }),
        /* @__PURE__ */ jsx(Button, { type: "button", className: cn(theme === "light" && "active"), "data-theme": "light", onClick: handleChangeTheme, children: "Light" }),
        /* @__PURE__ */ jsx(Button, { type: "button", className: cn(theme === "dark" && "active"), "data-theme": "dark", onClick: handleChangeTheme, children: "Dark" })
      ] })
    ] });
    $[206] = forcedTheme;
    $[207] = handleChangeTheme;
    $[208] = theme;
    $[209] = t78;
  } else {
    t78 = $[209];
  }
  let t79;
  if ($[210] === Symbol.for("react.memo_cache_sentinel")) {
    t79 = /* @__PURE__ */ jsxs("div", { children: [
      /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-title", children: "Clear storage" }),
      /* @__PURE__ */ jsx("div", { className: "graphiql-dialog-section-caption", children: "Remove all locally stored data and start fresh." })
    ] });
    $[210] = t79;
  } else {
    t79 = $[210];
  }
  const t80 = clearStorageStatus || void 0;
  const t81 = clearStorageStatus === "success";
  let t82;
  if ($[211] !== clearStorageStatus) {
    t82 = {
      success: "Cleared data",
      error: "Failed"
    }[clearStorageStatus] || "Clear data";
    $[211] = clearStorageStatus;
    $[212] = t82;
  } else {
    t82 = $[212];
  }
  let t83;
  if ($[213] !== handleClearData || $[214] !== t80 || $[215] !== t81 || $[216] !== t82) {
    t83 = /* @__PURE__ */ jsxs("div", { className: "graphiql-dialog-section", children: [
      t79,
      /* @__PURE__ */ jsx(Button, { type: "button", state: t80, disabled: t81, onClick: handleClearData, children: t82 })
    ] });
    $[213] = handleClearData;
    $[214] = t80;
    $[215] = t81;
    $[216] = t82;
    $[217] = t83;
  } else {
    t83 = $[217];
  }
  let t84;
  if ($[218] !== t75 || $[219] !== t77 || $[220] !== t78 || $[221] !== t83) {
    t84 = /* @__PURE__ */ jsxs(Dialog, { open: t75, onOpenChange: handleOpenSettingsDialog, children: [
      t76,
      t77,
      t78,
      t83
    ] });
    $[218] = t75;
    $[219] = t77;
    $[220] = t78;
    $[221] = t83;
    $[222] = t84;
  } else {
    t84 = $[222];
  }
  let t85;
  if ($[223] !== t21 || $[224] !== t30 || $[225] !== t70 || $[226] !== t74 || $[227] !== t84) {
    t85 = /* @__PURE__ */ jsx(Tooltip.Provider, { children: /* @__PURE__ */ jsxs("div", { className: t21, children: [
      t30,
      t70,
      t74,
      t84
    ] }) });
    $[223] = t21;
    $[224] = t30;
    $[225] = t70;
    $[226] = t74;
    $[227] = t84;
    $[228] = t85;
  } else {
    t85 = $[228];
  }
  return t85;
};
const modifier = isMacOs ? "⌘" : "Ctrl";
const SHORT_KEYS = Object.entries({
  "Search in editor": [modifier, "F"],
  "Search in documentation": [modifier, "K"],
  "Execute query": [modifier, "Enter"],
  "Prettify editors": ["Ctrl", "Shift", "P"],
  "Merge fragments definitions into operation definition": ["Ctrl", "Shift", "M"],
  "Copy query": ["Ctrl", "Shift", "C"],
  "Re-fetch schema using introspection": ["Ctrl", "Shift", "R"]
});
const ShortKeys = (t0) => {
  const $ = c(5);
  const {
    keyMap: t1
  } = t0;
  const keyMap = t1 === void 0 ? "sublime" : t1;
  let t2;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t2 = /* @__PURE__ */ jsxs("table", { className: "graphiql-table", children: [
      /* @__PURE__ */ jsx("thead", { children: /* @__PURE__ */ jsxs("tr", { children: [
        /* @__PURE__ */ jsx("th", { children: "Short Key" }),
        /* @__PURE__ */ jsx("th", { children: "Function" })
      ] }) }),
      /* @__PURE__ */ jsx("tbody", { children: SHORT_KEYS.map(_temp2) })
    ] });
    $[0] = t2;
  } else {
    t2 = $[0];
  }
  let t3;
  if ($[1] === Symbol.for("react.memo_cache_sentinel")) {
    t3 = /* @__PURE__ */ jsx("a", { href: "https://codemirror.net/5/doc/manual.html#keymaps", target: "_blank", rel: "noopener noreferrer", children: "CodeMirror Key Maps" });
    $[1] = t3;
  } else {
    t3 = $[1];
  }
  let t4;
  if ($[2] === Symbol.for("react.memo_cache_sentinel")) {
    t4 = /* @__PURE__ */ jsx("em", { children: "i" });
    $[2] = t4;
  } else {
    t4 = $[2];
  }
  let t5;
  if ($[3] !== keyMap) {
    t5 = /* @__PURE__ */ jsxs("div", { children: [
      t2,
      /* @__PURE__ */ jsxs("p", { children: [
        "The editors use",
        " ",
        t3,
        " ",
        "that add more short keys. This instance of Graph",
        t4,
        "QL uses",
        " ",
        /* @__PURE__ */ jsx("code", { children: keyMap }),
        "."
      ] })
    ] });
    $[3] = keyMap;
    $[4] = t5;
  } else {
    t5 = $[4];
  }
  return t5;
};
const defaultGraphiqlLogo = /* @__PURE__ */ jsxs("a", { className: "graphiql-logo-link", href: "https://github.com/graphql/graphiql", target: "_blank", rel: "noreferrer", children: [
  "Graph",
  /* @__PURE__ */ jsx("em", { children: "i" }),
  "QL"
] });
const GraphiQLLogo = (t0) => {
  const $ = c(2);
  const {
    children: t1
  } = t0;
  const children = t1 === void 0 ? defaultGraphiqlLogo : t1;
  let t2;
  if ($[0] !== children) {
    t2 = /* @__PURE__ */ jsx("div", { className: "graphiql-logo", children });
    $[0] = children;
    $[1] = t2;
  } else {
    t2 = $[1];
  }
  return t2;
};
const DefaultToolbarRenderProps = (t0) => {
  const $ = c(4);
  const {
    prettify,
    copy,
    merge
  } = t0;
  let t1;
  if ($[0] !== copy || $[1] !== merge || $[2] !== prettify) {
    t1 = /* @__PURE__ */ jsxs(Fragment$1, { children: [
      prettify,
      merge,
      copy
    ] });
    $[0] = copy;
    $[1] = merge;
    $[2] = prettify;
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  return t1;
};
const GraphiQLToolbar = ({
  children = DefaultToolbarRenderProps,
  // @ts-expect-error -- Hide this prop for user, we use cloneElement to pass onCopyQuery
  onCopyQuery,
  // @ts-expect-error -- Hide this prop for user, we use cloneElement to pass onPrettifyQuery
  onPrettifyQuery
}) => {
  "use no memo";
  if (typeof children !== "function") {
    throw new TypeError("The `GraphiQL.Toolbar` component requires a render prop function as its child.");
  }
  const onCopy = useCopyQuery({
    onCopyQuery
  });
  const onMerge = useMergeQuery();
  const onPrettify = usePrettifyEditors({
    onPrettifyQuery
  });
  const prettify = /* @__PURE__ */ jsx(ToolbarButton, { onClick: onPrettify, label: "Prettify query (Shift-Ctrl-P)", children: /* @__PURE__ */ jsx(PrettifyIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" }) });
  const merge = /* @__PURE__ */ jsx(ToolbarButton, { onClick: onMerge, label: "Merge fragments into query (Shift-Ctrl-M)", children: /* @__PURE__ */ jsx(MergeIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" }) });
  const copy = /* @__PURE__ */ jsx(ToolbarButton, { onClick: onCopy, label: "Copy query (Shift-Ctrl-C)", children: /* @__PURE__ */ jsx(CopyIcon, { className: "graphiql-toolbar-icon", "aria-hidden": "true" }) });
  return children({
    prettify,
    copy,
    merge
  });
};
const GraphiQLFooter = (props) => {
  const $ = c(2);
  let t0;
  if ($[0] !== props.children) {
    t0 = /* @__PURE__ */ jsx("div", { className: "graphiql-footer", children: props.children });
    $[0] = props.children;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  return t0;
};
function getChildComponentType(child) {
  if (child && typeof child === "object" && "type" in child && typeof child.type === "function") {
    return child.type;
  }
}
const GraphiQL = Object.assign(GraphiQL_, {
  Logo: GraphiQLLogo,
  Toolbar: GraphiQLToolbar,
  Footer: GraphiQLFooter
});
function _temp(key, index, array) {
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx("code", { className: "graphiql-key", children: key }),
    index !== array.length - 1 && " + "
  ] }, key);
}
function _temp2(t0) {
  const [title, keys] = t0;
  return /* @__PURE__ */ jsxs("tr", { children: [
    /* @__PURE__ */ jsx("td", { children: keys.map(_temp) }),
    /* @__PURE__ */ jsx("td", { children: title })
  ] }, title);
}
export {
  GraphiQL,
  GraphiQLInterface
};
//# sourceMappingURL=GraphiQL.js.map
